/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.kapt.classloaders;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.cache.CacheBuilder;
import org.jetbrains.kotlin.com.google.common.cache.RemovalListener;
import org.jetbrains.kotlin.com.google.common.cache.RemovalNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001e\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\"\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0016\u0010\u001c\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/kapt/classloaders/ClassLoadersCache;", "Ljava/lang/AutoCloseable;", "size", "", "parentClassLoader", "Ljava/lang/ClassLoader;", "ttl", "Ljava/time/Duration;", "(ILjava/lang/ClassLoader;Ljava/time/Duration;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/gradle/internal/kapt/classloaders/ClassLoadersCache$CacheKey;", "Ljava/net/URLClassLoader;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "close", "", "getForClassPath", "files", "", "Ljava/io/File;", "parent", "getForSplitPaths", "bottom", "top", "makeClassLoader", "key", "makeKey", "CacheKey", "ClasspathEntry", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nClassLoadersCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLoadersCache.kt\norg/jetbrains/kotlin/gradle/internal/kapt/classloaders/ClassLoadersCache\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,88:1\n72#2,2:89\n72#2,2:92\n1#3:91\n1#3:94\n1557#4:95\n1628#4,3:96\n1557#4:101\n1628#4,3:102\n37#5,2:99\n*S KotlinDebug\n*F\n+ 1 ClassLoadersCache.kt\norg/jetbrains/kotlin/gradle/internal/kapt/classloaders/ClassLoadersCache\n*L\n44#1:89,2\n61#1:92,2\n44#1:91\n61#1:94\n73#1:95\n73#1:96,3\n80#1:101\n80#1:102,3\n75#1:99,2\n*E\n"})
public final class ClassLoadersCache
implements AutoCloseable {
    @NotNull
    private final ClassLoader parentClassLoader;
    private final Logger logger;
    @NotNull
    private final ConcurrentMap<CacheKey, URLClassLoader> cache;

    public ClassLoadersCache(int size, @NotNull ClassLoader parentClassLoader, @NotNull Duration ttl) {
        Intrinsics.checkNotNullParameter((Object)parentClassLoader, (String)"parentClassLoader");
        Intrinsics.checkNotNullParameter((Object)ttl, (String)"ttl");
        this.parentClassLoader = parentClassLoader;
        this.logger = LoggerFactory.getLogger(ClassLoadersCache.class);
        ConcurrentMap concurrentMap = CacheBuilder.newBuilder().maximumSize(size).expireAfterAccess(ttl).removalListener(new RemovalListener(this){
            final /* synthetic */ ClassLoadersCache this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void onRemoval(RemovalNotification<CacheKey, URLClassLoader> removalNotification) {
                Collection<URL> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullExpressionValue(removalNotification, (String)"(key, cl)");
                CacheKey key = (CacheKey)((Map.Entry)removalNotification).getKey();
                URLClassLoader cl = (URLClassLoader)((Map.Entry)removalNotification).getValue();
                if (!(key != null && cl != null)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                Iterable iterable = key.getEntries();
                StringBuilder stringBuilder = new StringBuilder().append("Removing classloader from cache: ");
                Logger logger2 = ClassLoadersCache.access$getLogger$p(this.this$0);
                boolean $i$f$map = false;
                void var6_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ClasspathEntry classpathEntry = (ClasspathEntry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getPath());
                }
                collection = (List)destination$iv$iv;
                logger2.info(stringBuilder.append(collection).toString());
                cl.close();
            }
        }).build().asMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"newBuilder()\n           \u2026r>()\n            .asMap()");
        this.cache = concurrentMap;
    }

    public /* synthetic */ ClassLoadersCache(int n, ClassLoader classLoader, Duration duration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getSystemClassLoader()");
            classLoader = classLoader2;
        }
        if ((n2 & 4) != 0) {
            Duration duration2 = Duration.ofHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofHours(1)");
            duration = duration2;
        }
        this(n, classLoader, duration);
    }

    @NotNull
    public final ClassLoader getForClassPath(@NotNull List<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        return this.getForClassPath(files2, this.parentClassLoader);
    }

    private final ClassLoader getForClassPath(List<? extends File> files2, ClassLoader parent) {
        CacheKey key = this.makeKey(files2);
        ConcurrentMap<CacheKey, URLClassLoader> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key);
        if (object == null) {
            boolean bl = false;
            URLClassLoader default$iv = this.makeClassLoader(key, parent);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (ClassLoader)object;
    }

    @NotNull
    public final ClassLoader getForSplitPaths(@NotNull List<? extends File> bottom, @NotNull List<? extends File> top) {
        ClassLoader classLoader;
        Intrinsics.checkNotNullParameter(bottom, (String)"bottom");
        Intrinsics.checkNotNullParameter(top, (String)"top");
        if (bottom.isEmpty() || top.isEmpty()) {
            classLoader = this.getForClassPath(CollectionsKt.plus((Collection)bottom, (Iterable)top));
        } else {
            CacheKey key = this.makeKey(CollectionsKt.plus((Collection)bottom, (Iterable)top));
            ConcurrentMap<CacheKey, URLClassLoader> $this$getOrPut$iv = this.cache;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key);
            if (object == null) {
                boolean bl = false;
                ClassLoader parent = this.getForClassPath(top);
                URLClassLoader default$iv = this.makeClassLoader(this.makeKey(bottom), parent);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(key, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            classLoader = (ClassLoader)object;
        }
        return classLoader;
    }

    @Override
    public void close() {
        this.cache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final URLClassLoader makeClassLoader(CacheKey key, ClassLoader parent) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = key.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClasspathEntry classpathEntry = (ClasspathEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        List cp = (List)destination$iv$iv;
        this.logger.info("Creating new classloader for classpath: " + cp);
        Collection $this$toTypedArray$iv = cp;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new URLClassLoader(thisCollection$iv.toArray(new URL[0]), parent);
    }

    /*
     * WARNING - void declaration
     */
    private final CacheKey makeKey(List<? extends File> files2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = files2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void f;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            URL uRL = f.toURI().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"f.toURI().toURL()");
            collection.add(new ClasspathEntry(uRL, f.lastModified()));
        }
        List entries2 = (List)destination$iv$iv;
        return new CacheKey(entries2);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ClassLoadersCache $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/kapt/classloaders/ClassLoadersCache$CacheKey;", "", "entries", "", "Lorg/jetbrains/kotlin/gradle/internal/kapt/classloaders/ClassLoadersCache$ClasspathEntry;", "(Ljava/util/List;)V", "getEntries", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-gradle-plugin_common"})
    private static final class CacheKey {
        @NotNull
        private final List<ClasspathEntry> entries;

        public CacheKey(@NotNull List<ClasspathEntry> entries2) {
            Intrinsics.checkNotNullParameter(entries2, (String)"entries");
            this.entries = entries2;
        }

        @NotNull
        public final List<ClasspathEntry> getEntries() {
            return this.entries;
        }

        @NotNull
        public final List<ClasspathEntry> component1() {
            return this.entries;
        }

        @NotNull
        public final CacheKey copy(@NotNull List<ClasspathEntry> entries2) {
            Intrinsics.checkNotNullParameter(entries2, (String)"entries");
            return new CacheKey(entries2);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = cacheKey.entries;
            }
            return cacheKey.copy(list);
        }

        @NotNull
        public String toString() {
            return "CacheKey(entries=" + this.entries + ')';
        }

        public int hashCode() {
            return ((Object)this.entries).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            return Intrinsics.areEqual(this.entries, cacheKey.entries);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/kapt/classloaders/ClassLoadersCache$ClasspathEntry;", "", "path", "Ljava/net/URL;", "modificationTimestamp", "", "(Ljava/net/URL;J)V", "getModificationTimestamp", "()J", "getPath", "()Ljava/net/URL;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-gradle-plugin_common"})
    private static final class ClasspathEntry {
        @NotNull
        private final URL path;
        private final long modificationTimestamp;

        public ClasspathEntry(@NotNull URL path, long modificationTimestamp) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.modificationTimestamp = modificationTimestamp;
        }

        @NotNull
        public final URL getPath() {
            return this.path;
        }

        public final long getModificationTimestamp() {
            return this.modificationTimestamp;
        }

        @NotNull
        public final URL component1() {
            return this.path;
        }

        public final long component2() {
            return this.modificationTimestamp;
        }

        @NotNull
        public final ClasspathEntry copy(@NotNull URL path, long modificationTimestamp) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ClasspathEntry(path, modificationTimestamp);
        }

        public static /* synthetic */ ClasspathEntry copy$default(ClasspathEntry classpathEntry, URL uRL, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uRL = classpathEntry.path;
            }
            if ((n & 2) != 0) {
                l = classpathEntry.modificationTimestamp;
            }
            return classpathEntry.copy(uRL, l);
        }

        @NotNull
        public String toString() {
            return "ClasspathEntry(path=" + this.path + ", modificationTimestamp=" + this.modificationTimestamp + ')';
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.modificationTimestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClasspathEntry)) {
                return false;
            }
            ClasspathEntry classpathEntry = (ClasspathEntry)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)classpathEntry.path)) {
                return false;
            }
            return this.modificationTimestamp == classpathEntry.modificationTimestamp;
        }
    }
}

