/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.FrameworkDsymLayout;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010 \u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\tR\u0011\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\t\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/FrameworkLayout;", "", "rootDir", "Ljava/io/File;", "isMacosFramework", "", "(Ljava/io/File;Z)V", "binary", "getBinary", "()Ljava/io/File;", "contentDir", "dSYM", "Lorg/jetbrains/kotlin/gradle/tasks/FrameworkDsymLayout;", "getDSYM", "()Lorg/jetbrains/kotlin/gradle/tasks/FrameworkDsymLayout;", "frameworkName", "", "header", "getHeader", "headerDir", "getHeaderDir", "infoPlist", "getInfoPlist", "()Z", "macosADir", "macosResourcesDir", "macosVersionsDir", "moduleFile", "getModuleFile", "modulesDir", "getModulesDir", "getRootDir", "exists", "mkdirs", "", "kotlin-gradle-plugin_common"})
public final class FrameworkLayout {
    @NotNull
    private final File rootDir;
    private final boolean isMacosFramework;
    @NotNull
    private final String frameworkName;
    @NotNull
    private final File macosVersionsDir;
    @NotNull
    private final File macosADir;
    @NotNull
    private final File macosResourcesDir;
    @NotNull
    private final File contentDir;
    @NotNull
    private final File headerDir;
    @NotNull
    private final File modulesDir;
    @NotNull
    private final File binary;
    @NotNull
    private final File header;
    @NotNull
    private final File moduleFile;
    @NotNull
    private final File infoPlist;
    @NotNull
    private final FrameworkDsymLayout dSYM;

    public FrameworkLayout(@NotNull File rootDir, boolean isMacosFramework) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        this.rootDir = rootDir;
        this.isMacosFramework = isMacosFramework;
        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)this.rootDir), (Object)"framework")) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.frameworkName = FilesKt.getNameWithoutExtension((File)this.rootDir);
        this.macosVersionsDir = FilesKt.resolve((File)this.rootDir, (String)"Versions");
        this.macosADir = FilesKt.resolve((File)this.macosVersionsDir, (String)"A");
        this.macosResourcesDir = FilesKt.resolve((File)this.macosADir, (String)"Resources");
        this.contentDir = this.isMacosFramework ? this.macosADir : this.rootDir;
        this.headerDir = FilesKt.resolve((File)this.contentDir, (String)"Headers");
        this.modulesDir = FilesKt.resolve((File)this.contentDir, (String)"Modules");
        this.binary = FilesKt.resolve((File)this.contentDir, (String)this.frameworkName);
        this.header = FilesKt.resolve((File)this.headerDir, (String)(this.frameworkName + ".h"));
        this.moduleFile = FilesKt.resolve((File)this.modulesDir, (String)"module.modulemap");
        this.infoPlist = FilesKt.resolve((File)(this.isMacosFramework ? this.macosResourcesDir : this.rootDir), (String)"Info.plist");
        File file = this.rootDir.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDir.parentFile");
        this.dSYM = new FrameworkDsymLayout(FilesKt.resolve((File)file, (String)(this.frameworkName + ".framework.dSYM")));
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    public final boolean isMacosFramework() {
        return this.isMacosFramework;
    }

    @NotNull
    public final File getHeaderDir() {
        return this.headerDir;
    }

    @NotNull
    public final File getModulesDir() {
        return this.modulesDir;
    }

    @NotNull
    public final File getBinary() {
        return this.binary;
    }

    @NotNull
    public final File getHeader() {
        return this.header;
    }

    @NotNull
    public final File getModuleFile() {
        return this.moduleFile;
    }

    @NotNull
    public final File getInfoPlist() {
        return this.infoPlist;
    }

    @NotNull
    public final FrameworkDsymLayout getDSYM() {
        return this.dSYM;
    }

    public final void mkdirs() {
        this.rootDir.mkdirs();
        this.headerDir.mkdirs();
        this.modulesDir.mkdirs();
        if (this.isMacosFramework) {
            this.macosResourcesDir.mkdirs();
            File currentVersion = FilesKt.resolve((File)this.macosVersionsDir, (String)"Current");
            Files.createSymbolicLink(currentVersion.toPath(), FilesKt.relativeTo((File)this.macosADir, (File)this.macosVersionsDir).toPath(), new FileAttribute[0]);
            Path root2 = this.rootDir.toPath();
            Path current2 = FilesKt.relativeTo((File)currentVersion, (File)this.rootDir).toPath();
            Files.createSymbolicLink(root2.resolve("Headers"), current2.resolve("Headers"), new FileAttribute[0]);
            Files.createSymbolicLink(root2.resolve("Modules"), current2.resolve("Modules"), new FileAttribute[0]);
            Files.createSymbolicLink(root2.resolve("Resources"), current2.resolve("Resources"), new FileAttribute[0]);
            Files.createSymbolicLink(root2.resolve(this.frameworkName), current2.resolve(this.frameworkName), new FileAttribute[0]);
        }
    }

    public final boolean exists() {
        return this.rootDir.exists();
    }
}

