/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.internal.hash.FileHasher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gson.GsonBuilder;
import org.jetbrains.kotlin.com.google.gson.stream.JsonReader;
import org.jetbrains.kotlin.com.google.gson.stream.JsonToken;
import org.jetbrains.kotlin.com.google.gson.stream.JsonWriter;
import org.jetbrains.kotlin.gradle.targets.js.internal.UtilsKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001:\u0003123B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J'\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050 H\u0000\u00a2\u0006\u0002\b!J\"\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u00052\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050 H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00102\u0006\u0010)\u001a\u00020*H\u0002J\u001b\u0010+\u001a\u00020\u0019*\u00020*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190 H\u0082\bJ\u001b\u0010+\u001a\u00020\u0019*\u00020-2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190 H\u0082\bJ\f\u0010.\u001a\u00020/*\u00020&H\u0002J\u0014\u00100\u001a\u00020\u0019*\u00020\u00102\u0006\u0010)\u001a\u00020-H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache;", "Ljava/lang/AutoCloseable;", "fileHasher", "Lorg/gradle/internal/hash/FileHasher;", "projectDir", "Ljava/io/File;", "targetDir", "stateFileName", "", "version", "(Lorg/gradle/internal/hash/FileHasher;Ljava/io/File;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "getFileHasher", "()Lorg/gradle/internal/hash/FileHasher;", "getProjectDir", "()Ljava/io/File;", "state", "Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$State;", "stateFile", "getTargetDir", "getVersion", "()Ljava/lang/String;", "checkTarget", "", "target", "close", "", "decodeHexString", "", "hexString", "getOrCompute", "file", "compute", "Lkotlin/Function0;", "getOrCompute$kotlin_gradle_plugin_common", "getOrComputeKey", "hexToByte", "", "a", "", "b", "readFrom", "json", "Lorg/jetbrains/kotlin/com/google/gson/stream/JsonReader;", "obj", "body", "Lorg/jetbrains/kotlin/com/google/gson/stream/JsonWriter;", "toDigit", "", "writeTo", "ByteArrayWrapper", "Element", "State", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nProcessedFilesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessedFilesCache.kt\norg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,222:1\n85#1,2:224\n85#1,4:226\n87#1,2:230\n91#1,2:232\n91#1,2:234\n91#1,4:237\n93#1,2:242\n93#1,2:244\n1#2:223\n216#3:236\n217#3:241\n*S KotlinDebug\n*F\n+ 1 ProcessedFilesCache.kt\norg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache\n*L\n36#1:224,2\n42#1:226,4\n36#1:230,2\n67#1:232,2\n70#1:234,2\n73#1:237,4\n70#1:242,2\n67#1:244,2\n71#1:236\n71#1:241\n*E\n"})
public class ProcessedFilesCache
implements AutoCloseable {
    @NotNull
    private final FileHasher fileHasher;
    @NotNull
    private final File projectDir;
    @NotNull
    private final File targetDir;
    @NotNull
    private final String version;
    @NotNull
    private final File stateFile;
    @NotNull
    private final State state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ProcessedFilesCache(@NotNull FileHasher fileHasher, @NotNull File projectDir, @NotNull File targetDir, @NotNull String stateFileName, @NotNull String version2) {
        State state;
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileHasher, (String)"fileHasher");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter((Object)stateFileName, (String)"stateFileName");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        this.fileHasher = fileHasher;
        this.projectDir = projectDir;
        this.targetDir = targetDir;
        this.version = version2;
        this.stateFile = FilesKt.resolve((File)this.targetDir, (String)stateFileName);
        this.targetDir.mkdirs();
        ProcessedFilesCache processedFilesCache = this;
        if (this.stateFile.exists()) {
            Object object2;
            ProcessedFilesCache processedFilesCache2 = processedFilesCache;
            try {
                State state2;
                object2 = this.stateFile;
                Object object3 = Charsets.UTF_8;
                object2 = new GsonBuilder().setPrettyPrinting().create().newJsonReader(new InputStreamReader((InputStream)new FileInputStream((File)object2), (Charset)object3));
                ProcessedFilesCache processedFilesCache3 = processedFilesCache2;
                object3 = null;
                try {
                    JsonReader it = (JsonReader)object2;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    state2 = this.readFrom(it);
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                }
                processedFilesCache = processedFilesCache3;
                object2 = state2;
            }
            catch (Throwable throwable) {
                void e;
                processedFilesCache = processedFilesCache2;
                System.err.println("Cannot read " + this.stateFile);
                e.printStackTrace();
                if (this.targetDir.exists()) {
                    FilesKt.deleteRecursively((File)this.targetDir);
                }
                object2 = null;
            }
            object = object2;
        } else {
            object = state = null;
        }
        if (object == null) {
            state = new State();
        }
        processedFilesCache.state = state;
    }

    @NotNull
    public final FileHasher getFileHasher() {
        return this.fileHasher;
    }

    @NotNull
    public final File getProjectDir() {
        return this.projectDir;
    }

    @NotNull
    public final File getTargetDir() {
        return this.targetDir;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    private final State readFrom(JsonReader json) {
        State result2 = new State();
        ProcessedFilesCache processedFilesCache = this;
        JsonReader $this$obj$iv = json;
        boolean $i$f$obj = false;
        $this$obj$iv.beginObject();
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)json.nextName(), (Object)"version")) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String version2 = json.nextString();
        if (!Intrinsics.areEqual((Object)version2, (Object)this.version)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)json.nextName(), (Object)"items")) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ProcessedFilesCache processedFilesCache2 = this;
        JsonReader $this$obj$iv2 = json;
        boolean $i$f$obj2 = false;
        $this$obj$iv2.beginObject();
        boolean bl2 = false;
        while (json.peek() == JsonToken.NAME) {
            String key = json.nextName();
            json.beginObject();
            if (!Intrinsics.areEqual((Object)json.nextName(), (Object)"src")) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            String src = json.nextString();
            String target2 = null;
            if (json.peek() == JsonToken.NAME) {
                if (!Intrinsics.areEqual((Object)json.nextName(), (Object)"target")) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (json.peek() != JsonToken.NULL) {
                    target2 = json.nextString();
                }
            }
            json.endObject();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            byte[] byArray = this.decodeHexString(key);
            Intrinsics.checkNotNullExpressionValue((Object)src, (String)"src");
            result2.set(byArray, new Element(src, target2));
        }
        $this$obj$iv2.endObject();
        $this$obj$iv.endObject();
        return result2;
    }

    private final void writeTo(State $this$writeTo, JsonWriter json) {
        ProcessedFilesCache processedFilesCache = this;
        JsonWriter $this$obj$iv = json;
        boolean $i$f$obj = false;
        $this$obj$iv.beginObject();
        boolean bl = false;
        json.name("version").value(this.version);
        json.name("items");
        ProcessedFilesCache processedFilesCache2 = this;
        JsonWriter $this$obj$iv2 = json;
        boolean $i$f$obj2 = false;
        $this$obj$iv2.beginObject();
        boolean bl2 = false;
        Map<ByteArrayWrapper, Element> $this$forEach$iv = $this$writeTo.getByHash();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ByteArrayWrapper, Element>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ByteArrayWrapper, Element> element$iv;
            Map.Entry<ByteArrayWrapper, Element> it = element$iv = iterator2.next();
            boolean bl3 = false;
            json.name(UtilsKt.toHex(it.getKey().getContents()));
            ProcessedFilesCache processedFilesCache3 = this;
            JsonWriter $this$obj$iv3 = json;
            boolean $i$f$obj3 = false;
            $this$obj$iv3.beginObject();
            boolean bl4 = false;
            json.name("src").value(it.getValue().getSrc());
            json.name("target");
            if (it.getValue().getTarget() == null) {
                json.nullValue();
            } else {
                json.value(it.getValue().getTarget());
            }
            $this$obj$iv3.endObject();
        }
        $this$obj$iv2.endObject();
        $this$obj$iv.endObject();
    }

    private final void obj(JsonReader $this$obj, Function0<Unit> body) {
        boolean $i$f$obj = false;
        $this$obj.beginObject();
        body.invoke();
        $this$obj.endObject();
    }

    private final void obj(JsonWriter $this$obj, Function0<Unit> body) {
        boolean $i$f$obj = false;
        $this$obj.beginObject();
        body.invoke();
        $this$obj.endObject();
    }

    private final byte[] decodeHexString(String hexString) {
        if (!(hexString.length() % 2 == 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        byte[] bytes = new byte[hexString.length() / 2];
        int i2 = 0;
        int o = 0;
        while (i2 < hexString.length()) {
            bytes[o++] = this.hexToByte(hexString.charAt(i2++), hexString.charAt(i2++));
        }
        return bytes;
    }

    private final byte hexToByte(char a, char b) {
        return (byte)((this.toDigit(a) << 4) + this.toDigit(b));
    }

    private final int toDigit(char $this$toDigit) {
        int n;
        int it = n = Character.digit($this$toDigit, 16);
        boolean bl = false;
        if (!(it != -1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return n;
    }

    @Nullable
    public final File getOrCompute$kotlin_gradle_plugin_common(@NotNull File file2, @NotNull Function0<? extends File> compute) {
        File file3;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        String string = this.getOrComputeKey(file2, compute);
        if (string != null) {
            String it = string;
            boolean bl = false;
            file3 = new File(this.targetDir, it);
        } else {
            file3 = null;
        }
        return file3;
    }

    private final String getOrComputeKey(File file2, Function0<? extends File> compute) {
        File file3;
        if (!file2.exists()) {
            return null;
        }
        byte[] hash = this.fileHasher.hash(file2).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"hash");
        Element old = this.state.get(hash);
        if (old != null) {
            if (this.checkTarget(old.getTarget())) {
                return old.getTarget();
            }
            StringBuilder stringBuilder = new StringBuilder().append("Cannot find ");
            File file4 = FilesKt.relativeTo((File)this.targetDir, (File)this.projectDir);
            String string = old.getTarget();
            Intrinsics.checkNotNull((Object)string);
            System.err.println(stringBuilder.append(new File(file4, string)).append(", rebuilding").toString());
        }
        String key = (file3 = (File)compute.invoke()) != null && (file3 = FilesKt.relativeTo((File)file3, (File)this.targetDir)) != null ? file3.toString() : null;
        Element existedTarget = this.state.getByTarget().get(key);
        if (key != null && existedTarget != null && !new File(existedTarget.getSrc()).exists()) {
            System.err.println("Removing cache for removed source `" + existedTarget.getSrc() + '`');
            this.state.remove(existedTarget);
        }
        String string = FilesKt.normalize((File)file2).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.normalize().absolutePath");
        this.state.set(hash, new Element(string, key));
        return key;
    }

    private final boolean checkTarget(String target2) {
        if (target2 == null) {
            return true;
        }
        return FilesKt.resolve((File)this.targetDir, (String)target2).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.stateFile.getParentFile().mkdirs();
        Object object = this.stateFile;
        Object object2 = Charsets.UTF_8;
        object = new GsonBuilder().setPrettyPrinting().create().newJsonWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2));
        object2 = null;
        try {
            JsonWriter it = (JsonWriter)object;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.writeTo(this.state, it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$ByteArrayWrapper;", "", "contents", "", "([B)V", "getContents", "()[B", "equals", "", "other", "hashCode", "", "kotlin-gradle-plugin_common"})
    public static final class ByteArrayWrapper {
        @NotNull
        private final byte[] contents;

        public ByteArrayWrapper(@NotNull byte[] contents) {
            Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
            this.contents = contents;
        }

        @NotNull
        public final byte[] getContents() {
            return this.contents;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.internal.ProcessedFilesCache.ByteArrayWrapper");
            ByteArrayWrapper cfr_ignored_0 = (ByteArrayWrapper)other;
            return Arrays.equals(this.contents, ((ByteArrayWrapper)other).contents);
        }

        public int hashCode() {
            return Arrays.hashCode(this.contents);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$Element;", "", "src", "", "target", "(Ljava/lang/String;Ljava/lang/String;)V", "getSrc", "()Ljava/lang/String;", "getTarget", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
    public static final class Element {
        @NotNull
        private final String src;
        @Nullable
        private final String target;

        public Element(@NotNull String src, @Nullable String target2) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.src = src;
            this.target = target2;
        }

        @NotNull
        public final String getSrc() {
            return this.src;
        }

        @Nullable
        public final String getTarget() {
            return this.target;
        }

        @NotNull
        public final String component1() {
            return this.src;
        }

        @Nullable
        public final String component2() {
            return this.target;
        }

        @NotNull
        public final Element copy(@NotNull String src, @Nullable String target2) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return new Element(src, target2);
        }

        public static /* synthetic */ Element copy$default(Element element, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = element.src;
            }
            if ((n & 2) != 0) {
                string2 = element.target;
            }
            return element.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Element(src=" + this.src + ", target=" + this.target + ')';
        }

        public int hashCode() {
            int result2 = this.src.hashCode();
            result2 = result2 * 31 + (this.target == null ? 0 : this.target.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Element)) {
                return false;
            }
            Element element = (Element)other;
            if (!Intrinsics.areEqual((Object)this.src, (Object)element.src)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.target, (Object)element.target);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u0019\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0006H\u0086\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$State;", "", "()V", "byHash", "", "Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$ByteArrayWrapper;", "Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$Element;", "getByHash", "()Ljava/util/Map;", "byTarget", "", "getByTarget", "get", "elementHash", "", "remove", "", "element", "set", "kotlin-gradle-plugin_common"})
    private static final class State {
        @NotNull
        private final Map<ByteArrayWrapper, Element> byHash = new LinkedHashMap();
        @NotNull
        private final Map<String, Element> byTarget = new LinkedHashMap();

        @NotNull
        public final Map<ByteArrayWrapper, Element> getByHash() {
            return this.byHash;
        }

        @NotNull
        public final Map<String, Element> getByTarget() {
            return this.byTarget;
        }

        @Nullable
        public final Element get(@NotNull byte[] elementHash) {
            Intrinsics.checkNotNullParameter((Object)elementHash, (String)"elementHash");
            return this.byHash.get(new ByteArrayWrapper(elementHash));
        }

        public final void set(@NotNull byte[] elementHash, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)elementHash, (String)"elementHash");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.byHash.put(new ByteArrayWrapper(elementHash), element);
            String target2 = element.getTarget();
            if (target2 != null) {
                this.byTarget.put(target2, element);
            }
        }

        public final void remove(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.getTarget() != null) {
                this.byTarget.remove(element.getTarget());
            }
            this.byHash.values().removeIf(new Predicate(element){
                final /* synthetic */ Element $element;
                {
                    this.$element = $element;
                }

                public final boolean test(Element it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$element);
                }
            });
        }
    }
}

