/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.gradle.tasks.TaskOutputsBackup;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0002J\u0006\u0010'\u001a\u00020$J\u0006\u0010(\u001a\u00020$J\u0006\u0010)\u001a\u00020$J\u0018\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0018\u0010\u001a\u001a\u00020\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0018\u0010\u001f\u001a\u00020\u0014*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup;", "", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "snapshotsDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "outputsToRestore", "", "Ljava/io/File;", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "(Lorg/gradle/api/file/FileSystemOperations;Lorg/gradle/api/provider/Provider;Ljava/util/List;Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;)V", "getLogger", "()Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "getOutputsToRestore", "()Ljava/util/List;", "getSnapshotsDir", "()Lorg/gradle/api/provider/Provider;", "asNotExistsMarkerFile", "", "", "getAsNotExistsMarkerFile", "(I)Ljava/lang/String;", "asSnapshotArchiveName", "getAsSnapshotArchiveName", "asSnapshotHolderDirectory", "getAsSnapshotHolderDirectory", "isEmptyDirectory", "", "(Ljava/io/File;)Z", "normalizedToBeRelative", "Ljava/nio/file/Path;", "getNormalizedToBeRelative", "(Ljava/nio/file/Path;)Ljava/lang/String;", "compressDirectoryToZip", "", "snapshotFile", "outputPath", "createSnapshot", "deleteSnapshot", "restoreOutputs", "uncompressZipIntoDirectory", "outputDirectory", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nTasksOutputsBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksOutputsBackup.kt\norg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1872#2,3:204\n1872#2,3:207\n1863#2,2:213\n1317#3:210\n1318#3:212\n1#4:211\n*S KotlinDebug\n*F\n+ 1 TasksOutputsBackup.kt\norg/jetbrains/kotlin/gradle/tasks/TaskOutputsBackup\n*L\n45#1:204,3\n74#1:207,3\n151#1:213,2\n131#1:210\n131#1:212\n*E\n"})
public final class TaskOutputsBackup {
    @NotNull
    private final FileSystemOperations fileSystemOperations;
    @NotNull
    private final Provider<Directory> snapshotsDir;
    @NotNull
    private final List<File> outputsToRestore;
    @NotNull
    private final KotlinLogger logger;

    public TaskOutputsBackup(@NotNull FileSystemOperations fileSystemOperations, @NotNull Provider<Directory> snapshotsDir, @NotNull List<? extends File> outputsToRestore, @NotNull KotlinLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
        Intrinsics.checkNotNullParameter(snapshotsDir, (String)"snapshotsDir");
        Intrinsics.checkNotNullParameter(outputsToRestore, (String)"outputsToRestore");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.fileSystemOperations = fileSystemOperations;
        this.snapshotsDir = snapshotsDir;
        this.outputsToRestore = outputsToRestore;
        this.logger = logger2;
    }

    @NotNull
    public final Provider<Directory> getSnapshotsDir() {
        return this.snapshotsDir;
    }

    @NotNull
    public final List<File> getOutputsToRestore() {
        return this.outputsToRestore;
    }

    @NotNull
    public final KotlinLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void createSnapshot() {
        Iterable $this$forEachIndexed$iv = CollectionsKt.toSortedSet((Iterable)this.outputsToRestore);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void outputPath;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            File file2 = (File)item$iv;
            int index = n;
            boolean bl = false;
            if (outputPath.isDirectory()) {
                File snapshotFile = new File(((Directory)this.snapshotsDir.get()).getAsFile(), this.getAsSnapshotArchiveName(index));
                StringBuilder stringBuilder = new StringBuilder().append("Packing ");
                Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
                this.logger.debug(stringBuilder.append(FilesKt.getInvariantSeparatorsPath((File)outputPath)).append(" as ").append(FilesKt.getInvariantSeparatorsPath((File)snapshotFile)).append(" to make a backup").toString());
                this.compressDirectoryToZip(snapshotFile, (File)outputPath);
                continue;
            }
            if (!outputPath.exists()) {
                StringBuilder stringBuilder = new StringBuilder().append("Creating is-empty marker file for ");
                Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
                this.logger.debug(stringBuilder.append(FilesKt.getInvariantSeparatorsPath((File)outputPath)).append(" as it does not exist").toString());
                File markerFile = new File(((Directory)this.snapshotsDir.get()).getAsFile(), this.getAsNotExistsMarkerFile(index));
                markerFile.getParentFile().mkdirs();
                markerFile.createNewFile();
                continue;
            }
            File personalSnapshotDir2 = (File)this.snapshotsDir.map(new Transformer(this, index){
                final /* synthetic */ TaskOutputsBackup this$0;
                final /* synthetic */ int $index;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                }

                public final File transform(Directory it) {
                    return it.file(TaskOutputsBackup.access$getAsSnapshotHolderDirectory(this.this$0, this.$index)).getAsFile();
                }
            }).get();
            StringBuilder stringBuilder = new StringBuilder().append("Copying ");
            Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
            StringBuilder stringBuilder2 = stringBuilder.append(FilesKt.getInvariantSeparatorsPath((File)outputPath)).append(" into ");
            Intrinsics.checkNotNullExpressionValue((Object)personalSnapshotDir2, (String)"personalSnapshotDir");
            this.logger.debug(stringBuilder2.append(FilesKt.getInvariantSeparatorsPath((File)personalSnapshotDir2)).append(" to make a backup").toString());
            this.fileSystemOperations.copy(new Action((File)outputPath, personalSnapshotDir2){
                final /* synthetic */ File $outputPath;
                final /* synthetic */ File $personalSnapshotDir;
                {
                    this.$outputPath = $outputPath;
                    this.$personalSnapshotDir = $personalSnapshotDir;
                }

                public final void execute(CopySpec spec) {
                    Object[] objectArray = new Object[]{this.$outputPath};
                    spec.from(objectArray);
                    spec.into((Object)this.$personalSnapshotDir);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void restoreOutputs() {
        this.fileSystemOperations.delete(new Action(this){
            final /* synthetic */ TaskOutputsBackup this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(DeleteSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getOutputsToRestore()};
                it.delete(objectArray);
            }
        });
        Iterable $this$forEachIndexed$iv = CollectionsKt.toSortedSet((Iterable)this.outputsToRestore);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void outputPath;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            File file2 = (File)item$iv;
            int index = n;
            boolean bl = false;
            File possibleDir = ((Directory)this.snapshotsDir.get()).file(this.getAsSnapshotHolderDirectory(index)).getAsFile();
            File possibleArchive = ((Directory)this.snapshotsDir.get()).file(this.getAsSnapshotArchiveName(index)).getAsFile();
            File possibleNotExistsMarker = ((Directory)this.snapshotsDir.get()).file(this.getAsNotExistsMarkerFile(index)).getAsFile();
            if (possibleArchive.exists()) {
                StringBuilder stringBuilder = new StringBuilder().append("Unpacking ");
                Intrinsics.checkNotNullExpressionValue((Object)possibleArchive, (String)"possibleArchive");
                StringBuilder stringBuilder2 = stringBuilder.append(FilesKt.getInvariantSeparatorsPath((File)possibleArchive)).append(" into ");
                Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
                this.logger.debug(stringBuilder2.append(FilesKt.getInvariantSeparatorsPath((File)outputPath)).append(" to restore from backup").toString());
                outputPath.mkdirs();
                this.uncompressZipIntoDirectory(possibleArchive, (File)outputPath);
                continue;
            }
            if (possibleDir.exists()) {
                StringBuilder stringBuilder = new StringBuilder().append("Copying file from ");
                Intrinsics.checkNotNullExpressionValue((Object)possibleDir, (String)"possibleDir");
                StringBuilder stringBuilder3 = stringBuilder.append(FilesKt.getInvariantSeparatorsPath((File)possibleDir)).append(" into ");
                File file3 = outputPath.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"outputPath.parentFile");
                this.logger.debug(stringBuilder3.append(FilesKt.getInvariantSeparatorsPath((File)file3)).append(" to restore ").append(outputPath.getName()).append(" from backup").toString());
                this.fileSystemOperations.copy(new Action(possibleDir, (File)outputPath){
                    final /* synthetic */ File $possibleDir;
                    final /* synthetic */ File $outputPath;
                    {
                        this.$possibleDir = $possibleDir;
                        this.$outputPath = $outputPath;
                    }

                    public final void execute(CopySpec spec) {
                        Object[] objectArray = new Object[]{this.$possibleDir};
                        spec.from(objectArray);
                        spec.into((Object)this.$outputPath.getParentFile());
                    }
                });
                continue;
            }
            if (possibleNotExistsMarker.exists()) {
                StringBuilder stringBuilder = new StringBuilder().append("Found marker ");
                Intrinsics.checkNotNullExpressionValue((Object)possibleNotExistsMarker, (String)"possibleNotExistsMarker");
                StringBuilder stringBuilder4 = stringBuilder.append(FilesKt.getInvariantSeparatorsPath((File)possibleNotExistsMarker)).append(" for ");
                Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
                this.logger.debug(stringBuilder4.append(FilesKt.getInvariantSeparatorsPath((File)outputPath)).append(", doing nothing").toString());
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder().append("\n                    |Failed to restore task outputs as all possible snapshot files for ");
            Intrinsics.checkNotNullExpressionValue((Object)outputPath, (String)"outputPath");
            this.logger.warn(StringsKt.trimMargin$default((String)stringBuilder.append(FilesKt.getInvariantSeparatorsPath((File)outputPath)).append(" do not exist!\n                    |On recompilation full rebuild will be performed.\n                    ").toString(), null, (int)1, null));
            Function0 walkSnapshots2 = (Function0)new Function0<String>(this){
                final /* synthetic */ TaskOutputsBackup this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final String invoke() {
                    Stream<R> stream = Files.walk(FileUtilsKt.getDirectoryAsFile(this.this$0.getSnapshotsDir()).toPath(), new FileVisitOption[0]).map((Function)restoreOutputs.2.walkSnapshots.1.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(snapshotsDir.getFil\u2026ing\n                    }");
                    return CollectionsKt.joinToString$default((Iterable)SequencesKt.toList((Sequence)StreamsKt.asSequence(stream)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                }
            };
            this.logger.debug("Available snapshots: " + (String)walkSnapshots2.invoke());
            return;
        }
    }

    public final void deleteSnapshot() {
        this.fileSystemOperations.delete(new Action(this){
            final /* synthetic */ TaskOutputsBackup this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(DeleteSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getSnapshotsDir()};
                it.delete(objectArray);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void compressDirectoryToZip(File snapshotFile, File outputPath) {
        snapshotFile.getParentFile().mkdirs();
        snapshotFile.createNewFile();
        Closeable closeable = new FileOutputStream(snapshotFile);
        int n = 8192;
        closeable = new ZipOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipOutputStream zip = (ZipOutputStream)closeable;
            boolean bl = false;
            zip.setLevel(0);
            Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)outputPath)), (Function1)((Function1)new Function1<File, Boolean>(this){
                final /* synthetic */ TaskOutputsBackup this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Boolean invoke(File file2) {
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    return !file2.isDirectory() || TaskOutputsBackup.access$isEmptyDirectory(this.this$0, file2);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file2 = (File)element$iv;
                boolean bl2 = false;
                String suffix = file2.isDirectory() ? "/" : "";
                ZipEntry entry2 = new ZipEntry(FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)file2, (File)outputPath)) + suffix);
                zip.putNextEntry(entry2);
                if (!file2.isDirectory()) {
                    Closeable closeable2 = new FileInputStream(file2);
                    int n2 = 8192;
                    closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n2);
                    Throwable throwable2 = null;
                    try {
                        BufferedInputStream it = (BufferedInputStream)closeable2;
                        boolean bl3 = false;
                        long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)zip, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                zip.closeEntry();
            }
            zip.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void uncompressZipIntoDirectory(File snapshotFile, File outputDirectory2) {
        Path outputPath = outputDirectory2.toPath();
        URI snapshotUri = URI.create("jar:" + snapshotFile.toURI());
        Closeable closeable = FileSystems.newFileSystem(snapshotUri, MapsKt.emptyMap());
        Throwable throwable = null;
        try {
            FileSystem zipFs = (FileSystem)closeable;
            boolean bl = false;
            Iterable<Path> iterable = zipFs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"zipFs.rootDirectories");
            Iterable<Path> $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator<Path> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Path element$iv;
                Path rootDir = element$iv = iterator2.next();
                boolean bl2 = false;
                AutoCloseable autoCloseable = Files.walk(rootDir, new FileVisitOption[0]);
                Throwable throwable2 = null;
                try {
                    Stream paths = (Stream)autoCloseable;
                    boolean bl3 = false;
                    paths.forEach(new Consumer(outputPath, this){
                        final /* synthetic */ Path $outputPath;
                        final /* synthetic */ TaskOutputsBackup this$0;
                        {
                            this.$outputPath = $outputPath;
                            this.this$0 = $receiver;
                        }

                        public final void accept(Path it) {
                            if (Files.isDirectory(it, new LinkOption[0])) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                Files.createDirectories(this.$outputPath.resolve(TaskOutputsBackup.access$getNormalizedToBeRelative(this.this$0, it)), new FileAttribute[0]);
                            } else if (Files.isRegularFile(it, new LinkOption[0])) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Files.copy(it, this.$outputPath.resolve(TaskOutputsBackup.access$getNormalizedToBeRelative(this.this$0, it)), copyOptionArray);
                            }
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isEmptyDirectory(File $this$isEmptyDirectory) {
        boolean bl;
        AutoCloseable autoCloseable = Files.list($this$isEmptyDirectory.toPath());
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl2 = false;
            bl = it.findFirst().isPresent();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return !bl;
    }

    private final String getNormalizedToBeRelative(Path $this$normalizedToBeRelative) {
        return Intrinsics.areEqual((Object)((Object)$this$normalizedToBeRelative).toString(), (Object)"/") ? "." : StringsKt.removePrefix((String)((Object)$this$normalizedToBeRelative).toString(), (CharSequence)"/");
    }

    private final String getAsSnapshotArchiveName(int $this$asSnapshotArchiveName) {
        return $this$asSnapshotArchiveName + ".zip";
    }

    private final String getAsNotExistsMarkerFile(int $this$asNotExistsMarkerFile) {
        return $this$asNotExistsMarkerFile + ".not-exists";
    }

    private final String getAsSnapshotHolderDirectory(int $this$asSnapshotHolderDirectory) {
        return String.valueOf($this$asSnapshotHolderDirectory);
    }

    public static final /* synthetic */ String access$getAsSnapshotHolderDirectory(TaskOutputsBackup $this, int $receiver) {
        return $this.getAsSnapshotHolderDirectory($receiver);
    }

    public static final /* synthetic */ boolean access$isEmptyDirectory(TaskOutputsBackup $this, File $receiver) {
        return $this.isEmptyDirectory($receiver);
    }

    public static final /* synthetic */ String access$getNormalizedToBeRelative(TaskOutputsBackup $this, Path $receiver) {
        return $this.getNormalizedToBeRelative($receiver);
    }
}

