/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a1\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\r"}, d2={"formatContentLength", "", "bytes", "", "formatDuration", "milliseconds", "lifecycleWithDuration", "T", "Lorg/gradle/api/logging/Logger;", "messagePrefix", "action", "Lkotlin/Function0;", "(Lorg/gradle/api/logging/Logger;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-gradle-plugin_common"})
public final class FormattingUtilsKt {
    @NotNull
    public static final String formatDuration(long milliseconds) {
        StringBuilder stringBuilder;
        long ms = 0L;
        ms = milliseconds;
        long s = 0L;
        long m = 0L;
        long h = 0L;
        if (ms >= 1000L) {
            s = ms / (long)1000;
            ms %= (long)1000;
            if (s >= 60L) {
                m = s / (long)60;
                s %= (long)60;
                if (m >= 60L) {
                    h = m / (long)60;
                    m %= (long)60;
                }
            }
        }
        StringBuilder $this$formatDuration_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (h > 0L) {
            $this$formatDuration_u24lambda_u240.append(h).append(" h ");
        }
        if (m > 0L || ((CharSequence)$this$formatDuration_u24lambda_u240).length() > 0) {
            $this$formatDuration_u24lambda_u240.append(m).append(" m ");
        }
        if (s > 0L || ((CharSequence)$this$formatDuration_u24lambda_u240).length() > 0) {
            $this$formatDuration_u24lambda_u240.append(s).append(" s ");
        }
        if (ms > 0L || ((CharSequence)$this$formatDuration_u24lambda_u240).length() > 0) {
            $this$formatDuration_u24lambda_u240.append(ms).append(" ms");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final <T> T lifecycleWithDuration(@NotNull Logger $this$lifecycleWithDuration, @NotNull String messagePrefix, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)$this$lifecycleWithDuration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)messagePrefix, (String)"messagePrefix");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$lifecycleWithDuration = false;
        long startTime = System.currentTimeMillis();
        Object result2 = action2.invoke();
        long finishTime = System.currentTimeMillis();
        $this$lifecycleWithDuration.lifecycle(messagePrefix + " took " + FormattingUtilsKt.formatDuration(finishTime - startTime));
        return (T)result2;
    }

    @NotNull
    public static final String formatContentLength(long bytes) {
        String string;
        if (bytes < 0L) {
            string = "N/A";
        } else if (bytes < 1024L) {
            string = bytes + " bytes";
        } else {
            double kilobytes = (double)bytes / (double)1024;
            if (kilobytes < 1024.0) {
                String string2 = "%.2f KB";
                Object[] objectArray = new Object[]{kilobytes};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                double megabytes = kilobytes / (double)1024;
                if (megabytes < 1024.0) {
                    String string4 = "%.2f MB";
                    Object[] objectArray = new Object[]{megabytes};
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                } else {
                    double gigabytes = megabytes / (double)1024;
                    String string6 = "%.2f GB";
                    Object[] objectArray = new Object[]{gigabytes};
                    String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
                }
            }
        }
        return string;
    }
}

