/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.properties.NativePropertiesKt;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionTypeProvider;
import org.jetbrains.kotlin.gradle.utils.ConfigurationsKt;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.gradle.utils.NativeCompilerDownloader;
import org.jetbrains.kotlin.gradle.utils.ResourceUtilsKt;
import org.jetbrains.kotlin.internal.compilerRunner.native.NativeRunnerHelpersKt;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.util.DependencyDirectories;
import org.jetbrains.kotlin.tooling.core.KotlinToolingVersion;
import org.jetbrains.kotlin.tooling.core.KotlinToolingVersionKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0002,-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u0006\u0010&\u001a\u00020$J\u0010\u0010'\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\nH\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001d\u0010\f\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "compilerDirectory", "Ljava/io/File;", "getCompilerDirectory", "()Ljava/io/File;", "dependencyFileName", "", "getDependencyFileName", "()Ljava/lang/String;", "dependencyNameWithOsAndVersion", "getDependencyNameWithOsAndVersion", "downloadFromMaven", "Lorg/gradle/api/provider/Provider;", "", "kotlinProperties", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "getKotlinProperties", "()Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "getProject", "()Lorg/gradle/api/Project;", "repoUrl", "getRepoUrl", "repoUrl$delegate", "Lkotlin/Lazy;", "archiveFileTree", "Lorg/gradle/api/file/FileTree;", "archive", "checkClassPath", "", "downloadAndExtract", "downloadIfNeeded", "extractKotlinNativeFromArchive", "removeRepo", "repo", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "setupRepo", "Companion", "NativeCompilerDownloaderClassPathChecker", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nNativeCompilerDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 formattingUtils.kt\norg/jetbrains/kotlin/gradle/utils/FormattingUtilsKt\n*L\n1#1,304:1\n1#2:305\n38#3,7:306\n38#3,7:313\n*S KotlinDebug\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader\n*L\n186#1:306,7\n199#1:313,7\n*E\n"})
public final class NativeCompilerDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Provider<Boolean> downloadFromMaven;
    @NotNull
    private final Lazy repoUrl$delegate;
    @NotNull
    private static final Lazy<String> DEFAULT_KONAN_VERSION$delegate = LazyKt.lazy((Function0)Companion.DEFAULT_KONAN_VERSION.2.INSTANCE);
    private static boolean NEED_TO_DOWNLOAD_FLAG = true;
    @NotNull
    public static final String BASE_DOWNLOAD_URL = "https://download.jetbrains.com/kotlin/native/builds";
    @NotNull
    public static final String KOTLIN_GROUP_ID = "org.jetbrains.kotlin";
    @NotNull
    private static final String simpleOsName = HostManager.Companion.platformName();
    private static final boolean useZip = HostManager.Companion.getHostIsMingw();

    public NativeCompilerDownloader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.downloadFromMaven = NativePropertiesKt.getNativeProperties(this.project).getDownloadFromMaven();
        this.repoUrl$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NativeCompilerDownloader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                StringBuilder stringBuilder;
                KotlinToolingVersion.Maturity maturity = KotlinToolingVersionKt.KotlinToolingVersion((String)org.jetbrains.kotlin.gradle.utils.NativeCompilerDownloader$Companion.access$getCompilerVersion(NativeCompilerDownloader.Companion, this.this$0.getProject())).getMaturity();
                NativeCompilerDownloader nativeCompilerDownloader = this.this$0;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$invoke_u24lambda_u240.append(NativeCompilerDownloader.access$getKotlinProperties(nativeCompilerDownloader).getNativeBaseDownloadUrl() + '/');
                $this$invoke_u24lambda_u240.append(maturity == KotlinToolingVersion.Maturity.DEV ? "dev/" : "releases/");
                $this$invoke_u24lambda_u240.append(org.jetbrains.kotlin.gradle.utils.NativeCompilerDownloader$Companion.access$getCompilerVersion(NativeCompilerDownloader.Companion, nativeCompilerDownloader.getProject()) + '/');
                $this$invoke_u24lambda_u240.append(NativeCompilerDownloader.access$getSimpleOsName$cp());
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final File getCompilerDirectory() {
        return Companion.getCompilerDirectory$kotlin_gradle_plugin_common(this.project, NativePropertiesKt.getNativeProperties(this.project).getKonanDataDir());
    }

    private final Logger getLogger() {
        Logger logger2 = this.project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"project.logger");
        return logger2;
    }

    private final PropertiesProvider getKotlinProperties() {
        return PropertiesProvider.Companion.invoke(this.project);
    }

    private final String getDependencyNameWithOsAndVersion() {
        return Companion.getDependencyNameWithOsAndVersion$kotlin_gradle_plugin_common(this.project);
    }

    private final String getDependencyFileName() {
        return this.getDependencyNameWithOsAndVersion() + '.' + NativeCompilerDownloader.Companion.getArchiveExtension();
    }

    private final FileTree archiveFileTree(File archive) {
        FileTree fileTree;
        if (useZip) {
            FileTree fileTree2 = this.project.zipTree((Object)archive);
            fileTree = fileTree2;
            Intrinsics.checkNotNullExpressionValue((Object)fileTree2, (String)"{\n            project.zipTree(archive)\n        }");
        } else {
            FileTree fileTree3 = this.project.tarTree((Object)archive);
            fileTree = fileTree3;
            Intrinsics.checkNotNullExpressionValue((Object)fileTree3, (String)"{\n            project.tarTree(archive)\n        }");
        }
        return fileTree;
    }

    private final ArtifactRepository setupRepo(String repoUrl2) {
        IvyArtifactRepository ivyArtifactRepository = this.project.getRepositories().ivy(new Action(repoUrl2){
            final /* synthetic */ String $repoUrl;
            {
                this.$repoUrl = $repoUrl;
            }

            public final void execute(IvyArtifactRepository repo2) {
                repo2.setUrl((Object)this.$repoUrl);
                repo2.patternLayout((Action)setupRepo.1.INSTANCE);
                repo2.metadataSources((Action)setupRepo.2.INSTANCE);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)ivyArtifactRepository, (String)"repoUrl: String): Artifa\u2026)\n            }\n        }");
        return (ArtifactRepository)ivyArtifactRepository;
    }

    private final void removeRepo(ArtifactRepository repo2) {
        this.project.getRepositories().remove((Object)repo2);
    }

    private final String getRepoUrl() {
        Lazy lazy = this.repoUrl$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadAndExtract() {
        void $this$lifecycleWithDuration$iv;
        Logger lengthSuffix;
        Dependency dependency;
        ArtifactRepository repo2 = (Boolean)this.downloadFromMaven.get() == false ? this.setupRepo(this.getRepoUrl()) : null;
        Object object = this.downloadFromMaven.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"downloadFromMaven.get()");
        if (((Boolean)object).booleanValue()) {
            dependency = this.project.getDependencies().create(Companion.getCompilerDependencyNotation$kotlin_gradle_plugin_common(this.project));
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)(NativeCompilerDownloader.Companion.getDependencyName(this.project) + '-' + simpleOsName)), TuplesKt.to((Object)"version", (Object)NativeCompilerDownloader.Companion.getCompilerVersion(this.project)), TuplesKt.to((Object)"ext", (Object)NativeCompilerDownloader.Companion.getArchiveExtension())};
            dependency = this.project.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
        }
        Dependency compilerDependency = dependency;
        ConfigurationContainer configurationContainer = this.project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        Dependency[] dependencyArray = new Dependency[1];
        Intrinsics.checkNotNullExpressionValue((Object)compilerDependency, (String)"compilerDependency");
        dependencyArray[0] = compilerDependency;
        Configuration configuration2 = ConfigurationsKt.detachedResolvable(configurationContainer, dependencyArray);
        this.getLogger().lifecycle("\nPlease wait while Kotlin/Native compiler " + NativeCompilerDownloader.Companion.getCompilerVersion(this.project) + " is being installed.");
        if (!((Boolean)this.downloadFromMaven.get()).booleanValue()) {
            String string;
            String string2;
            String dependencyUrl = this.getRepoUrl() + '/' + this.getDependencyFileName();
            Long l = ResourceUtilsKt.probeRemoteFileLength(this.project, dependencyUrl, 200);
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                string2 = " (" + FormattingUtilsKt.formatContentLength(it) + ')';
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "";
            }
            lengthSuffix = string;
            this.getLogger().lifecycle("Download " + dependencyUrl + (String)lengthSuffix);
        }
        lengthSuffix = this.getLogger();
        String messagePrefix$iv = "Download " + this.getDependencyFileName() + " finished,";
        boolean $i$f$lifecycleWithDuration = false;
        long startTime$iv = System.currentTimeMillis();
        boolean bl = false;
        Set set = configuration2.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configuration.files");
        File result$iv = (File)CollectionsKt.single((Iterable)set);
        long finishTime$iv = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv - startTime$iv));
        File archive = result$iv;
        Intrinsics.checkNotNullExpressionValue((Object)archive, (String)"archive");
        this.extractKotlinNativeFromArchive(archive);
        if (repo2 != null) {
            this.removeRepo(repo2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void extractKotlinNativeFromArchive(File archive) {
        void $this$lifecycleWithDuration$iv;
        File file2;
        GradleLoggingUtilsKt.kotlinInfo(this.getLogger(), "Using Kotlin/Native compiler archive: " + archive.getAbsolutePath());
        this.getLogger().lifecycle("Unpack Kotlin/Native compiler to " + this.getCompilerDirectory());
        Logger logger2 = this.getLogger();
        String messagePrefix$iv = "Unpack Kotlin/Native compiler to " + this.getCompilerDirectory() + " finished,";
        boolean $i$f$lifecycleWithDuration = false;
        long startTime$iv = System.currentTimeMillis();
        boolean bl = false;
        File it = file2 = this.getCompilerDirectory().getParentFile();
        boolean bl2 = false;
        it.mkdirs();
        File kotlinNativeDir = file2;
        File tmpDir = Files.createTempDirectory(kotlinNativeDir.toPath(), "compiler-", new FileAttribute[0]).toFile();
        try {
            this.getLogger().debug("Unpacking Kotlin/Native compiler to tmp directory " + tmpDir);
            this.project.copy(new Action(this, archive, tmpDir){
                final /* synthetic */ NativeCompilerDownloader this$0;
                final /* synthetic */ File $archive;
                final /* synthetic */ File $tmpDir;
                {
                    this.this$0 = $receiver;
                    this.$archive = $archive;
                    this.$tmpDir = $tmpDir;
                }

                public final void execute(CopySpec it) {
                    Object[] objectArray = new Object[]{NativeCompilerDownloader.access$archiveFileTree(this.this$0, this.$archive)};
                    it.from(objectArray);
                    it.into((Object)this.$tmpDir);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            File compilerTmp = FilesKt.resolve((File)tmpDir, (String)this.getDependencyNameWithOsAndVersion());
            if (!compilerTmp.renameTo(this.getCompilerDirectory())) {
                this.project.copy(new Action(compilerTmp, this){
                    final /* synthetic */ File $compilerTmp;
                    final /* synthetic */ NativeCompilerDownloader this$0;
                    {
                        this.$compilerTmp = $compilerTmp;
                        this.this$0 = $receiver;
                    }

                    public final void execute(CopySpec it) {
                        Object[] objectArray = new Object[]{this.$compilerTmp};
                        it.from(objectArray);
                        it.into((Object)this.this$0.getCompilerDirectory());
                    }
                });
            }
            this.getLogger().debug("Moved Kotlin/Native compiler from " + tmpDir + " to " + this.getCompilerDirectory());
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNullExpressionValue((Object)tmpDir, (String)"tmpDir");
            FilesKt.deleteRecursively((File)tmpDir);
            throw throwable;
        }
        FilesKt.deleteRecursively((File)tmpDir);
        Unit result$iv = Unit.INSTANCE;
        long finishTime$iv = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv - startTime$iv));
    }

    public final void downloadIfNeeded() {
        this.checkClassPath();
        if (NEED_TO_DOWNLOAD_FLAG) {
            this.downloadAndExtract();
        }
    }

    private final void checkClassPath() {
        this.project.getProviders().of(NativeCompilerDownloaderClassPathChecker.class, new Action(this){
            final /* synthetic */ NativeCompilerDownloader this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ValueSourceSpec<NativeCompilerDownloaderClassPathChecker.Params> it) {
                ConfigurableFileCollection configurableFileCollection = ((NativeCompilerDownloaderClassPathChecker.Params)it.getParameters()).getClassPath();
                ObjectFactory objectFactory = this.this$0.getProject().getObjects();
                Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
                configurableFileCollection.setFrom((Iterable)NativeRunnerHelpersKt.nativeCompilerClasspath(objectFactory, NativePropertiesKt.getNativeProperties(this.this$0.getProject()).getActualNativeHomeDirectory(), NativePropertiesKt.getNativeProperties(this.this$0.getProject()).getShouldUseEmbeddableCompilerJar()));
            }
        }).get();
    }

    public static final /* synthetic */ FileTree access$archiveFileTree(NativeCompilerDownloader $this, File archive) {
        return $this.archiveFileTree(archive);
    }

    public static final /* synthetic */ PropertiesProvider access$getKotlinProperties(NativeCompilerDownloader $this) {
        return $this.getKotlinProperties();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0015\u0010 \u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0015\u0010#\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b$J\u001d\u0010%\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$Companion;", "", "()V", "BASE_DOWNLOAD_URL", "", "DEFAULT_KONAN_VERSION", "getDEFAULT_KONAN_VERSION", "()Ljava/lang/String;", "DEFAULT_KONAN_VERSION$delegate", "Lkotlin/Lazy;", "KOTLIN_GROUP_ID", "NEED_TO_DOWNLOAD_FLAG", "", "getNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common", "()Z", "setNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common", "(Z)V", "archiveExtension", "getArchiveExtension", "simpleOsName", "useZip", "getCompilerDependencyNotation", "", "project", "Lorg/gradle/api/Project;", "getCompilerDependencyNotation$kotlin_gradle_plugin_common", "getCompilerDirectory", "Ljava/io/File;", "konanDataDirProperty", "Lorg/gradle/api/provider/Provider;", "getCompilerDirectory$kotlin_gradle_plugin_common", "getCompilerVersion", "getDefaultCompilerDirectory", "getDefaultCompilerDirectory$kotlin_gradle_plugin_common", "getDependencyName", "getDependencyNameWithOsAndVersion", "getDependencyNameWithOsAndVersion$kotlin_gradle_plugin_common", "getOsSpecificCompilerDirectory", "konanDataDir", "getOsSpecificCompilerDirectory$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDEFAULT_KONAN_VERSION() {
            Lazy lazy = DEFAULT_KONAN_VERSION$delegate;
            return (String)lazy.getValue();
        }

        public final boolean getNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common() {
            return NEED_TO_DOWNLOAD_FLAG;
        }

        public final void setNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common(boolean bl) {
            NEED_TO_DOWNLOAD_FLAG = bl;
        }

        @NotNull
        public final Map<String, String> getCompilerDependencyNotation$kotlin_gradle_plugin_common(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)NativeCompilerDownloader.KOTLIN_GROUP_ID), TuplesKt.to((Object)"name", (Object)this.getDependencyName(project)), TuplesKt.to((Object)"version", (Object)this.getCompilerVersion(project)), TuplesKt.to((Object)"classifier", (Object)simpleOsName), TuplesKt.to((Object)"ext", (Object)this.getArchiveExtension())};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @NotNull
        public final File getCompilerDirectory$kotlin_gradle_plugin_common(@NotNull Project project, @NotNull Provider<File> konanDataDirProperty2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(konanDataDirProperty2, (String)"konanDataDirProperty");
            File file2 = (File)konanDataDirProperty2.getOrNull();
            return FilesKt.resolve((File)DependencyDirectories.INSTANCE.getLocalKonanDir(file2 != null ? file2.getAbsolutePath() : null), (String)this.getDependencyNameWithOsAndVersion$kotlin_gradle_plugin_common(project));
        }

        @NotNull
        public final File getDefaultCompilerDirectory$kotlin_gradle_plugin_common(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return FilesKt.resolve((File)DependencyDirectories.INSTANCE.getLocalKonanDir(null), (String)this.getDependencyNameWithOsAndVersion$kotlin_gradle_plugin_common(project));
        }

        @NotNull
        public final File getOsSpecificCompilerDirectory$kotlin_gradle_plugin_common(@NotNull Project project, @NotNull File konanDataDir2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)konanDataDir2, (String)"konanDataDir");
            return FilesKt.resolve((File)konanDataDir2, (String)this.getDependencyNameWithOsAndVersion$kotlin_gradle_plugin_common(project));
        }

        @NotNull
        public final String getDependencyNameWithOsAndVersion$kotlin_gradle_plugin_common(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getDependencyName(project) + '-' + simpleOsName + '-' + this.getCompilerVersion(project);
        }

        private final String getCompilerVersion(Project project) {
            Object object = NativePropertiesKt.getNativeProperties(project).getKotlinNativeVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.nativeProperties.kotlinNativeVersion.get()");
            return (String)object;
        }

        private final String getDependencyName(Project project) {
            String dependencySuffix = new NativeDistributionTypeProvider(PropertiesProvider.Companion.invoke(project).getNativeDistributionType()).getDistributionType().getSuffix();
            return dependencySuffix != null ? "kotlin-native-" + dependencySuffix : "kotlin-native";
        }

        private final String getArchiveExtension() {
            return useZip ? "zip" : "tar.gz";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker;", "Lorg/gradle/api/provider/ValueSource;", "", "Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker$Params;", "()V", "obtain", "()Ljava/lang/Boolean;", "Params", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nNativeCompilerDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,304:1\n2632#2,3:305\n*S KotlinDebug\n*F\n+ 1 NativeCompilerDownloader.kt\norg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker\n*L\n248#1:305,3\n*E\n"})
    public static abstract class NativeCompilerDownloaderClassPathChecker
    implements ValueSource<Boolean, Params> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public Boolean obtain() {
            boolean bl;
            Companion companion;
            block3: {
                void $this$none$iv;
                Set set = ((Params)this.getParameters()).getClassPath().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"parameters.classPath.files");
                Iterable iterable = set;
                companion = Companion;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        File it = (File)element$iv;
                        boolean bl2 = false;
                        if (!it.exists()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            boolean bl3 = bl;
            companion.setNEED_TO_DOWNLOAD_FLAG$kotlin_gradle_plugin_common(bl3);
            return true;
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$NativeCompilerDownloaderClassPathChecker$Params;", "Lorg/gradle/api/provider/ValueSourceParameters;", "classPath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassPath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlin-gradle-plugin_common"})
        public static interface Params
        extends ValueSourceParameters {
            @NotNull
            public ConfigurableFileCollection getClassPath();
        }
    }
}

