/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.testing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\fH\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/testing/TCServiceMessageOutputStreamHandler;", "Ljava/io/OutputStream;", "client", "Ljetbrains/buildServer/messages/serviceMessages/ServiceMessageParserCallback;", "onException", "Lkotlin/Function0;", "", "logger", "Lorg/slf4j/Logger;", "ignoreTcsmOverflow", "", "messageLimitBytes", "", "(Ljetbrains/buildServer/messages/serviceMessages/ServiceMessageParserCallback;Lkotlin/jvm/functions/Function0;Lorg/slf4j/Logger;ZI)V", "buffer", "Ljava/io/ByteArrayOutputStream;", "closed", "overflowInsideMessage", "close", "flushLine", "overflow", "parse", "text", "", "write", "b", "", "off", "len", "Companion", "kotlin-gradle-plugin_common"})
public final class TCServiceMessageOutputStreamHandler
extends OutputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServiceMessageParserCallback client;
    @NotNull
    private final Function0<Unit> onException;
    @NotNull
    private final Logger logger;
    private final boolean ignoreTcsmOverflow;
    private final int messageLimitBytes;
    private boolean closed;
    @NotNull
    private final ByteArrayOutputStream buffer;
    private boolean overflowInsideMessage;
    private static final int MESSAGE_LIMIT_BYTES = 0x100000;
    @NotNull
    public static final String IGNORE_TCSM_OVERFLOW = "kotlin.ignore.tcsm.overflow";

    public TCServiceMessageOutputStreamHandler(@NotNull ServiceMessageParserCallback client, @NotNull Function0<Unit> onException, @NotNull Logger logger2, boolean ignoreTcsmOverflow, int messageLimitBytes) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(onException, (String)"onException");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.client = client;
        this.onException = onException;
        this.logger = logger2;
        this.ignoreTcsmOverflow = ignoreTcsmOverflow;
        this.messageLimitBytes = messageLimitBytes;
        this.buffer = new ByteArrayOutputStream();
    }

    public /* synthetic */ TCServiceMessageOutputStreamHandler(ServiceMessageParserCallback serviceMessageParserCallback, Function0 function0, Logger logger2, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            n = 0x100000;
        }
        this(serviceMessageParserCallback, (Function0<Unit>)function0, logger2, bl, n);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.flushLine();
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.closed) {
            throw new IOException("The stream has been closed.");
        }
        Ref.IntRef i2 = new Ref.IntRef();
        i2.element = off;
        Ref.IntRef last = new Ref.IntRef();
        last.element = off;
        int end = off + len;
        while (i2.element < end) {
            int n = i2.element;
            i2.element = n + 1;
            byte c = b[n];
            if (c == 10) {
                TCServiceMessageOutputStreamHandler.write$append$default(this, b, last, i2, 0, 16, null);
                this.flushLine();
                continue;
            }
            if (this.buffer.size() + TCServiceMessageOutputStreamHandler.write$bytesToAppend(i2, last) < this.messageLimitBytes) continue;
            TCServiceMessageOutputStreamHandler.write$append(this, b, last, i2, this.messageLimitBytes - this.buffer.size());
            this.overflow();
        }
        TCServiceMessageOutputStreamHandler.write$append$default(this, b, last, i2, 0, 16, null);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] byArray = new byte[]{(byte)b};
        this.write(byArray, 0, 1);
    }

    private final void flushLine() {
        this.overflowInsideMessage = false;
        if (this.buffer.size() > 0) {
            String text = this.buffer.toString("utf-8");
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            this.parse(text);
            this.buffer.reset();
        }
    }

    private final void overflow() {
        int i2;
        int n;
        String text = this.buffer.toString("utf-8");
        if (this.overflowInsideMessage) {
            if (!this.ignoreTcsmOverflow) {
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                if (!StringsKt.endsWith$default((String)text, (String)"]", (boolean)false, (int)2, null)) {
                    this.logger.warn(text);
                    this.overflowInsideMessage = false;
                    this.buffer.reset();
                    this.client.serviceMessage(new TestFailed("overflow-message", (Throwable)new GradleException("Cannot process output: too long teamcity service message (more than 1Mb). Event was lost.\nBuild failed to prevent inconsistent behaviour. To ignore it use Gradle property 'kotlin.ignore.tcsm.overflow=true'")));
                }
            }
            n = -1;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            n = i2 = StringsKt.indexOf$default((CharSequence)text, (String)"##teamcity[", (int)0, (boolean)false, (int)6, null);
        }
        if (i2 != -1) {
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            String string = text.substring(0, i2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.client.regularText(string);
            this.buffer.reset();
            String string2 = text.substring(i2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = string2;
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.buffer.write(byArray);
            this.overflowInsideMessage = true;
        } else {
            this.flushLine();
        }
    }

    private final void parse(String text) {
        try {
            ServiceMessage.parse(text, this.client);
        }
        catch (Exception e) {
            this.onException.invoke();
            this.logger.error("Error while processing test process output message \"" + text + '\"', (Throwable)e);
        }
    }

    private static final int write$bytesToAppend(Ref.IntRef i2, Ref.IntRef last) {
        return i2.element - last.element;
    }

    private static final void write$append(TCServiceMessageOutputStreamHandler this$0, byte[] $b, Ref.IntRef last, Ref.IntRef i2, int len) {
        this$0.buffer.write($b, last.element, i2.element - last.element);
        last.element += len;
    }

    static /* synthetic */ void write$append$default(TCServiceMessageOutputStreamHandler tCServiceMessageOutputStreamHandler, byte[] byArray, Ref.IntRef intRef, Ref.IntRef intRef2, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = TCServiceMessageOutputStreamHandler.write$bytesToAppend(intRef2, intRef);
        }
        TCServiceMessageOutputStreamHandler.write$append(tCServiceMessageOutputStreamHandler, byArray, intRef, intRef2, n);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/testing/TCServiceMessageOutputStreamHandler$Companion;", "", "()V", "IGNORE_TCSM_OVERFLOW", "", "MESSAGE_LIMIT_BYTES", "", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

