/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ReportedDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.StyledToolingDiagnosticKt;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticOutput;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticRenderingOptions;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticRenderingOptionsKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u001a\u0018\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a2\u0010\n\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\"\u0010\u0014\u001a\u00020\u0015*\u00060\u0016j\u0002`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000*\f\b\u0000\u0010\u001b\"\u00020\u00052\u00020\u0005\u00a8\u0006\u001c\u00b2\u0006\n\u0010\u001d\u001a\u00020\u0001X\u008a\u0084\u0002"}, d2={"DIAGNOSTIC_SEPARATOR", "", "DIAGNOSTIC_STACKTRACE_END_SEPARATOR", "DIAGNOSTIC_STACKTRACE_START", "createAnExceptionForFatalDiagnostic", "Lorg/gradle/api/InvalidUserCodeException;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinDiagnosticsException;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "renderingOptions", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticRenderingOptions;", "render", "showStacktrace", "", "coloredOutput", "effectiveSeverity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "renderReportedDiagnostic", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ReportedDiagnostic;", "logger", "Lorg/gradle/api/logging/Logger;", "renderStacktrace", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "throwable", "", "useParsableFormatting", "KotlinDiagnosticsException", "kotlin-gradle-plugin_common", "message"})
public final class RenderReportedDiagnosticsKt {
    @NotNull
    public static final String DIAGNOSTIC_SEPARATOR = "#diagnostic-end";
    @NotNull
    public static final String DIAGNOSTIC_STACKTRACE_START = "Stacktrace:";
    @NotNull
    public static final String DIAGNOSTIC_STACKTRACE_END_SEPARATOR = "#stacktrace-end";

    @Nullable
    public static final ReportedDiagnostic renderReportedDiagnostic(@NotNull ToolingDiagnostic $this$renderReportedDiagnostic, @NotNull Logger logger2, @NotNull ToolingDiagnosticRenderingOptions renderingOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$renderReportedDiagnostic, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)renderingOptions, (String)"renderingOptions");
        if (ToolingDiagnosticRenderingOptionsKt.isSuppressed($this$renderReportedDiagnostic, renderingOptions)) {
            return null;
        }
        ToolingDiagnostic.Severity severity = renderingOptions.effectiveSeverity($this$renderReportedDiagnostic.getSeverity());
        if (severity == null) {
            return null;
        }
        ToolingDiagnostic.Severity effectiveSeverity = severity;
        Lazy message$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>($this$renderReportedDiagnostic, renderingOptions, effectiveSeverity){
            final /* synthetic */ ToolingDiagnostic $this_renderReportedDiagnostic;
            final /* synthetic */ ToolingDiagnosticRenderingOptions $renderingOptions;
            final /* synthetic */ ToolingDiagnostic.Severity $effectiveSeverity;
            {
                this.$this_renderReportedDiagnostic = $receiver;
                this.$renderingOptions = $renderingOptions;
                this.$effectiveSeverity = $effectiveSeverity;
                super(0);
            }

            public final String invoke() {
                return RenderReportedDiagnosticsKt.render$default(this.$this_renderReportedDiagnostic, this.$renderingOptions, false, false, this.$effectiveSeverity, 6, null);
            }
        }));
        switch (WhenMappings.$EnumSwitchMapping$0[effectiveSeverity.ordinal()]) {
            case 1: {
                logger2.warn("w: " + RenderReportedDiagnosticsKt.renderReportedDiagnostic$lambda$0((Lazy<String>)message$delegate) + '\n');
                break;
            }
            case 2: {
                logger2.error("e: " + RenderReportedDiagnosticsKt.renderReportedDiagnostic$lambda$0((Lazy<String>)message$delegate) + '\n');
            }
        }
        return effectiveSeverity == ToolingDiagnostic.Severity.FATAL ? (ReportedDiagnostic)new ReportedDiagnostic.Throwable(effectiveSeverity, RenderReportedDiagnosticsKt.createAnExceptionForFatalDiagnostic($this$renderReportedDiagnostic, renderingOptions)) : (ReportedDiagnostic)new ReportedDiagnostic.Message(effectiveSeverity);
    }

    @NotNull
    public static final InvalidUserCodeException createAnExceptionForFatalDiagnostic(@NotNull ToolingDiagnostic $this$createAnExceptionForFatalDiagnostic, @NotNull ToolingDiagnosticRenderingOptions renderingOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$createAnExceptionForFatalDiagnostic, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)renderingOptions, (String)"renderingOptions");
        String message2 = RenderReportedDiagnosticsKt.render$default($this$createAnExceptionForFatalDiagnostic, renderingOptions, false, false, null, 8, null);
        return $this$createAnExceptionForFatalDiagnostic.getThrowable() != null ? new InvalidUserCodeException(message2, $this$createAnExceptionForFatalDiagnostic.getThrowable()) : new InvalidUserCodeException(message2);
    }

    private static final String render(ToolingDiagnostic $this$render, ToolingDiagnosticRenderingOptions renderingOptions, boolean showStacktrace, boolean coloredOutput, ToolingDiagnostic.Severity effectiveSeverity) {
        ToolingDiagnosticOutput diagnosticOutput;
        StringBuilder stringBuilder;
        StringBuilder $this$render_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ToolingDiagnosticRenderingOptions $this$render_u24lambda_u244_u24lambda_u243 = renderingOptions;
        boolean bl2 = false;
        ToolingDiagnosticOutput toolingDiagnosticOutput = diagnosticOutput = coloredOutput ? (ToolingDiagnosticOutput)StyledToolingDiagnosticKt.styled($this$render, $this$render_u24lambda_u244_u24lambda_u243.getShowSeverityEmoji(), effectiveSeverity) : (ToolingDiagnosticOutput)StyledToolingDiagnosticKt.plain($this$render, $this$render_u24lambda_u244_u24lambda_u243.getShowSeverityEmoji(), effectiveSeverity);
        if ($this$render_u24lambda_u244_u24lambda_u243.getUseParsableFormat()) {
            StringBuilder stringBuilder2 = $this$render_u24lambda_u244.append($this$render.parsableFormat$kotlin_gradle_plugin_common(effectiveSeverity));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        } else {
            StringBuilder stringBuilder3;
            StringBuilder stringBuilder4;
            String it;
            StringBuilder stringBuilder5 = $this$render_u24lambda_u244.append(diagnosticOutput.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder6 = $this$render_u24lambda_u244.append(diagnosticOutput.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            String string = diagnosticOutput.getSolution();
            if (string != null) {
                it = string;
                boolean bl3 = false;
                StringBuilder stringBuilder7 = $this$render_u24lambda_u244.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                StringBuilder stringBuilder8 = stringBuilder7.append('\n');
                stringBuilder4 = stringBuilder8;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            } else {
                stringBuilder4 = null;
            }
            String string2 = diagnosticOutput.getDocumentation();
            if (string2 != null) {
                it = string2;
                boolean bl4 = false;
                StringBuilder stringBuilder9 = $this$render_u24lambda_u244.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
                StringBuilder stringBuilder10 = stringBuilder9.append('\n');
                stringBuilder3 = stringBuilder10;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
            } else {
                stringBuilder3 = null;
            }
        }
        if (showStacktrace) {
            RenderReportedDiagnosticsKt.renderStacktrace($this$render_u24lambda_u244, $this$render.getThrowable(), $this$render_u24lambda_u244_u24lambda_u243.getUseParsableFormat());
        }
        if ($this$render_u24lambda_u244_u24lambda_u243.getUseParsableFormat()) {
            StringBuilder stringBuilder11 = $this$render_u24lambda_u244.append(DIAGNOSTIC_SEPARATOR);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
    }

    static /* synthetic */ String render$default(ToolingDiagnostic toolingDiagnostic, ToolingDiagnosticRenderingOptions toolingDiagnosticRenderingOptions, boolean bl, boolean bl2, ToolingDiagnostic.Severity severity, int n, Object object) {
        if ((n & 2) != 0) {
            bl = toolingDiagnosticRenderingOptions.getShowStacktrace();
        }
        if ((n & 4) != 0) {
            bl2 = toolingDiagnosticRenderingOptions.getColoredOutput();
        }
        if ((n & 8) != 0) {
            severity = toolingDiagnostic.getSeverity();
        }
        return RenderReportedDiagnosticsKt.render(toolingDiagnostic, toolingDiagnosticRenderingOptions, bl, bl2, severity);
    }

    private static final void renderStacktrace(StringBuilder $this$renderStacktrace, Throwable throwable, boolean useParsableFormatting) {
        if (throwable == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$renderStacktrace.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder = $this$renderStacktrace.append(DIAGNOSTIC_STACKTRACE_START);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder2 = $this$renderStacktrace.append(StringsKt.prependIndent((String)((Object)StringsKt.trim((CharSequence)ExceptionsKt.stackTraceToString((Throwable)throwable))).toString(), (String)"    "));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        if (useParsableFormatting) {
            StringBuilder stringBuilder3 = $this$renderStacktrace.append(DIAGNOSTIC_STACKTRACE_END_SEPARATOR);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
    }

    private static final String renderReportedDiagnostic$lambda$0(Lazy<String> $message$delegate) {
        Lazy<String> lazy = $message$delegate;
        return (String)lazy.getValue();
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolingDiagnostic.Severity.values().length];
            try {
                nArray[ToolingDiagnostic.Severity.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolingDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

