/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.IdeaKt;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticRenderingOptionsKt;
import org.jetbrains.kotlin.konan.target.HostManager;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001bR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticRenderingOptions;", "Ljava/io/Serializable;", "useParsableFormat", "", "suppressedWarningIds", "", "", "suppressedErrorIds", "showStacktrace", "showSeverityEmoji", "coloredOutput", "ignoreWarningMode", "warningMode", "Lorg/gradle/api/logging/configuration/WarningMode;", "(ZLjava/util/List;Ljava/util/List;ZZZZLorg/gradle/api/logging/configuration/WarningMode;)V", "getColoredOutput", "()Z", "getIgnoreWarningMode", "getShowSeverityEmoji", "getShowStacktrace", "getSuppressedErrorIds", "()Ljava/util/List;", "getSuppressedWarningIds", "getUseParsableFormat", "getWarningMode", "()Lorg/gradle/api/logging/configuration/WarningMode;", "effectiveSeverity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "severity", "Companion", "kotlin-gradle-plugin_common"})
public final class ToolingDiagnosticRenderingOptions
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean useParsableFormat;
    @NotNull
    private final List<String> suppressedWarningIds;
    @NotNull
    private final List<String> suppressedErrorIds;
    private final boolean showStacktrace;
    private final boolean showSeverityEmoji;
    private final boolean coloredOutput;
    private final boolean ignoreWarningMode;
    @NotNull
    private final WarningMode warningMode;

    public ToolingDiagnosticRenderingOptions(boolean useParsableFormat, @NotNull List<String> suppressedWarningIds, @NotNull List<String> suppressedErrorIds, boolean showStacktrace, boolean showSeverityEmoji, boolean coloredOutput, boolean ignoreWarningMode, @NotNull WarningMode warningMode) {
        Intrinsics.checkNotNullParameter(suppressedWarningIds, (String)"suppressedWarningIds");
        Intrinsics.checkNotNullParameter(suppressedErrorIds, (String)"suppressedErrorIds");
        Intrinsics.checkNotNullParameter((Object)warningMode, (String)"warningMode");
        this.useParsableFormat = useParsableFormat;
        this.suppressedWarningIds = suppressedWarningIds;
        this.suppressedErrorIds = suppressedErrorIds;
        this.showStacktrace = showStacktrace;
        this.showSeverityEmoji = showSeverityEmoji;
        this.coloredOutput = coloredOutput;
        this.ignoreWarningMode = ignoreWarningMode;
        this.warningMode = warningMode;
    }

    public final boolean getUseParsableFormat() {
        return this.useParsableFormat;
    }

    @NotNull
    public final List<String> getSuppressedWarningIds() {
        return this.suppressedWarningIds;
    }

    @NotNull
    public final List<String> getSuppressedErrorIds() {
        return this.suppressedErrorIds;
    }

    public final boolean getShowStacktrace() {
        return this.showStacktrace;
    }

    public final boolean getShowSeverityEmoji() {
        return this.showSeverityEmoji;
    }

    public final boolean getColoredOutput() {
        return this.coloredOutput;
    }

    public final boolean getIgnoreWarningMode() {
        return this.ignoreWarningMode;
    }

    @NotNull
    public final WarningMode getWarningMode() {
        return this.warningMode;
    }

    @Nullable
    public final ToolingDiagnostic.Severity effectiveSeverity(@NotNull ToolingDiagnostic.Severity severity) {
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        if (!this.ignoreWarningMode) {
            if (this.warningMode == WarningMode.None && severity == ToolingDiagnostic.Severity.WARNING) {
                return null;
            }
            return severity == ToolingDiagnostic.Severity.WARNING && this.warningMode == WarningMode.Fail ? ToolingDiagnostic.Severity.ERROR : severity;
        }
        return severity;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticRenderingOptions$Companion;", "", "()V", "forProject", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticRenderingOptions;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolingDiagnosticRenderingOptions forProject(@NotNull Project project) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PropertiesProvider $this$forProject_u24lambda_u240 = PropertiesProvider.Companion.getKotlinPropertiesProvider$kotlin_gradle_plugin_common(project);
            boolean bl2 = false;
            if ($this$forProject_u24lambda_u240.getInternalDiagnosticsShowStacktrace() != null) {
                Boolean bl3 = $this$forProject_u24lambda_u240.getInternalDiagnosticsShowStacktrace();
                Intrinsics.checkNotNull((Object)bl3);
                bl = bl3;
            } else {
                Object object = IdeaKt.isInIdeaSync(project).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.isInIdeaSync.get()");
                bl = (Boolean)object != false ? false : project.getGradle().getStartParameter().getShowStacktrace().compareTo((Enum)ShowStacktrace.INTERNAL_EXCEPTIONS) > 0;
            }
            boolean showStacktrace = bl;
            boolean bl4 = $this$forProject_u24lambda_u240.getInternalDiagnosticsUseParsableFormat();
            List<String> list = $this$forProject_u24lambda_u240.getSuppressedGradlePluginWarnings();
            List<String> list2 = $this$forProject_u24lambda_u240.getSuppressedGradlePluginErrors();
            boolean bl5 = (Boolean)IdeaKt.isInIdeaEnvironment(project).get() == false && !HostManager.Companion.getHostIsMingw();
            boolean bl6 = ToolingDiagnosticRenderingOptionsKt.access$showColoredDiagnostics(project);
            boolean bl7 = Intrinsics.areEqual((Object)$this$forProject_u24lambda_u240.getInternalDiagnosticsIgnoreWarningMode(), (Object)true);
            WarningMode warningMode = project.getGradle().getStartParameter().getWarningMode();
            Intrinsics.checkNotNullExpressionValue((Object)warningMode, (String)"project.gradle.startParameter.warningMode");
            return new ToolingDiagnosticRenderingOptions(bl4, list, list2, showStacktrace, bl5, bl6, bl7, warningMode);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

