/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources.android.checker;

import com.android.build.gradle.api.AndroidSourceSet;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollector;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetInfoKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayout;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayoutKt;
import org.jetbrains.kotlin.gradle.plugin.sources.android.checker.KotlinAndroidSourceSetLayoutChecker;
import org.jetbrains.kotlin.gradle.utils.AndroidExtensionUitlsKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker;", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/checker/KotlinAndroidSourceSetLayoutChecker;", "()V", "checkCreatedSourceSet", "", "diagnosticsCollector", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnosticsCollector;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "layout", "Lorg/jetbrains/kotlin/gradle/plugin/sources/android/KotlinAndroidSourceSetLayout;", "kotlinSourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "androidSourceSet", "Lcom/android/build/gradle/api/AndroidSourceSet;", "Lorg/jetbrains/kotlin/gradle/utils/DeprecatedAndroidSourceSet;", "kotlin-gradle-plugin_common"})
public final class MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker
implements KotlinAndroidSourceSetLayoutChecker {
    @NotNull
    public static final MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker INSTANCE = new MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker();

    private MultiplatformLayoutV2MultiplatformLayoutV1StyleSourceDirUsageChecker() {
    }

    @Override
    public void checkCreatedSourceSet(@NotNull KotlinToolingDiagnosticsCollector diagnosticsCollector, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout, @NotNull KotlinSourceSet kotlinSourceSet, @NotNull AndroidSourceSet androidSourceSet) {
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
        Intrinsics.checkNotNullParameter((Object)androidSourceSet, (String)"androidSourceSet");
        String string = KotlinAndroidSourceSetLayoutKt.getMultiplatformAndroidSourceSetLayoutV1().getNaming().kotlinSourceSetName(target2.getDisambiguationClassifier(), androidSourceSet.getName(), KotlinAndroidSourceSetInfoKt.getAndroidSourceSetInfo(kotlinSourceSet).getAndroidVariantType$kotlin_gradle_plugin_common());
        if (string == null) {
            return;
        }
        String v1kotlinSourceSetName = string;
        if (Intrinsics.areEqual((Object)v1kotlinSourceSetName, (Object)kotlinSourceSet.getName())) {
            return;
        }
        if (AndroidExtensionUitlsKt.getAndroidExtension(target2.getProject()).getSourceSets().findByName(v1kotlinSourceSetName) != null) {
            return;
        }
        Path rootDirPath = target2.getProject().getRootDir().toPath();
        File v1KotlinSourceDir = target2.getProject().file((Object)("src/" + v1kotlinSourceSetName + "/kotlin"));
        if (v1KotlinSourceDir.exists()) {
            File v2SourceDirToUse = target2.getProject().file((Object)("src/" + kotlinSourceSet.getName() + "/kotlin"));
            Project project = target2.getProject();
            Path path = v1KotlinSourceDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"v1KotlinSourceDir.toPath()");
            Intrinsics.checkNotNullExpressionValue((Object)rootDirPath, (String)"rootDirPath");
            String string2 = ((Object)PathsKt.relativeTo((Path)path, (Path)rootDirPath)).toString();
            String string3 = layout.getName();
            Path path2 = v2SourceDirToUse.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"v2SourceDirToUse.toPath()");
            KotlinToolingDiagnosticsCollector.report$default(diagnosticsCollector, project, KotlinToolingDiagnostics.SourceSetLayoutV1StyleDirUsageWarning.INSTANCE.invoke(string2, string3, ((Object)PathsKt.relativeTo((Path)path2, (Path)rootDirPath)).toString()), false, null, 12, null);
        }
    }

    @Override
    public void checkBeforeLayoutApplied(@NotNull KotlinToolingDiagnosticsCollector diagnosticsCollector, @NotNull KotlinAndroidTarget target2, @NotNull KotlinAndroidSourceSetLayout layout) {
        KotlinAndroidSourceSetLayoutChecker.DefaultImpls.checkBeforeLayoutApplied(this, diagnosticsCollector, target2, layout);
    }
}

