/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.statistics.DefaultKotlinBuildStatsBeanService;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsBeanService;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsMXBean;
import org.jetbrains.kotlin.gradle.plugin.statistics.old.Pre232IdeaKotlinBuildStatsBeanService;
import org.jetbrains.kotlin.gradle.plugin.statistics.old.Pre232IdeaKotlinBuildStatsMXBean;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J?\u0010\u0014\u001a\u00020\u000e\"\b\b\u0000\u0010\u0015*\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u0002H\u00152\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00150\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001cR\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsServicesRegistry;", "Ljava/io/Closeable;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger$kotlin_gradle_plugin_common", "()Lorg/gradle/api/logging/Logger;", "services", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsBeanService;", "Lkotlin/collections/HashMap;", "close", "", "recordBuildStart", "buildId", "registerServices", "project", "Lorg/gradle/api/Project;", "registerStatsService", "T", "mbs", "Ljavax/management/MBeanServer;", "service", "beanInterfaceType", "Ljava/lang/Class;", "qualifier", "(Ljavax/management/MBeanServer;Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsBeanService;Ljava/lang/Class;Ljava/lang/String;)V", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinBuildStatsServicesRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBuildStatsServicesRegistry.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsServicesRegistry\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,98:1\n216#2,2:99\n*S KotlinDebug\n*F\n+ 1 KotlinBuildStatsServicesRegistry.kt\norg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsServicesRegistry\n*L\n54#1:99,2\n*E\n"})
public final class KotlinBuildStatsServicesRegistry
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = Logging.getLogger(this.getClass());
    @NotNull
    private final HashMap<String, KotlinBuildStatsBeanService> services = new HashMap();
    @NotNull
    private static final String JXM_BEAN_BASE_NAME = "org.jetbrains.kotlin.gradle.plugin.statistics:type=StatsService";
    @NotNull
    private static final String LEGACY_SERVICE_QUALIFIER = "";
    @NotNull
    public static final String DEFAULT_SERVICE_QUALIFIER = "v2";

    public final Logger getLogger$kotlin_gradle_plugin_common() {
        return this.logger;
    }

    public final void registerServices(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Intrinsics.checkNotNullExpressionValue((Object)mBeanServer, (String)"getPlatformMBeanServer()");
        MBeanServer mbs = mBeanServer;
        this.registerStatsService(mbs, (KotlinBuildStatsBeanService)new DefaultKotlinBuildStatsBeanService(project, Companion.getBeanName$kotlin_gradle_plugin_common(DEFAULT_SERVICE_QUALIFIER)), KotlinBuildStatsMXBean.class, DEFAULT_SERVICE_QUALIFIER);
        this.registerStatsService(mbs, (KotlinBuildStatsBeanService)new Pre232IdeaKotlinBuildStatsBeanService(project, Companion.getBeanName$kotlin_gradle_plugin_common(LEGACY_SERVICE_QUALIFIER)), Pre232IdeaKotlinBuildStatsMXBean.class, LEGACY_SERVICE_QUALIFIER);
    }

    public final void recordBuildStart(@NotNull String buildId) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Map $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            ((KotlinBuildStatsBeanService)it.getValue()).recordBuildStart(buildId);
        }
    }

    private final <T extends KotlinBuildStatsBeanService> void registerStatsService(MBeanServer mbs, T service, Class<? super T> beanInterfaceType, String qualifier) {
        ObjectName beanName = Companion.getBeanName$kotlin_gradle_plugin_common(qualifier);
        String loggedServiceName = KotlinBuildStatsBeanService.class + (((CharSequence)qualifier).length() > 0 ? '_' + qualifier : LEGACY_SERVICE_QUALIFIER);
        if (!mbs.isRegistered(beanName)) {
            mbs.registerMBean(new StandardMBean(service, beanInterfaceType), beanName);
            ((Map)this.services).put(qualifier, service);
            this.logger.debug("Instantiated " + loggedServiceName + ": new instance " + service);
        } else {
            this.logger.debug(loggedServiceName + " is already instantiated in another classpath.");
        }
    }

    @Override
    public void close() {
        for (KotlinBuildStatsBeanService service : this.services.values()) {
            service.close();
        }
        this.services.clear();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/KotlinBuildStatsServicesRegistry$Companion;", "", "()V", "DEFAULT_SERVICE_QUALIFIER", "", "JXM_BEAN_BASE_NAME", "LEGACY_SERVICE_QUALIFIER", "getBeanName", "Ljavax/management/ObjectName;", "qualifier", "getBeanName$kotlin_gradle_plugin_common", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectName getBeanName$kotlin_gradle_plugin_common(@NotNull String qualifier) {
            Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
            return new ObjectName(KotlinBuildStatsServicesRegistry.JXM_BEAN_BASE_NAME + (((CharSequence)qualifier).length() > 0 ? ",name=" + qualifier : KotlinBuildStatsServicesRegistry.LEGACY_SERVICE_QUALIFIER));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

