/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.abi;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.api.AbiFilters;
import org.jetbrains.kotlin.abi.tools.api.AbiToolsInterface;
import org.jetbrains.kotlin.abi.tools.api.v2.AbiToolsV2;
import org.jetbrains.kotlin.abi.tools.api.v2.KlibDump;
import org.jetbrains.kotlin.abi.tools.api.v2.KlibTarget;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.UsesKotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.tasks.abi.AbiToolsTask;
import org.jetbrains.kotlin.gradle.tasks.abi.KotlinLegacyAbiDumpTask;
import org.jetbrains.kotlin.gradle.tasks.abi.KotlinLegacyAbiDumpTaskImpl;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@CacheableTask
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b!\u0018\u0000 52\u00020\u00012\u00020\u00022\u00020\u0003:\u0003567B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0018R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0018R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001dR\u0013\u0010%\u001a\u00020\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\rR\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001d\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTaskImpl;", "Lorg/jetbrains/kotlin/gradle/tasks/abi/AbiToolsTask;", "Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTask;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/UsesKotlinToolingDiagnostics;", "()V", "dumpDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDumpDir", "()Lorg/gradle/api/file/DirectoryProperty;", "excludedAnnotatedWith", "Lorg/gradle/api/provider/SetProperty;", "", "getExcludedAnnotatedWith", "()Lorg/gradle/api/provider/SetProperty;", "excludedClasses", "getExcludedClasses", "includedAnnotatedWith", "getIncludedAnnotatedWith", "includedClasses", "getIncludedClasses", "jvm", "Lorg/gradle/api/provider/ListProperty;", "Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTaskImpl$JvmTargetInfo;", "getJvm", "()Lorg/gradle/api/provider/ListProperty;", "keepUnsupportedTargets", "Lorg/gradle/api/provider/Property;", "", "getKeepUnsupportedTargets", "()Lorg/gradle/api/provider/Property;", "klib", "Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTaskImpl$KlibTargetInfo;", "getKlib", "klibInput", "getKlibInput", "klibIsEnabled", "getKlibIsEnabled", "projectName", "getProjectName", "()Ljava/lang/String;", "referenceKlibDump", "Lorg/gradle/api/file/RegularFileProperty;", "getReferenceKlibDump", "()Lorg/gradle/api/file/RegularFileProperty;", "unsupportedTargets", "Lorg/jetbrains/kotlin/abi/tools/api/v2/KlibTarget;", "getUnsupportedTargets", "variantName", "getVariantName", "runTools", "", "tools", "Lorg/jetbrains/kotlin/abi/tools/api/AbiToolsInterface;", "Companion", "JvmTargetInfo", "KlibTargetInfo", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinLegacyAbiDumpTaskImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLegacyAbiDumpTaskImpl.kt\norg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTaskImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1863#2:191\n1864#2:193\n1863#2,2:194\n1557#2:196\n1628#2,3:197\n1863#2,2:200\n1#3:192\n*S KotlinDebug\n*F\n+ 1 KotlinLegacyAbiDumpTaskImpl.kt\norg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTaskImpl\n*L\n109#1:191\n109#1:193\n132#1:194,2\n148#1:196\n148#1:197,3\n153#1:200,2\n*E\n"})
public abstract class KotlinLegacyAbiDumpTaskImpl
extends AbiToolsTask
implements KotlinLegacyAbiDumpTask,
UsesKotlinToolingDiagnostics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectName;

    public KotlinLegacyAbiDumpTaskImpl() {
        String string = this.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        this.projectName = string;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getDumpDir();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getReferenceKlibDump();

    @Input
    @NotNull
    public abstract SetProperty<KlibTarget> getUnsupportedTargets();

    @Input
    @NotNull
    public abstract Property<Boolean> getKlibIsEnabled();

    @Input
    @NotNull
    public abstract Property<Boolean> getKeepUnsupportedTargets();

    @Nested
    @NotNull
    public abstract ListProperty<JvmTargetInfo> getJvm();

    @Internal
    @NotNull
    public abstract ListProperty<KlibTargetInfo> getKlibInput();

    @Nested
    @NotNull
    public abstract ListProperty<KlibTargetInfo> getKlib();

    @Input
    @Optional
    @NotNull
    public abstract SetProperty<String> getIncludedClasses();

    @Input
    @Optional
    @NotNull
    public abstract SetProperty<String> getExcludedClasses();

    @Input
    @Optional
    @NotNull
    public abstract SetProperty<String> getIncludedAnnotatedWith();

    @Input
    @Optional
    @NotNull
    public abstract SetProperty<String> getExcludedAnnotatedWith();

    @Input
    @NotNull
    public abstract Property<String> getVariantName();

    @Input
    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void runTools(@NotNull AbiToolsInterface tools) {
        block19: {
            File dirForDump;
            AbiFilters filters;
            String klibDumpName;
            Set unsupported;
            List klibTargets;
            File abiDir;
            block20: {
                Intrinsics.checkNotNullParameter((Object)tools, (String)"tools");
                abiDir = ((Directory)this.getDumpDir().get()).getAsFile();
                List jvmTargets = (List)this.getJvm().get();
                klibTargets = (List)this.getKlib().get();
                unsupported = (Set)this.getUnsupportedTargets().get();
                Boolean keepUnsupported = (Boolean)this.getKeepUnsupportedTargets().get();
                String jvmDumpName = this.projectName + ".api";
                klibDumpName = this.projectName + ".klib.api";
                if (!keepUnsupported.booleanValue()) {
                    Intrinsics.checkNotNullExpressionValue((Object)unsupported, (String)"unsupported");
                    if (!((Collection)unsupported).isEmpty()) {
                        throw new IllegalStateException("Validation could not be performed as targets " + this.getUnsupportedTargets() + " are not supported by host compiler and the 'keepUnsupported' mode was disabled.");
                    }
                }
                Object object = this.getIncludedClasses().getOrElse((Object)SetsKt.emptySet());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"includedClasses.getOrElse(emptySet())");
                Set set = (Set)object;
                Object object2 = this.getExcludedClasses().getOrElse((Object)SetsKt.emptySet());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"excludedClasses.getOrElse(emptySet())");
                Set set2 = (Set)object2;
                Object object3 = this.getIncludedAnnotatedWith().getOrElse((Object)SetsKt.emptySet());
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"includedAnnotatedWith.getOrElse(emptySet())");
                Set set3 = (Set)object3;
                Object object4 = this.getExcludedAnnotatedWith().getOrElse((Object)SetsKt.emptySet());
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"excludedAnnotatedWith.getOrElse(emptySet())");
                filters = new AbiFilters(set, set2, set3, (Set)object4);
                abiDir.mkdirs();
                Intrinsics.checkNotNullExpressionValue((Object)abiDir, (String)"abiDir");
                FileUtilsKt.deleteDirectoryContents(abiDir);
                Intrinsics.checkNotNullExpressionValue((Object)jvmTargets, (String)"jvmTargets");
                Iterable $this$forEach$iv = jvmTargets;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object it;
                    File file2;
                    JvmTargetInfo jvmTarget = (JvmTargetInfo)element$iv;
                    boolean bl = false;
                    FileTree fileTree = jvmTarget.getClassfilesDirs().getAsFileTree();
                    Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"jvmTarget.classfilesDirs.asFileTree");
                    Iterable classfiles2 = SequencesKt.asIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)fileTree)), (Function1)runTools.1.classfiles.1.INSTANCE));
                    if (Intrinsics.areEqual((Object)jvmTarget.getSubdirectoryName(), (Object)"")) {
                        file2 = abiDir;
                    } else {
                        File file3 = FilesKt.resolve((File)abiDir, (String)jvmTarget.getSubdirectoryName());
                        it = file3;
                        boolean bl2 = false;
                        ((File)it).mkdirs();
                        file2 = file3;
                    }
                    dirForDump = file2;
                    Intrinsics.checkNotNullExpressionValue((Object)dirForDump, (String)"dirForDump");
                    File dumpFile = FilesKt.resolve((File)dirForDump, (String)jvmDumpName);
                    it = dumpFile;
                    Object bl2 = Charsets.UTF_8;
                    int n = 8192;
                    Object object5 = it;
                    object5 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object5), (Charset)bl2);
                    it = object5 instanceof BufferedWriter ? (BufferedWriter)object5 : new BufferedWriter((Writer)object5, n);
                    bl2 = null;
                    try {
                        BufferedWriter writer = (BufferedWriter)it;
                        boolean bl3 = false;
                        tools.getV2().printJvmDump((Appendable)writer, classfiles2, filters);
                        writer = Unit.INSTANCE;
                    }
                    catch (Throwable writer) {
                        bl2 = writer;
                        throw writer;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)it, (Throwable)bl2);
                    }
                }
                Object object6 = this.getKlibIsEnabled().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"klibIsEnabled.get()");
                if (!((Boolean)object6).booleanValue()) break block19;
                Intrinsics.checkNotNullExpressionValue((Object)klibTargets, (String)"klibTargets");
                if (!((Collection)klibTargets).isEmpty()) break block20;
                Intrinsics.checkNotNullExpressionValue((Object)unsupported, (String)"unsupported");
                if (!(!((Collection)unsupported).isEmpty())) break block19;
            }
            KlibDump mergedDump = tools.getV2().createKlibDump();
            Iterable $this$forEach$iv = klibTargets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KlibTargetInfo suite = (KlibTargetInfo)element$iv;
                boolean bl = false;
                Set set = suite.getKlibFiles().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"suite.klibFiles.files");
                File klibDir = (File)CollectionsKt.first((Iterable)set);
                if (!klibDir.exists()) continue;
                AbiToolsV2 abiToolsV2 = tools.getV2();
                Intrinsics.checkNotNullExpressionValue((Object)klibDir, (String)"klibDir");
                KlibDump dump2 = abiToolsV2.extractKlibAbi(klibDir, new KlibTarget(suite.getCanonicalTargetName(), suite.getTargetName()), filters);
                mergedDump.merge(dump2);
            }
            File referenceFile = ((RegularFile)this.getReferenceKlibDump().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)unsupported, (String)"unsupported");
            if (!((Collection)unsupported).isEmpty()) {
                void $this$forEach$iv2;
                void $this$mapTo$iv$iv;
                KlibDump klibDump;
                if (referenceFile.exists() && referenceFile.isFile()) {
                    AbiToolsV2 abiToolsV2 = tools.getV2();
                    Intrinsics.checkNotNullExpressionValue((Object)referenceFile, (String)"referenceFile");
                    klibDump = abiToolsV2.loadKlibDump(referenceFile);
                } else {
                    klibDump = tools.getV2().createKlibDump();
                }
                KlibDump referenceDump = klibDump;
                Iterable $this$map$iv = unsupported;
                boolean $i$f$map = false;
                Iterable suite = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void unsupportedTarget2;
                    dirForDump = (KlibTarget)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    this.reportDiagnostic(KotlinToolingDiagnostics.AbiValidationUnsupportedTarget.INSTANCE.invoke(unsupportedTarget2.getTargetName()));
                    Intrinsics.checkNotNullExpressionValue((Object)unsupportedTarget2, (String)"unsupportedTarget");
                    collection.add(mergedDump.inferAbiForUnsupportedTarget(referenceDump, (KlibTarget)unsupportedTarget2));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    KlibDump inferredDump = (KlibDump)element$iv;
                    boolean bl = false;
                    mergedDump.merge(inferredDump);
                }
            }
            mergedDump.print(FilesKt.resolve((File)abiDir, (String)klibDumpName));
        }
    }

    @Override
    public void reportDiagnostic(@NotNull ToolingDiagnostic diagnostic) {
        UsesKotlinToolingDiagnostics.DefaultImpls.reportDiagnostic(this, diagnostic);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTaskImpl$Companion;", "", "()V", "nameForVariant", "", "variantName", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String nameForVariant(@NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            return AbiToolsTask.Companion.composeTaskName$kotlin_gradle_plugin_common("dumpLegacyAbi", variantName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTaskImpl$JvmTargetInfo;", "", "subdirectoryName", "", "classfilesDirs", "Lorg/gradle/api/file/FileCollection;", "(Ljava/lang/String;Lorg/gradle/api/file/FileCollection;)V", "getClassfilesDirs", "()Lorg/gradle/api/file/FileCollection;", "getSubdirectoryName", "()Ljava/lang/String;", "kotlin-gradle-plugin_common"})
    public static final class JvmTargetInfo {
        @NotNull
        private final String subdirectoryName;
        @NotNull
        private final FileCollection classfilesDirs;

        public JvmTargetInfo(@NotNull String subdirectoryName, @NotNull FileCollection classfilesDirs) {
            Intrinsics.checkNotNullParameter((Object)subdirectoryName, (String)"subdirectoryName");
            Intrinsics.checkNotNullParameter((Object)classfilesDirs, (String)"classfilesDirs");
            this.subdirectoryName = subdirectoryName;
            this.classfilesDirs = classfilesDirs;
        }

        @Input
        @NotNull
        public final String getSubdirectoryName() {
            return this.subdirectoryName;
        }

        @Optional
        @Classpath
        @NotNull
        public final FileCollection getClassfilesDirs() {
            return this.classfilesDirs;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiDumpTaskImpl$KlibTargetInfo;", "", "targetName", "", "canonicalTargetName", "klibFiles", "Lorg/gradle/api/file/FileCollection;", "(Ljava/lang/String;Ljava/lang/String;Lorg/gradle/api/file/FileCollection;)V", "getCanonicalTargetName", "()Ljava/lang/String;", "getKlibFiles", "()Lorg/gradle/api/file/FileCollection;", "getTargetName", "kotlin-gradle-plugin_common"})
    public static final class KlibTargetInfo {
        @NotNull
        private final String targetName;
        @NotNull
        private final String canonicalTargetName;
        @NotNull
        private final FileCollection klibFiles;

        public KlibTargetInfo(@NotNull String targetName, @NotNull String canonicalTargetName, @NotNull FileCollection klibFiles) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            Intrinsics.checkNotNullParameter((Object)canonicalTargetName, (String)"canonicalTargetName");
            Intrinsics.checkNotNullParameter((Object)klibFiles, (String)"klibFiles");
            this.targetName = targetName;
            this.canonicalTargetName = canonicalTargetName;
            this.klibFiles = klibFiles;
        }

        @Input
        @NotNull
        public final String getTargetName() {
            return this.targetName;
        }

        @Input
        @NotNull
        public final String getCanonicalTargetName() {
            return this.canonicalTargetName;
        }

        @InputFiles
        @Optional
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public final FileCollection getKlibFiles() {
            return this.klibFiles;
        }
    }
}

