/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.archivers.sevenz;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;

public class CLI {
    private static Mode grabMode(String[] args2) {
        if (args2.length < 2) {
            return Mode.LIST;
        }
        return Enum.valueOf(Mode.class, args2[1].toUpperCase(Locale.ROOT));
    }

    public static void main(String[] args2) throws Exception {
        if (args2.length == 0) {
            CLI.usage();
            return;
        }
        Mode mode = CLI.grabMode(args2);
        System.out.println(mode.getMessage() + " " + args2[0]);
        File file2 = new File(args2[0]);
        if (!file2.isFile()) {
            System.err.println(file2 + " doesn't exist or is a directory");
        }
        try (SevenZFile archive = ((SevenZFile.Builder)SevenZFile.builder().setFile(file2)).get();){
            SevenZArchiveEntry ae;
            while ((ae = archive.getNextEntry()) != null) {
                mode.takeAction(archive, ae);
            }
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [list]");
    }

    private static enum Mode {
        LIST("Analysing"){

            private String getContentMethods(SevenZArchiveEntry entry2) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (SevenZMethodConfiguration sevenZMethodConfiguration : entry2.getContentMethods()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append((Object)sevenZMethodConfiguration.getMethod());
                    if (sevenZMethodConfiguration.getOptions() == null) continue;
                    sb.append("(").append(sevenZMethodConfiguration.getOptions()).append(")");
                }
                return sb.toString();
            }

            @Override
            public void takeAction(SevenZFile archive, SevenZArchiveEntry entry2) {
                System.out.print(entry2.getName());
                if (entry2.isDirectory()) {
                    System.out.print(" dir");
                } else {
                    System.out.print(" " + entry2.getCompressedSize() + "/" + entry2.getSize());
                }
                if (entry2.getHasLastModifiedDate()) {
                    System.out.print(" " + entry2.getLastModifiedDate());
                } else {
                    System.out.print(" no last modified date");
                }
                if (!entry2.isDirectory()) {
                    System.out.println(" " + this.getContentMethods(entry2));
                } else {
                    System.out.println();
                }
            }
        };

        private final String message;

        private Mode(String message2) {
            this.message = message2;
        }

        public String getMessage() {
            return this.message;
        }

        public abstract void takeAction(SevenZFile var1, SevenZArchiveEntry var2) throws IOException;
    }
}

