/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerArgumentsLogLevel;
import org.jetbrains.kotlin.gradle.dsl.NativeCacheKind;
import org.jetbrains.kotlin.gradle.internal.ClassLoadersCachingBuildService;
import org.jetbrains.kotlin.gradle.targets.native.KonanPropertiesBuildService;
import org.jetbrains.kotlin.gradle.targets.native.internal.PlatformLibrariesGenerator;
import org.jetbrains.kotlin.gradle.tasks.CacheBuilder;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeTasksKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.gradle.utils.GradleUtilsKt;
import org.jetbrains.kotlin.internal.compilerRunner.native.KotlinNativeToolRunner;
import org.jetbrains.kotlin.internal.compilerRunner.native.NativeLibraryGenerationRunnerKt;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.DistributionKt;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.util.VisibleNamedKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 I2\u00020\u0001:\u0003IJKB\u00b7\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u0007\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007\u0012\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0007\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007\u00a2\u0006\u0002\u0010\u001fJ\b\u0010C\u001a\u00020\u0014H\u0002J\b\u0010D\u001a\u00020\u0014H\u0002J\u0006\u0010E\u001a\u00020FJ\b\u0010G\u001a\u00020FH\u0002J\u0018\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00190;*\b\u0012\u0004\u0012\u00020\u00190;H\u0002R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\n )*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010!R\u001c\u00100\u001a\n )*\u0004\u0018\u00010\u001b0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\n )*\u0004\u0018\u00010808X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\n )*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00190;8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b<\u0010=R\u0014\u0010@\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator;", "", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "konanTarget", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "kotlinCompilerArgumentsLogLevel", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerArgumentsLogLevel;", "konanPropertiesService", "Lorg/jetbrains/kotlin/gradle/targets/native/KonanPropertiesBuildService;", "metricsReporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "classLoadersCachingService", "Lorg/jetbrains/kotlin/gradle/internal/ClassLoadersCachingBuildService;", "platformLibrariesService", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$GeneratedPlatformLibrariesService;", "useXcodeMessageStyle", "", "classpath", "Lorg/gradle/api/file/FileCollection;", "jvmArgs", "Lorg/gradle/api/provider/ListProperty;", "", "actualNativeHomeDirectory", "Ljava/io/File;", "konanDataDir", "nativeCacheKind", "Lorg/jetbrains/kotlin/gradle/dsl/NativeCacheKind;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/jetbrains/kotlin/konan/target/KonanTarget;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/provider/ListProperty;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;)V", "getActualNativeHomeDirectory", "()Lorg/gradle/api/provider/Provider;", "alreadyProcessed", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo;", "getAlreadyProcessed", "()Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo;", "getClasspath", "()Lorg/gradle/api/file/FileCollection;", "defDirectory", "kotlin.jvm.PlatformType", "distribution", "Lorg/jetbrains/kotlin/konan/target/Distribution;", "getJvmArgs", "()Lorg/gradle/api/provider/ListProperty;", "konanCacheKind", "getKonanDataDir", "konanHome", "getKonanHome", "()Ljava/io/File;", "getKonanTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "libraryGenerationRunner", "Lorg/jetbrains/kotlin/internal/compilerRunner/native/KotlinNativeToolRunner;", "logger", "Lorg/gradle/api/logging/Logger;", "platformLibsDirectory", "presentDefs", "", "getPresentDefs", "()Ljava/util/Set;", "presentDefs$delegate", "Lkotlin/Lazy;", "shouldBuildCaches", "getShouldBuildCaches", "()Z", "checkCaches", "checkLibrariesInDistribution", "generatePlatformLibsIfNeeded", "", "runGenerationTool", "toPlatformLibNames", "Companion", "GeneratedPlatformLibrariesService", "PlatformLibsInfo", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nPlatformLibrariesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformLibrariesGenerator.kt\norg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 formattingUtils.kt\norg/jetbrains/kotlin/gradle/utils/FormattingUtilsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1620#2,3:276\n1722#2,3:285\n1722#2,3:288\n1851#2,2:291\n18#3:279\n26#4:280\n11335#5:281\n11670#5,3:282\n38#6,7:293\n1#7:300\n*S KotlinDebug\n*F\n+ 1 PlatformLibrariesGenerator.kt\norg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator\n*L\n93#1:276,3\n104#1:285,3\n118#1:288,3\n160#1:291,2\n100#1:279\n100#1:280\n101#1:281\n101#1:282,3\n211#1:293,7\n*E\n"})
public final class PlatformLibrariesGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KonanTarget konanTarget;
    @NotNull
    private final Provider<KotlinCompilerArgumentsLogLevel> kotlinCompilerArgumentsLogLevel;
    @NotNull
    private final Provider<KonanPropertiesBuildService> konanPropertiesService;
    @NotNull
    private final Provider<GeneratedPlatformLibrariesService> platformLibrariesService;
    @NotNull
    private final FileCollection classpath;
    @NotNull
    private final ListProperty<String> jvmArgs;
    @NotNull
    private final Provider<File> actualNativeHomeDirectory;
    @NotNull
    private final Provider<String> konanDataDir;
    private final Logger logger;
    @NotNull
    private final KotlinNativeToolRunner libraryGenerationRunner;
    @NotNull
    private final Distribution distribution;
    private final File platformLibsDirectory;
    private final File defDirectory;
    @NotNull
    private final Provider<NativeCacheKind> konanCacheKind;
    @NotNull
    private final Lazy presentDefs$delegate;

    public PlatformLibrariesGenerator(@NotNull ObjectFactory objectFactory, @NotNull KonanTarget konanTarget2, @NotNull Provider<KotlinCompilerArgumentsLogLevel> kotlinCompilerArgumentsLogLevel2, @NotNull Provider<KonanPropertiesBuildService> konanPropertiesService, @NotNull Provider<BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>> metricsReporter, @NotNull Provider<ClassLoadersCachingBuildService> classLoadersCachingService, @NotNull Provider<GeneratedPlatformLibrariesService> platformLibrariesService, @NotNull Provider<Boolean> useXcodeMessageStyle, @NotNull FileCollection classpath2, @NotNull ListProperty<String> jvmArgs2, @NotNull Provider<File> actualNativeHomeDirectory2, @NotNull Provider<String> konanDataDir2, @NotNull Provider<NativeCacheKind> nativeCacheKind2) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)konanTarget2, (String)"konanTarget");
        Intrinsics.checkNotNullParameter(kotlinCompilerArgumentsLogLevel2, (String)"kotlinCompilerArgumentsLogLevel");
        Intrinsics.checkNotNullParameter(konanPropertiesService, (String)"konanPropertiesService");
        Intrinsics.checkNotNullParameter(metricsReporter, (String)"metricsReporter");
        Intrinsics.checkNotNullParameter(classLoadersCachingService, (String)"classLoadersCachingService");
        Intrinsics.checkNotNullParameter(platformLibrariesService, (String)"platformLibrariesService");
        Intrinsics.checkNotNullParameter(useXcodeMessageStyle, (String)"useXcodeMessageStyle");
        Intrinsics.checkNotNullParameter((Object)classpath2, (String)"classpath");
        Intrinsics.checkNotNullParameter(jvmArgs2, (String)"jvmArgs");
        Intrinsics.checkNotNullParameter(actualNativeHomeDirectory2, (String)"actualNativeHomeDirectory");
        Intrinsics.checkNotNullParameter(konanDataDir2, (String)"konanDataDir");
        Intrinsics.checkNotNullParameter(nativeCacheKind2, (String)"nativeCacheKind");
        this.konanTarget = konanTarget2;
        this.kotlinCompilerArgumentsLogLevel = kotlinCompilerArgumentsLogLevel2;
        this.konanPropertiesService = konanPropertiesService;
        this.platformLibrariesService = platformLibrariesService;
        this.classpath = classpath2;
        this.jvmArgs = jvmArgs2;
        this.actualNativeHomeDirectory = actualNativeHomeDirectory2;
        this.konanDataDir = konanDataDir2;
        this.logger = Logging.getLogger(this.getClass());
        Provider provider = this.konanPropertiesService.map((Transformer)libraryGenerationRunner.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"konanPropertiesService.m\u2026it.environmentBlacklist }");
        this.libraryGenerationRunner = NativeLibraryGenerationRunnerKt.KotlinNativeLibraryGenerationRunner(objectFactory, metricsReporter, classLoadersCachingService, useXcodeMessageStyle, this.classpath, this.jvmArgs, (Provider<Set<String>>)provider);
        String string = this.getKonanHome().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"konanHome.absolutePath");
        this.distribution = DistributionKt.customerDistribution((String)string, (String)((String)this.konanDataDir.getOrNull()));
        this.platformLibsDirectory = new File(this.distribution.platformLibs(this.konanTarget)).getAbsoluteFile();
        this.defDirectory = new File(this.distribution.platformDefs(this.konanTarget)).getAbsoluteFile();
        this.konanCacheKind = nativeCacheKind2;
        this.presentDefs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ PlatformLibrariesGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Set<String> invoke() {
                void $this$mapTo$iv$iv;
                File[] $this$orEmpty$iv = PlatformLibrariesGenerator.access$getDefDirectory$p(this.this$0).listFiles(presentDefs.1.INSTANCE);
                boolean $i$f$orEmpty = false;
                Object[] objectArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    boolean $i$f$emptyArray = false;
                    objectArray = new File[0];
                }
                File[] $this$map$iv = objectArray;
                boolean $i$f$map = false;
                File[] $i$f$emptyArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(FilesKt.getNameWithoutExtension((File)it));
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
        }));
    }

    @NotNull
    public final KonanTarget getKonanTarget() {
        return this.konanTarget;
    }

    @NotNull
    public final FileCollection getClasspath() {
        return this.classpath;
    }

    @NotNull
    public final ListProperty<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @NotNull
    public final Provider<File> getActualNativeHomeDirectory() {
        return this.actualNativeHomeDirectory;
    }

    @NotNull
    public final Provider<String> getKonanDataDir() {
        return this.konanDataDir;
    }

    private final File getKonanHome() {
        return (File)this.actualNativeHomeDirectory.get();
    }

    private final boolean getShouldBuildCaches() {
        return ((KonanPropertiesBuildService)this.konanPropertiesService.get()).cacheWorksFor$kotlin_gradle_plugin_common(this.konanTarget) && this.konanCacheKind.get() != NativeCacheKind.NONE;
    }

    private final Set<String> getPresentDefs() {
        Lazy lazy = this.presentDefs$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> toPlatformLibNames(Set<String> $this$toPlatformLibNames) {
        void var3_3;
        void $this$mapTo$iv;
        Iterable iterable = $this$toPlatformLibNames;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add("org.jetbrains.kotlin.native.platform." + (String)it);
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkLibrariesInDistribution() {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            File[] $this$orEmpty$iv = this.platformLibsDirectory.listFiles(checkLibrariesInDistribution.presentPlatformLibs.1.INSTANCE);
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                objectArray = new File[0];
            }
            File[] $this$map$iv = objectArray;
            boolean $i$f$map = false;
            File[] $i$f$emptyArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            Set presentPlatformLibs2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$all$iv = this.toPlatformLibNames(this.getPresentDefs());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (presentPlatformLibs2.contains(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean checkCaches() {
        boolean bl;
        block4: {
            if (!this.getShouldBuildCaches()) {
                return true;
            }
            File file2 = this.getKonanHome();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"konanHome");
            Object object = this.konanCacheKind.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"konanCacheKind.get()");
            File cacheDirectory = CacheBuilder.Companion.getRootCacheDirectory$kotlin_gradle_plugin_common(file2, this.konanTarget, true, (NativeCacheKind)((Object)object));
            Iterable $this$all$iv = this.toPlatformLibNames(this.getPresentDefs());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Object object2 = this.konanCacheKind.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"konanCacheKind.get()");
                    if (!(FileUtilsKt.listFilesOrEmpty(FilesKt.resolve((File)cacheDirectory, (String)CacheBuilder.Companion.getCacheFileName$kotlin_gradle_plugin_common(it, (NativeCacheKind)((Object)object2)))).length == 0)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final PlatformLibsInfo getAlreadyProcessed() {
        return ((GeneratedPlatformLibrariesService)this.platformLibrariesService.get()).getPlatformLibsInfo();
    }

    private final void runGenerationTool() {
        Object object = new String[]{"-target", this.konanTarget.getVisibleName()};
        List args2 = CollectionsKt.mutableListOf((Object[])object);
        if (this.logger.isInfoEnabled()) {
            args2.add("-verbose");
        }
        String string = (String)this.konanDataDir.getOrNull();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Object[] objectArray = new String[]{"-Xkonan-data-dir", it};
            args2.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (this.getShouldBuildCaches()) {
            String string2 = ((NativeCacheKind)((Object)this.konanCacheKind.get())).getProduce();
            Intrinsics.checkNotNull((Object)string2);
            KotlinNativeTasksKt.addArg(args2, "-cache-kind", string2);
            Object object2 = this.actualNativeHomeDirectory.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"actualNativeHomeDirectory.get()");
            File file2 = (File)object2;
            Object object3 = this.konanCacheKind.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"konanCacheKind.get()");
            object = CacheBuilder.Companion.getRootCacheDirectory$kotlin_gradle_plugin_common(file2, this.konanTarget, true, (NativeCacheKind)((Object)object3)).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CacheBuilder.getRootCach\u2026           ).absolutePath");
            KotlinNativeTasksKt.addArg(args2, "-cache-directory", (String)object);
            KotlinNativeTasksKt.addArg(args2, "-cache-arg", "-g");
            List<String> additionalCacheFlags = ((KonanPropertiesBuildService)this.konanPropertiesService.get()).additionalCacheFlags$kotlin_gradle_plugin_common(this.konanTarget);
            Iterable $this$forEach$iv = additionalCacheFlags;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                KotlinNativeTasksKt.addArg(args2, "-cache-arg", it);
            }
        }
        Object object4 = this.kotlinCompilerArgumentsLogLevel.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"kotlinCompilerArgumentsLogLevel.get()");
        this.libraryGenerationRunner.runTool(new KotlinNativeToolRunner.ToolArguments(false, (KotlinCompilerArgumentsLogLevel)((Object)object4), args2));
    }

    /*
     * WARNING - void declaration
     */
    public final void generatePlatformLibsIfNeeded() {
        void $this$lifecycleWithDuration$iv;
        String string;
        boolean cachesAreReady;
        if (!new HostManager().isEnabled(this.konanTarget)) {
            return;
        }
        PlatformLibsInfo platformLibsInfo = this.getAlreadyProcessed();
        File file2 = this.platformLibsDirectory;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"platformLibsDirectory");
        boolean alreadyGenerated = platformLibsInfo.isGenerated(file2);
        PlatformLibsInfo platformLibsInfo2 = this.getAlreadyProcessed();
        File file3 = this.platformLibsDirectory;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"platformLibsDirectory");
        Object object = this.konanCacheKind.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"konanCacheKind.get()");
        boolean alreadyCached = platformLibsInfo2.isCached(file3, (NativeCacheKind)((Object)object));
        if (alreadyGenerated && alreadyCached || !this.defDirectory.exists()) {
            return;
        }
        boolean platformLibsAreReady = this.checkLibrariesInDistribution();
        if (platformLibsAreReady) {
            PlatformLibsInfo platformLibsInfo3 = this.getAlreadyProcessed();
            File file4 = this.platformLibsDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"platformLibsDirectory");
            platformLibsInfo3.setGenerated(file4);
        }
        if (cachesAreReady = this.checkCaches()) {
            PlatformLibsInfo platformLibsInfo4 = this.getAlreadyProcessed();
            File file5 = this.platformLibsDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"platformLibsDirectory");
            Object object2 = this.konanCacheKind.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"konanCacheKind.get()");
            platformLibsInfo4.setCached(file5, (NativeCacheKind)((Object)object2));
        }
        if (!platformLibsAreReady && !cachesAreReady) {
            StringBuilder stringBuilder = new StringBuilder().append("Generate and precompile platform libraries for ").append(this.konanTarget).append(" (precompilation: ");
            Object object3 = this.konanCacheKind.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"konanCacheKind.get()");
            string = stringBuilder.append(VisibleNamedKt.getVisibleName((Enum)((Enum)object3))).append(')').toString();
        } else if (platformLibsAreReady && !cachesAreReady) {
            StringBuilder stringBuilder = new StringBuilder().append("Precompile platform libraries for ").append(this.konanTarget).append(" (precompilation: ");
            Object object4 = this.konanCacheKind.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"konanCacheKind.get()");
            string = stringBuilder.append(VisibleNamedKt.getVisibleName((Enum)((Enum)object4))).append(')').toString();
        } else if (!platformLibsAreReady && cachesAreReady) {
            string = "Generate platform libraries for " + this.konanTarget;
        } else {
            return;
        }
        String generationMessage = string;
        this.logger.lifecycle(generationMessage);
        Logger logger2 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        Logger logger3 = logger2;
        String messagePrefix$iv = generationMessage + " finished,";
        boolean $i$f$lifecycleWithDuration = false;
        long startTime$iv = System.currentTimeMillis();
        boolean bl = false;
        this.runGenerationTool();
        Unit result$iv = Unit.INSTANCE;
        long finishTime$iv = System.currentTimeMillis();
        $this$lifecycleWithDuration$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv - startTime$iv));
        boolean librariesAreActuallyGenerated = this.checkLibrariesInDistribution();
        if (_Assertions.ENABLED && !librariesAreActuallyGenerated) {
            boolean $i$a$-assert-PlatformLibrariesGenerator$generatePlatformLibsIfNeeded$42 = false;
            String $i$a$-assert-PlatformLibrariesGenerator$generatePlatformLibsIfNeeded$42 = "Some platform libraries were not generated";
            throw new AssertionError((Object)$i$a$-assert-PlatformLibrariesGenerator$generatePlatformLibsIfNeeded$42);
        }
        if (librariesAreActuallyGenerated) {
            PlatformLibsInfo platformLibsInfo5 = this.getAlreadyProcessed();
            File file6 = this.platformLibsDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)file6, (String)"platformLibsDirectory");
            platformLibsInfo5.setGenerated(file6);
        }
        boolean librariesAreActuallyCached = this.checkCaches();
        if (_Assertions.ENABLED && !librariesAreActuallyCached) {
            boolean bl2 = false;
            String string2 = "Some platform libraries were not precompiled";
            throw new AssertionError((Object)string2);
        }
        if (librariesAreActuallyCached) {
            PlatformLibsInfo platformLibsInfo6 = this.getAlreadyProcessed();
            File file7 = this.platformLibsDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)file7, (String)"platformLibsDirectory");
            Object object5 = this.konanCacheKind.get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"konanCacheKind.get()");
            platformLibsInfo6.setCached(file7, (NativeCacheKind)((Object)object5));
        }
    }

    public static final /* synthetic */ File access$getDefDirectory$p(PlatformLibrariesGenerator $this) {
        return $this.defDirectory;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$Companion;", "", "()V", "registerRequiredServiceIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$GeneratedPlatformLibrariesService;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<GeneratedPlatformLibrariesService> registerRequiredServiceIfAbsent(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Gradle gradle = project.getGradle();
            Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
            return GradleUtilsKt.registerClassLoaderScopedBuildService$default(gradle, Reflection.getOrCreateKotlinClass(GeneratedPlatformLibrariesService.class), null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$GeneratedPlatformLibrariesService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "()V", "platformLibsInfo", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo;", "getPlatformLibsInfo", "()Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo;", "kotlin-gradle-plugin_common"})
    public static abstract class GeneratedPlatformLibrariesService
    implements BuildService<BuildServiceParameters.None> {
        @NotNull
        private final PlatformLibsInfo platformLibsInfo = new PlatformLibsInfo();

        @NotNull
        public final PlatformLibsInfo getPlatformLibsInfo() {
            return this.platformLibsInfo;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo;", "", "()V", "cached", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/gradle/dsl/NativeCacheKind;", "", "Ljava/io/File;", "generated", "cacheKind", "isCached", "", "path", "kind", "isGenerated", "setCached", "", "setGenerated", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nPlatformLibrariesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformLibrariesGenerator.kt\norg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n73#2,2:276\n1#3:278\n*S KotlinDebug\n*F\n+ 1 PlatformLibrariesGenerator.kt\norg/jetbrains/kotlin/gradle/targets/native/internal/PlatformLibrariesGenerator$PlatformLibsInfo\n*L\n232#1:276,2\n232#1:278\n*E\n"})
    public static final class PlatformLibsInfo {
        @NotNull
        private final Set<File> generated;
        @NotNull
        private final ConcurrentHashMap<NativeCacheKind, Set<File>> cached;

        public PlatformLibsInfo() {
            Set set = Collections.newSetFromMap(new ConcurrentHashMap());
            Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(ConcurrentHashMap<File, Boolean>())");
            this.generated = set;
            this.cached = new ConcurrentHashMap();
        }

        private final Set<File> cached(NativeCacheKind cacheKind) {
            ConcurrentMap $this$getOrPut$iv = this.cached;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get((Object)cacheKind);
            if (object == null) {
                boolean bl = false;
                Set default$iv = Collections.newSetFromMap(new ConcurrentHashMap());
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(cacheKind, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"cached.getOrPut(cacheKin\u2026le, Boolean>())\n        }");
            return (Set)object;
        }

        public final boolean isGenerated(@NotNull File path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.generated.contains(path);
        }

        public final void setGenerated(@NotNull File path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.generated.add(path);
        }

        public final boolean isCached(@NotNull File path, @NotNull NativeCacheKind kind) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            return kind == NativeCacheKind.NONE || this.cached(kind).contains(path);
        }

        public final void setCached(@NotNull File path, @NotNull NativeCacheKind kind) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            if (kind != NativeCacheKind.NONE) {
                this.cached(kind).add(path);
            }
        }
    }
}

