/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.util;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.util.GarbageCollectionStats;
import org.jetbrains.kotlin.gradle.internal.util.PhaseSideType;
import org.jetbrains.kotlin.gradle.internal.util.PhaseType;
import org.jetbrains.kotlin.gradle.internal.util.SideStats;
import org.jetbrains.kotlin.gradle.internal.util.Time;
import org.jetbrains.kotlin.gradle.internal.util.UnitStats;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00010\u0004\u001a&\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u001e\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000b\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0006\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"forEachPhaseMeasurement", "", "Lorg/jetbrains/kotlin/gradle/internal/util/UnitStats;", "action", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/gradle/internal/util/PhaseType;", "Lorg/jetbrains/kotlin/gradle/internal/util/Time;", "forEachPhaseSideMeasurement", "Lorg/jetbrains/kotlin/gradle/internal/util/PhaseSideType;", "Lorg/jetbrains/kotlin/gradle/internal/util/SideStats;", "forEachStringMeasurement", "Lkotlin/Function1;", "", "nanosInSecond", "", "getLinesPerSecond", "", "time", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nUnitStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitStats.kt\norg/jetbrains/kotlin/util/UnitStatsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1869#2,2:195\n1869#2,2:197\n*S KotlinDebug\n*F\n+ 1 UnitStats.kt\norg/jetbrains/kotlin/util/UnitStatsKt\n*L\n178#1:195,2\n187#1:197,2\n*E\n"})
public final class UnitStatsKt {
    private static final long nanosInSecond = TimeUnit.SECONDS.toNanos(1L);

    public static final void forEachPhaseMeasurement(@NotNull UnitStats $this$forEachPhaseMeasurement, @NotNull Function2<? super PhaseType, ? super Time, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachPhaseMeasurement, (String)"<this>");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        action2.invoke((Object)PhaseType.Initialization, (Object)$this$forEachPhaseMeasurement.getInitStats());
        action2.invoke((Object)PhaseType.Analysis, (Object)$this$forEachPhaseMeasurement.getAnalysisStats());
        action2.invoke((Object)PhaseType.TranslationToIr, (Object)$this$forEachPhaseMeasurement.getTranslationToIrStats());
        action2.invoke((Object)PhaseType.IrLowering, (Object)$this$forEachPhaseMeasurement.getIrLoweringStats());
        action2.invoke((Object)PhaseType.Backend, (Object)$this$forEachPhaseMeasurement.getBackendStats());
    }

    public static final void forEachPhaseSideMeasurement(@NotNull UnitStats $this$forEachPhaseSideMeasurement, @NotNull Function2<? super PhaseSideType, ? super SideStats, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachPhaseSideMeasurement, (String)"<this>");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        action2.invoke((Object)PhaseSideType.FindJavaClass, (Object)$this$forEachPhaseSideMeasurement.getFindJavaClassStats());
        action2.invoke((Object)PhaseSideType.BinaryClassFromKotlinFile, (Object)$this$forEachPhaseSideMeasurement.getFindKotlinClassStats());
    }

    public static final void forEachStringMeasurement(@NotNull UnitStats $this$forEachStringMeasurement, @NotNull Function1<? super String, Unit> action2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$forEachStringMeasurement, (String)"<this>");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            UnitStatsKt.forEachPhaseMeasurement($this$forEachStringMeasurement, (Function2<? super PhaseType, ? super Time, Unit>)((Function2)(arg_0, arg_1) -> UnitStatsKt.forEachStringMeasurement$lambda$0(action2, $this$forEachStringMeasurement, arg_0, arg_1)));
            UnitStatsKt.forEachPhaseSideMeasurement($this$forEachStringMeasurement, (Function2<? super PhaseSideType, ? super SideStats, Unit>)((Function2)(arg_0, arg_1) -> UnitStatsKt.forEachStringMeasurement$lambda$1(action2, arg_0, arg_1)));
            Iterable $this$forEach$iv = $this$forEachStringMeasurement.getGcStats();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GarbageCollectionStats it = (GarbageCollectionStats)element$iv;
                boolean bl = false;
                action2.invoke((Object)("GC time for " + it.getKind() + " is " + it.getMillis() + " ms, " + it.getCount() + " collections"));
            }
            Long l = $this$forEachStringMeasurement.getJitTimeMillis();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                action2.invoke((Object)("JIT time is " + it + " ms"));
            }
            List<String> list = $this$forEachStringMeasurement.getExtendedStats();
            if (list == null) break block3;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl = false;
                action2.invoke((Object)it);
            }
        }
    }

    public static final double getLinesPerSecond(@NotNull UnitStats $this$getLinesPerSecond, @NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)$this$getLinesPerSecond, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return (double)$this$getLinesPerSecond.getLinesCount() / (double)time.getNanos() * (double)nanosInSecond;
    }

    private static final Unit forEachStringMeasurement$lambda$0(Function1 $action, UnitStats $this_forEachStringMeasurement, PhaseType phaseType, Time time) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)phaseType), (String)"phaseType");
        if (time == null) {
            return Unit.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[phaseType.ordinal()]) {
            case 1: {
                string2 = "INIT";
                break;
            }
            case 2: {
                string2 = "ANALYZE";
                break;
            }
            case 3: {
                string2 = "TRANSLATION to IR";
                break;
            }
            case 4: {
                string2 = "IR LOWERING";
                break;
            }
            case 5: {
                string2 = "BACKEND";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String name2 = string2;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "%20s%8s ms";
        Object object = new Object[]{name2, time.getMillis()};
        String string4 = String.format(string3, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(string4);
        if (phaseType != PhaseType.Initialization && $this_forEachStringMeasurement.getLinesCount() != 0) {
            string3 = "%12.3f loc/s";
            object = Locale.ENGLISH;
            Object[] objectArray = new Object[]{UnitStatsKt.getLinesPerSecond($this_forEachStringMeasurement, time)};
            String string5 = String.format((Locale)object, string3, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        } else {
            string = "";
        }
        $action.invoke((Object)stringBuilder2.append(string).toString());
        return Unit.INSTANCE;
    }

    private static final Unit forEachStringMeasurement$lambda$1(Function1 $action, PhaseSideType phaseSideType, SideStats sideStats) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)phaseSideType), (String)"phaseSideType");
        if (sideStats == null) {
            return Unit.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[phaseSideType.ordinal()]) {
            case 1: {
                string = "Binary class from Kotlin file";
                break;
            }
            case 2: {
                string = "Find Java class";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String description = string;
        $action.invoke((Object)(description + " performed " + sideStats.getCount() + " times, total time " + sideStats.getTime().getMillis() + " ms"));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PhaseType.values().length];
            try {
                nArray[PhaseType.Initialization.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Analysis.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.TranslationToIr.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.IrLowering.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Backend.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PhaseSideType.values().length];
            try {
                nArray[PhaseSideType.BinaryClassFromKotlinFile.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseSideType.FindJavaClass.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

