/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.logging;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\rJ\u0014\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0014\u001a\u00020\u0015R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\bj\b\u0012\u0004\u0012\u00020\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/logging/BuildErrorMessageCollector;", "", "logger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "kotlinPluginVersion", "", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;Ljava/lang/String;)V", "errors", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getLogger", "()Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "addError", "", "error", "clear", "flush", "files", "", "Ljava/io/File;", "hasErrors", "", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildErrorMessageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildErrorMessageCollector.kt\norg/jetbrains/kotlin/gradle/logging/BuildErrorMessageCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class BuildErrorMessageCollector {
    @NotNull
    private final KotlinLogger logger;
    @Nullable
    private final String kotlinPluginVersion;
    @NotNull
    private final ArrayList<String> errors;

    public BuildErrorMessageCollector(@NotNull KotlinLogger logger2, @Nullable String kotlinPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.errors = new ArrayList();
    }

    public /* synthetic */ BuildErrorMessageCollector(KotlinLogger kotlinLogger, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(kotlinLogger, string);
    }

    @NotNull
    public final KotlinLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ArrayList<String> arrayList = this.errors;
        synchronized (arrayList) {
            boolean bl = false;
            this.errors.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        ArrayList<String> arrayList = this.errors;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = this.errors.add(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasErrors() {
        boolean bl;
        ArrayList<String> arrayList = this.errors;
        synchronized (arrayList) {
            boolean bl2 = false;
            bl = !((Collection)this.errors).isEmpty();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush(@NotNull Set<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        if (!this.hasErrors()) {
            return;
        }
        for (File file2 : files2) {
            file2.getParentFile().mkdirs();
            file2.createNewFile();
            Closeable closeable = new FileWriter(file2);
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)closeable;
                boolean bl = false;
                if (this.kotlinPluginVersion != null) {
                    String string;
                    String version2 = string;
                    boolean bl2 = false;
                    it.append("kotlin version: " + version2 + '\n');
                }
                for (String error : this.errors) {
                    it.append("error message: " + error + "\n\n");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.logger.debug(((Collection)this.errors).size() + " errors were stored into file " + file2.getAbsolutePath());
        }
        this.clear();
    }
}

