/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPairGeneratorProvider;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="PGP keys are not supposed to be cached. This task is intended for CLI usage.")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/GeneratePgpKeys;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "bouncyCastleClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBouncyCastleClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "gradleHomePath", "Lorg/gradle/api/provider/Property;", "", "getGradleHomePath", "()Lorg/gradle/api/provider/Property;", "keyName", "getKeyName", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "password", "getPassword", "execute", "", "GenerateKeyParameters", "GenerateKeys", "kotlin-gradle-plugin_common"})
public abstract class GeneratePgpKeys
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;

    @Inject
    public GeneratePgpKeys(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }

    @Input
    @Option(description="The name to be used for the generated key. Usually in the form of: 'Name Surname <email>'", option="name")
    @Optional
    @NotNull
    public abstract Property<String> getKeyName();

    @Input
    @Option(description="The password to be used for key encryption. If not provided, the value of the 'signing.password' Gradle property will be used.", option="password")
    @Optional
    @NotNull
    public abstract Property<String> getPassword();

    @Internal
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @Internal
    @NotNull
    public abstract ConfigurableFileCollection getBouncyCastleClasspath();

    @Internal
    @NotNull
    public abstract Property<String> getGradleHomePath();

    @TaskAction
    public final void execute() {
        if (!this.getKeyName().isPresent()) {
            boolean $i$a$-require-GeneratePgpKeys$execute$32 = false;
            String $i$a$-require-GeneratePgpKeys$execute$32 = "You must provide a value for the '--name' command line option, e.g. --name \"Jane Doe <janedoe@example.com>\"";
            throw new IllegalArgumentException($i$a$-require-GeneratePgpKeys$execute$32.toString());
        }
        if (!this.getPassword().isPresent()) {
            boolean bl = false;
            String string = "You must provide a value for either the '--password' command line option or the 'signing.password' Gradle property ";
            throw new IllegalArgumentException(string.toString());
        }
        WorkQueue workQueue2 = this.workerExecutor.classLoaderIsolation(new Action(this){
            final /* synthetic */ GeneratePgpKeys this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ClassLoaderWorkerSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getBouncyCastleClasspath()};
                it.getClasspath().from(objectArray);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"@TaskAction\n    fun exec\u2026omePath)\n        })\n    }");
        WorkQueue workQueue3 = workQueue2;
        workQueue3.submit(GenerateKeys.class, new Action(this){
            final /* synthetic */ GeneratePgpKeys this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(GenerateKeyParameters parameters) {
                parameters.getOutputDirectory().set((Provider)this.this$0.getOutputDirectory());
                parameters.getKeyName().set((Provider)this.this$0.getKeyName());
                parameters.getPassword().set(this.this$0.getPassword().get());
                parameters.getGradleHomePath().set((Provider)this.this$0.getGradleHomePath());
            }
        });
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b`\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/GeneratePgpKeys$GenerateKeyParameters;", "Lorg/gradle/workers/WorkParameters;", "gradleHomePath", "Lorg/gradle/api/provider/Property;", "", "getGradleHomePath", "()Lorg/gradle/api/provider/Property;", "keyName", "getKeyName", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "password", "getPassword", "kotlin-gradle-plugin_common"})
    public static interface GenerateKeyParameters
    extends WorkParameters {
        @NotNull
        public DirectoryProperty getOutputDirectory();

        @NotNull
        public Property<String> getKeyName();

        @NotNull
        public Property<String> getPassword();

        @NotNull
        public Property<String> getGradleHomePath();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/GeneratePgpKeys$GenerateKeys;", "Lorg/gradle/workers/WorkAction;", "Lorg/jetbrains/kotlin/gradle/tasks/GeneratePgpKeys$GenerateKeyParameters;", "()V", "execute", "", "generateKeyRing", "", "identity", "", "password", "", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\npgpHelperTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pgpHelperTasks.kt\norg/jetbrains/kotlin/gradle/tasks/GeneratePgpKeys$GenerateKeys\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n618#2,12:330\n1851#2,2:342\n*S KotlinDebug\n*F\n+ 1 pgpHelperTasks.kt\norg/jetbrains/kotlin/gradle/tasks/GeneratePgpKeys$GenerateKeys\n*L\n114#1:330,12\n118#1:342,2\n*E\n"})
    public static abstract class GenerateKeys
    implements WorkAction<GenerateKeyParameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Throwable throwable;
            Closeable closeable;
            FileOutputStream fileOutputStream2;
            Object it;
            Object object = ((GenerateKeyParameters)this.getParameters()).getKeyName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.keyName.get()");
            String string = (String)object;
            Object object2 = ((GenerateKeyParameters)this.getParameters()).getPassword().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.password.get()");
            char[] cArray = ((String)object2).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            Object object3 = this.generateKeyRing(string, cArray);
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.bouncycastle.openpgp.PGPSecretKeyRing");
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)object3;
            Iterator iterator2 = secretKeys.getPublicKeys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"secretKeys.publicKeys");
            PGPPublicKeyRing publicKeys = new PGPPublicKeyRing(SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator2)));
            Iterable $this$single$iv = (Iterable)publicKeys;
            boolean $i$f$single = false;
            Object[] single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                it = (PGPPublicKey)element$iv;
                boolean bl = false;
                if (!it.isMasterKey()) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = (Object[])element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            String string2 = StringsKt.takeLast((String)UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)((PGPPublicKey)single$iv).getKeyID()), (int)16), (int)8).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String keyId = string2;
            File dir2 = (File)((GenerateKeyParameters)this.getParameters()).getOutputDirectory().getAsFile().get();
            single$iv = new String[]{"secret_" + keyId + ".gpg", "secret_" + keyId + ".asc", "public_" + keyId + ".gpg", "public_" + keyId + ".asc", "example_" + keyId + ".properties"};
            List files2 = CollectionsKt.listOf((Object[])single$iv);
            Object $this$forEach$iv = files2;
            boolean $i$f$forEach = false;
            Unit unit = $this$forEach$iv.iterator();
            while (unit.hasNext()) {
                Object element$iv;
                element$iv = unit.next();
                it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)dir2, (String)"dir");
                if (!FilesKt.resolve((File)dir2, (String)it).exists()) continue;
                boolean $i$a$-check-GeneratePgpKeys$GenerateKeys$execute$1$22 = false;
                String $i$a$-check-GeneratePgpKeys$GenerateKeys$execute$1$22 = StringsKt.trimIndent((String)("\n                    The output directory '" + dir2.getAbsoluteFile() + "' already contains a file named '" + (String)it + "'.\n                    Please move your existing key files to another location then try again.                    \n                "));
                throw new IllegalStateException($i$a$-check-GeneratePgpKeys$GenerateKeys$execute$1$22.toString());
            }
            if (!dir2.exists() && !dir2.mkdirs()) {
                throw new IllegalStateException(("Failed to create output directory '" + dir2.getAbsolutePath() + '\'').toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)dir2, (String)"dir");
            $this$forEach$iv = new FileOutputStream(FilesKt.resolve((File)dir2, (String)("secret_" + keyId + ".gpg")));
            Object object4 = null;
            try {
                FileOutputStream secretOut = (FileOutputStream)$this$forEach$iv;
                boolean bl = false;
                secretKeys.encode((OutputStream)secretOut);
                secretOut = Unit.INSTANCE;
            }
            catch (Throwable secretOut) {
                object4 = secretOut;
                throw secretOut;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)object4);
            }
            $this$forEach$iv = new FileOutputStream(FilesKt.resolve((File)dir2, (String)("secret_" + keyId + ".asc")));
            object4 = null;
            try {
                fileOutputStream2 = (FileOutputStream)$this$forEach$iv;
                boolean bl = false;
                closeable = (Closeable)new ArmoredOutputStream((OutputStream)fileOutputStream2);
                throwable = null;
                try {
                    ArmoredOutputStream secretOut = (ArmoredOutputStream)closeable;
                    boolean bl2 = false;
                    secretKeys.encode((OutputStream)secretOut);
                    secretOut = Unit.INSTANCE;
                }
                catch (Throwable secretOut) {
                    throwable = secretOut;
                    throw secretOut;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                fileOutputStream2 = Unit.INSTANCE;
            }
            catch (Throwable fileOutputStream2) {
                object4 = fileOutputStream2;
                throw fileOutputStream2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)object4);
            }
            $this$forEach$iv = new FileOutputStream(FilesKt.resolve((File)dir2, (String)("public_" + keyId + ".gpg")));
            object4 = null;
            try {
                FileOutputStream publicOut = (FileOutputStream)$this$forEach$iv;
                boolean bl = false;
                publicKeys.encode((OutputStream)publicOut);
                publicOut = Unit.INSTANCE;
            }
            catch (Throwable publicOut) {
                object4 = publicOut;
                throw publicOut;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)object4);
            }
            $this$forEach$iv = new FileOutputStream(FilesKt.resolve((File)dir2, (String)("public_" + keyId + ".asc")));
            object4 = null;
            try {
                fileOutputStream2 = (FileOutputStream)$this$forEach$iv;
                boolean bl = false;
                closeable = (Closeable)new ArmoredOutputStream((OutputStream)fileOutputStream2);
                throwable = null;
                try {
                    ArmoredOutputStream publicOut = (ArmoredOutputStream)closeable;
                    boolean bl3 = false;
                    publicKeys.encode((OutputStream)publicOut);
                    Unit unit2 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                object4 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)object4);
            }
            String exampleProperties = StringsKt.trimIndent((String)("\n                signing.keyId=" + keyId + "\n                signing.password=<YOUR_PASSWORD>\n                signing.secretKeyRingFile=/PATH/TO/secret_" + keyId + ".gpg\n            "));
            FilesKt.writeText$default((File)FilesKt.resolve((File)dir2, (String)("example_" + keyId + ".properties")), (String)exampleProperties, null, (int)2, null);
            object4 = StringsKt.trimIndent((String)("\n                Generated PGP keys and associated metadata in '" + dir2.getAbsolutePath() + "'\n                Please move your generated key files to a secure location and do not share the secret key or your password with others.\n                The key ID of the generated key is '" + keyId + "'.\n                You can use this key ID to configure signing in your build script.\n                \n                For example, put the following in " + (String)((GenerateKeyParameters)this.getParameters()).getGradleHomePath().get() + File.separator + "gradle.properties:\n                \n" + StringsKt.prependIndent((String)exampleProperties, (String)"                ") + "\n                \n                More information: https://kotl.in/y470b1\n                \n                You can also find the armored ASCII version of the generated keys in the 'public_" + keyId + ".asc' and 'secret_" + keyId + ".asc' files.\n                \n                To upload your key to a PGP keyserver, you can use:\n                \n                gradlew uploadPublicPgpKey --keyring=\"" + FilesKt.resolve((File)dir2, (String)("public_" + keyId + ".asc")).getAbsolutePath() + "\"\n            "));
            System.out.println(object4);
        }

        private final Object generateKeyRing(String identity, char[] password) {
            PGPKeyPairGenerator generator = new BcPGPKeyPairGeneratorProvider().get(4, new Date());
            PGPKeyPair primaryKey = generator.generateLegacyEd25519KeyPair();
            PGPDigestCalculator sha1Calc = new BcPGPDigestCalculatorProvider().get(2);
            PGPContentSignerBuilder pGPContentSignerBuilder = new BcPGPContentSignerBuilderProvider(10).get(primaryKey.getPublicKey());
            Intrinsics.checkNotNullExpressionValue((Object)pGPContentSignerBuilder, (String)"BcPGPContentSignerBuilde\u2026get(primaryKey.publicKey)");
            PGPContentSignerBuilder contentSignerBuilder = pGPContentSignerBuilder;
            PBESecretKeyEncryptor secretKeyEncryptor = new BcPBESecretKeyEncryptorBuilder(9, sha1Calc).build(password);
            PGPSignatureSubpacketGenerator primarySubpackets = new PGPSignatureSubpacketGenerator();
            primarySubpackets.setKeyFlags(true, 2);
            int[] nArray = new int[]{10, 9, 8, 11};
            primarySubpackets.setPreferredHashAlgorithms(false, nArray);
            nArray = new int[]{9, 8, 7};
            primarySubpackets.setPreferredSymmetricAlgorithms(false, nArray);
            nArray = new int[]{2, 3, 1, 0};
            primarySubpackets.setPreferredCompressionAlgorithms(false, nArray);
            primarySubpackets.setFeature(false, (byte)1);
            primarySubpackets.setIssuerFingerprint(false, primaryKey.getPublicKey());
            PGPKeyRingGenerator gen = new PGPKeyRingGenerator(19, primaryKey, identity, sha1Calc, primarySubpackets.generate(), null, contentSignerBuilder, secretKeyEncryptor);
            PGPSecretKeyRing secretKeys = gen.generateSecretKeyRing();
            Intrinsics.checkNotNullExpressionValue((Object)secretKeys, (String)"secretKeys");
            return secretKeys;
        }
    }
}

