/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.stats;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.util.GarbageCollectionStats;
import org.jetbrains.kotlin.gradle.internal.util.PhaseSideType;
import org.jetbrains.kotlin.gradle.internal.util.PhaseType;
import org.jetbrains.kotlin.gradle.internal.util.SideStats;
import org.jetbrains.kotlin.gradle.internal.util.Time;
import org.jetbrains.kotlin.gradle.internal.util.TimeRatio;
import org.jetbrains.kotlin.gradle.internal.util.UnitStats;
import org.jetbrains.kotlin.gradle.internal.util.UnitStatsKt;
import org.jetbrains.kotlin.stats.MarkdownTableRenderer;
import org.jetbrains.kotlin.stats.ModulesReportsData;
import org.jetbrains.kotlin.stats.StatsCalculator;
import org.jetbrains.kotlin.stats.TimestampReportsData;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b*\u00060\tj\u0002`\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b*\u00060\tj\u0002`\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000b*\u00060\tj\u0002`\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b*\u00060\tj\u0002`\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\rJ\u0083\u0001\u0010\u001e\u001a\u00020\u000b\"\u000e\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u00028\u00000\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00028\u00000\u001626\u0010\u001d\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001a\u0012\b\b\u0013\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001a\u0012\b\b\u0013\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00060\u0019H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010$\u001a\u00020\u00062\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%J\u001b\u0010'\u001a\u00020\u0006*\u00020\u00172\u0006\u0010&\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b'\u0010(R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010)\u001a\u0004\b*\u0010+R\u001d\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00170,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u0017\u00101\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b3\u00104R\u0017\u00105\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b5\u00107R\u0017\u00108\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b8\u00102\u001a\u0004\b9\u00104R\u0014\u0010;\u001a\u00020:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/stats/MarkdownReportRenderer;", "", "Lorg/jetbrains/kotlin/stats/StatsCalculator;", "statsCalculator", "<init>", "(Lorg/jetbrains/kotlin/stats/StatsCalculator;)V", "", "render", "()Ljava/lang/String;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "renderInfo", "(Ljava/lang/StringBuilder;)V", "renderAggregateTimeStats", "renderSystemStats", "renderTopUnitStats", "", "R", "name", "", "max", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/gradle/internal/util/UnitStats;", "selector", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "moduleResult", "totalResult", "printer", "renderTopModules", "(Ljava/lang/StringBuilder;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "", "ratio", "", "nanos", "formatTime", "(DJ)Ljava/lang/String;", "total", "getTitleName", "(Lorg/jetbrains/kotlin/gradle/internal/util/UnitStats;Z)Ljava/lang/String;", "Lorg/jetbrains/kotlin/stats/StatsCalculator;", "getStatsCalculator", "()Lorg/jetbrains/kotlin/stats/StatsCalculator;", "", "unitStats", "Ljava/util/Collection;", "getUnitStats", "()Ljava/util/Collection;", "totalStats", "Lorg/jetbrains/kotlin/gradle/internal/util/UnitStats;", "getTotalStats", "()Lorg/jetbrains/kotlin/util/UnitStats;", "isTimestampMode", "Z", "()Z", "aggregatedStats", "getAggregatedStats", "Ljava/text/SimpleDateFormat;", "dateTimeFormatter", "Ljava/text/SimpleDateFormat;", "Companion", "compiler.common"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nMarkdownReportRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownReportRenderer.kt\norg/jetbrains/kotlin/stats/MarkdownReportRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1#2:214\n*E\n"})
public final class MarkdownReportRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StatsCalculator statsCalculator;
    @NotNull
    private final Collection<UnitStats> unitStats;
    @NotNull
    private final UnitStats totalStats;
    private final boolean isTimestampMode;
    @NotNull
    private final UnitStats aggregatedStats;
    @NotNull
    private final SimpleDateFormat dateTimeFormatter;
    public static final int TOP_MODULE_COUNT = 10;

    public MarkdownReportRenderer(@NotNull StatsCalculator statsCalculator) {
        Intrinsics.checkNotNullParameter((Object)statsCalculator, (String)"statsCalculator");
        this.statsCalculator = statsCalculator;
        this.unitStats = this.statsCalculator.getUnitStats();
        this.totalStats = this.statsCalculator.getTotalStats();
        this.isTimestampMode = this.statsCalculator.getReportsData() instanceof TimestampReportsData;
        this.aggregatedStats = this.isTimestampMode ? this.statsCalculator.getAverageStats() : this.totalStats;
        this.dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    @NotNull
    public final StatsCalculator getStatsCalculator() {
        return this.statsCalculator;
    }

    @NotNull
    public final Collection<UnitStats> getUnitStats() {
        return this.unitStats;
    }

    @NotNull
    public final UnitStats getTotalStats() {
        return this.totalStats;
    }

    public final boolean isTimestampMode() {
        return this.isTimestampMode;
    }

    @NotNull
    public final UnitStats getAggregatedStats() {
        return this.aggregatedStats;
    }

    @NotNull
    public final String render() {
        StringBuilder stringBuilder;
        StringBuilder $this$render_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.renderInfo($this$render_u24lambda_u240);
        this.renderAggregateTimeStats($this$render_u24lambda_u240);
        this.renderSystemStats($this$render_u24lambda_u240);
        if (this.statsCalculator.getUnitStats().size() > 1) {
            this.renderTopUnitStats($this$render_u24lambda_u240);
        }
        return stringBuilder.toString();
    }

    private final void renderInfo(StringBuilder $this$renderInfo) {
        $this$renderInfo.append("# Stats for " + this.getTitleName(this.totalStats, true)).append('\n');
        $this$renderInfo.append('\n');
        $this$renderInfo.append("* Platform: " + (Object)((Object)this.totalStats.getPlatform())).append('\n');
        $this$renderInfo.append("* Has errors: " + this.totalStats.getHasErrors()).append('\n');
        $this$renderInfo.append("* Modules count: " + this.unitStats.size()).append('\n');
        $this$renderInfo.append("* Files count: " + this.totalStats.getFilesCount()).append('\n');
        $this$renderInfo.append("* Lines count: " + this.totalStats.getLinesCount()).append('\n');
        $this$renderInfo.append('\n');
    }

    private final void renderAggregateTimeStats(StringBuilder $this$renderAggregateTimeStats) {
        Time aggregatedTime = this.aggregatedStats.getTotalTime();
        $this$renderAggregateTimeStats.append("# " + (this.isTimestampMode ? "Average" : "Total") + " time").append('\n');
        $this$renderAggregateTimeStats.append('\n');
        long maxTotalTime = Math.max(aggregatedTime.getNanos(), Math.max(aggregatedTime.getUserNanos(), aggregatedTime.getCpuNanos()));
        Iterator iterator2 = ((Iterable)UnitStatsKt.getPhaseTypeName().values()).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        String it422 = (String)iterator2.next();
        boolean bl = false;
        int it422 = it422.length();
        while (iterator2.hasNext()) {
            String it32 = (String)iterator2.next();
            $i$a$-maxOf-MarkdownReportRenderer$renderAggregateTimeStats$nameMaxColumnWidth$1 = false;
            int it32 = it32.length();
            if (it422 >= it32) continue;
            it422 = it32;
        }
        int n = it422;
        Iterator it422 = ((Iterable)UnitStatsKt.getPhaseSideTypeName().values()).iterator();
        if (!it422.hasNext()) {
            throw new NoSuchElementException();
        }
        String it22 = (String)it422.next();
        boolean bl2 = false;
        int it22 = it22.length();
        while (it422.hasNext()) {
            String it = (String)it422.next();
            $i$a$-maxOf-MarkdownReportRenderer$renderAggregateTimeStats$nameMaxColumnWidth$2 = false;
            int n2 = it.length();
            if (it22 >= n2) continue;
            it22 = n2;
        }
        int n3 = it22;
        int nameMaxColumnWidth = Math.max(n, n3);
        int valueMaxColumnWidth = this.formatTime(1.0, maxTotalTime).length();
        MarkdownTableRenderer $this$renderAggregateTimeStats_u24lambda_u242 = new MarkdownTableRenderer(4, nameMaxColumnWidth, valueMaxColumnWidth);
        boolean bl3 = false;
        String[] stringArray = new String[]{"Phase", "Absolute", "User", "Cpu"};
        $this$renderAggregateTimeStats_u24lambda_u242.renderHeader($this$renderAggregateTimeStats, stringArray);
        UnitStatsKt.forEachPhaseMeasurement(this.aggregatedStats, (Function2<? super PhaseType, ? super Time, Unit>)((Function2)(arg_0, arg_1) -> MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$0(aggregatedTime, $this$renderAggregateTimeStats_u24lambda_u242, $this$renderAggregateTimeStats, this, arg_0, arg_1)));
        $this$renderAggregateTimeStats_u24lambda_u242.renderBreak($this$renderAggregateTimeStats);
        UnitStatsKt.forEachPhaseSideMeasurement(this.aggregatedStats, (Function2<? super PhaseSideType, ? super SideStats, Unit>)((Function2)(arg_0, arg_1) -> MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$1(aggregatedTime, $this$renderAggregateTimeStats_u24lambda_u242, $this$renderAggregateTimeStats, this, arg_0, arg_1)));
        $this$renderAggregateTimeStats_u24lambda_u242.renderBreak($this$renderAggregateTimeStats);
        MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$renderTimeLine(aggregatedTime, $this$renderAggregateTimeStats_u24lambda_u242, $this$renderAggregateTimeStats, this, "TOTAL", aggregatedTime);
        $this$renderAggregateTimeStats.append('\n');
    }

    private final void renderSystemStats(StringBuilder $this$renderSystemStats) {
        $this$renderSystemStats.append("# System stats" + (this.isTimestampMode ? " (Average)" : "")).append('\n');
        $this$renderSystemStats.append('\n');
        $this$renderSystemStats.append("* JIT time: " + this.aggregatedStats.getJitTimeMillis() + " ms").append('\n');
        $this$renderSystemStats.append("* GC stats:").append('\n');
        for (GarbageCollectionStats gcStats : this.aggregatedStats.getGcStats()) {
            $this$renderSystemStats.append("  * " + gcStats.getKind() + ": " + gcStats.getMillis() + " ms (" + gcStats.getCount() + " collections)").append('\n');
        }
        $this$renderSystemStats.append('\n');
    }

    private final void renderTopUnitStats(StringBuilder $this$renderTopUnitStats) {
        $this$renderTopUnitStats.append("# Slowest " + (this.isTimestampMode ? "runs" : "modules")).append('\n');
        $this$renderTopUnitStats.append('\n');
        this.renderTopModules($this$renderTopUnitStats, "total time", true, MarkdownReportRenderer::renderTopUnitStats$lambda$0, (arg_0, arg_1) -> MarkdownReportRenderer.renderTopUnitStats$lambda$1(this, arg_0, arg_1));
        this.renderTopModules($this$renderTopUnitStats, "analysis time", true, MarkdownReportRenderer::renderTopUnitStats$lambda$2, (arg_0, arg_1) -> MarkdownReportRenderer.renderTopUnitStats$lambda$3(this, arg_0, arg_1));
        this.renderTopModules($this$renderTopUnitStats, "LPS (lines per second)", false, MarkdownReportRenderer::renderTopUnitStats$lambda$4, MarkdownReportRenderer::renderTopUnitStats$lambda$5);
    }

    private final <R extends Comparable<? super R>> void renderTopModules(StringBuilder $this$renderTopModules, String name2, boolean max, Function1<? super UnitStats, ? extends R> selector, Function2<? super R, ? super R, String> printer) {
        $this$renderTopModules.append("## By " + name2).append('\n');
        $this$renderTopModules.append('\n');
        Comparable totalValue = (Comparable)selector.invoke((Object)this.totalStats);
        List<UnitStats> topAnalysisModules = this.statsCalculator.getTopModulesBy(10, max, selector);
        String firstColumnName = this.statsCalculator.getReportsData() instanceof TimestampReportsData ? "Time Stamp" : "Module";
        int n = firstColumnName.length();
        Iterator iterator2 = ((Iterable)topAnalysisModules).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        UnitStats it22 = (UnitStats)iterator2.next();
        boolean bl = false;
        int it22 = this.getTitleName(it22, false).length();
        while (iterator2.hasNext()) {
            UnitStats it = (UnitStats)iterator2.next();
            $i$a$-maxOf-MarkdownReportRenderer$renderTopModules$nameMaxColumnWidth$1 = false;
            int n2 = this.getTitleName(it, false).length();
            if (it22 >= n2) continue;
            it22 = n2;
        }
        int n3 = it22;
        int nameMaxColumnWidth = Math.max(n, n3);
        int valueMaxColumnWidth = ((String)printer.invoke(selector.invoke((Object)(max ? (UnitStats)CollectionsKt.first(topAnalysisModules) : (UnitStats)CollectionsKt.last(topAnalysisModules))), (Object)totalValue)).length();
        MarkdownTableRenderer $this$renderTopModules_u24lambda_u241 = new MarkdownTableRenderer(2, nameMaxColumnWidth, valueMaxColumnWidth);
        boolean bl2 = false;
        String[] stringArray = new String[]{firstColumnName, "Value"};
        $this$renderTopModules_u24lambda_u241.renderHeader($this$renderTopModules, stringArray);
        for (UnitStats module2 : topAnalysisModules) {
            String[] stringArray2 = new String[]{this.getTitleName(module2, false), printer.invoke(selector.invoke((Object)module2), (Object)totalValue)};
            $this$renderTopModules_u24lambda_u241.renderLine($this$renderTopModules, stringArray2);
        }
        $this$renderTopModules.append('\n');
    }

    private final String formatTime(double ratio, long nanos) {
        String string = "%.2f%% (%d ms)";
        Object[] objectArray = new Object[]{ratio * (double)100, TimeUnit.NANOSECONDS.toMillis(nanos)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final String getTitleName(UnitStats $this$getTitleName, boolean total) {
        String string;
        if (this.statsCalculator.getReportsData() instanceof TimestampReportsData && total || this.statsCalculator.getReportsData() instanceof ModulesReportsData && !total) {
            string = $this$getTitleName.getName();
            if (string == null) {
                string = "";
            }
        } else {
            String prefix = this.statsCalculator.getUnitStats().size() == 1 ? $this$getTitleName.getName() + " at " : "";
            string = prefix + this.dateTimeFormatter.format($this$getTitleName.getTimeStampMs());
        }
        return string;
    }

    private static final void renderAggregateTimeStats$lambda$2$renderTimeLine(Time aggregatedTime, MarkdownTableRenderer $this_with, StringBuilder $this_renderAggregateTimeStats, MarkdownReportRenderer this$0, String name2, Time time) {
        if (time == null || Intrinsics.areEqual((Object)time, (Object)Time.Companion.getZERO())) {
            return;
        }
        TimeRatio timeRatio = time.div(aggregatedTime);
        String[] stringArray = new String[]{name2, this$0.formatTime(timeRatio.getNanos(), time.getNanos()), this$0.formatTime(timeRatio.getUserNanos(), time.getUserNanos()), this$0.formatTime(timeRatio.getCpuNanos(), time.getCpuNanos())};
        $this_with.renderLine($this_renderAggregateTimeStats, stringArray);
    }

    private static final Unit renderAggregateTimeStats$lambda$2$0(Time $aggregatedTime, MarkdownTableRenderer $this_with, StringBuilder $this_renderAggregateTimeStats, MarkdownReportRenderer this$0, PhaseType phaseType, Time time) {
        Intrinsics.checkNotNullParameter((Object)((Object)phaseType), (String)"phaseType");
        MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$renderTimeLine($aggregatedTime, $this_with, $this_renderAggregateTimeStats, this$0, (String)MapsKt.getValue(UnitStatsKt.getPhaseTypeName(), (Object)((Object)phaseType)), time);
        return Unit.INSTANCE;
    }

    private static final Unit renderAggregateTimeStats$lambda$2$1(Time $aggregatedTime, MarkdownTableRenderer $this_with, StringBuilder $this_renderAggregateTimeStats, MarkdownReportRenderer this$0, PhaseSideType phaseSideType, SideStats time) {
        Intrinsics.checkNotNullParameter((Object)((Object)phaseSideType), (String)"phaseSideType");
        SideStats sideStats = time;
        MarkdownReportRenderer.renderAggregateTimeStats$lambda$2$renderTimeLine($aggregatedTime, $this_with, $this_renderAggregateTimeStats, this$0, (String)MapsKt.getValue(UnitStatsKt.getPhaseSideTypeName(), (Object)((Object)phaseSideType)), sideStats != null ? sideStats.getTime() : null);
        return Unit.INSTANCE;
    }

    private static final long renderTopUnitStats$lambda$0(UnitStats it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTotalTime().getNanos();
    }

    private static final String renderTopUnitStats$lambda$1(MarkdownReportRenderer this$0, long moduleResult, long totalResult) {
        return this$0.formatTime((double)moduleResult / (double)totalResult, moduleResult);
    }

    private static final long renderTopUnitStats$lambda$2(UnitStats it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Time time = it.getAnalysisStats();
        return time != null ? time.getNanos() : 0L;
    }

    private static final String renderTopUnitStats$lambda$3(MarkdownReportRenderer this$0, long moduleResult, long totalResult) {
        return this$0.formatTime((double)moduleResult / (double)totalResult, moduleResult);
    }

    private static final double renderTopUnitStats$lambda$4(UnitStats it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (double)it.getLinesCount() / (double)it.getTotalTime().getNanos() * (double)UnitStatsKt.getNanosInSecond();
    }

    private static final String renderTopUnitStats$lambda$5(double moduleResult, double d) {
        String string = "%.2f LPS";
        Object[] objectArray = new Object[]{moduleResult};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Metadata(k=1, mv={2, 0, 0}, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/stats/MarkdownReportRenderer$Companion;", "", "<init>", "()V", "", "TOP_MODULE_COUNT", "I", "compiler.common"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

