/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.sources.ConsistencyCheck;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B>\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\b\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J5\u0010\u0013\u001a\u00020\u000f\"\u0004\b\u0001\u0010\u00142\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00140\n\u00a2\u0006\u0002\u0010\u0016R!\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001f\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/FragmentConsistencyChecker;", "T", "", "unitsName", "", "name", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "checks", "", "Lorg/jetbrains/kotlin/gradle/plugin/sources/ConsistencyCheck;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Ljava/util/List;)V", "getChecks", "()Ljava/util/List;", "runAllChecks", "", "dependent", "dependency", "(Ljava/lang/Object;Ljava/lang/Object;)V", "runSingleCheck", "S", "check", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/jetbrains/kotlin/gradle/plugin/sources/ConsistencyCheck;)V", "kotlin-gradle-plugin_common"})
public final class FragmentConsistencyChecker<T> {
    @NotNull
    private final String unitsName;
    @NotNull
    private final Function1<T, String> name;
    @NotNull
    private final List<ConsistencyCheck<T, ?>> checks;

    public FragmentConsistencyChecker(@NotNull String unitsName, @NotNull Function1<? super T, String> name2, @NotNull List<? extends ConsistencyCheck<T, ?>> checks) {
        Intrinsics.checkNotNullParameter((Object)unitsName, (String)"unitsName");
        Intrinsics.checkNotNullParameter(name2, (String)"name");
        Intrinsics.checkNotNullParameter(checks, (String)"checks");
        this.unitsName = unitsName;
        this.name = name2;
        this.checks = checks;
    }

    @NotNull
    public final List<ConsistencyCheck<T, ?>> getChecks() {
        return this.checks;
    }

    public final <S> void runSingleCheck(T dependent, T dependency, @NotNull ConsistencyCheck<T, S> check2) {
        Intrinsics.checkNotNullParameter(check2, (String)"check");
        Object leftValue = check2.getGetValue().invoke(dependent);
        Object rightValue = check2.getGetValue().invoke(dependency);
        if (!((Boolean)check2.getLeftExtendsRightConsistently().invoke(leftValue, rightValue)).booleanValue()) {
            throw new InvalidUserDataException("Inconsistent settings for Kotlin " + this.unitsName + ": '" + (String)this.name.invoke(dependent) + "' depends on '" + (String)this.name.invoke(dependency) + "'\n'" + (String)this.name.invoke(dependent) + "': " + check2.getName() + " is " + leftValue + "\n'" + (String)this.name.invoke(dependency) + "': " + check2.getName() + " is " + rightValue + '\n' + check2.getConsistencyConditionHint());
        }
    }

    public final void runAllChecks(T dependent, T dependency) {
        for (ConsistencyCheck<T, ?> check2 : this.checks) {
            this.runSingleCheck(dependent, dependency, check2);
        }
    }
}

