/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.diagnostics;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinSourceSetConvention;
import org.jetbrains.kotlin.gradle.dsl.KotlinVersion;
import org.jetbrains.kotlin.gradle.internal.properties.NativeProperties;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.DiagnosticGroup;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsKt;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnosticFactory;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.checkers.UnresolvedKmpDependency;
import org.jetbrains.kotlin.gradle.plugin.sources.android.KotlinAndroidSourceSetLayoutKt;
import org.jetbrains.kotlin.gradle.utils.KotlinPlatformTypeUtilsKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.tooling.core.KotlinToolingVersion;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\bi\b\u00c0\u0002\u0018\u00002\u00020\u0001:g\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics;", "", "()V", "BUG_REPORT_URL", "Ljava/net/URI;", "resourcesBugReportRequest", "", "url", "AbiValidationUnsupportedTarget", "AgpRequirementNotMetForAndroidSourceSetLayoutV2", "AgpWithBuiltInKotlinIsAlreadyApplied", "AndroidExtensionPluginRemoval", "AndroidGradlePluginIsMissing", "AndroidMainSourceSetConventionUsedWithoutAndroidTarget", "AndroidPublicationNotConfigured", "AndroidSourceSetLayoutV1Deprecation", "AndroidSourceSetLayoutV1SourceSetsNotFoundError", "AndroidStyleSourceDirUsageWarning", "AndroidTargetIsMissing", "AssetsPublishedMoreThanOncePerTarget", "BrokenKotlinNativeBundleError", "BuildToolsApiVersionInconsistency", "CInteropRequiredParametersNotSpecifiedError", "CircularDependsOnEdges", "CommonMainOrTestWithDependsOnDiagnostic", "CrossCompilationWithCinterops", "DependencyDoesNotPhysicallyExist", "DeprecatedErrorGradleProperties", "DeprecatedGradleProperties", "DeprecatedJvmWithJavaPresetDiagnostic", "DeprecatedKotlinNativeTargetsDiagnostic", "DeprecatedKotlinVersionKotlinDsl", "DeprecatedPropertyWithReplacement", "DeprecatedWarningGradleProperties", "DisabledCinteropsCommonizationInHmppProject", "DisabledKotlinNativeTargets", "DuplicateSourceSetsError", "ExperimentalArtifactsDslUsed", "ExperimentalFeatureWarning", "ExperimentalTryNextWarning", "FailedToGetAgpVersionWarning", "IcFirMisconfigurationLV", "IncompatibleAgpVersionTooLowFatalError", "IncompatibleBinaryConfiguration", "IncompatibleGradleVersionTooLowFatalError", "IncompatibleWithTheNewAgpDsl", "InconsistentTargetCompatibilityForKotlinAndJavaTasks", "IncorrectCompileOnlyDependencyWarning", "InternalKotlinGradlePluginPropertiesUsed", "IosSourceSetConventionUsedWithoutIosTarget", "JsEnvironmentNotChosenExplicitly", "JsLikeEnvironmentNotChosenExplicitly", "JvmWithJavaIsIncompatibleWithAndroid", "KMPJavaPluginsIncompatibilityDiagnostic", "KMPWithJavaDiagnostic", "KonanHomeConflictDeclaration", "KotlinCompilationSourceDeprecation", "KotlinCompilerEmbeddableIsPresentInClasspath", "KotlinDefaultHierarchyFallbackDependsOnUsageDetected", "KotlinDefaultHierarchyFallbackIllegalTargetNames", "KotlinJvmMainRunTaskConflict", "KotlinNativeArtifactsDeprecation", "KotlinScriptingMisconfiguration", "KotlinSourceSetDependsOnDefaultCompilationSourceSet", "KotlinSourceSetTreeDependsOnMismatch", "KotlinTargetAlreadyDeclared", "KotlinTargetAlreadyDeclaredError", "KotlinTargetAlreadyDeclaredWarning", "KotlinTopLevelDependenciesUsedInIncompatibleGradleVersion", "MissingResourcesConfigurationForTarget", "MissingRuntimeDependencyConfigurationForWasmTarget", "MultipleSourceSetRootsInCompilation", "NativeStdlibIsMissingDiagnostic", "NewNativeVersionDiagnostic", "NoComposeCompilerPluginAppliedWarning", "NoKotlinTargetsDeclared", "NotCompatibleWithGradle9", "OldNativeVersionDiagnostic", "PartiallyResolvedKmpDependencies", "PlatformSourceSetConventionUsedWithCustomTargetName", "PlatformSourceSetConventionUsedWithoutCorrespondingTarget", "PomMisconfigured", "PreHMPPFlagsError", "PreHmppDependenciesUsedInBuild", "PublishAllAndroidLibraryVariantsDeprecated", "RedundantDependsOnEdgesFound", "ResourceMayNotBePublishedForTarget", "ResourceMayNotBeResolvedForTarget", "ResourceMayNotBeResolvedWithGradleVersion", "ResourcePublishedMoreThanOncePerTarget", "SigningMisconfigured", "SomePublicationsNotSigned", "SourceSetLayoutV1StyleDirUsageWarning", "SwiftExportArtifactResolution", "SwiftExportInvalidModuleName", "SwiftExportModuleResolutionError", "UklibFragmentFromUnexpectedTarget", "UklibPublicationWithCinterops", "UklibPublicationWithoutCrossCompilation", "UklibSourceSetStructureUnderRefinementViolation", "UnknownAppleFrameworkBuildType", "UnrecognizedKotlinNativeDistributionType", "UnusedSourceSetsWarning", "UsingOutOfProcessDisablesBuildToolsApi", "WarnFailToConfigureJavaTestFixturesPlugin", "WasmJsEnvironmentNotChosenExplicitly", "WasmSourceSetsNotFoundError", "WasmWasiEnvironmentNotChosenExplicitly", "XCFrameworkDifferentInnerFrameworksName", "XcodeUserScriptSandboxingDiagnostic", "XcodeVersionTooHighWarning", "kotlin-gradle-plugin_common"})
public final class KotlinToolingDiagnostics {
    @NotNull
    public static final KotlinToolingDiagnostics INSTANCE = new KotlinToolingDiagnostics();
    @NotNull
    private static final URI BUG_REPORT_URL = new URI("https://kotl.in/issue");

    private KotlinToolingDiagnostics() {
    }

    private final String resourcesBugReportRequest(String url) {
        return "This is likely a bug in Kotlin Gradle Plugin configuration. Please report this issue to " + url;
    }

    public static final /* synthetic */ URI access$getBUG_REPORT_URL$p() {
        return BUG_REPORT_URL;
    }

    public static final /* synthetic */ String access$resourcesBugReportRequest(KotlinToolingDiagnostics $this, String url) {
        return $this.resourcesBugReportRequest(url);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AbiValidationUnsupportedTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class AbiValidationUnsupportedTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AbiValidationUnsupportedTarget INSTANCE = new AbiValidationUnsupportedTarget();

        private AbiValidationUnsupportedTarget() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Experimental.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(targetName){
                final /* synthetic */ String $targetName;
                {
                    this.$targetName = $targetName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("ABI Validation: unsupported target").description((Function0<String>)((Function0)new Function0<String>(this.$targetName){
                        final /* synthetic */ String $targetName;
                        {
                            this.$targetName = $targetName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Target " + this.$targetName + " is not supported by the host compiler and a KLib ABI dump could not be directly generated for it.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AgpRequirementNotMetForAndroidSourceSetLayoutV2;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "minimumRequiredAgpVersion", "", "currentAgpVersion", "kotlin-gradle-plugin_common"})
    public static final class AgpRequirementNotMetForAndroidSourceSetLayoutV2
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AgpRequirementNotMetForAndroidSourceSetLayoutV2 INSTANCE = new AgpRequirementNotMetForAndroidSourceSetLayoutV2();

        private AgpRequirementNotMetForAndroidSourceSetLayoutV2() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String minimumRequiredAgpVersion, @NotNull String currentAgpVersion) {
            Intrinsics.checkNotNullParameter((Object)minimumRequiredAgpVersion, (String)"minimumRequiredAgpVersion");
            Intrinsics.checkNotNullParameter((Object)currentAgpVersion, (String)"currentAgpVersion");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(minimumRequiredAgpVersion, currentAgpVersion){
                final /* synthetic */ String $minimumRequiredAgpVersion;
                final /* synthetic */ String $currentAgpVersion;
                {
                    this.$minimumRequiredAgpVersion = $minimumRequiredAgpVersion;
                    this.$currentAgpVersion = $currentAgpVersion;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Android Gradle Plugin Version Incompatible with Source Set Layout V2").description((Function0<String>)((Function0)new Function0<String>(this.$minimumRequiredAgpVersion, this.$currentAgpVersion){
                        final /* synthetic */ String $minimumRequiredAgpVersion;
                        final /* synthetic */ String $currentAgpVersion;
                        {
                            this.$minimumRequiredAgpVersion = $minimumRequiredAgpVersion;
                            this.$currentAgpVersion = $currentAgpVersion;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    " + KotlinAndroidSourceSetLayoutKt.getMultiplatformAndroidSourceSetLayoutV2().getName() + " requires Android Gradle Plugin Version >= " + this.$minimumRequiredAgpVersion + ".\n                    Found " + this.$currentAgpVersion + "\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$minimumRequiredAgpVersion){
                        final /* synthetic */ String $minimumRequiredAgpVersion;
                        {
                            this.$minimumRequiredAgpVersion = $minimumRequiredAgpVersion;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please update the Android Gradle Plugin version to at least " + this.$minimumRequiredAgpVersion + '.';
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AgpWithBuiltInKotlinIsAlreadyApplied;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "buildFile", "Ljava/io/File;", "trace", "", "kotlin-gradle-plugin_common"})
    public static final class AgpWithBuiltInKotlinIsAlreadyApplied
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AgpWithBuiltInKotlinIsAlreadyApplied INSTANCE = new AgpWithBuiltInKotlinIsAlreadyApplied();

        private AgpWithBuiltInKotlinIsAlreadyApplied() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull File buildFile, @NotNull Throwable trace) {
            Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, trace, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(buildFile){
                final /* synthetic */ File $buildFile;
                {
                    this.$buildFile = $buildFile;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$build.title("Failed to apply plugin 'com.jetbrains.kotlin.android'").description("The 'org.jetbrains.kotlin.android' plugin is no longer required for Kotlin support since AGP 9.0.").solution("Remove the 'org.jetbrains.kotlin.android' plugin from this project's build file: " + this.$buildFile + '.'), new URI("https://kotl.in/gradle/agp-built-in-kotlin"), null, 2, null);
                }
            }, 7, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidExtensionPluginRemoval;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class AndroidExtensionPluginRemoval
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidExtensionPluginRemoval INSTANCE = new AndroidExtensionPluginRemoval();

        private AndroidExtensionPluginRemoval() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidGradlePluginIsMissing;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "trace", "", "kotlin-gradle-plugin_common"})
    public static final class AndroidGradlePluginIsMissing
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidGradlePluginIsMissing INSTANCE = new AndroidGradlePluginIsMissing();

        private AndroidGradlePluginIsMissing() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable Throwable trace) {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, trace, invoke.1.INSTANCE, 7, null);
        }

        public static /* synthetic */ ToolingDiagnostic invoke$default(AndroidGradlePluginIsMissing androidGradlePluginIsMissing, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                throwable = null;
            }
            return androidGradlePluginIsMissing.invoke(throwable);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidMainSourceSetConventionUsedWithoutAndroidTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
    public static final class AndroidMainSourceSetConventionUsedWithoutAndroidTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidMainSourceSetConventionUsedWithoutAndroidTarget INSTANCE = new AndroidMainSourceSetConventionUsedWithoutAndroidTarget();

        private AndroidMainSourceSetConventionUsedWithoutAndroidTarget() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinSourceSet sourceSet) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, KotlinSourceSetConvention.INSTANCE.isAccessedByKotlinSourceSetConventionAt$kotlin_gradle_plugin_common(sourceSet), (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(sourceSet){
                final /* synthetic */ KotlinSourceSet $sourceSet;
                {
                    this.$sourceSet = $sourceSet;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Android Source Set Used Without an Android Target").description((Function0<String>)((Function0)new Function0<String>(this.$sourceSet){
                        final /* synthetic */ KotlinSourceSet $sourceSet;
                        {
                            this.$sourceSet = $sourceSet;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Accessed '" + this.$sourceSet + "' without registering the Android target\n                    Please apply a given Android Gradle plugin (e.g. com.android.library) and register an Android target\n                    \n                    Example using the 'com.android.library' plugin:\n                    \n                        plugins {\n                            id(\"com.android.library\")\n                        }\n                    \n                        android {\n                            namespace = \"org.sample.library\"\n                            compileSdk = 33\n                        }\n                    \n                        kotlin {\n                            androidTarget() /* <- register the androidTarget */\n                        }\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 7, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidPublicationNotConfigured;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "componentName", "", "publicationName", "kotlin-gradle-plugin_common"})
    public static final class AndroidPublicationNotConfigured
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidPublicationNotConfigured INSTANCE = new AndroidPublicationNotConfigured();

        private AndroidPublicationNotConfigured() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String componentName, @NotNull String publicationName) {
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            Intrinsics.checkNotNullParameter((Object)publicationName, (String)"publicationName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, new Throwable(), (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(publicationName, componentName){
                final /* synthetic */ String $publicationName;
                final /* synthetic */ String $componentName;
                {
                    this.$publicationName = $publicationName;
                    this.$componentName = $componentName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$build.title("Android Publication '" + this.$publicationName + "' Misconfigured for Variant '" + this.$componentName + '\'').description((Function0<String>)((Function0)new Function0<String>(this.$publicationName, this.$componentName){
                        final /* synthetic */ String $publicationName;
                        final /* synthetic */ String $componentName;
                        {
                            this.$publicationName = $publicationName;
                            this.$componentName = $componentName;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Android Publication '" + this.$publicationName + "' for variant '" + this.$componentName + "' was not configured properly:\n                    \n                    To avoid this warning, please create and configure Android publication variant with name '" + this.$componentName + "'.\n                    Example:\n                    ```\n                    android {\n                        publishing {\n                            singleVariant(\"" + this.$componentName + "\") {}\n                        }\n                    }\n                    ```\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$publicationName, this.$componentName){
                        final /* synthetic */ String $publicationName;
                        final /* synthetic */ String $componentName;
                        {
                            this.$publicationName = $publicationName;
                            this.$componentName = $componentName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please configure Android publication '" + this.$publicationName + "' for variant '" + this.$componentName + "'.";
                        }
                    })), new URI("https://kotl.in/oe70nr"), null, 2, null);
                }
            }, 7, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidSourceSetLayoutV1Deprecation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class AndroidSourceSetLayoutV1Deprecation
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidSourceSetLayoutV1Deprecation INSTANCE = new AndroidSourceSetLayoutV1Deprecation();

        private AndroidSourceSetLayoutV1Deprecation() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidSourceSetLayoutV1SourceSetsNotFoundError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "nameOfRequestedSourceSet", "", "kotlin-gradle-plugin_common"})
    public static final class AndroidSourceSetLayoutV1SourceSetsNotFoundError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidSourceSetLayoutV1SourceSetsNotFoundError INSTANCE = new AndroidSourceSetLayoutV1SourceSetsNotFoundError();

        private AndroidSourceSetLayoutV1SourceSetsNotFoundError() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String nameOfRequestedSourceSet) {
            Intrinsics.checkNotNullParameter((Object)nameOfRequestedSourceSet, (String)"nameOfRequestedSourceSet");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(nameOfRequestedSourceSet){
                final /* synthetic */ String $nameOfRequestedSourceSet;
                {
                    this.$nameOfRequestedSourceSet = $nameOfRequestedSourceSet;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Renamed Android Source Set Not Found").description((Function0<String>)((Function0)new Function0<String>(this.$nameOfRequestedSourceSet){
                        final /* synthetic */ String $nameOfRequestedSourceSet;
                        {
                            this.$nameOfRequestedSourceSet = $nameOfRequestedSourceSet;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    KotlinSourceSet with name '" + this.$nameOfRequestedSourceSet + "' not found:\n                    The SourceSet requested ('" + this.$nameOfRequestedSourceSet + "') was renamed in Kotlin 1.9.0\n                    \n                    In order to migrate you might want to replace:\n                    sourceSets.getByName(\"androidTest\") -> sourceSets.getByName(\"androidUnitTest\")\n                    sourceSets.getByName(\"androidAndroidTest\") -> sourceSets.getByName(\"androidInstrumentedTest\")\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/android-source-set-layout-v2"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidStyleSourceDirUsageWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "androidStyleSourceDirInUse", "", "kotlinStyleSourceDirToUse", "kotlin-gradle-plugin_common"})
    public static final class AndroidStyleSourceDirUsageWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidStyleSourceDirUsageWarning INSTANCE = new AndroidStyleSourceDirUsageWarning();

        private AndroidStyleSourceDirUsageWarning() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String androidStyleSourceDirInUse, @NotNull String kotlinStyleSourceDirToUse) {
            Intrinsics.checkNotNullParameter((Object)androidStyleSourceDirInUse, (String)"androidStyleSourceDirInUse");
            Intrinsics.checkNotNullParameter((Object)kotlinStyleSourceDirToUse, (String)"kotlinStyleSourceDirToUse");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(androidStyleSourceDirInUse, kotlinStyleSourceDirToUse){
                final /* synthetic */ String $androidStyleSourceDirInUse;
                final /* synthetic */ String $kotlinStyleSourceDirToUse;
                {
                    this.$androidStyleSourceDirInUse = $androidStyleSourceDirInUse;
                    this.$kotlinStyleSourceDirToUse = $kotlinStyleSourceDirToUse;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Deprecated 'Android Style' Source Directory").description((Function0<String>)((Function0)new Function0<String>(this.$androidStyleSourceDirInUse, this.$kotlinStyleSourceDirToUse){
                        final /* synthetic */ String $androidStyleSourceDirInUse;
                        final /* synthetic */ String $kotlinStyleSourceDirToUse;
                        {
                            this.$androidStyleSourceDirInUse = $androidStyleSourceDirInUse;
                            this.$kotlinStyleSourceDirToUse = $kotlinStyleSourceDirToUse;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Usage of 'Android Style' source directory " + this.$androidStyleSourceDirInUse + " is deprecated.\n                    Use " + this.$kotlinStyleSourceDirToUse + " instead.\n                    \n                    To suppress this warning: put the following in your gradle.properties:\n                    " + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_ANDROID_SOURCE_SET_LAYOUT_ANDROID_STYLE_NO_WARN() + "=true\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$kotlinStyleSourceDirToUse){
                        final /* synthetic */ String $kotlinStyleSourceDirToUse;
                        {
                            this.$kotlinStyleSourceDirToUse = $kotlinStyleSourceDirToUse;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please migrate to the new source directory: " + this.$kotlinStyleSourceDirToUse;
                        }
                    })).documentationLink(new URI("https://kotl.in/android-source-set-layout-v2"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AndroidTargetIsMissing;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "projectName", "", "projectPath", "androidPluginId", "kotlin-gradle-plugin_common"})
    public static final class AndroidTargetIsMissing
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AndroidTargetIsMissing INSTANCE = new AndroidTargetIsMissing();

        private AndroidTargetIsMissing() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String projectName, @NotNull String projectPath2, @NotNull String androidPluginId) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            Intrinsics.checkNotNullParameter((Object)projectPath2, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)androidPluginId, (String)"androidPluginId");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(projectName, projectPath2, androidPluginId){
                final /* synthetic */ String $projectName;
                final /* synthetic */ String $projectPath;
                final /* synthetic */ String $androidPluginId;
                {
                    this.$projectName = $projectName;
                    this.$projectPath = $projectPath;
                    this.$androidPluginId = $androidPluginId;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Missing `androidTarget()` in Kotlin Multiplatform Project").description((Function0<String>)((Function0)new Function0<String>(this.$projectName, this.$projectPath, this.$androidPluginId){
                        final /* synthetic */ String $projectName;
                        final /* synthetic */ String $projectPath;
                        final /* synthetic */ String $androidPluginId;
                        {
                            this.$projectName = $projectName;
                            this.$projectPath = $projectPath;
                            this.$androidPluginId = $androidPluginId;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Missing `androidTarget()` Kotlin target in multiplatform project '" + this.$projectName + " (" + this.$projectPath + ")'.\n                    The Android Gradle plugin was applied without creating a corresponding `androidTarget()` Kotlin Target\n                    ```\n                    plugins {\n                        id(\"" + this.$androidPluginId + "\")\n                        kotlin(\"multiplatform\")\n                    }\n                    \n                    kotlin {\n                        androidTarget() // <-- please register this Android target\n                    }\n                    ```\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$AssetsPublishedMoreThanOncePerTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class AssetsPublishedMoreThanOncePerTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final AssetsPublishedMoreThanOncePerTarget INSTANCE = new AssetsPublishedMoreThanOncePerTarget();

        private AssetsPublishedMoreThanOncePerTarget() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$BrokenKotlinNativeBundleError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlinNativeHomePropertyValue", "", "kotlinNativeHomeProperty", "kotlin-gradle-plugin_common"})
    public static final class BrokenKotlinNativeBundleError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final BrokenKotlinNativeBundleError INSTANCE = new BrokenKotlinNativeBundleError();

        private BrokenKotlinNativeBundleError() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable String kotlinNativeHomePropertyValue, @NotNull String kotlinNativeHomeProperty) {
            Intrinsics.checkNotNullParameter((Object)kotlinNativeHomeProperty, (String)"kotlinNativeHomeProperty");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(kotlinNativeHomePropertyValue, kotlinNativeHomeProperty){
                final /* synthetic */ String $kotlinNativeHomePropertyValue;
                final /* synthetic */ String $kotlinNativeHomeProperty;
                {
                    this.$kotlinNativeHomePropertyValue = $kotlinNativeHomePropertyValue;
                    this.$kotlinNativeHomeProperty = $kotlinNativeHomeProperty;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Kotlin/Native Distribution Missing Required Subdirectories").description((Function0<String>)((Function0)new Function0<String>(this.$kotlinNativeHomePropertyValue){
                        final /* synthetic */ String $kotlinNativeHomePropertyValue;
                        {
                            this.$kotlinNativeHomePropertyValue = $kotlinNativeHomePropertyValue;
                            super(0);
                        }

                        public final String invoke() {
                            return "The Kotlin/Native distribution (" + this.$kotlinNativeHomePropertyValue + ") used in this build does not provide required subdirectories.";
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$kotlinNativeHomeProperty){
                        final /* synthetic */ String $kotlinNativeHomeProperty;
                        {
                            this.$kotlinNativeHomeProperty = $kotlinNativeHomeProperty;
                            super(0);
                        }

                        public final String invoke() {
                            return "Make sure that the '" + this.$kotlinNativeHomeProperty + "' property points to a valid Kotlin/Native distribution.";
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$BuildToolsApiVersionInconsistency;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "expectedVersion", "", "actualVersion", "kotlin-gradle-plugin_common"})
    public static final class BuildToolsApiVersionInconsistency
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final BuildToolsApiVersionInconsistency INSTANCE = new BuildToolsApiVersionInconsistency();

        private BuildToolsApiVersionInconsistency() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String expectedVersion, @Nullable String actualVersion) {
            Intrinsics.checkNotNullParameter((Object)expectedVersion, (String)"expectedVersion");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(expectedVersion, actualVersion){
                final /* synthetic */ String $expectedVersion;
                final /* synthetic */ String $actualVersion;
                {
                    this.$expectedVersion = $expectedVersion;
                    this.$actualVersion = $actualVersion;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Build Tools API Version Mismatch Detected").description((Function0<String>)((Function0)new Function0<String>(this.$expectedVersion, this.$actualVersion){
                        final /* synthetic */ String $expectedVersion;
                        final /* synthetic */ String $actualVersion;
                        {
                            this.$expectedVersion = $expectedVersion;
                            this.$actualVersion = $actualVersion;
                            super(0);
                        }

                        public final String invoke() {
                            StringBuilder stringBuilder = new StringBuilder().append("\n                    Artifact org.jetbrains.kotlin:kotlin-build-tools-impl must have version aligned with the version of KGP when compilation via the Build Tools API is disabled.\n    \n                    Expected version: ").append(this.$expectedVersion).append("\n                    Actual resolved version: ");
                            String string = this.$actualVersion;
                            if (string == null) {
                                string = "not found";
                            }
                            return StringsKt.trimIndent((String)stringBuilder.append(string).append("\n                    ").toString());
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$CInteropRequiredParametersNotSpecifiedError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class CInteropRequiredParametersNotSpecifiedError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final CInteropRequiredParametersNotSpecifiedError INSTANCE = new CInteropRequiredParametersNotSpecifiedError();

        private CInteropRequiredParametersNotSpecifiedError() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$CircularDependsOnEdges;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSetsOnCycle", "", "", "kotlin-gradle-plugin_common"})
    public static final class CircularDependsOnEdges
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final CircularDependsOnEdges INSTANCE = new CircularDependsOnEdges();

        private CircularDependsOnEdges() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> sourceSetsOnCycle) {
            Intrinsics.checkNotNullParameter(sourceSetsOnCycle, (String)"sourceSetsOnCycle");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(sourceSetsOnCycle){
                final /* synthetic */ Collection<String> $sourceSetsOnCycle;
                {
                    this.$sourceSetsOnCycle = $sourceSetsOnCycle;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Circular dependsOn Relationship Detected in Kotlin Source Sets").description((Function0<String>)((Function0)new Function0<String>(this.$sourceSetsOnCycle){
                        final /* synthetic */ Collection<String> $sourceSetsOnCycle;
                        {
                            this.$sourceSetsOnCycle = $sourceSetsOnCycle;
                            super(0);
                        }

                        public final String invoke() {
                            return "Circular dependsOn hierarchy found in the Kotlin source sets: " + CollectionsKt.joinToString$default((Iterable)this.$sourceSetsOnCycle, (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null);
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$CommonMainOrTestWithDependsOnDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "suffix", "", "kotlin-gradle-plugin_common"})
    public static final class CommonMainOrTestWithDependsOnDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final CommonMainOrTestWithDependsOnDiagnostic INSTANCE = new CommonMainOrTestWithDependsOnDiagnostic();

        private CommonMainOrTestWithDependsOnDiagnostic() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            return ToolingDiagnosticFactory.buildDiagnostic$default((ToolingDiagnosticFactory)this, null, "Invalid `dependsOn` Configuration in Common Source Set", "common" + suffix + " can't declare dependsOn on other source sets", "Please remove the `dependsOn` configuration from the common" + suffix + " source set", null, null, null, null, null, 497, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$CrossCompilationWithCinterops;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "projectName", "", "target", "interops", "", "hostname", "kotlin-gradle-plugin_common"})
    public static final class CrossCompilationWithCinterops
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final CrossCompilationWithCinterops INSTANCE = new CrossCompilationWithCinterops();

        private CrossCompilationWithCinterops() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String projectName, @NotNull String target2, @NotNull List<String> interops, @NotNull String hostname) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Intrinsics.checkNotNullParameter(interops, (String)"interops");
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(projectName, target2, interops, hostname){
                final /* synthetic */ String $projectName;
                final /* synthetic */ String $target;
                final /* synthetic */ List<String> $interops;
                final /* synthetic */ String $hostname;
                {
                    this.$projectName = $projectName;
                    this.$target = $target;
                    this.$interops = $interops;
                    this.$hostname = $hostname;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Cross Compilation with Cinterop Not Supported in Project '" + this.$projectName + '\'').description((Function0<String>)((Function0)new Function0<String>(this.$projectName, this.$target, this.$interops, this.$hostname){
                        final /* synthetic */ String $projectName;
                        final /* synthetic */ String $target;
                        final /* synthetic */ List<String> $interops;
                        final /* synthetic */ String $hostname;
                        {
                            this.$projectName = $projectName;
                            this.$target = $target;
                            this.$interops = $interops;
                            this.$hostname = $hostname;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    In project '" + this.$projectName + "', cross compilation to target '" + this.$target + "' has been disabled because it contains cinterops: '" + CollectionsKt.joinToString$default((Iterable)this.$interops, (CharSequence)"', '", null, null, (int)0, null, null, (int)62, null) + "' which cannot be processed on host '" + this.$hostname + "'.\n                    Cinterop libraries require platform-specific native toolchains that aren't available on the current host system.\n                    "));
                        }
                    })).solutions((Function0<? extends List<String>>)((Function0)new Function0<List<? extends String>>(this.$interops, this.$target){
                        final /* synthetic */ List<String> $interops;
                        final /* synthetic */ String $target;
                        {
                            this.$interops = $interops;
                            this.$target = $target;
                            super(0);
                        }

                        public final List<String> invoke() {
                            Object[] objectArray = new String[]{"Remove the cinterop dependencies '" + CollectionsKt.joinToString$default((Iterable)this.$interops, (CharSequence)"', '", null, null, (int)0, null, null, (int)62, null) + "' from target '" + this.$target + '\'', "Build on a compatible host platform for this target/cinterop combination", "To disable klib cross compilation entirely, add '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_NATIVE_ENABLE_KLIBS_CROSSCOMPILATION() + "=false' to your Gradle properties"};
                            return CollectionsKt.listOf((Object[])objectArray);
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DependencyDoesNotPhysicallyExist;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "dependency", "Ljava/io/File;", "kotlin-gradle-plugin_common"})
    public static final class DependencyDoesNotPhysicallyExist
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DependencyDoesNotPhysicallyExist INSTANCE = new DependencyDoesNotPhysicallyExist();

        private DependencyDoesNotPhysicallyExist() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull File dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(dependency){
                final /* synthetic */ File $dependency;
                {
                    this.$dependency = $dependency;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Specified Dependency Does Not Exist").description((Function0<String>)((Function0)new Function0<String>(this.$dependency){
                        final /* synthetic */ File $dependency;
                        {
                            this.$dependency = $dependency;
                            super(0);
                        }

                        public final String invoke() {
                            return "Unable to find the dependency at the location '" + this.$dependency.getAbsolutePath() + "'.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedErrorGradleProperties;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedGradleProperties;", "()V", "kotlin-gradle-plugin_common"})
    public static final class DeprecatedErrorGradleProperties
    extends DeprecatedGradleProperties {
        @NotNull
        public static final DeprecatedErrorGradleProperties INSTANCE = new DeprecatedErrorGradleProperties();

        private DeprecatedErrorGradleProperties() {
            super(ToolingDiagnostic.Severity.ERROR);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0086\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedGradleProperties;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "severity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "(Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;)V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "usedDeprecatedProperty", "", "details", "kotlin-gradle-plugin_common"})
    public static class DeprecatedGradleProperties
    extends ToolingDiagnosticFactory {
        public DeprecatedGradleProperties(@NotNull ToolingDiagnostic.Severity severity) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            super(severity, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String usedDeprecatedProperty, @Nullable String details) {
            Intrinsics.checkNotNullParameter((Object)usedDeprecatedProperty, (String)"usedDeprecatedProperty");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(usedDeprecatedProperty, details){
                final /* synthetic */ String $usedDeprecatedProperty;
                final /* synthetic */ String $details;
                {
                    this.$usedDeprecatedProperty = $usedDeprecatedProperty;
                    this.$details = $details;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Deprecated Gradle Property '" + this.$usedDeprecatedProperty + "' Used").description("The `" + this.$usedDeprecatedProperty + "` deprecated property is used in your build.").solutions((Function0<? extends List<String>>)((Function0)new Function0<List<? extends String>>(this.$details){
                        final /* synthetic */ String $details;
                        {
                            this.$details = $details;
                            super(0);
                        }

                        public final List<String> invoke() {
                            Object[] objectArray = new String[]{"It is unsupported, please stop using it.", this.$details};
                            return CollectionsKt.listOfNotNull((Object[])objectArray);
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedJvmWithJavaPresetDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class DeprecatedJvmWithJavaPresetDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DeprecatedJvmWithJavaPresetDiagnostic INSTANCE = new DeprecatedJvmWithJavaPresetDiagnostic();

        private DeprecatedJvmWithJavaPresetDiagnostic() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedKotlinNativeTargetsDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "usedTargetIds", "", "", "kotlin-gradle-plugin_common"})
    public static final class DeprecatedKotlinNativeTargetsDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DeprecatedKotlinNativeTargetsDiagnostic INSTANCE = new DeprecatedKotlinNativeTargetsDiagnostic();

        private DeprecatedKotlinNativeTargetsDiagnostic() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<String> usedTargetIds) {
            Intrinsics.checkNotNullParameter(usedTargetIds, (String)"usedTargetIds");
            return ToolingDiagnosticFactory.buildDiagnostic$default((ToolingDiagnosticFactory)this, null, "Deprecated Kotlin/Native Targets", "The following removed Kotlin/Native targets were used in the project: " + CollectionsKt.joinToString$default((Iterable)usedTargetIds, null, null, null, (int)0, null, null, (int)63, null), "Please update the project to use the new Kotlin/Native targets.", null, null, null, null, null, 497, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0086\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedKotlinVersionKotlinDsl;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "versionMetadata", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedKotlinVersionKotlinDsl$VersionMetadata;", "nonDeprecatedVersion", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinVersion;", "VersionMetadata", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinToolingDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedKotlinVersionKotlinDsl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1978:1\n1#2:1979\n*E\n"})
    public static final class DeprecatedKotlinVersionKotlinDsl
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DeprecatedKotlinVersionKotlinDsl INSTANCE = new DeprecatedKotlinVersionKotlinDsl();

        private DeprecatedKotlinVersionKotlinDsl() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<VersionMetadata> versionMetadata, @NotNull KotlinVersion nonDeprecatedVersion) {
            Comparable comparable;
            Intrinsics.checkNotNullParameter(versionMetadata, (String)"versionMetadata");
            Intrinsics.checkNotNullParameter((Object)nonDeprecatedVersion, (String)"nonDeprecatedVersion");
            Iterator iterator2 = ((Iterable)versionMetadata).iterator();
            if (!iterator2.hasNext()) {
                comparable = null;
            } else {
                VersionMetadata it = (VersionMetadata)iterator2.next();
                boolean bl = false;
                Comparable comparable2 = (Comparable)((Object)it.getLanguageVersionUnsupportedLevel());
                while (iterator2.hasNext()) {
                    VersionMetadata it2 = (VersionMetadata)iterator2.next();
                    $i$a$-maxOfOrNull-KotlinToolingDiagnostics$DeprecatedKotlinVersionKotlinDsl$invoke$level$1 = false;
                    Comparable comparable3 = (Comparable)((Object)it2.getLanguageVersionUnsupportedLevel());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            ToolingDiagnostic.Severity level = (ToolingDiagnostic.Severity)((Object)comparable);
            return ToolingDiagnosticFactory.build$default(this, null, level, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(nonDeprecatedVersion, versionMetadata){
                final /* synthetic */ KotlinVersion $nonDeprecatedVersion;
                final /* synthetic */ List<VersionMetadata> $versionMetadata;
                {
                    this.$nonDeprecatedVersion = $nonDeprecatedVersion;
                    this.$versionMetadata = $versionMetadata;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    String[] stringArray = new String[]{"Do not use `kotlin(jvm)` explicitly in this module and allow `kotlin-dsl` to auto-provide a compatible version on its own. If you prefer staying explicit, consider using the `embeddedKotlinVersion` constant.", "Do not use `kotlin-dsl` in this module.", "Configure your module to use " + this.$nonDeprecatedVersion.getVersion() + " or higher overriding `kotlin-dsl` behavior (unrecommended)."};
                    return ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$build.title("Unsupported Kotlin plugin version").description((Function0<String>)((Function0)new Function0<String>(this.$versionMetadata, this.$nonDeprecatedVersion){
                        final /* synthetic */ List<VersionMetadata> $versionMetadata;
                        final /* synthetic */ KotlinVersion $nonDeprecatedVersion;
                        {
                            this.$versionMetadata = $versionMetadata;
                            this.$nonDeprecatedVersion = $nonDeprecatedVersion;
                            super(0);
                        }

                        public final String invoke() {
                            boolean isPlural = this.$versionMetadata.size() > 1;
                            String entries2 = CollectionsKt.joinToString$default((Iterable)this.$versionMetadata, (CharSequence)"\n", null, null, (int)0, null, (Function1)invoke.entries.1.INSTANCE, (int)30, null);
                            boolean shouldUseAfterEvaluate = GradleVersion.current().compareTo(GradleVersion.version((String)"8.2")) < 0;
                            String accessorsSnippet2 = CollectionsKt.joinToString$default((Iterable)this.$versionMetadata, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<VersionMetadata, CharSequence>(shouldUseAfterEvaluate, this.$nonDeprecatedVersion){
                                final /* synthetic */ boolean $shouldUseAfterEvaluate;
                                final /* synthetic */ KotlinVersion $nonDeprecatedVersion;
                                {
                                    this.$shouldUseAfterEvaluate = $shouldUseAfterEvaluate;
                                    this.$nonDeprecatedVersion = $nonDeprecatedVersion;
                                    super(1);
                                }

                                public final CharSequence invoke(VersionMetadata meta) {
                                    Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
                                    int nestedLevel = this.$shouldUseAfterEvaluate ? 12 : 8;
                                    return '|' + StringsKt.repeat((CharSequence)" ", (int)nestedLevel) + meta.getAccessor() + ".set(org.jetbrains.kotlin.gradle.dsl.KotlinVersion." + this.$nonDeprecatedVersion + ')';
                                }
                            }), (int)30, null);
                            String configureSnippet = shouldUseAfterEvaluate ? StringsKt.trimMargin$default((String)("\n                            |afterEvaluate { // this code can be unwrapped from afterEvaluate after upgrading to Gradle 8.2 or newer\n                            |    tasks.withType<org.jetbrains.kotlin.gradle.tasks.KotlinCompile> {\n                            |        compilerOptions {\n                                         " + accessorsSnippet2 + "\n                            |        }\n                            |    }\n                            |}\n                            "), null, (int)1, null) : StringsKt.trimMargin$default((String)("\n                            |tasks.withType<org.jetbrains.kotlin.gradle.tasks.KotlinCompile> {\n                            |    compilerOptions {\n                                    " + accessorsSnippet2 + "\n                            |    }\n                            |}\n                            "), null, (int)1, null);
                            return StringsKt.trimMargin$default((String)("\n                            |The Kotlin Gradle plugin detected incompatible Kotlin " + (isPlural ? "versions" : "version") + " in the `kotlin-dsl` plugin. This may lead to a compilation failure.\n                            |\n                            |Detected unsupported Kotlin " + (isPlural ? "versions" : "version") + " in `kotlin-dsl`:\n                            " + entries2 + "\n                            |\n                            |The `kotlin-dsl` plugin relies on the Gradle-embedded Kotlin version. Using `kotlin-dsl` plugin together with a different Kotlin version (for example by using Kotlin Gradle plugin (`kotlin(jvm)`)) in the same module is not recommended.\n                            |\n                            |If you are writing a convention plugin (or a precompiled script plugin in general) it\u2019s recommended to only use the `kotlin-dsl` plugin and use the embedded Kotlin version. If you are writing a binary plugin it\u2019s recommended to not use the `kotlin-dsl` plugin and use the Kotlin Gradle plugin (`kotlin(jvm)`).\n                            |To upgrade the embedded Kotlin Language version a Gradle update is required. Please find the required Gradle version in the following table:\n                            |https://docs.gradle.org/current/userguide/compatibility.html#kotlin\n                            |\n                            |You can configure your module to use " + this.$nonDeprecatedVersion.getVersion() + " or higher overriding `kotlin-dsl` behavior using a following snippet:\n                            |" + configureSnippet + "\n                            |Note that this may lead to some hard to predict behavior and in general should be avoided, see documentation for more information.\n                            "), null, (int)1, null);
                        }
                    })).solutions(stringArray), new URI("https://kotl.in/gradle/kotlin-dsl-version-compatibility"), null, 2, null);
                }
            }, 13, null);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedKotlinVersionKotlinDsl$VersionMetadata;", "", "version", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinVersion;", "type", "", "accessor", "languageVersionUnsupportedLevel", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "(Lorg/jetbrains/kotlin/gradle/dsl/KotlinVersion;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;)V", "getAccessor", "()Ljava/lang/String;", "getLanguageVersionUnsupportedLevel", "()Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "getType", "getVersion", "()Lorg/jetbrains/kotlin/gradle/dsl/KotlinVersion;", "kotlin-gradle-plugin_common"})
        public static final class VersionMetadata {
            @NotNull
            private final KotlinVersion version;
            @NotNull
            private final String type;
            @NotNull
            private final String accessor;
            @NotNull
            private final ToolingDiagnostic.Severity languageVersionUnsupportedLevel;

            public VersionMetadata(@NotNull KotlinVersion version2, @NotNull String type, @NotNull String accessor, @NotNull ToolingDiagnostic.Severity languageVersionUnsupportedLevel) {
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                Intrinsics.checkNotNullParameter((Object)((Object)languageVersionUnsupportedLevel), (String)"languageVersionUnsupportedLevel");
                this.version = version2;
                this.type = type;
                this.accessor = accessor;
                this.languageVersionUnsupportedLevel = languageVersionUnsupportedLevel;
            }

            @NotNull
            public final KotlinVersion getVersion() {
                return this.version;
            }

            @NotNull
            public final String getType() {
                return this.type;
            }

            @NotNull
            public final String getAccessor() {
                return this.accessor;
            }

            @NotNull
            public final ToolingDiagnostic.Severity getLanguageVersionUnsupportedLevel() {
                return this.languageVersionUnsupportedLevel;
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedPropertyWithReplacement;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "deprecatedPropertyName", "", "replacement", "kotlin-gradle-plugin_common"})
    public static final class DeprecatedPropertyWithReplacement
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DeprecatedPropertyWithReplacement INSTANCE = new DeprecatedPropertyWithReplacement();

        private DeprecatedPropertyWithReplacement() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String deprecatedPropertyName, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)deprecatedPropertyName, (String)"deprecatedPropertyName");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(deprecatedPropertyName, replacement){
                final /* synthetic */ String $deprecatedPropertyName;
                final /* synthetic */ String $replacement;
                {
                    this.$deprecatedPropertyName = $deprecatedPropertyName;
                    this.$replacement = $replacement;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Deprecated Project Property '" + this.$deprecatedPropertyName + '\'').description((Function0<String>)((Function0)new Function0<String>(this.$deprecatedPropertyName){
                        final /* synthetic */ String $deprecatedPropertyName;
                        {
                            this.$deprecatedPropertyName = $deprecatedPropertyName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Project property '" + this.$deprecatedPropertyName + "' is deprecated.";
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$replacement){
                        final /* synthetic */ String $replacement;
                        {
                            this.$replacement = $replacement;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please use '" + this.$replacement + "' instead.";
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedWarningGradleProperties;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DeprecatedGradleProperties;", "()V", "kotlin-gradle-plugin_common"})
    public static final class DeprecatedWarningGradleProperties
    extends DeprecatedGradleProperties {
        @NotNull
        public static final DeprecatedWarningGradleProperties INSTANCE = new DeprecatedWarningGradleProperties();

        private DeprecatedWarningGradleProperties() {
            super(ToolingDiagnostic.Severity.WARNING);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DisabledCinteropsCommonizationInHmppProject;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "affectedSourceSetsString", "", "affectedCinteropsString", "kotlin-gradle-plugin_common"})
    public static final class DisabledCinteropsCommonizationInHmppProject
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DisabledCinteropsCommonizationInHmppProject INSTANCE = new DisabledCinteropsCommonizationInHmppProject();

        private DisabledCinteropsCommonizationInHmppProject() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Experimental.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String affectedSourceSetsString, @NotNull String affectedCinteropsString) {
            Intrinsics.checkNotNullParameter((Object)affectedSourceSetsString, (String)"affectedSourceSetsString");
            Intrinsics.checkNotNullParameter((Object)affectedCinteropsString, (String)"affectedCinteropsString");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(affectedSourceSetsString, affectedCinteropsString){
                final /* synthetic */ String $affectedSourceSetsString;
                final /* synthetic */ String $affectedCinteropsString;
                {
                    this.$affectedSourceSetsString = $affectedSourceSetsString;
                    this.$affectedCinteropsString = $affectedCinteropsString;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("CInterop Commonization Disabled").description((Function0<String>)((Function0)new Function0<String>(this.$affectedSourceSetsString, this.$affectedCinteropsString){
                        final /* synthetic */ String $affectedSourceSetsString;
                        final /* synthetic */ String $affectedCinteropsString;
                        {
                            this.$affectedSourceSetsString = $affectedSourceSetsString;
                            this.$affectedCinteropsString = $affectedCinteropsString;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    The project is using Kotlin Multiplatform with hierarchical structure and disabled 'cinterop commonization'\n                    \n                    'cinterop commonization' can be enabled in your 'gradle.properties'\n                    kotlin.mpp.enableCInteropCommonization=true\n                    \n                    To hide this message, add to your 'gradle.properties'\n                    " + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_ENABLE_CINTEROP_COMMONIZATION() + ".nowarn=true \n                \n                    The following source sets are affected: \n                    " + this.$affectedSourceSetsString + "\n                    \n                    The following cinterops are affected: \n                    " + this.$affectedCinteropsString + "\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotlinlang.org/docs/mpp-share-on-platforms.html#use-native-libraries-in-the-hierarchical-structure"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DisabledKotlinNativeTargets;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "disabledTargetNames", "", "", "kotlin-gradle-plugin_common"})
    public static final class DisabledKotlinNativeTargets
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DisabledKotlinNativeTargets INSTANCE = new DisabledKotlinNativeTargets();

        private DisabledKotlinNativeTargets() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> disabledTargetNames) {
            Intrinsics.checkNotNullParameter(disabledTargetNames, (String)"disabledTargetNames");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(disabledTargetNames){
                final /* synthetic */ Collection<String> $disabledTargetNames;
                {
                    this.$disabledTargetNames = $disabledTargetNames;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Disabled Kotlin/Native Targets").description((Function0<String>)((Function0)new Function0<String>(this.$disabledTargetNames){
                        final /* synthetic */ Collection<String> $disabledTargetNames;
                        {
                            this.$disabledTargetNames = $disabledTargetNames;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    The following Kotlin/Native targets cannot be built on this machine and are disabled:\n                    " + CollectionsKt.joinToString$default((Iterable)this.$disabledTargetNames, null, null, null, (int)0, null, null, (int)63, null) + "\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DuplicateSourceSetsError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "duplicatedSourceSets", "", "", "", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinToolingDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DuplicateSourceSetsError\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1978:1\n125#2:1979\n152#2,3:1980\n*S KotlinDebug\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$DuplicateSourceSetsError\n*L\n1183#1:1979\n1183#1:1980,3\n*E\n"})
    public static final class DuplicateSourceSetsError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final DuplicateSourceSetsError INSTANCE = new DuplicateSourceSetsError();

        private DuplicateSourceSetsError() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Map<String, ? extends List<String>> duplicatedSourceSets) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(duplicatedSourceSets, (String)"duplicatedSourceSets");
            Map<String, ? extends List<String>> $this$map$iv = duplicatedSourceSets;
            boolean $i$f$map = false;
            Map<String, ? extends List<String>> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void entry2;
                Map.Entry item$iv$iv;
                Map.Entry entry3 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CollectionsKt.joinToString$default((Iterable)((Iterable)entry2.getValue()), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            String duplicatesGroupsString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"], [", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(duplicatesGroupsString){
                final /* synthetic */ String $duplicatesGroupsString;
                {
                    this.$duplicatesGroupsString = $duplicatesGroupsString;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Duplicate Kotlin Source Sets Detected").description((Function0<String>)((Function0)new Function0<String>(this.$duplicatesGroupsString){
                        final /* synthetic */ String $duplicatesGroupsString;
                        {
                            this.$duplicatesGroupsString = $duplicatesGroupsString;
                            super(0);
                        }

                        public final String invoke() {
                            return "Duplicate Kotlin source sets have been detected: " + this.$duplicatesGroupsString + ". Keep in mind that source set names are case-insensitive, which means that `srcMain` and `sRcMain` are considered the same source set.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ExperimentalArtifactsDslUsed;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class ExperimentalArtifactsDslUsed
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ExperimentalArtifactsDslUsed INSTANCE = new ExperimentalArtifactsDslUsed();

        private ExperimentalArtifactsDslUsed() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Experimental.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ExperimentalFeatureWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "featureName", "", "youtrackUrl", "extraSolution", "kotlin-gradle-plugin_common"})
    public static final class ExperimentalFeatureWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ExperimentalFeatureWarning INSTANCE = new ExperimentalFeatureWarning();

        private ExperimentalFeatureWarning() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Experimental.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String featureName, @NotNull String youtrackUrl, @Nullable String extraSolution) {
            Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
            Intrinsics.checkNotNullParameter((Object)youtrackUrl, (String)"youtrackUrl");
            return ToolingDiagnosticFactory.build$default(this, KotlinToolingDiagnosticsKt.toIdSuffix(featureName), null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(youtrackUrl, featureName, extraSolution){
                final /* synthetic */ String $youtrackUrl;
                final /* synthetic */ String $featureName;
                final /* synthetic */ String $extraSolution;
                {
                    this.$youtrackUrl = $youtrackUrl;
                    this.$featureName = $featureName;
                    this.$extraSolution = $extraSolution;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Experimental Feature Notice").description((Function0<String>)((Function0)new Function0<String>(this.$featureName){
                        final /* synthetic */ String $featureName;
                        {
                            this.$featureName = $featureName;
                            super(0);
                        }

                        public final String invoke() {
                            return this.$featureName + " is an experimental feature and subject to change in any future releases.";
                        }
                    })).solutions((Function0<? extends List<String>>)((Function0)new Function0<List<? extends String>>(this.$extraSolution){
                        final /* synthetic */ String $extraSolution;
                        {
                            this.$extraSolution = $extraSolution;
                            super(0);
                        }

                        public final List<String> invoke() {
                            Object[] objectArray = new String[]{"It may not function as you expect and you may encounter bugs. Use it at your own risk.", this.$extraSolution};
                            return CollectionsKt.listOfNotNull((Object[])objectArray);
                        }
                    })).documentationLink(new URI(this.$youtrackUrl), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 14, null);
        }

        public static /* synthetic */ ToolingDiagnostic invoke$default(ExperimentalFeatureWarning experimentalFeatureWarning, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            return experimentalFeatureWarning.invoke(string, string2, string3);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ExperimentalTryNextWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class ExperimentalTryNextWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ExperimentalTryNextWarning INSTANCE = new ExperimentalTryNextWarning();

        private ExperimentalTryNextWarning() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Experimental.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$FailedToGetAgpVersionWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "agpPluginId", "", "kotlin-gradle-plugin_common"})
    public static final class FailedToGetAgpVersionWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final FailedToGetAgpVersionWarning INSTANCE = new FailedToGetAgpVersionWarning();

        private FailedToGetAgpVersionWarning() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String agpPluginId) {
            Intrinsics.checkNotNullParameter((Object)agpPluginId, (String)"agpPluginId");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(agpPluginId){
                final /* synthetic */ String $agpPluginId;
                {
                    this.$agpPluginId = $agpPluginId;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Failed to Retrieve Android Gradle Plugin Version").description((Function0<String>)((Function0)new Function0<String>(this.$agpPluginId){
                        final /* synthetic */ String $agpPluginId;
                        {
                            this.$agpPluginId = $agpPluginId;
                            super(0);
                        }

                        public final String invoke() {
                            return "Failed to get Android Gradle Plugin version (for '" + this.$agpPluginId + "' plugin).";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/issue"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IcFirMisconfigurationLV;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "taskPath", "", "languageVersion", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinVersion;", "kotlin-gradle-plugin_common"})
    public static final class IcFirMisconfigurationLV
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IcFirMisconfigurationLV INSTANCE = new IcFirMisconfigurationLV();

        private IcFirMisconfigurationLV() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String taskPath, @NotNull KotlinVersion languageVersion2) {
            Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
            Intrinsics.checkNotNullParameter((Object)languageVersion2, (String)"languageVersion");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(taskPath, languageVersion2){
                final /* synthetic */ String $taskPath;
                final /* synthetic */ KotlinVersion $languageVersion;
                {
                    this.$taskPath = $taskPath;
                    this.$languageVersion = $languageVersion;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("FIR based incremental compilation Kotlin version 1.x compatibility").description((Function0<String>)((Function0)new Function0<String>(this.$taskPath, this.$languageVersion){
                        final /* synthetic */ String $taskPath;
                        final /* synthetic */ KotlinVersion $languageVersion;
                        {
                            this.$taskPath = $taskPath;
                            this.$languageVersion = $languageVersion;
                            super(0);
                        }

                        public final String invoke() {
                            return "FIR based incremental compilation is enabled for '" + this.$taskPath + "' alongside with '" + this.$languageVersion.getVersion() + "' Kotlin language version.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncompatibleAgpVersionTooLowFatalError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "androidGradlePluginVersionString", "", "minSupported", "kotlin-gradle-plugin_common"})
    public static final class IncompatibleAgpVersionTooLowFatalError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IncompatibleAgpVersionTooLowFatalError INSTANCE = new IncompatibleAgpVersionTooLowFatalError();

        private IncompatibleAgpVersionTooLowFatalError() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String androidGradlePluginVersionString, @NotNull String minSupported) {
            Intrinsics.checkNotNullParameter((Object)androidGradlePluginVersionString, (String)"androidGradlePluginVersionString");
            Intrinsics.checkNotNullParameter((Object)minSupported, (String)"minSupported");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(androidGradlePluginVersionString, minSupported){
                final /* synthetic */ String $androidGradlePluginVersionString;
                final /* synthetic */ String $minSupported;
                {
                    this.$androidGradlePluginVersionString = $androidGradlePluginVersionString;
                    this.$minSupported = $minSupported;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Android Gradle Plugin Version Incompatible with Kotlin Gradle Plugin").description((Function0<String>)((Function0)new Function0<String>(this.$androidGradlePluginVersionString, this.$minSupported){
                        final /* synthetic */ String $androidGradlePluginVersionString;
                        final /* synthetic */ String $minSupported;
                        {
                            this.$androidGradlePluginVersionString = $androidGradlePluginVersionString;
                            this.$minSupported = $minSupported;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Kotlin Gradle Plugin <-> Android Gradle Plugin compatibility issue:\n                    The applied Android Gradle Plugin version (" + this.$androidGradlePluginVersionString + ") is lower than the minimum supported " + this.$minSupported + ".\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$minSupported){
                        final /* synthetic */ String $minSupported;
                        {
                            this.$minSupported = $minSupported;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please update the Android Gradle Plugin version to at least " + this.$minSupported + '.';
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0086\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncompatibleBinaryConfiguration;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "binaryName", "", "debuggable", "", "optimized", "kotlin-gradle-plugin_common"})
    public static final class IncompatibleBinaryConfiguration
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IncompatibleBinaryConfiguration INSTANCE = new IncompatibleBinaryConfiguration();

        private IncompatibleBinaryConfiguration() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String binaryName2, boolean debuggable2, boolean optimized2) {
            Intrinsics.checkNotNullParameter((Object)binaryName2, (String)"binaryName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(debuggable2, optimized2, binaryName2){
                final /* synthetic */ boolean $debuggable;
                final /* synthetic */ boolean $optimized;
                final /* synthetic */ String $binaryName;
                {
                    this.$debuggable = $debuggable;
                    this.$optimized = $optimized;
                    this.$binaryName = $binaryName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Incompatible Binary Configuration").description((Function0<String>)((Function0)new Function0<String>(this.$debuggable, this.$optimized, this.$binaryName){
                        final /* synthetic */ boolean $debuggable;
                        final /* synthetic */ boolean $optimized;
                        final /* synthetic */ String $binaryName;
                        {
                            this.$debuggable = $debuggable;
                            this.$optimized = $optimized;
                            this.$binaryName = $binaryName;
                            super(0);
                        }

                        public final String invoke() {
                            return this.$debuggable && this.$optimized ? StringsKt.trimIndent((String)("\n                            Binary '" + this.$binaryName + "' has incompatible configuration: debuggable=true and optimized=true.\n                            Debug binaries should not be optimized as this defeats the purpose of fast compilation and debugging.\n                            Optimization significantly increases compile time while making debugging more difficult.\n                            ")) : StringsKt.trimIndent((String)("\n                            Binary '" + this.$binaryName + "' has incompatible configuration: debuggable=false and optimized=false.\n                            Release binaries should be optimized to ensure good runtime performance.\n                            Without optimization, you get slow compilation (no debug build optimizations) and poor runtime performance.\n                            "));
                        }
                    })).solutions((Function0<? extends List<String>>)((Function0)new Function0<List<? extends String>>(this.$debuggable, this.$optimized, this.$binaryName){
                        final /* synthetic */ boolean $debuggable;
                        final /* synthetic */ boolean $optimized;
                        final /* synthetic */ String $binaryName;
                        {
                            this.$debuggable = $debuggable;
                            this.$optimized = $optimized;
                            this.$binaryName = $binaryName;
                            super(0);
                        }

                        public final List<String> invoke() {
                            List list;
                            if (this.$debuggable && this.$optimized) {
                                Object[] objectArray = new String[]{"Set 'optimized = false' for binary '" + this.$binaryName + "' to enable fast debug compilation", "Use a release build type if you need optimization", "Consider creating separate debug and release configurations"};
                                list = CollectionsKt.listOf((Object[])objectArray);
                            } else {
                                Object[] objectArray = new String[]{"Set 'optimized = true' for binary '" + this.$binaryName + "' to improve runtime performance", "Use a debug build type if you need fast compilation and debugging capabilities", "Verify that your build type configuration matches your intended use case"};
                                list = CollectionsKt.listOf((Object[])objectArray);
                            }
                            return list;
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncompatibleGradleVersionTooLowFatalError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "currentGradleVersion", "Lorg/gradle/util/GradleVersion;", "minimallySupportedGradleVersion", "kotlin-gradle-plugin_common"})
    public static final class IncompatibleGradleVersionTooLowFatalError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IncompatibleGradleVersionTooLowFatalError INSTANCE = new IncompatibleGradleVersionTooLowFatalError();

        private IncompatibleGradleVersionTooLowFatalError() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull GradleVersion currentGradleVersion, @NotNull GradleVersion minimallySupportedGradleVersion) {
            Intrinsics.checkNotNullParameter((Object)currentGradleVersion, (String)"currentGradleVersion");
            Intrinsics.checkNotNullParameter((Object)minimallySupportedGradleVersion, (String)"minimallySupportedGradleVersion");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(currentGradleVersion, minimallySupportedGradleVersion){
                final /* synthetic */ GradleVersion $currentGradleVersion;
                final /* synthetic */ GradleVersion $minimallySupportedGradleVersion;
                {
                    this.$currentGradleVersion = $currentGradleVersion;
                    this.$minimallySupportedGradleVersion = $minimallySupportedGradleVersion;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Gradle Version Incompatible with Kotlin Gradle Plugin").description((Function0<String>)((Function0)new Function0<String>(this.$currentGradleVersion){
                        final /* synthetic */ GradleVersion $currentGradleVersion;
                        {
                            this.$currentGradleVersion = $currentGradleVersion;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Kotlin Gradle Plugin <-> Gradle compatibility issue:\n                    The applied Kotlin Gradle is not compatible with the used Gradle version (" + this.$currentGradleVersion + ").\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$minimallySupportedGradleVersion){
                        final /* synthetic */ GradleVersion $minimallySupportedGradleVersion;
                        {
                            this.$minimallySupportedGradleVersion = $minimallySupportedGradleVersion;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please update the Gradle version to at least " + this.$minimallySupportedGradleVersion + '.';
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncompatibleWithTheNewAgpDsl;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "trace", "", "kotlin-gradle-plugin_common"})
    public static final class IncompatibleWithTheNewAgpDsl
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IncompatibleWithTheNewAgpDsl INSTANCE = new IncompatibleWithTheNewAgpDsl();

        private IncompatibleWithTheNewAgpDsl() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Throwable trace) {
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, trace, invoke.1.INSTANCE, 7, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$InconsistentTargetCompatibilityForKotlinAndJavaTasks;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "javaTaskName", "", "targetCompatibility", "kotlinTaskName", "jvmTarget", "severity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "kotlin-gradle-plugin_common"})
    public static final class InconsistentTargetCompatibilityForKotlinAndJavaTasks
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final InconsistentTargetCompatibilityForKotlinAndJavaTasks INSTANCE = new InconsistentTargetCompatibilityForKotlinAndJavaTasks();

        private InconsistentTargetCompatibilityForKotlinAndJavaTasks() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String javaTaskName, @NotNull String targetCompatibility, @NotNull String kotlinTaskName, @NotNull String jvmTarget, @NotNull ToolingDiagnostic.Severity severity) {
            Intrinsics.checkNotNullParameter((Object)javaTaskName, (String)"javaTaskName");
            Intrinsics.checkNotNullParameter((Object)targetCompatibility, (String)"targetCompatibility");
            Intrinsics.checkNotNullParameter((Object)kotlinTaskName, (String)"kotlinTaskName");
            Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return ToolingDiagnosticFactory.build$default(this, null, severity, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(javaTaskName, targetCompatibility, kotlinTaskName, jvmTarget, severity){
                final /* synthetic */ String $javaTaskName;
                final /* synthetic */ String $targetCompatibility;
                final /* synthetic */ String $kotlinTaskName;
                final /* synthetic */ String $jvmTarget;
                final /* synthetic */ ToolingDiagnostic.Severity $severity;
                {
                    this.$javaTaskName = $javaTaskName;
                    this.$targetCompatibility = $targetCompatibility;
                    this.$kotlinTaskName = $kotlinTaskName;
                    this.$jvmTarget = $jvmTarget;
                    this.$severity = $severity;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Inconsistent JVM Target Compatibility Between Java and Kotlin Tasks").description((Function0<String>)((Function0)new Function0<String>(this.$javaTaskName, this.$targetCompatibility, this.$kotlinTaskName, this.$jvmTarget, this.$severity){
                        final /* synthetic */ String $javaTaskName;
                        final /* synthetic */ String $targetCompatibility;
                        final /* synthetic */ String $kotlinTaskName;
                        final /* synthetic */ String $jvmTarget;
                        final /* synthetic */ ToolingDiagnostic.Severity $severity;
                        {
                            this.$javaTaskName = $javaTaskName;
                            this.$targetCompatibility = $targetCompatibility;
                            this.$kotlinTaskName = $kotlinTaskName;
                            this.$jvmTarget = $jvmTarget;
                            this.$severity = $severity;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Inconsistent JVM-target compatibility detected for tasks '" + this.$javaTaskName + "' (" + this.$targetCompatibility + ") and '" + this.$kotlinTaskName + "' (" + this.$jvmTarget + ").\n                    " + (this.$severity == ToolingDiagnostic.Severity.WARNING ? "This will become an error in Gradle 8.0." : "") + "\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/gradle/jvm/target-validation"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 13, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "compilationsWithCompileOnlyDependencies", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning$CompilationDependenciesPair;", "CompilationDependenciesPair", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinToolingDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1978:1\n1549#2:1979\n1620#2,3:1980\n296#3,16:1983\n125#4:1999\n152#4,3:2000\n*S KotlinDebug\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning\n*L\n1226#1:1979\n1226#1:1980,3\n1232#1:1983,16\n1237#1:1999\n1237#1:2000,3\n*E\n"})
    public static final class IncorrectCompileOnlyDependencyWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IncorrectCompileOnlyDependencyWarning INSTANCE = new IncorrectCompileOnlyDependencyWarning();

        private IncorrectCompileOnlyDependencyWarning() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<CompilationDependenciesPair> compilationsWithCompileOnlyDependencies) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map $this$flatGroupBy$iv;
            CompilationDependenciesPair it;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(compilationsWithCompileOnlyDependencies, (String)"compilationsWithCompileOnlyDependencies");
            Iterable $this$map$iv2 = compilationsWithCompileOnlyDependencies;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                CompilationDependenciesPair compilationDependenciesPair = (CompilationDependenciesPair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinPlatformTypeUtilsKt.getPrettyName(it.getCompilation().getPlatformType()));
            }
            String formattedPlatformNames = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv))), null, null, null, (int)0, null, null, (int)63, null);
            List<CompilationDependenciesPair> $i$f$map22 = compilationsWithCompileOnlyDependencies;
            boolean $i$f$flatGroupBy = false;
            Map result$iv = new LinkedHashMap();
            Iterator $i$f$mapTo22 = $this$flatGroupBy$iv.iterator();
            while ($i$f$mapTo22.hasNext()) {
                Object element$iv = $i$f$mapTo22.next();
                CompilationDependenciesPair it2 = (CompilationDependenciesPair)element$iv;
                boolean bl = false;
                Collection keys$iv = it2.getDependencyCoords();
                it = (CompilationDependenciesPair)element$iv;
                boolean bl2 = false;
                String value$iv = it.getCompilation().getDefaultSourceSet().getName();
                for (Object key$iv : keys$iv) {
                    String it3 = (String)key$iv;
                    boolean bl3 = false;
                    String transformedKey$iv = it3;
                    List list$iv = (List)result$iv.get(transformedKey$iv);
                    if (list$iv == null) {
                        list$iv = new ArrayList();
                        result$iv.put(transformedKey$iv, list$iv);
                    }
                    ((Collection)list$iv).add(value$iv);
                }
            }
            $this$flatGroupBy$iv = result$iv;
            boolean $i$f$map = false;
            result$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator2.next();
                collection = destination$iv$iv2;
                boolean bl = false;
                String dependency = (String)entry2.getKey();
                List sourceSetNames = (List)entry2.getValue();
                collection.add(dependency + " (source sets: " + CollectionsKt.joinToString$default((Iterable)sourceSetNames, null, null, null, (int)0, null, null, (int)63, null) + ')');
            }
            String formattedCompileOnlyDeps2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2))), (CharSequence)"\n", null, null, (int)0, null, (Function1)invoke.formattedCompileOnlyDeps.5.INSTANCE, (int)30, null);
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(formattedPlatformNames, formattedCompileOnlyDeps2){
                final /* synthetic */ String $formattedPlatformNames;
                final /* synthetic */ String $formattedCompileOnlyDeps;
                {
                    this.$formattedPlatformNames = $formattedPlatformNames;
                    this.$formattedCompileOnlyDeps = $formattedCompileOnlyDeps;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Unsupported `compileOnly` Dependencies in Kotlin Targets").description((Function0<String>)((Function0)new Function0<String>(this.$formattedPlatformNames, this.$formattedCompileOnlyDeps){
                        final /* synthetic */ String $formattedPlatformNames;
                        final /* synthetic */ String $formattedCompileOnlyDeps;
                        {
                            this.$formattedPlatformNames = $formattedPlatformNames;
                            this.$formattedCompileOnlyDeps = $formattedCompileOnlyDeps;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimMargin$default((String)("\n                        |A compileOnly dependency is used in targets: " + this.$formattedPlatformNames + ".\n                        |Dependencies:\n                        |" + this.$formattedCompileOnlyDeps + "\n                        |\n                        |Using compileOnly dependencies in these targets is not currently supported, because compileOnly dependencies must be present during the compilation of projects that depend on this project.\n                        |\n                        |To ensure consistent compilation behaviour, compileOnly dependencies should be exposed as api dependencies.\n                        |\n                        |Example:\n                        |\n                        |    kotlin {\n                        |        sourceSets {\n                        |            nativeMain {\n                        |                dependencies {\n                        |                    compileOnly(\"org.example:lib:1.2.3\")\n                        |                    // additionally add the compileOnly dependency as an api dependency:\n                        |                    api(\"org.example:lib:1.2.3\")\n                        |                }\n                        |            }\n                        |        }\n                        |    }\n                        |\n                        |This warning can be suppressed in gradle.properties:\n                        |\n                        |    kotlin.suppressGradlePluginWarnings=" + IncorrectCompileOnlyDependencyWarning.INSTANCE.getId() + "\n                        |\n                        "), null, (int)1, null);
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IncorrectCompileOnlyDependencyWarning$CompilationDependenciesPair;", "", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "dependencyCoords", "", "", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;Ljava/util/List;)V", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "getDependencyCoords", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
        public static final class CompilationDependenciesPair {
            @NotNull
            private final KotlinCompilation<?> compilation;
            @NotNull
            private final List<String> dependencyCoords;

            public CompilationDependenciesPair(@NotNull KotlinCompilation<?> compilation2, @NotNull List<String> dependencyCoords) {
                Intrinsics.checkNotNullParameter(compilation2, (String)"compilation");
                Intrinsics.checkNotNullParameter(dependencyCoords, (String)"dependencyCoords");
                this.compilation = compilation2;
                this.dependencyCoords = dependencyCoords;
            }

            @NotNull
            public final KotlinCompilation<?> getCompilation() {
                return this.compilation;
            }

            @NotNull
            public final List<String> getDependencyCoords() {
                return this.dependencyCoords;
            }

            @NotNull
            public final KotlinCompilation<?> component1() {
                return this.compilation;
            }

            @NotNull
            public final List<String> component2() {
                return this.dependencyCoords;
            }

            @NotNull
            public final CompilationDependenciesPair copy(@NotNull KotlinCompilation<?> compilation2, @NotNull List<String> dependencyCoords) {
                Intrinsics.checkNotNullParameter(compilation2, (String)"compilation");
                Intrinsics.checkNotNullParameter(dependencyCoords, (String)"dependencyCoords");
                return new CompilationDependenciesPair(compilation2, dependencyCoords);
            }

            public static /* synthetic */ CompilationDependenciesPair copy$default(CompilationDependenciesPair compilationDependenciesPair, KotlinCompilation kotlinCompilation, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    kotlinCompilation = compilationDependenciesPair.compilation;
                }
                if ((n & 2) != 0) {
                    list = compilationDependenciesPair.dependencyCoords;
                }
                return compilationDependenciesPair.copy(kotlinCompilation, list);
            }

            @NotNull
            public String toString() {
                return "CompilationDependenciesPair(compilation=" + this.compilation + ", dependencyCoords=" + this.dependencyCoords + ')';
            }

            public int hashCode() {
                int result2 = this.compilation.hashCode();
                result2 = result2 * 31 + ((Object)this.dependencyCoords).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CompilationDependenciesPair)) {
                    return false;
                }
                CompilationDependenciesPair compilationDependenciesPair = (CompilationDependenciesPair)other;
                if (!Intrinsics.areEqual(this.compilation, compilationDependenciesPair.compilation)) {
                    return false;
                }
                return Intrinsics.areEqual(this.dependencyCoords, compilationDependenciesPair.dependencyCoords);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$InternalKotlinGradlePluginPropertiesUsed;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "propertiesUsed", "", "", "kotlin-gradle-plugin_common"})
    public static final class InternalKotlinGradlePluginPropertiesUsed
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final InternalKotlinGradlePluginPropertiesUsed INSTANCE = new InternalKotlinGradlePluginPropertiesUsed();

        private InternalKotlinGradlePluginPropertiesUsed() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> propertiesUsed) {
            Intrinsics.checkNotNullParameter(propertiesUsed, (String)"propertiesUsed");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(propertiesUsed){
                final /* synthetic */ Collection<String> $propertiesUsed;
                {
                    this.$propertiesUsed = $propertiesUsed;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Usage of Internal Kotlin Gradle Plugin Properties Detected").description((Function0<String>)((Function0)new Function0<String>(this.$propertiesUsed){
                        final /* synthetic */ Collection<String> $propertiesUsed;
                        {
                            this.$propertiesUsed = $propertiesUsed;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimMargin$default((String)("\n                    |ATTENTION! This build uses the following Kotlin Gradle Plugin properties:\n                    |\n                    |" + CollectionsKt.joinToString$default((Iterable)this.$propertiesUsed, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n                    |\n                    |Internal properties are not recommended for production use.\n                    |Stability and future compatibility of the build is not guaranteed.\n                    "), null, (int)1, null);
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$IosSourceSetConventionUsedWithoutIosTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
    public static final class IosSourceSetConventionUsedWithoutIosTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final IosSourceSetConventionUsedWithoutIosTarget INSTANCE = new IosSourceSetConventionUsedWithoutIosTarget();

        private IosSourceSetConventionUsedWithoutIosTarget() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinSourceSet sourceSet) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, KotlinSourceSetConvention.INSTANCE.isAccessedByKotlinSourceSetConventionAt$kotlin_gradle_plugin_common(sourceSet), (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(sourceSet){
                final /* synthetic */ KotlinSourceSet $sourceSet;
                {
                    this.$sourceSet = $sourceSet;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("iOS Source Set Used Without an iOS Target").description((Function0<String>)((Function0)new Function0<String>(this.$sourceSet){
                        final /* synthetic */ KotlinSourceSet $sourceSet;
                        {
                            this.$sourceSet = $sourceSet;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Accessed '" + this.$sourceSet + "' without registering any ios target:\n                    kotlin {\n                        /* Register at least one of the following targets */\n                        iosX64()\n                        iosArm64()\n                        iosSimulatorArm64()\n                    \n                        /* Use convention */\n                        sourceSets." + this.$sourceSet.getName() + ".dependencies {\n                    \n                        }\n                    }\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 7, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$JsEnvironmentNotChosenExplicitly;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$JsLikeEnvironmentNotChosenExplicitly;", "()V", "kotlin-gradle-plugin_common"})
    public static final class JsEnvironmentNotChosenExplicitly
    extends JsLikeEnvironmentNotChosenExplicitly {
        @NotNull
        public static final JsEnvironmentNotChosenExplicitly INSTANCE = new JsEnvironmentNotChosenExplicitly();

        private JsEnvironmentNotChosenExplicitly() {
            super("JavaScript", "js");
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$JsLikeEnvironmentNotChosenExplicitly;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "environmentName", "", "targetType", "(Ljava/lang/String;Ljava/lang/String;)V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "availableEnvironments", "", "kotlin-gradle-plugin_common"})
    public static abstract class JsLikeEnvironmentNotChosenExplicitly
    extends ToolingDiagnosticFactory {
        @NotNull
        private final String environmentName;
        @NotNull
        private final String targetType;

        public JsLikeEnvironmentNotChosenExplicitly(@NotNull String environmentName, @NotNull String targetType) {
            Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
            this.environmentName = environmentName;
            this.targetType = targetType;
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<String> availableEnvironments) {
            Intrinsics.checkNotNullParameter(availableEnvironments, (String)"availableEnvironments");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(this, availableEnvironments){
                final /* synthetic */ JsLikeEnvironmentNotChosenExplicitly this$0;
                final /* synthetic */ List<String> $availableEnvironments;
                {
                    this.this$0 = $receiver;
                    this.$availableEnvironments = $availableEnvironments;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("JS Environment Not Selected").description((Function0<String>)((Function0)new Function0<String>(this.this$0, this.$availableEnvironments){
                        final /* synthetic */ JsLikeEnvironmentNotChosenExplicitly this$0;
                        final /* synthetic */ List<String> $availableEnvironments;
                        {
                            this.this$0 = $receiver;
                            this.$availableEnvironments = $availableEnvironments;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimMargin$default((String)("\n                    |Please choose a " + JsLikeEnvironmentNotChosenExplicitly.access$getEnvironmentName$p(this.this$0) + " environment to build distributions and run tests.\n                    |Not choosing any of them will be an error in the future releases.\n                    |kotlin {\n                    |    " + JsLikeEnvironmentNotChosenExplicitly.access$getTargetType$p(this.this$0) + " {\n                    |        // To build distributions for and run tests use one or several of:\n                    |        " + CollectionsKt.joinToString$default((Iterable)this.$availableEnvironments, (CharSequence)"\n        ", null, null, (int)0, null, null, (int)62, null) + "\n                    |    }\n                    |}\n                    "), null, (int)1, null);
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.this$0){
                        final /* synthetic */ JsLikeEnvironmentNotChosenExplicitly this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please choose a " + JsLikeEnvironmentNotChosenExplicitly.access$getEnvironmentName$p(this.this$0) + " environment to build distributions and run tests.";
                        }
                    }));
                }
            }, 15, null);
        }

        public static final /* synthetic */ String access$getEnvironmentName$p(JsLikeEnvironmentNotChosenExplicitly $this) {
            return $this.environmentName;
        }

        public static final /* synthetic */ String access$getTargetType$p(JsLikeEnvironmentNotChosenExplicitly $this) {
            return $this.targetType;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$JvmWithJavaIsIncompatibleWithAndroid;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "androidPluginId", "", "trace", "", "kotlin-gradle-plugin_common"})
    public static final class JvmWithJavaIsIncompatibleWithAndroid
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final JvmWithJavaIsIncompatibleWithAndroid INSTANCE = new JvmWithJavaIsIncompatibleWithAndroid();

        private JvmWithJavaIsIncompatibleWithAndroid() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String androidPluginId, @Nullable Throwable trace) {
            Intrinsics.checkNotNullParameter((Object)androidPluginId, (String)"androidPluginId");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, trace, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(androidPluginId){
                final /* synthetic */ String $androidPluginId;
                {
                    this.$androidPluginId = $androidPluginId;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("`withJava()` in JVM Target Incompatible with Android Plugins").description((Function0<String>)((Function0)new Function0<String>(this.$androidPluginId){
                        final /* synthetic */ String $androidPluginId;
                        {
                            this.$androidPluginId = $androidPluginId;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    'withJava()' is not compatible with Android Plugins\n                    Incompatible Android Plugin applied: '" + this.$androidPluginId + "'\n                    \n                    kotlin {\n                        jvm {\n                            withJava() /* <- cannot be used when the Android Plugin is present */\n                        }\n                    }\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 7, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0011\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0086\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KMPJavaPluginsIncompatibilityDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "buildDiagnosticForApplicationPlugin", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "severity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "buildDiagnosticForJavaPlugin", "pluginId", "", "pluginString", "diagnosticDescription", "diagnosticTitle", "invoke", "kotlin-gradle-plugin_common"})
    public static final class KMPJavaPluginsIncompatibilityDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KMPJavaPluginsIncompatibilityDiagnostic INSTANCE = new KMPJavaPluginsIncompatibilityDiagnostic();

        private KMPJavaPluginsIncompatibilityDiagnostic() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            ToolingDiagnostic.Severity severity = GradleVersion.current().compareTo(GradleVersion.version((String)"8.7")) >= 0 ? ToolingDiagnostic.Severity.ERROR : ToolingDiagnostic.Severity.WARNING;
            String string = pluginId;
            return Intrinsics.areEqual((Object)string, (Object)"application") ? this.buildDiagnosticForApplicationPlugin(severity) : (Intrinsics.areEqual((Object)string, (Object)"java-library") ? this.buildDiagnosticForJavaPlugin(severity, pluginId, '\'' + pluginId + "' (also applies 'java' plugin)") : this.buildDiagnosticForJavaPlugin(severity, pluginId, '\'' + pluginId + '\''));
        }

        private final ToolingDiagnostic buildDiagnosticForJavaPlugin(ToolingDiagnostic.Severity severity, String pluginId, String pluginString) {
            return ToolingDiagnosticFactory.build$default(this, null, severity, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(pluginId, pluginString){
                final /* synthetic */ String $pluginId;
                final /* synthetic */ String $pluginString;
                {
                    this.$pluginId = $pluginId;
                    this.$pluginString = $pluginString;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title(KMPJavaPluginsIncompatibilityDiagnostic.access$diagnosticTitle(KMPJavaPluginsIncompatibilityDiagnostic.INSTANCE, this.$pluginId)).description(KMPJavaPluginsIncompatibilityDiagnostic.access$diagnosticDescription(KMPJavaPluginsIncompatibilityDiagnostic.INSTANCE, this.$pluginString)).solution((Function0<String>)((Function0)new Function0<String>(this.$pluginId){
                        final /* synthetic */ String $pluginId;
                        {
                            this.$pluginId = $pluginId;
                            super(0);
                        }

                        public final String invoke() {
                            return "Consider adding a new subproject with '" + this.$pluginId + "' plugin where the KMP project is added as a dependency.";
                        }
                    }));
                }
            }, 13, null);
        }

        private final ToolingDiagnostic buildDiagnosticForApplicationPlugin(ToolingDiagnostic.Severity severity) {
            return ToolingDiagnosticFactory.build$default(this, null, severity, null, null, buildDiagnosticForApplicationPlugin.1.INSTANCE, 13, null);
        }

        private final String diagnosticTitle(String pluginId) {
            return '\'' + pluginId + "' Plugin Incompatible with 'org.jetbrains.kotlin.multiplatform' Plugin";
        }

        private final String diagnosticDescription(String pluginString) {
            return pluginString + " Gradle plugin is not compatible with 'org.jetbrains.kotlin.multiplatform' plugin.";
        }

        public static final /* synthetic */ String access$diagnosticTitle(KMPJavaPluginsIncompatibilityDiagnostic $this, String pluginId) {
            return $this.diagnosticTitle(pluginId);
        }

        public static final /* synthetic */ String access$diagnosticDescription(KMPJavaPluginsIncompatibilityDiagnostic $this, String pluginString) {
            return $this.diagnosticDescription(pluginString);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KMPWithJavaDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class KMPWithJavaDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KMPWithJavaDiagnostic INSTANCE = new KMPWithJavaDiagnostic();

        private KMPWithJavaDiagnostic() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            ToolingDiagnostic.Severity severity = GradleVersion.current().compareTo(GradleVersion.version((String)"9.0")) >= 0 ? ToolingDiagnostic.Severity.ERROR : ToolingDiagnostic.Severity.WARNING;
            return ToolingDiagnosticFactory.build$default(this, null, severity, null, null, invoke.1.INSTANCE, 13, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KonanHomeConflictDeclaration;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "konanDataDirPropertyValue", "Ljava/io/File;", "kotlinNativeHomeProperty", "", "kotlin-gradle-plugin_common"})
    public static final class KonanHomeConflictDeclaration
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KonanHomeConflictDeclaration INSTANCE = new KonanHomeConflictDeclaration();

        private KonanHomeConflictDeclaration() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable File konanDataDirPropertyValue, @Nullable String kotlinNativeHomeProperty) {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(konanDataDirPropertyValue, kotlinNativeHomeProperty){
                final /* synthetic */ File $konanDataDirPropertyValue;
                final /* synthetic */ String $kotlinNativeHomeProperty;
                {
                    this.$konanDataDirPropertyValue = $konanDataDirPropertyValue;
                    this.$kotlinNativeHomeProperty = $kotlinNativeHomeProperty;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Both " + NativeProperties.Companion.getKONAN_DATA_DIR$kotlin_gradle_plugin_common().getName() + " and " + NativeProperties.Companion.getNATIVE_HOME$kotlin_gradle_plugin_common().getName() + " Properties Declared").description((Function0<String>)((Function0)new Function0<String>(this.$konanDataDirPropertyValue, this.$kotlinNativeHomeProperty){
                        final /* synthetic */ File $konanDataDirPropertyValue;
                        final /* synthetic */ String $kotlinNativeHomeProperty;
                        {
                            this.$konanDataDirPropertyValue = $konanDataDirPropertyValue;
                            this.$kotlinNativeHomeProperty = $kotlinNativeHomeProperty;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                        Both " + NativeProperties.Companion.getKONAN_DATA_DIR$kotlin_gradle_plugin_common().getName() + '=' + this.$konanDataDirPropertyValue + " and " + NativeProperties.Companion.getNATIVE_HOME$kotlin_gradle_plugin_common().getName() + '=' + this.$kotlinNativeHomeProperty + " are declared.\n                        The " + NativeProperties.Companion.getKONAN_DATA_DIR$kotlin_gradle_plugin_common().getName() + '=' + this.$konanDataDirPropertyValue + " path will be given the highest priority.\n                        "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinCompilationSourceDeprecation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "trace", "", "kotlin-gradle-plugin_common"})
    public static final class KotlinCompilationSourceDeprecation
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinCompilationSourceDeprecation INSTANCE = new KotlinCompilationSourceDeprecation();

        private KotlinCompilationSourceDeprecation() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable Throwable trace) {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, trace, invoke.1.INSTANCE, 7, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinCompilerEmbeddableIsPresentInClasspath;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class KotlinCompilerEmbeddableIsPresentInClasspath
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinCompilerEmbeddableIsPresentInClasspath INSTANCE = new KotlinCompilerEmbeddableIsPresentInClasspath();

        private KotlinCompilerEmbeddableIsPresentInClasspath() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0086\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinDefaultHierarchyFallbackDependsOnUsageDetected;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "project", "Lorg/gradle/api/Project;", "sourceSetsWithDependsOnEdges", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
    public static final class KotlinDefaultHierarchyFallbackDependsOnUsageDetected
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinDefaultHierarchyFallbackDependsOnUsageDetected INSTANCE = new KotlinDefaultHierarchyFallbackDependsOnUsageDetected();

        private KotlinDefaultHierarchyFallbackDependsOnUsageDetected() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Project project, @NotNull Iterable<? extends KotlinSourceSet> sourceSetsWithDependsOnEdges) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(sourceSetsWithDependsOnEdges, (String)"sourceSetsWithDependsOnEdges");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(project, sourceSetsWithDependsOnEdges){
                final /* synthetic */ Project $project;
                final /* synthetic */ Iterable<KotlinSourceSet> $sourceSetsWithDependsOnEdges;
                {
                    this.$project = $project;
                    this.$sourceSetsWithDependsOnEdges = $sourceSetsWithDependsOnEdges;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Default Kotlin Hierarchy Template Not Applied Correctly").description((Function0<String>)((Function0)new Function0<String>(this.$project, this.$sourceSetsWithDependsOnEdges){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ Iterable<KotlinSourceSet> $sourceSetsWithDependsOnEdges;
                        {
                            this.$project = $project;
                            this.$sourceSetsWithDependsOnEdges = $sourceSetsWithDependsOnEdges;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final String invoke() {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Iterable iterable = CollectionsKt.toSet(this.$sourceSetsWithDependsOnEdges);
                            StringBuilder stringBuilder = new StringBuilder().append("\n                    The Default Kotlin Hierarchy Template was not applied to '").append(this.$project.getDisplayName()).append("':\n                    Explicit .dependsOn() edges were configured for the following source sets:\n                    ");
                            boolean $i$f$map = false;
                            void var3_4 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getName());
                            }
                            return StringsKt.trimIndent((String)stringBuilder.append((List)destination$iv$iv).append("\n                    \n                    Consider removing dependsOn-calls or disabling the default template by adding\n                        '").append(PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_APPLY_DEFAULT_HIERARCHY_TEMPLATE()).append("=false'\n                    to your gradle.properties\n                    ").toString());
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/hierarchy-template"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0086\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinDefaultHierarchyFallbackIllegalTargetNames;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "project", "Lorg/gradle/api/Project;", "illegalTargetNamesUsed", "", "", "kotlin-gradle-plugin_common"})
    public static final class KotlinDefaultHierarchyFallbackIllegalTargetNames
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinDefaultHierarchyFallbackIllegalTargetNames INSTANCE = new KotlinDefaultHierarchyFallbackIllegalTargetNames();

        private KotlinDefaultHierarchyFallbackIllegalTargetNames() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Project project, @NotNull Iterable<String> illegalTargetNamesUsed2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(illegalTargetNamesUsed2, (String)"illegalTargetNamesUsed");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(project, illegalTargetNamesUsed2){
                final /* synthetic */ Project $project;
                final /* synthetic */ Iterable<String> $illegalTargetNamesUsed;
                {
                    this.$project = $project;
                    this.$illegalTargetNamesUsed = $illegalTargetNamesUsed;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Default Kotlin Hierarchy Template Misconfiguration Due to Illegal Target Names").description((Function0<String>)((Function0)new Function0<String>(this.$project, this.$illegalTargetNamesUsed){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ Iterable<String> $illegalTargetNamesUsed;
                        {
                            this.$project = $project;
                            this.$illegalTargetNamesUsed = $illegalTargetNamesUsed;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    The Default Kotlin Hierarchy Template was not applied to '" + this.$project.getDisplayName() + "':\n                    Source sets created by the following targets will clash with source sets created by the template:\n                    " + CollectionsKt.toSet(this.$illegalTargetNamesUsed) + "\n                    \n                    Consider renaming the targets or disabling the default template by adding\n                        '" + PropertiesProvider.PropertyNames.INSTANCE.getKOTLIN_MPP_APPLY_DEFAULT_HIERARCHY_TEMPLATE() + "=false'\n                    to your gradle.properties\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/hierarchy-template"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinJvmMainRunTaskConflict;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "taskName", "kotlin-gradle-plugin_common"})
    public static final class KotlinJvmMainRunTaskConflict
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinJvmMainRunTaskConflict INSTANCE = new KotlinJvmMainRunTaskConflict();

        private KotlinJvmMainRunTaskConflict() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName, @NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(targetName, taskName){
                final /* synthetic */ String $targetName;
                final /* synthetic */ String $taskName;
                {
                    this.$targetName = $targetName;
                    this.$taskName = $taskName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("JVM Main Run Task Conflict").description((Function0<String>)((Function0)new Function0<String>(this.$targetName, this.$taskName){
                        final /* synthetic */ String $targetName;
                        final /* synthetic */ String $taskName;
                        {
                            this.$targetName = $targetName;
                            this.$taskName = $taskName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Target '" + this.$targetName + "': Unable to create run task '" + this.$taskName + "' as there is already such a task registered";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinNativeArtifactsDeprecation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class KotlinNativeArtifactsDeprecation
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinNativeArtifactsDeprecation INSTANCE = new KotlinNativeArtifactsDeprecation();

        private KotlinNativeArtifactsDeprecation() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinScriptingMisconfiguration;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "taskPath", "", "discoveryResultsConfigurationName", "kotlin-gradle-plugin_common"})
    public static final class KotlinScriptingMisconfiguration
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinScriptingMisconfiguration INSTANCE = new KotlinScriptingMisconfiguration();

        private KotlinScriptingMisconfiguration() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String taskPath, @NotNull String discoveryResultsConfigurationName) {
            Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
            Intrinsics.checkNotNullParameter((Object)discoveryResultsConfigurationName, (String)"discoveryResultsConfigurationName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(taskPath, discoveryResultsConfigurationName){
                final /* synthetic */ String $taskPath;
                final /* synthetic */ String $discoveryResultsConfigurationName;
                {
                    this.$taskPath = $taskPath;
                    this.$discoveryResultsConfigurationName = $discoveryResultsConfigurationName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Kotlin scripting misconfiguration").description((Function0<String>)((Function0)new Function0<String>(this.$taskPath, this.$discoveryResultsConfigurationName){
                        final /* synthetic */ String $taskPath;
                        final /* synthetic */ String $discoveryResultsConfigurationName;
                        {
                            this.$taskPath = $taskPath;
                            this.$discoveryResultsConfigurationName = $discoveryResultsConfigurationName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Scripting configuration for task '" + this.$taskPath + "' is not found: " + this.$discoveryResultsConfigurationName;
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinSourceSetDependsOnDefaultCompilationSourceSet;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "dependeeName", "", "dependencyName", "kotlin-gradle-plugin_common"})
    public static final class KotlinSourceSetDependsOnDefaultCompilationSourceSet
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinSourceSetDependsOnDefaultCompilationSourceSet INSTANCE = new KotlinSourceSetDependsOnDefaultCompilationSourceSet();

        private KotlinSourceSetDependsOnDefaultCompilationSourceSet() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String dependeeName, @NotNull String dependencyName) {
            Intrinsics.checkNotNullParameter((Object)dependeeName, (String)"dependeeName");
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(dependeeName, dependencyName){
                final /* synthetic */ String $dependeeName;
                final /* synthetic */ String $dependencyName;
                {
                    this.$dependeeName = $dependeeName;
                    this.$dependencyName = $dependencyName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Invalid Dependency on Default Compilation Source Set").description((Function0<String>)((Function0)new Function0<String>(this.$dependeeName, this.$dependencyName){
                        final /* synthetic */ String $dependeeName;
                        final /* synthetic */ String $dependencyName;
                        {
                            this.$dependeeName = $dependeeName;
                            this.$dependencyName = $dependencyName;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Kotlin Source Set '" + this.$dependeeName + "' can't depend on '" + this.$dependencyName + "' which is a default source set for compilation.\n                    None of source sets can depend on the compilation default source sets.\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0086\u0002J+\u0010\u0005\u001a\u00020\u00062\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\n2\u0006\u0010\b\u001a\u00020\u0004H\u0086\u0002J\"\u0010\f\u001a\u00020\u00042\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinSourceSetTreeDependsOnMismatch;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "diagnosticName", "", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "dependeeName", "dependencyName", "dependents", "", "", "renderSourceSetGroups", "sourceSetGroups", "kotlin-gradle-plugin_common"})
    public static final class KotlinSourceSetTreeDependsOnMismatch
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinSourceSetTreeDependsOnMismatch INSTANCE = new KotlinSourceSetTreeDependsOnMismatch();

        private KotlinSourceSetTreeDependsOnMismatch() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        private final String diagnosticName() {
            return "Invalid Source Set Dependency Across Trees";
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String dependeeName, @NotNull String dependencyName) {
            Intrinsics.checkNotNullParameter((Object)dependeeName, (String)"dependeeName");
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(dependeeName, dependencyName){
                final /* synthetic */ String $dependeeName;
                final /* synthetic */ String $dependencyName;
                {
                    this.$dependeeName = $dependeeName;
                    this.$dependencyName = $dependencyName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title((Function0<String>)((Function0)new Function0<String>((Object)KotlinSourceSetTreeDependsOnMismatch.INSTANCE){

                        public final String invoke() {
                            return KotlinSourceSetTreeDependsOnMismatch.access$diagnosticName((KotlinSourceSetTreeDependsOnMismatch)this.receiver);
                        }
                    })).description((Function0<String>)((Function0)new Function0<String>(this.$dependeeName, this.$dependencyName){
                        final /* synthetic */ String $dependeeName;
                        final /* synthetic */ String $dependencyName;
                        {
                            this.$dependeeName = $dependeeName;
                            this.$dependencyName = $dependencyName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Kotlin Source Set '" + this.$dependeeName + "' can't depend on '" + this.$dependencyName + "' as they are from different Source Set Trees.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.3.INSTANCE));
                }
            }, 15, null);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Map<String, ? extends List<String>> dependents, @NotNull String dependencyName) {
            Intrinsics.checkNotNullParameter(dependents, (String)"dependents");
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(dependencyName, dependents){
                final /* synthetic */ String $dependencyName;
                final /* synthetic */ Map<String, List<String>> $dependents;
                {
                    this.$dependencyName = $dependencyName;
                    this.$dependents = $dependents;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title((Function0<String>)((Function0)new Function0<String>((Object)KotlinSourceSetTreeDependsOnMismatch.INSTANCE){

                        public final String invoke() {
                            return KotlinSourceSetTreeDependsOnMismatch.access$diagnosticName((KotlinSourceSetTreeDependsOnMismatch)this.receiver);
                        }
                    })).description((Function0<String>)((Function0)new Function0<String>(this.$dependencyName, this.$dependents){
                        final /* synthetic */ String $dependencyName;
                        final /* synthetic */ Map<String, List<String>> $dependents;
                        {
                            this.$dependencyName = $dependencyName;
                            this.$dependents = $dependents;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Following Kotlin Source Set groups can't depend on '" + this.$dependencyName + "' together as they belong to different Kotlin Source Set Trees.\n                    " + KotlinToolingDiagnosticsKt.indentLines$default(KotlinSourceSetTreeDependsOnMismatch.access$renderSourceSetGroups(KotlinSourceSetTreeDependsOnMismatch.INSTANCE, this.$dependents), 16, false, 2, null) + "\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)KotlinSourceSetTreeDependsOnMismatch.invoke.3.INSTANCE));
                }
            }, 15, null);
        }

        private final String renderSourceSetGroups(Map<String, ? extends List<String>> sourceSetGroups) {
            StringBuilder stringBuilder;
            StringBuilder $this$renderSourceSetGroups_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            for (Map.Entry<String, ? extends List<String>> entry2 : sourceSetGroups.entrySet()) {
                String sourceSetTreeName = entry2.getKey();
                List<String> sourceSets = entry2.getValue();
                StringUtilsKt.appendLine($this$renderSourceSetGroups_u24lambda_u240, "Source Sets from '" + sourceSetTreeName + "' Tree:");
                StringUtilsKt.appendLine($this$renderSourceSetGroups_u24lambda_u240, CollectionsKt.joinToString$default((Iterable)sourceSets, (CharSequence)"\n", null, null, (int)0, null, (Function1)renderSourceSetGroups.1.1.INSTANCE, (int)30, null));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        public static final /* synthetic */ String access$diagnosticName(KotlinSourceSetTreeDependsOnMismatch $this) {
            return $this.diagnosticName();
        }

        public static final /* synthetic */ String access$renderSourceSetGroups(KotlinSourceSetTreeDependsOnMismatch $this, Map sourceSetGroups) {
            return $this.renderSourceSetGroups(sourceSetGroups);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinTargetAlreadyDeclared;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "severity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "(Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;)V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetDslFunctionName", "", "kotlin-gradle-plugin_common"})
    public static abstract class KotlinTargetAlreadyDeclared
    extends ToolingDiagnosticFactory {
        public KotlinTargetAlreadyDeclared(@NotNull ToolingDiagnostic.Severity severity) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            super(severity, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetDslFunctionName) {
            Intrinsics.checkNotNullParameter((Object)targetDslFunctionName, (String)"targetDslFunctionName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(targetDslFunctionName){
                final /* synthetic */ String $targetDslFunctionName;
                {
                    this.$targetDslFunctionName = $targetDslFunctionName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$build.title('`' + this.$targetDslFunctionName + "()` Kotlin Target Already Declared").description((Function0<String>)((Function0)invoke.1.INSTANCE)).solution((Function0<String>)((Function0)invoke.2.INSTANCE)), new URI("https://kotl.in/declaring-multiple-targets"), null, 2, null);
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinTargetAlreadyDeclaredError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinTargetAlreadyDeclared;", "()V", "kotlin-gradle-plugin_common"})
    public static final class KotlinTargetAlreadyDeclaredError
    extends KotlinTargetAlreadyDeclared {
        @NotNull
        public static final KotlinTargetAlreadyDeclaredError INSTANCE = new KotlinTargetAlreadyDeclaredError();

        private KotlinTargetAlreadyDeclaredError() {
            super(ToolingDiagnostic.Severity.ERROR);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinTargetAlreadyDeclaredWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinTargetAlreadyDeclared;", "()V", "kotlin-gradle-plugin_common"})
    public static final class KotlinTargetAlreadyDeclaredWarning
    extends KotlinTargetAlreadyDeclared {
        @NotNull
        public static final KotlinTargetAlreadyDeclaredWarning INSTANCE = new KotlinTargetAlreadyDeclaredWarning();

        private KotlinTargetAlreadyDeclaredWarning() {
            super(ToolingDiagnostic.Severity.WARNING);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$KotlinTopLevelDependenciesUsedInIncompatibleGradleVersion;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "currentGradleVersion", "Lorg/gradle/util/GradleVersion;", "minimumSupportedGradleVersion", "kotlin-gradle-plugin_common"})
    public static final class KotlinTopLevelDependenciesUsedInIncompatibleGradleVersion
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final KotlinTopLevelDependenciesUsedInIncompatibleGradleVersion INSTANCE = new KotlinTopLevelDependenciesUsedInIncompatibleGradleVersion();

        private KotlinTopLevelDependenciesUsedInIncompatibleGradleVersion() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull GradleVersion currentGradleVersion, @NotNull GradleVersion minimumSupportedGradleVersion) {
            Intrinsics.checkNotNullParameter((Object)currentGradleVersion, (String)"currentGradleVersion");
            Intrinsics.checkNotNullParameter((Object)minimumSupportedGradleVersion, (String)"minimumSupportedGradleVersion");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(currentGradleVersion, minimumSupportedGradleVersion){
                final /* synthetic */ GradleVersion $currentGradleVersion;
                final /* synthetic */ GradleVersion $minimumSupportedGradleVersion;
                {
                    this.$currentGradleVersion = $currentGradleVersion;
                    this.$minimumSupportedGradleVersion = $minimumSupportedGradleVersion;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$build.title("Kotlin Top Level Dependencies Used With Incompatible Gradle Version").description("Kotlin top-level dependencies is not available in " + this.$currentGradleVersion + ". Minimum supported version is " + this.$minimumSupportedGradleVersion + '.').solution("Please upgrade your Gradle version or keep using source set dependencies block (https://kotl.in/source-set-dependencies)"), new URI("https://kotl.in/kmp-top-level-dependencies"), null, 2, null);
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$MissingResourcesConfigurationForTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class MissingResourcesConfigurationForTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final MissingResourcesConfigurationForTarget INSTANCE = new MissingResourcesConfigurationForTarget();

        private MissingResourcesConfigurationForTarget() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(targetName){
                final /* synthetic */ String $targetName;
                {
                    this.$targetName = $targetName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Missing Resource Configuration for Target '" + this.$targetName + '\'').description((Function0<String>)((Function0)new Function0<String>(this.$targetName){
                        final /* synthetic */ String $targetName;
                        {
                            this.$targetName = $targetName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Resources will not be resolved for " + this.$targetName + " as it is missing resourcesConfiguration.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(KotlinToolingDiagnostics.access$getBUG_REPORT_URL$p(), (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)KotlinToolingDiagnostics.INSTANCE){

                        public final String invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return KotlinToolingDiagnostics.access$resourcesBugReportRequest((KotlinToolingDiagnostics)this.receiver, p0);
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$MissingRuntimeDependencyConfigurationForWasmTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class MissingRuntimeDependencyConfigurationForWasmTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final MissingRuntimeDependencyConfigurationForWasmTarget INSTANCE = new MissingRuntimeDependencyConfigurationForWasmTarget();

        private MissingRuntimeDependencyConfigurationForWasmTarget() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(targetName){
                final /* synthetic */ String $targetName;
                {
                    this.$targetName = $targetName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Missing Runtime Dependency Configuration for Wasm Target '" + this.$targetName + '\'').description((Function0<String>)((Function0)new Function0<String>(this.$targetName){
                        final /* synthetic */ String $targetName;
                        {
                            this.$targetName = $targetName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Resources will not be resolved for " + this.$targetName + " as it is missing runtimeDependencyConfiguration.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(KotlinToolingDiagnostics.access$getBUG_REPORT_URL$p(), (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)KotlinToolingDiagnostics.INSTANCE){

                        public final String invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return KotlinToolingDiagnostics.access$resourcesBugReportRequest((KotlinToolingDiagnostics)this.receiver, p0);
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0086\u0002J%\u0010\u0005\u001a\u00020\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0086\u0002J#\u0010\u0005\u001a\u00020\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$MultipleSourceSetRootsInCompilation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "DIAGNOSTIC_NAME", "", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetNames", "", "unexpectedSourceSetRoot", "expectedRoot", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "sourceSetRoots", "kotlin-gradle-plugin_common"})
    public static final class MultipleSourceSetRootsInCompilation
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final MultipleSourceSetRootsInCompilation INSTANCE = new MultipleSourceSetRootsInCompilation();
        @NotNull
        private static final String DIAGNOSTIC_NAME = "Missing 'dependsOn' in Source Sets";

        private MultipleSourceSetRootsInCompilation() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinCompilation<?> kotlinCompilation, @NotNull String unexpectedSourceSetRoot, @NotNull String expectedRoot) {
            Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
            Intrinsics.checkNotNullParameter((Object)unexpectedSourceSetRoot, (String)"unexpectedSourceSetRoot");
            Intrinsics.checkNotNullParameter((Object)expectedRoot, (String)"expectedRoot");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(unexpectedSourceSetRoot, kotlinCompilation, expectedRoot){
                final /* synthetic */ String $unexpectedSourceSetRoot;
                final /* synthetic */ KotlinCompilation<?> $kotlinCompilation;
                final /* synthetic */ String $expectedRoot;
                {
                    this.$unexpectedSourceSetRoot = $unexpectedSourceSetRoot;
                    this.$kotlinCompilation = $kotlinCompilation;
                    this.$expectedRoot = $expectedRoot;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$build.title("Missing 'dependsOn' in Source Sets").description((Function0<String>)((Function0)new Function0<String>(this.$unexpectedSourceSetRoot, this.$kotlinCompilation, this.$expectedRoot){
                        final /* synthetic */ String $unexpectedSourceSetRoot;
                        final /* synthetic */ KotlinCompilation<?> $kotlinCompilation;
                        final /* synthetic */ String $expectedRoot;
                        {
                            this.$unexpectedSourceSetRoot = $unexpectedSourceSetRoot;
                            this.$kotlinCompilation = $kotlinCompilation;
                            this.$expectedRoot = $expectedRoot;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Kotlin Source Set '" + this.$unexpectedSourceSetRoot + "' is included to '" + this.$kotlinCompilation.getName() + "' compilation of '" + this.$kotlinCompilation.getTarget().getName() + "' target,\n                    but it doesn't depend on '" + this.$expectedRoot + "'.\n                    \n                    Please remove '" + this.$unexpectedSourceSetRoot + "' and include its sources to the compilation's default source set:\n                    \n                        kotlin.sourceSets[\"" + this.$kotlinCompilation.getDefaultSourceSet().getName() + "\"].kotlin.srcDir() // <-- pass sources directory of '" + this.$unexpectedSourceSetRoot + "'\n                    \n                    Or provide explicit dependency if the solution above is not applicable\n                    \n                        kotlin.sourceSets[\"" + this.$unexpectedSourceSetRoot + "\"].dependsOn(" + this.$expectedRoot + ")\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$unexpectedSourceSetRoot){
                        final /* synthetic */ String $unexpectedSourceSetRoot;
                        {
                            this.$unexpectedSourceSetRoot = $unexpectedSourceSetRoot;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please remove '" + this.$unexpectedSourceSetRoot + "' and include its sources to the compilation's default source set.";
                        }
                    })), new URI("https://kotl.in/connecting-source-sets"), null, 2, null);
                }
            }, 15, null);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> targetNames, @NotNull String unexpectedSourceSetRoot, @NotNull String expectedRoot) {
            Intrinsics.checkNotNullParameter(targetNames, (String)"targetNames");
            Intrinsics.checkNotNullParameter((Object)unexpectedSourceSetRoot, (String)"unexpectedSourceSetRoot");
            Intrinsics.checkNotNullParameter((Object)expectedRoot, (String)"expectedRoot");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(unexpectedSourceSetRoot, targetNames, expectedRoot){
                final /* synthetic */ String $unexpectedSourceSetRoot;
                final /* synthetic */ Collection<String> $targetNames;
                final /* synthetic */ String $expectedRoot;
                {
                    this.$unexpectedSourceSetRoot = $unexpectedSourceSetRoot;
                    this.$targetNames = $targetNames;
                    this.$expectedRoot = $expectedRoot;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$build.title("Missing 'dependsOn' in Source Sets").description((Function0<String>)((Function0)new Function0<String>(this.$unexpectedSourceSetRoot, this.$targetNames, this.$expectedRoot){
                        final /* synthetic */ String $unexpectedSourceSetRoot;
                        final /* synthetic */ Collection<String> $targetNames;
                        final /* synthetic */ String $expectedRoot;
                        {
                            this.$unexpectedSourceSetRoot = $unexpectedSourceSetRoot;
                            this.$targetNames = $targetNames;
                            this.$expectedRoot = $expectedRoot;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Kotlin Source Set '" + this.$unexpectedSourceSetRoot + "' is included in compilations of Kotlin Targets: " + CollectionsKt.joinToString$default((Iterable)this.$targetNames, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.1.INSTANCE, (int)30, null) + "\n                    but it doesn't depend on '" + this.$expectedRoot + "'\n                    \n                    Please remove '" + this.$unexpectedSourceSetRoot + "' and include its sources to one of the default source set: https://kotl.in/hierarchy-template\n                    For example:\n    \n                        kotlin.sourceSets.commonMain.kotlin.srcDir() // <-- pass here sources directory\n    \n                    Or add explicit dependency if the solution above is not applicable:\n    \n                        kotlin.sourceSets[\"" + this.$unexpectedSourceSetRoot + "\"].dependsOn(" + this.$expectedRoot + ")\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$unexpectedSourceSetRoot){
                        final /* synthetic */ String $unexpectedSourceSetRoot;
                        {
                            this.$unexpectedSourceSetRoot = $unexpectedSourceSetRoot;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please remove '" + this.$unexpectedSourceSetRoot + "' and include its sources to one of the default source set.";
                        }
                    })), new URI("https://kotl.in/connecting-source-sets"), null, 2, null);
                }
            }, 15, null);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinCompilation<?> kotlinCompilation, @NotNull Collection<String> sourceSetRoots) {
            Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
            Intrinsics.checkNotNullParameter(sourceSetRoots, (String)"sourceSetRoots");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(sourceSetRoots, kotlinCompilation){
                final /* synthetic */ Collection<String> $sourceSetRoots;
                final /* synthetic */ KotlinCompilation<?> $kotlinCompilation;
                {
                    this.$sourceSetRoots = $sourceSetRoots;
                    this.$kotlinCompilation = $kotlinCompilation;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Missing 'dependsOn' in Source Sets").description((Function0<String>)((Function0)new Function0<String>(this.$sourceSetRoots, this.$kotlinCompilation){
                        final /* synthetic */ Collection<String> $sourceSetRoots;
                        final /* synthetic */ KotlinCompilation<?> $kotlinCompilation;
                        {
                            this.$sourceSetRoots = $sourceSetRoots;
                            this.$kotlinCompilation = $kotlinCompilation;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Kotlin Source Sets: " + CollectionsKt.joinToString$default((Iterable)this.$sourceSetRoots, (CharSequence)", ", null, null, (int)0, null, (Function1)MultipleSourceSetRootsInCompilation.invoke.1.INSTANCE, (int)30, null) + "\n                    are included to '" + this.$kotlinCompilation.getName() + "' compilation of '" + this.$kotlinCompilation.getTarget().getName() + "' target.\n                    However, they have no common source set root between them.\n                    \n                    Please remove these kotlin source sets and include their source directories to the compilation's default source set.\n                    \n                        kotlin.sourceSets[\"" + this.$kotlinCompilation.getDefaultSourceSet().getName() + "\"].kotlin.srcDir() // <-- pass sources directories here\n                    \n                    Or, if the solution above is not applicable, specify `dependsOn` edges between these source sets so that there are no multiple roots.\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/connecting-source-sets"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$NativeStdlibIsMissingDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "changedKotlinNativeHomeProperty", "", "kotlin-gradle-plugin_common"})
    public static final class NativeStdlibIsMissingDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final NativeStdlibIsMissingDiagnostic INSTANCE = new NativeStdlibIsMissingDiagnostic();

        private NativeStdlibIsMissingDiagnostic() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable String changedKotlinNativeHomeProperty) {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(changedKotlinNativeHomeProperty){
                final /* synthetic */ String $changedKotlinNativeHomeProperty;
                {
                    this.$changedKotlinNativeHomeProperty = $changedKotlinNativeHomeProperty;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Missing Kotlin/Native Standard Library").description((Function0<String>)((Function0)invoke.1.INSTANCE)).solution((Function0<String>)((Function0)new Function0<String>(this.$changedKotlinNativeHomeProperty){
                        final /* synthetic */ String $changedKotlinNativeHomeProperty;
                        {
                            this.$changedKotlinNativeHomeProperty = $changedKotlinNativeHomeProperty;
                            super(0);
                        }

                        public final String invoke() {
                            String string = "Make sure that the '" + this.$changedKotlinNativeHomeProperty + "' property points to a valid Kotlin/Native distribution.";
                            String string2 = this.$changedKotlinNativeHomeProperty;
                            String it = string;
                            boolean bl = false;
                            String string3 = string2 != null ? string : null;
                            if (string3 == null) {
                                string3 = "";
                            }
                            return string3;
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$NewNativeVersionDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "nativeVersion", "Lorg/jetbrains/kotlin/tooling/core/KotlinToolingVersion;", "kotlinVersion", "kotlin-gradle-plugin_common"})
    public static final class NewNativeVersionDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final NewNativeVersionDiagnostic INSTANCE = new NewNativeVersionDiagnostic();

        private NewNativeVersionDiagnostic() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable KotlinToolingVersion nativeVersion2, @NotNull KotlinToolingVersion kotlinVersion) {
            Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(nativeVersion2, kotlinVersion){
                final /* synthetic */ KotlinToolingVersion $nativeVersion;
                final /* synthetic */ KotlinToolingVersion $kotlinVersion;
                {
                    this.$nativeVersion = $nativeVersion;
                    this.$kotlinVersion = $kotlinVersion;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Kotlin/Native and Kotlin Versions Incompatible").description((Function0<String>)((Function0)new Function0<String>(this.$nativeVersion, this.$kotlinVersion){
                        final /* synthetic */ KotlinToolingVersion $nativeVersion;
                        final /* synthetic */ KotlinToolingVersion $kotlinVersion;
                        {
                            this.$nativeVersion = $nativeVersion;
                            this.$kotlinVersion = $kotlinVersion;
                            super(0);
                        }

                        public final String invoke() {
                            return "" + '\'' + this.$nativeVersion + "' Kotlin/Native is being used with an older '" + this.$kotlinVersion + "' Kotlin.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$NoComposeCompilerPluginAppliedWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class NoComposeCompilerPluginAppliedWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final NoComposeCompilerPluginAppliedWarning INSTANCE = new NoComposeCompilerPluginAppliedWarning();

        private NoComposeCompilerPluginAppliedWarning() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$NoKotlinTargetsDeclared;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "projectName", "", "projectPath", "kotlin-gradle-plugin_common"})
    public static final class NoKotlinTargetsDeclared
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final NoKotlinTargetsDeclared INSTANCE = new NoKotlinTargetsDeclared();

        private NoKotlinTargetsDeclared() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String projectName, @NotNull String projectPath2) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            Intrinsics.checkNotNullParameter((Object)projectPath2, (String)"projectPath");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(projectName, projectPath2){
                final /* synthetic */ String $projectName;
                final /* synthetic */ String $projectPath;
                {
                    this.$projectName = $projectName;
                    this.$projectPath = $projectPath;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("No Kotlin Targets Declared").description((Function0<String>)((Function0)new Function0<String>(this.$projectName, this.$projectPath){
                        final /* synthetic */ String $projectName;
                        final /* synthetic */ String $projectPath;
                        {
                            this.$projectName = $projectName;
                            this.$projectPath = $projectPath;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please initialize at least one Kotlin target in '" + this.$projectName + " (" + this.$projectPath + ")'.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/set-up-targets"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$NotCompatibleWithGradle9;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "fixAction", "", "kotlin-gradle-plugin_common"})
    public static final class NotCompatibleWithGradle9
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final NotCompatibleWithGradle9 INSTANCE = new NotCompatibleWithGradle9();

        private NotCompatibleWithGradle9() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String fixAction) {
            Intrinsics.checkNotNullParameter((Object)fixAction, (String)"fixAction");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(fixAction){
                final /* synthetic */ String $fixAction;
                {
                    this.$fixAction = $fixAction;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Kotlin Gradle Plugin Not Compatible with Gradle 9").description((Function0<String>)((Function0)invoke.1.INSTANCE)).solution((Function0<String>)((Function0)new Function0<String>(this.$fixAction){
                        final /* synthetic */ String $fixAction;
                        {
                            this.$fixAction = $fixAction;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please " + this.$fixAction + " to fix it.";
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$OldNativeVersionDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "nativeVersion", "Lorg/jetbrains/kotlin/tooling/core/KotlinToolingVersion;", "kotlinVersion", "kotlin-gradle-plugin_common"})
    public static final class OldNativeVersionDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final OldNativeVersionDiagnostic INSTANCE = new OldNativeVersionDiagnostic();

        private OldNativeVersionDiagnostic() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@Nullable KotlinToolingVersion nativeVersion2, @NotNull KotlinToolingVersion kotlinVersion) {
            Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(nativeVersion2, kotlinVersion){
                final /* synthetic */ KotlinToolingVersion $nativeVersion;
                final /* synthetic */ KotlinToolingVersion $kotlinVersion;
                {
                    this.$nativeVersion = $nativeVersion;
                    this.$kotlinVersion = $kotlinVersion;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Kotlin/Native and Kotlin Versions Incompatible").description((Function0<String>)((Function0)new Function0<String>(this.$nativeVersion, this.$kotlinVersion){
                        final /* synthetic */ KotlinToolingVersion $nativeVersion;
                        final /* synthetic */ KotlinToolingVersion $kotlinVersion;
                        {
                            this.$nativeVersion = $nativeVersion;
                            this.$kotlinVersion = $kotlinVersion;
                            super(0);
                        }

                        public final String invoke() {
                            return "" + '\'' + this.$nativeVersion + "' Kotlin/Native is being used with an newer '" + this.$kotlinVersion + "' Kotlin.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bJ\u001f\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0086\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PartiallyResolvedKmpDependencies;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "extendedDetailsLogInInfo", "", "getExtendedDetailsLogInInfo", "()Ljava/lang/String;", "isInfoLoggingEnabled", "", "()Z", "solution", "getSolution", "failureMessage", "sourceSetName", "unresolvedDependency", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PartiallyResolvedKmpDependencies$UnresolvedKmpDependency;", "emitAdditionalInformationInEachFailure", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "unresolvedDependencies", "", "UnresolvedKmpDependency", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nKotlinToolingDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PartiallyResolvedKmpDependencies\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1978:1\n1549#2:1979\n1620#2,3:1980\n1851#2,2:1983\n1851#2,2:1985\n*S KotlinDebug\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PartiallyResolvedKmpDependencies\n*L\n140#1:1979\n140#1:1980,3\n150#1:1983,2\n155#1:1985,2\n*E\n"})
    public static final class PartiallyResolvedKmpDependencies
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PartiallyResolvedKmpDependencies INSTANCE = new PartiallyResolvedKmpDependencies();

        private PartiallyResolvedKmpDependencies() {
            super(ToolingDiagnostic.Severity.STRONG_WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String failureMessage(@NotNull String sourceSetName, @NotNull UnresolvedKmpDependency unresolvedDependency, boolean isInfoLoggingEnabled, boolean emitAdditionalInformationInEachFailure) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
            Intrinsics.checkNotNullParameter((Object)unresolvedDependency, (String)"unresolvedDependency");
            StringBuilder $this$failureMessage_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, "Couldn't resolve dependency '" + unresolvedDependency.getDisplayName() + "' in '" + sourceSetName + "' for all target platforms.");
            StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, "The dependency should target platforms: " + CollectionsKt.sorted((Iterable)unresolvedDependency.getAllTargets()));
            Iterable iterable = unresolvedDependency.getUnresolvedComponents();
            StringBuilder stringBuilder2 = new StringBuilder().append("Unresolved platforms: ");
            Appendable appendable = $this$failureMessage_u24lambda_u243;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UnresolvedKmpDependency.UnresolvedComponent unresolvedComponent = (UnresolvedKmpDependency.UnresolvedComponent)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getTargetName());
            }
            collection = (List)destination$iv$iv;
            StringUtilsKt.appendLine(appendable, stringBuilder2.append(CollectionsKt.sorted((Iterable)collection)).toString());
            if (emitAdditionalInformationInEachFailure) {
                StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243);
                StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, INSTANCE.getSolution());
            }
            if (isInfoLoggingEnabled) {
                StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243);
                StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, "Detailed log:");
                StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, "Dependency '" + unresolvedDependency.getDisplayName() + "':");
                StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, StringsKt.prependIndent((String)"Unresolved platforms:", (String)StringsKt.repeat((CharSequence)" ", (int)2)));
                Iterable $this$forEach$iv = unresolvedDependency.getUnresolvedComponents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UnresolvedKmpDependency.UnresolvedComponent it = (UnresolvedKmpDependency.UnresolvedComponent)element$iv;
                    boolean bl3 = false;
                    StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, StringsKt.prependIndent((String)("Compilation " + it.getCompilationName() + " resolved configuration '" + it.getConfigurationName() + "' with resolution failure: " + it.getFailureDescription()), (String)StringsKt.repeat((CharSequence)" ", (int)4)));
                }
                if (!((Collection)unresolvedDependency.getResolvedVariants()).isEmpty()) {
                    StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, StringsKt.prependIndent((String)"Resolved platforms:", (String)StringsKt.repeat((CharSequence)" ", (int)2)));
                    $this$forEach$iv = unresolvedDependency.getResolvedVariants();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        UnresolvedKmpDependency.ResolvedVariant it = (UnresolvedKmpDependency.ResolvedVariant)element$iv;
                        boolean bl4 = false;
                        StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, StringsKt.prependIndent((String)("Compilation " + it.getCompilationName() + " resolved configuration '" + it.getConfigurationName() + "' with variant: " + it.getVariant()), (String)StringsKt.repeat((CharSequence)" ", (int)4)));
                    }
                }
            } else if (emitAdditionalInformationInEachFailure) {
                StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243);
                StringUtilsKt.appendLine($this$failureMessage_u24lambda_u243, INSTANCE.getExtendedDetailsLogInInfo());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String sourceSetName, @NotNull List<UnresolvedKmpDependency> unresolvedDependencies) {
            Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
            Intrinsics.checkNotNullParameter(unresolvedDependencies, (String)"unresolvedDependencies");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(sourceSetName, unresolvedDependencies){
                final /* synthetic */ String $sourceSetName;
                final /* synthetic */ List<UnresolvedKmpDependency> $unresolvedDependencies;
                {
                    this.$sourceSetName = $sourceSetName;
                    this.$unresolvedDependencies = $unresolvedDependencies;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("KMP Dependencies Resolution Failure").descriptionBuilder((Function0<String>)((Function0)new Function0<String>(this.$sourceSetName, this.$unresolvedDependencies){
                        final /* synthetic */ String $sourceSetName;
                        final /* synthetic */ List<UnresolvedKmpDependency> $unresolvedDependencies;
                        {
                            this.$sourceSetName = $sourceSetName;
                            this.$unresolvedDependencies = $unresolvedDependencies;
                            super(0);
                        }

                        public final String invoke() {
                            StringBuilder stringBuilder;
                            String string = this.$sourceSetName;
                            List<UnresolvedKmpDependency> list = this.$unresolvedDependencies;
                            StringBuilder $this$invoke_u24lambda_u241 = stringBuilder = new StringBuilder();
                            boolean bl = false;
                            StringUtilsKt.appendLine($this$invoke_u24lambda_u241, "Source set '" + string + "' couldn't resolve dependencies for all target platforms");
                            Iterable $this$forEach$iv = list;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                UnresolvedKmpDependency it = (UnresolvedKmpDependency)element$iv;
                                boolean bl2 = false;
                                StringUtilsKt.appendLine($this$invoke_u24lambda_u241, PartiallyResolvedKmpDependencies.INSTANCE.failureMessage(string, it, PartiallyResolvedKmpDependencies.access$isInfoLoggingEnabled(PartiallyResolvedKmpDependencies.INSTANCE), false));
                                StringUtilsKt.appendLine($this$invoke_u24lambda_u241);
                            }
                            if (!PartiallyResolvedKmpDependencies.access$isInfoLoggingEnabled(PartiallyResolvedKmpDependencies.INSTANCE)) {
                                StringUtilsKt.appendLine($this$invoke_u24lambda_u241, PartiallyResolvedKmpDependencies.INSTANCE.getExtendedDetailsLogInInfo());
                                StringUtilsKt.appendLine($this$invoke_u24lambda_u241);
                            }
                            String string2 = stringBuilder.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                            return string2;
                        }
                    })).solution(PartiallyResolvedKmpDependencies.access$getSolution(PartiallyResolvedKmpDependencies.INSTANCE));
                }
            }, 15, null);
        }

        private final boolean isInfoLoggingEnabled() {
            return LoggerFactory.getLogger(PartiallyResolvedKmpDependencies.class).isInfoEnabled();
        }

        private final String getSolution() {
            return "Make sure you are using a dependency that targets all required platforms or move your dependency and relevant code to a more applicable source set: https://kotl.in/57b2-source-set-dependencies";
        }

        @NotNull
        public final String getExtendedDetailsLogInInfo() {
            return "Run the build with '--info' for more details.";
        }

        public static final /* synthetic */ boolean access$isInfoLoggingEnabled(PartiallyResolvedKmpDependencies $this) {
            return $this.isInfoLoggingEnabled();
        }

        public static final /* synthetic */ String access$getSolution(PartiallyResolvedKmpDependencies $this) {
            return $this.getSolution();
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0003J?\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PartiallyResolvedKmpDependencies$UnresolvedKmpDependency;", "", "displayName", "", "resolvedMetadataComponentIdentifier", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "unresolvedComponents", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/checkers/UnresolvedKmpDependency$UnresolvedComponent;", "resolvedVariants", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/checkers/UnresolvedKmpDependency$ResolvedVariant;", "(Ljava/lang/String;Lorg/gradle/api/artifacts/component/ComponentIdentifier;Ljava/util/List;Ljava/util/List;)V", "allTargets", "getAllTargets", "()Ljava/util/List;", "getDisplayName", "()Ljava/lang/String;", "getResolvedMetadataComponentIdentifier", "()Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "setResolvedMetadataComponentIdentifier", "(Lorg/gradle/api/artifacts/component/ComponentIdentifier;)V", "getResolvedVariants", "getUnresolvedComponents", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
        @SourceDebugExtension(value={"SMAP\nKotlinToolingDiagnostics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PartiallyResolvedKmpDependencies$UnresolvedKmpDependency\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1978:1\n1549#2:1979\n1620#2,3:1980\n*S KotlinDebug\n*F\n+ 1 KotlinToolingDiagnostics.kt\norg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PartiallyResolvedKmpDependencies$UnresolvedKmpDependency\n*L\n129#1:1979\n129#1:1980,3\n*E\n"})
        public static final class UnresolvedKmpDependency {
            @NotNull
            private final String displayName;
            @Nullable
            private ComponentIdentifier resolvedMetadataComponentIdentifier;
            @NotNull
            private final List<UnresolvedKmpDependency.UnresolvedComponent> unresolvedComponents;
            @NotNull
            private final List<UnresolvedKmpDependency.ResolvedVariant> resolvedVariants;
            @NotNull
            private final List<String> allTargets;

            public UnresolvedKmpDependency(@NotNull String displayName, @Nullable ComponentIdentifier resolvedMetadataComponentIdentifier, @NotNull List<UnresolvedKmpDependency.UnresolvedComponent> unresolvedComponents, @NotNull List<UnresolvedKmpDependency.ResolvedVariant> resolvedVariants) {
                Collection<String> collection;
                UnresolvedKmpDependency.ResolvedVariant it;
                Collection collection2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
                Intrinsics.checkNotNullParameter(unresolvedComponents, (String)"unresolvedComponents");
                Intrinsics.checkNotNullParameter(resolvedVariants, (String)"resolvedVariants");
                this.displayName = displayName;
                this.resolvedMetadataComponentIdentifier = resolvedMetadataComponentIdentifier;
                this.unresolvedComponents = unresolvedComponents;
                this.resolvedVariants = resolvedVariants;
                Iterable iterable = this.unresolvedComponents;
                UnresolvedKmpDependency unresolvedKmpDependency = this;
                boolean $i$f$map = false;
                void var7_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    UnresolvedKmpDependency.UnresolvedComponent unresolvedComponent = (UnresolvedKmpDependency.UnresolvedComponent)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(((UnresolvedKmpDependency.UnresolvedComponent)((Object)it)).getTargetName());
                }
                $this$map$iv = this.resolvedVariants;
                collection2 = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (UnresolvedKmpDependency.ResolvedVariant)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getTargetName());
                }
                collection = (List)destination$iv$iv;
                unresolvedKmpDependency.allTargets = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
            }

            @NotNull
            public final String getDisplayName() {
                return this.displayName;
            }

            @Nullable
            public final ComponentIdentifier getResolvedMetadataComponentIdentifier() {
                return this.resolvedMetadataComponentIdentifier;
            }

            public final void setResolvedMetadataComponentIdentifier(@Nullable ComponentIdentifier componentIdentifier) {
                this.resolvedMetadataComponentIdentifier = componentIdentifier;
            }

            @NotNull
            public final List<UnresolvedKmpDependency.UnresolvedComponent> getUnresolvedComponents() {
                return this.unresolvedComponents;
            }

            @NotNull
            public final List<UnresolvedKmpDependency.ResolvedVariant> getResolvedVariants() {
                return this.resolvedVariants;
            }

            @NotNull
            public final List<String> getAllTargets() {
                return this.allTargets;
            }

            @NotNull
            public final String component1() {
                return this.displayName;
            }

            @Nullable
            public final ComponentIdentifier component2() {
                return this.resolvedMetadataComponentIdentifier;
            }

            @NotNull
            public final List<UnresolvedKmpDependency.UnresolvedComponent> component3() {
                return this.unresolvedComponents;
            }

            @NotNull
            public final List<UnresolvedKmpDependency.ResolvedVariant> component4() {
                return this.resolvedVariants;
            }

            @NotNull
            public final UnresolvedKmpDependency copy(@NotNull String displayName, @Nullable ComponentIdentifier resolvedMetadataComponentIdentifier, @NotNull List<UnresolvedKmpDependency.UnresolvedComponent> unresolvedComponents, @NotNull List<UnresolvedKmpDependency.ResolvedVariant> resolvedVariants) {
                Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
                Intrinsics.checkNotNullParameter(unresolvedComponents, (String)"unresolvedComponents");
                Intrinsics.checkNotNullParameter(resolvedVariants, (String)"resolvedVariants");
                return new UnresolvedKmpDependency(displayName, resolvedMetadataComponentIdentifier, unresolvedComponents, resolvedVariants);
            }

            public static /* synthetic */ UnresolvedKmpDependency copy$default(UnresolvedKmpDependency unresolvedKmpDependency, String string, ComponentIdentifier componentIdentifier, List list, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = unresolvedKmpDependency.displayName;
                }
                if ((n & 2) != 0) {
                    componentIdentifier = unresolvedKmpDependency.resolvedMetadataComponentIdentifier;
                }
                if ((n & 4) != 0) {
                    list = unresolvedKmpDependency.unresolvedComponents;
                }
                if ((n & 8) != 0) {
                    list2 = unresolvedKmpDependency.resolvedVariants;
                }
                return unresolvedKmpDependency.copy(string, componentIdentifier, list, list2);
            }

            @NotNull
            public String toString() {
                return "UnresolvedKmpDependency(displayName=" + this.displayName + ", resolvedMetadataComponentIdentifier=" + this.resolvedMetadataComponentIdentifier + ", unresolvedComponents=" + this.unresolvedComponents + ", resolvedVariants=" + this.resolvedVariants + ')';
            }

            public int hashCode() {
                int result2 = this.displayName.hashCode();
                result2 = result2 * 31 + (this.resolvedMetadataComponentIdentifier == null ? 0 : this.resolvedMetadataComponentIdentifier.hashCode());
                result2 = result2 * 31 + ((Object)this.unresolvedComponents).hashCode();
                result2 = result2 * 31 + ((Object)this.resolvedVariants).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnresolvedKmpDependency)) {
                    return false;
                }
                UnresolvedKmpDependency unresolvedKmpDependency = (UnresolvedKmpDependency)other;
                if (!Intrinsics.areEqual((Object)this.displayName, (Object)unresolvedKmpDependency.displayName)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.resolvedMetadataComponentIdentifier, (Object)unresolvedKmpDependency.resolvedMetadataComponentIdentifier)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.unresolvedComponents, unresolvedKmpDependency.unresolvedComponents)) {
                    return false;
                }
                return Intrinsics.areEqual(this.resolvedVariants, unresolvedKmpDependency.resolvedVariants);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PlatformSourceSetConventionUsedWithCustomTargetName;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "expectedTargetName", "", "kotlin-gradle-plugin_common"})
    public static final class PlatformSourceSetConventionUsedWithCustomTargetName
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PlatformSourceSetConventionUsedWithCustomTargetName INSTANCE = new PlatformSourceSetConventionUsedWithCustomTargetName();

        private PlatformSourceSetConventionUsedWithCustomTargetName() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinSourceSet sourceSet, @NotNull KotlinTarget target2, @NotNull String expectedTargetName) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Intrinsics.checkNotNullParameter((Object)expectedTargetName, (String)"expectedTargetName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, KotlinSourceSetConvention.INSTANCE.isAccessedByKotlinSourceSetConventionAt$kotlin_gradle_plugin_common(sourceSet), (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(sourceSet, expectedTargetName, target2){
                final /* synthetic */ KotlinSourceSet $sourceSet;
                final /* synthetic */ String $expectedTargetName;
                final /* synthetic */ KotlinTarget $target;
                {
                    this.$sourceSet = $sourceSet;
                    this.$expectedTargetName = $expectedTargetName;
                    this.$target = $target;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Source Set used with custom target name").description((Function0<String>)((Function0)new Function0<String>(this.$sourceSet, this.$expectedTargetName, this.$target){
                        final /* synthetic */ KotlinSourceSet $sourceSet;
                        final /* synthetic */ String $expectedTargetName;
                        final /* synthetic */ KotlinTarget $target;
                        {
                            this.$sourceSet = $sourceSet;
                            this.$expectedTargetName = $expectedTargetName;
                            this.$target = $target;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                        Accessed '" + this.$sourceSet + "', but " + this.$expectedTargetName + " target used a custom name '" + this.$target.getName() + "' (expected '" + this.$expectedTargetName + "'):\n                        \n                        Replace:\n                        ```\n                        kotlin {\n                            " + this.$expectedTargetName + "(\"" + this.$target.getName() + "\") /* <- custom name used */\n                        }\n                        ```\n                        \n                        With:\n                        ```\n                        kotlin {\n                            " + this.$expectedTargetName + "()\n                        }\n                        ```\n                        "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$expectedTargetName){
                        final /* synthetic */ String $expectedTargetName;
                        {
                            this.$expectedTargetName = $expectedTargetName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please use the " + this.$expectedTargetName + "() target name.";
                        }
                    }));
                }
            }, 7, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PlatformSourceSetConventionUsedWithoutCorrespondingTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "expectedTargetName", "", "kotlin-gradle-plugin_common"})
    public static final class PlatformSourceSetConventionUsedWithoutCorrespondingTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PlatformSourceSetConventionUsedWithoutCorrespondingTarget INSTANCE = new PlatformSourceSetConventionUsedWithoutCorrespondingTarget();

        private PlatformSourceSetConventionUsedWithoutCorrespondingTarget() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinSourceSet sourceSet, @NotNull String expectedTargetName) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            Intrinsics.checkNotNullParameter((Object)expectedTargetName, (String)"expectedTargetName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, KotlinSourceSetConvention.INSTANCE.isAccessedByKotlinSourceSetConventionAt$kotlin_gradle_plugin_common(sourceSet), (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(sourceSet, expectedTargetName){
                final /* synthetic */ KotlinSourceSet $sourceSet;
                final /* synthetic */ String $expectedTargetName;
                {
                    this.$sourceSet = $sourceSet;
                    this.$expectedTargetName = $expectedTargetName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Source Set Used Without a Corresponding Target").description((Function0<String>)((Function0)new Function0<String>(this.$sourceSet, this.$expectedTargetName){
                        final /* synthetic */ KotlinSourceSet $sourceSet;
                        final /* synthetic */ String $expectedTargetName;
                        {
                            this.$sourceSet = $sourceSet;
                            this.$expectedTargetName = $expectedTargetName;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                        Accessed '" + this.$sourceSet + "' without the registering the " + this.$expectedTargetName + " target:\n                        kotlin {\n                            " + this.$expectedTargetName + "() /* <- register the '" + this.$expectedTargetName + "' target */\n                        \n                            sourceSets." + this.$sourceSet.getName() + ".dependencies {\n                        \n                            }\n                        }\n                        "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$expectedTargetName){
                        final /* synthetic */ String $expectedTargetName;
                        {
                            this.$expectedTargetName = $expectedTargetName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please register the " + this.$expectedTargetName + " target.";
                        }
                    }));
                }
            }, 7, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PomMisconfigured;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "description", "", "solution", "link", "kotlin-gradle-plugin_common"})
    public static final class PomMisconfigured
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PomMisconfigured INSTANCE = new PomMisconfigured();

        private PomMisconfigured() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String description2, @NotNull String solution2, @Nullable String link2) {
            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
            Intrinsics.checkNotNullParameter((Object)solution2, (String)"solution");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(description2, solution2, link2){
                final /* synthetic */ String $description;
                final /* synthetic */ String $solution;
                final /* synthetic */ String $link;
                {
                    this.$description = $description;
                    this.$solution = $solution;
                    this.$link = $link;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    ToolingDiagnostics.OptionalStep optionalStep;
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                        optionalStep = $this$build.title("There was a problem with the Maven POM file configuration.").description(this.$description).solution(this.$solution);
                        String string = this.$link;
                        ToolingDiagnostics.OptionalStep $this$invoke_u24lambda_u241 = optionalStep;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) break block0;
                        String it = string2;
                        boolean bl2 = false;
                        ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$invoke_u24lambda_u241, new URI(it), null, 2, null);
                    }
                    return optionalStep;
                }
            }, 15, null);
        }

        public static /* synthetic */ ToolingDiagnostic invoke$default(PomMisconfigured pomMisconfigured, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            return pomMisconfigured.invoke(string, string2, string3);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PreHMPPFlagsError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "usedDeprecatedFlags", "", "", "kotlin-gradle-plugin_common"})
    public static final class PreHMPPFlagsError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PreHMPPFlagsError INSTANCE = new PreHMPPFlagsError();

        private PreHMPPFlagsError() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<String> usedDeprecatedFlags) {
            Intrinsics.checkNotNullParameter(usedDeprecatedFlags, (String)"usedDeprecatedFlags");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(usedDeprecatedFlags){
                final /* synthetic */ List<String> $usedDeprecatedFlags;
                {
                    this.$usedDeprecatedFlags = $usedDeprecatedFlags;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Deprecated Kotlin Multiplatform Properties").description((Function0<String>)((Function0)new Function0<String>(this.$usedDeprecatedFlags){
                        final /* synthetic */ List<String> $usedDeprecatedFlags;
                        {
                            this.$usedDeprecatedFlags = $usedDeprecatedFlags;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    The following properties are obsolete and no longer supported:\n                    " + CollectionsKt.joinToString$default((Iterable)this.$usedDeprecatedFlags, null, null, null, (int)0, null, null, (int)63, null) + "\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotlinlang.org/docs/multiplatform-compatibility-guide.html#deprecate-hmpp-properties"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PreHmppDependenciesUsedInBuild;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "dependencyName", "", "kotlin-gradle-plugin_common"})
    public static final class PreHmppDependenciesUsedInBuild
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PreHmppDependenciesUsedInBuild INSTANCE = new PreHmppDependenciesUsedInBuild();

        private PreHmppDependenciesUsedInBuild() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String dependencyName) {
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(dependencyName){
                final /* synthetic */ String $dependencyName;
                {
                    this.$dependencyName = $dependencyName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Deprecated Legacy Mode Dependency").description((Function0<String>)((Function0)new Function0<String>(this.$dependencyName){
                        final /* synthetic */ String $dependencyName;
                        {
                            this.$dependencyName = $dependencyName;
                            super(0);
                        }

                        public final String invoke() {
                            return "The dependency '" + this.$dependencyName + "' was published in the legacy mode. Support for such dependencies will be removed in the future.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/0b5kn8"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$PublishAllAndroidLibraryVariantsDeprecated;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class PublishAllAndroidLibraryVariantsDeprecated
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final PublishAllAndroidLibraryVariantsDeprecated INSTANCE = new PublishAllAndroidLibraryVariantsDeprecated();

        private PublishAllAndroidLibraryVariantsDeprecated() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$RedundantDependsOnEdgesFound;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "redundantEdges", "", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$RedundantDependsOnEdgesFound$RedundantEdge;", "RedundantEdge", "kotlin-gradle-plugin_common"})
    public static final class RedundantDependsOnEdgesFound
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final RedundantDependsOnEdgesFound INSTANCE = new RedundantDependsOnEdgesFound();

        private RedundantDependsOnEdgesFound() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<RedundantEdge> redundantEdges) {
            Intrinsics.checkNotNullParameter(redundantEdges, (String)"redundantEdges");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(redundantEdges){
                final /* synthetic */ List<RedundantEdge> $redundantEdges;
                {
                    this.$redundantEdges = $redundantEdges;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Redundant dependsOn Kotlin Source Sets found").description((Function0<String>)((Function0)new Function0<String>(this.$redundantEdges){
                        final /* synthetic */ List<RedundantEdge> $redundantEdges;
                        {
                            this.$redundantEdges = $redundantEdges;
                            super(0);
                        }

                        public final String invoke() {
                            StringBuilder stringBuilder;
                            List<RedundantEdge> list = this.$redundantEdges;
                            StringBuilder $this$invoke_u24lambda_u241 = stringBuilder = new StringBuilder();
                            boolean bl = false;
                            Iterable $this$forEach$iv = list;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                RedundantEdge edge = (RedundantEdge)element$iv;
                                boolean bl2 = false;
                                StringUtilsKt.appendLine($this$invoke_u24lambda_u241, " * " + edge.getFrom() + ".dependsOn(" + edge.getTo() + ')');
                            }
                            String string = stringBuilder.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                            String redundantEdgesString = string;
                            return StringsKt.trimMargin$default((String)("\n                    |Redundant dependsOn edges between Kotlin Source Sets found.\n                    |Please remove the following dependsOn invocations from your build scripts:\n                    |" + redundantEdgesString + "\n                    "), null, (int)1, null);
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/hierarchy-template"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$RedundantDependsOnEdgesFound$RedundantEdge;", "", "from", "", "to", "(Ljava/lang/String;Ljava/lang/String;)V", "getFrom", "()Ljava/lang/String;", "getTo", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-gradle-plugin_common"})
        public static final class RedundantEdge {
            @NotNull
            private final String from;
            @NotNull
            private final String to;

            public RedundantEdge(@NotNull String from2, @NotNull String to) {
                Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                this.from = from2;
                this.to = to;
            }

            @NotNull
            public final String getFrom() {
                return this.from;
            }

            @NotNull
            public final String getTo() {
                return this.to;
            }

            @NotNull
            public final String component1() {
                return this.from;
            }

            @NotNull
            public final String component2() {
                return this.to;
            }

            @NotNull
            public final RedundantEdge copy(@NotNull String from2, @NotNull String to) {
                Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
                Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                return new RedundantEdge(from2, to);
            }

            public static /* synthetic */ RedundantEdge copy$default(RedundantEdge redundantEdge, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = redundantEdge.from;
                }
                if ((n & 2) != 0) {
                    string2 = redundantEdge.to;
                }
                return redundantEdge.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "RedundantEdge(from=" + this.from + ", to=" + this.to + ')';
            }

            public int hashCode() {
                int result2 = this.from.hashCode();
                result2 = result2 * 31 + this.to.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RedundantEdge)) {
                    return false;
                }
                RedundantEdge redundantEdge = (RedundantEdge)other;
                if (!Intrinsics.areEqual((Object)this.from, (Object)redundantEdge.from)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.to, (Object)redundantEdge.to);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ResourceMayNotBePublishedForTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class ResourceMayNotBePublishedForTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ResourceMayNotBePublishedForTarget INSTANCE = new ResourceMayNotBePublishedForTarget();

        private ResourceMayNotBePublishedForTarget() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(targetName){
                final /* synthetic */ String $targetName;
                {
                    this.$targetName = $targetName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Resource Publication Not Supported for Target '" + this.$targetName + '\'').description((Function0<String>)((Function0)new Function0<String>(this.$targetName){
                        final /* synthetic */ String $targetName;
                        {
                            this.$targetName = $targetName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Resources publication for target " + this.$targetName + " is not supported yet.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(KotlinToolingDiagnostics.access$getBUG_REPORT_URL$p(), (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)KotlinToolingDiagnostics.INSTANCE){

                        public final String invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return KotlinToolingDiagnostics.access$resourcesBugReportRequest((KotlinToolingDiagnostics)this.receiver, p0);
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ResourceMayNotBeResolvedForTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class ResourceMayNotBeResolvedForTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ResourceMayNotBeResolvedForTarget INSTANCE = new ResourceMayNotBeResolvedForTarget();

        private ResourceMayNotBeResolvedForTarget() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(targetName){
                final /* synthetic */ String $targetName;
                {
                    this.$targetName = $targetName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Resource Resolution Not Supported for Target '" + this.$targetName + '\'').description((Function0<String>)((Function0)new Function0<String>(this.$targetName){
                        final /* synthetic */ String $targetName;
                        {
                            this.$targetName = $targetName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Resources resolution for target " + this.$targetName + " is not supported.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(KotlinToolingDiagnostics.access$getBUG_REPORT_URL$p(), (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)KotlinToolingDiagnostics.INSTANCE){

                        public final String invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return KotlinToolingDiagnostics.access$resourcesBugReportRequest((KotlinToolingDiagnostics)this.receiver, p0);
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ResourceMayNotBeResolvedWithGradleVersion;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "currentGradleVersion", "minimumRequiredVersion", "kotlin-gradle-plugin_common"})
    public static final class ResourceMayNotBeResolvedWithGradleVersion
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ResourceMayNotBeResolvedWithGradleVersion INSTANCE = new ResourceMayNotBeResolvedWithGradleVersion();

        private ResourceMayNotBeResolvedWithGradleVersion() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName, @NotNull String currentGradleVersion, @NotNull String minimumRequiredVersion) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            Intrinsics.checkNotNullParameter((Object)currentGradleVersion, (String)"currentGradleVersion");
            Intrinsics.checkNotNullParameter((Object)minimumRequiredVersion, (String)"minimumRequiredVersion");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(targetName, minimumRequiredVersion, currentGradleVersion){
                final /* synthetic */ String $targetName;
                final /* synthetic */ String $minimumRequiredVersion;
                final /* synthetic */ String $currentGradleVersion;
                {
                    this.$targetName = $targetName;
                    this.$minimumRequiredVersion = $minimumRequiredVersion;
                    this.$currentGradleVersion = $currentGradleVersion;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Resource Resolution for Target '" + this.$targetName + "' Requires Gradle " + this.$minimumRequiredVersion).description((Function0<String>)((Function0)new Function0<String>(this.$targetName, this.$minimumRequiredVersion, this.$currentGradleVersion){
                        final /* synthetic */ String $targetName;
                        final /* synthetic */ String $minimumRequiredVersion;
                        final /* synthetic */ String $currentGradleVersion;
                        {
                            this.$targetName = $targetName;
                            this.$minimumRequiredVersion = $minimumRequiredVersion;
                            this.$currentGradleVersion = $currentGradleVersion;
                            super(0);
                        }

                        public final String invoke() {
                            return "Resources for target " + this.$targetName + " may not be resolved. Minimum required Gradle version is " + this.$minimumRequiredVersion + " but current is " + this.$currentGradleVersion + '.';
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$minimumRequiredVersion){
                        final /* synthetic */ String $minimumRequiredVersion;
                        {
                            this.$minimumRequiredVersion = $minimumRequiredVersion;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please upgrade Gradle to " + this.$minimumRequiredVersion + " or higher.";
                        }
                    })).documentationLink(KotlinToolingDiagnostics.access$getBUG_REPORT_URL$p(), (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)KotlinToolingDiagnostics.INSTANCE){

                        public final String invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return KotlinToolingDiagnostics.access$resourcesBugReportRequest((KotlinToolingDiagnostics)this.receiver, p0);
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$ResourcePublishedMoreThanOncePerTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "targetName", "", "kotlin-gradle-plugin_common"})
    public static final class ResourcePublishedMoreThanOncePerTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final ResourcePublishedMoreThanOncePerTarget INSTANCE = new ResourcePublishedMoreThanOncePerTarget();

        private ResourcePublishedMoreThanOncePerTarget() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String targetName) {
            Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(targetName){
                final /* synthetic */ String $targetName;
                {
                    this.$targetName = $targetName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Multiple Resource Publications Detected for Target '" + this.$targetName + '\'').description((Function0<String>)((Function0)new Function0<String>(this.$targetName){
                        final /* synthetic */ String $targetName;
                        {
                            this.$targetName = $targetName;
                            super(0);
                        }

                        public final String invoke() {
                            return "Only one resources publication per target " + this.$targetName + " is allowed.";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(KotlinToolingDiagnostics.access$getBUG_REPORT_URL$p(), (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)KotlinToolingDiagnostics.INSTANCE){

                        public final String invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return KotlinToolingDiagnostics.access$resourcesBugReportRequest((KotlinToolingDiagnostics)this.receiver, p0);
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$SigningMisconfigured;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "description", "", "solution", "link", "kotlin-gradle-plugin_common"})
    public static final class SigningMisconfigured
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final SigningMisconfigured INSTANCE = new SigningMisconfigured();

        private SigningMisconfigured() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String description2, @NotNull String solution2, @Nullable String link2) {
            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
            Intrinsics.checkNotNullParameter((Object)solution2, (String)"solution");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(description2, solution2, link2){
                final /* synthetic */ String $description;
                final /* synthetic */ String $solution;
                final /* synthetic */ String $link;
                {
                    this.$description = $description;
                    this.$solution = $solution;
                    this.$link = $link;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    ToolingDiagnostics.OptionalStep optionalStep;
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                        optionalStep = $this$build.title("There was a problem with the artifact signing configuration.").description(this.$description).solution(this.$solution);
                        String string = this.$link;
                        ToolingDiagnostics.OptionalStep $this$invoke_u24lambda_u241 = optionalStep;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) break block0;
                        String it = string2;
                        boolean bl2 = false;
                        ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$invoke_u24lambda_u241, new URI(it), null, 2, null);
                    }
                    return optionalStep;
                }
            }, 15, null);
        }

        public static /* synthetic */ ToolingDiagnostic invoke$default(SigningMisconfigured signingMisconfigured, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            return signingMisconfigured.invoke(string, string2, string3);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$SomePublicationsNotSigned;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "publications", "", "", "kotlin-gradle-plugin_common"})
    public static final class SomePublicationsNotSigned
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final SomePublicationsNotSigned INSTANCE = new SomePublicationsNotSigned();

        private SomePublicationsNotSigned() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<String> publications) {
            Intrinsics.checkNotNullParameter(publications, (String)"publications");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(publications){
                final /* synthetic */ List<String> $publications;
                {
                    this.$publications = $publications;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return ToolingDiagnostics.OptionalStep.DefaultImpls.documentationLink$default($this$build.title("Signing is not enabled for some publications.").description("Publishing unsigned publications to Maven Central will fail validation.").solution("Configure signing for the following publications if you plan to publish them to Maven Central: " + CollectionsKt.joinToString$default((Iterable)this.$publications, null, null, null, (int)0, null, null, (int)63, null)), new URI("https://kotl.in/9l92c3"), null, 2, null);
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$SourceSetLayoutV1StyleDirUsageWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "v1StyleSourceDirInUse", "", "currentLayoutName", "v2StyleSourceDirToUse", "kotlin-gradle-plugin_common"})
    public static final class SourceSetLayoutV1StyleDirUsageWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final SourceSetLayoutV1StyleDirUsageWarning INSTANCE = new SourceSetLayoutV1StyleDirUsageWarning();

        private SourceSetLayoutV1StyleDirUsageWarning() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String v1StyleSourceDirInUse, @NotNull String currentLayoutName, @NotNull String v2StyleSourceDirToUse) {
            Intrinsics.checkNotNullParameter((Object)v1StyleSourceDirInUse, (String)"v1StyleSourceDirInUse");
            Intrinsics.checkNotNullParameter((Object)currentLayoutName, (String)"currentLayoutName");
            Intrinsics.checkNotNullParameter((Object)v2StyleSourceDirToUse, (String)"v2StyleSourceDirToUse");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(v1StyleSourceDirInUse, currentLayoutName, v2StyleSourceDirToUse){
                final /* synthetic */ String $v1StyleSourceDirInUse;
                final /* synthetic */ String $currentLayoutName;
                final /* synthetic */ String $v2StyleSourceDirToUse;
                {
                    this.$v1StyleSourceDirInUse = $v1StyleSourceDirInUse;
                    this.$currentLayoutName = $currentLayoutName;
                    this.$v2StyleSourceDirToUse = $v2StyleSourceDirToUse;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Deprecated Source Set Layout V1").description((Function0<String>)((Function0)new Function0<String>(this.$v1StyleSourceDirInUse, this.$currentLayoutName, this.$v2StyleSourceDirToUse){
                        final /* synthetic */ String $v1StyleSourceDirInUse;
                        final /* synthetic */ String $currentLayoutName;
                        final /* synthetic */ String $v2StyleSourceDirToUse;
                        {
                            this.$v1StyleSourceDirInUse = $v1StyleSourceDirInUse;
                            this.$currentLayoutName = $currentLayoutName;
                            this.$v2StyleSourceDirToUse = $v2StyleSourceDirToUse;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Found used source directory " + this.$v1StyleSourceDirInUse + "\n                    This source directory was supported by: " + KotlinAndroidSourceSetLayoutKt.getMultiplatformAndroidSourceSetLayoutV1().getName() + "\n                    Current KotlinAndroidSourceSetLayout: " + this.$currentLayoutName + "\n                    New source directory is: " + this.$v2StyleSourceDirToUse + "\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)new Function0<String>(this.$v2StyleSourceDirToUse){
                        final /* synthetic */ String $v2StyleSourceDirToUse;
                        {
                            this.$v2StyleSourceDirToUse = $v2StyleSourceDirToUse;
                            super(0);
                        }

                        public final String invoke() {
                            return "Please migrate to the new source directory: " + this.$v2StyleSourceDirToUse;
                        }
                    }));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$SwiftExportArtifactResolution;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "component", "", "artifacts", "", "kotlin-gradle-plugin_common"})
    public static final class SwiftExportArtifactResolution
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final SwiftExportArtifactResolution INSTANCE = new SwiftExportArtifactResolution();

        private SwiftExportArtifactResolution() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String component, @NotNull List<String> artifacts) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
            return ToolingDiagnosticFactory.build$default(this, null, artifacts.isEmpty() ? ToolingDiagnostic.Severity.WARNING : ToolingDiagnostic.Severity.ERROR, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(artifacts, component){
                final /* synthetic */ List<String> $artifacts;
                final /* synthetic */ String $component;
                {
                    this.$artifacts = $artifacts;
                    this.$component = $component;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Swift Export Artifact Resolution Error").description((Function0<String>)((Function0)new Function0<String>(this.$artifacts, this.$component){
                        final /* synthetic */ List<String> $artifacts;
                        final /* synthetic */ String $component;
                        {
                            this.$artifacts = $artifacts;
                            this.$component = $component;
                            super(0);
                        }

                        public final String invoke() {
                            return this.$artifacts.isEmpty() ? "Component " + this.$component + " doesn't have suitable artifacts" : "Component " + this.$component + " has too many artifacts: " + this.$artifacts;
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 13, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$SwiftExportInvalidModuleName;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "moduleName", "", "kotlin-gradle-plugin_common"})
    public static final class SwiftExportInvalidModuleName
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final SwiftExportInvalidModuleName INSTANCE = new SwiftExportInvalidModuleName();

        private SwiftExportInvalidModuleName() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String moduleName) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(moduleName){
                final /* synthetic */ String $moduleName;
                {
                    this.$moduleName = $moduleName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Invalid Swift Module Name").description((Function0<String>)((Function0)new Function0<String>(this.$moduleName){
                        final /* synthetic */ String $moduleName;
                        {
                            this.$moduleName = $moduleName;
                            super(0);
                        }

                        public final String invoke() {
                            return "The Swift module name '" + this.$moduleName + "' is invalid";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$SwiftExportModuleResolutionError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "modules", "", "", "kotlin-gradle-plugin_common"})
    public static final class SwiftExportModuleResolutionError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final SwiftExportModuleResolutionError INSTANCE = new SwiftExportModuleResolutionError();

        private SwiftExportModuleResolutionError() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull List<String> modules2) {
            Intrinsics.checkNotNullParameter(modules2, (String)"modules");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(modules2){
                final /* synthetic */ List<String> $modules;
                {
                    this.$modules = $modules;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Swift Module Resolution Error").description((Function0<String>)((Function0)new Function0<String>(this.$modules){
                        final /* synthetic */ List<String> $modules;
                        {
                            this.$modules = $modules;
                            super(0);
                        }

                        public final String invoke() {
                            return "The following modules specified in swiftExport { export() } were not found in the resolved components: " + CollectionsKt.joinToString$default((Iterable)this.$modules, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UklibFragmentFromUnexpectedTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "target", "", "kotlin-gradle-plugin_common"})
    public static final class UklibFragmentFromUnexpectedTarget
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UklibFragmentFromUnexpectedTarget INSTANCE = new UklibFragmentFromUnexpectedTarget();

        private UklibFragmentFromUnexpectedTarget() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(target2){
                final /* synthetic */ String $target;
                {
                    this.$target = $target;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Uklib Publication With Unsupported Target").description("Publication of uklib with target '" + this.$target + "' is currently not supported").solution("Please see https://kotl.in/uklib-publication-with-unsupported-target");
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UklibPublicationWithCinterops;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "target", "", "interopName", "kotlin-gradle-plugin_common"})
    public static final class UklibPublicationWithCinterops
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UklibPublicationWithCinterops INSTANCE = new UklibPublicationWithCinterops();

        private UklibPublicationWithCinterops() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String target2, @NotNull String interopName) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Intrinsics.checkNotNullParameter((Object)interopName, (String)"interopName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(target2, interopName){
                final /* synthetic */ String $target;
                final /* synthetic */ String $interopName;
                {
                    this.$target = $target;
                    this.$interopName = $interopName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Uklib Publication With Cinterops").description("Publication of uklib with cinterops is not yet supported. Target '" + this.$target + "' declares cinterop '" + this.$interopName + '\'').solution("Cinterop publication is not yet supported (https://kotl.in/uklib-with-cinterops). Please disable uklib publication in projects with cinterops");
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UklibPublicationWithoutCrossCompilation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "severity", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "(Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;)V", "getSeverity", "()Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic$Severity;", "component1", "copy", "equals", "", "other", "", "get", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "hashCode", "", "toString", "", "kotlin-gradle-plugin_common"})
    public static final class UklibPublicationWithoutCrossCompilation
    extends ToolingDiagnosticFactory {
        @NotNull
        private final ToolingDiagnostic.Severity severity;

        public UklibPublicationWithoutCrossCompilation(@NotNull ToolingDiagnostic.Severity severity) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            super(severity, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
            this.severity = severity;
        }

        @NotNull
        public final ToolingDiagnostic.Severity getSeverity() {
            return this.severity;
        }

        @NotNull
        public final ToolingDiagnostic get() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, get.1.INSTANCE, 15, null);
        }

        @NotNull
        public final ToolingDiagnostic.Severity component1() {
            return this.severity;
        }

        @NotNull
        public final UklibPublicationWithoutCrossCompilation copy(@NotNull ToolingDiagnostic.Severity severity) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            return new UklibPublicationWithoutCrossCompilation(severity);
        }

        public static /* synthetic */ UklibPublicationWithoutCrossCompilation copy$default(UklibPublicationWithoutCrossCompilation uklibPublicationWithoutCrossCompilation, ToolingDiagnostic.Severity severity, int n, Object object) {
            if ((n & 1) != 0) {
                severity = uklibPublicationWithoutCrossCompilation.severity;
            }
            return uklibPublicationWithoutCrossCompilation.copy(severity);
        }

        @NotNull
        public String toString() {
            return "UklibPublicationWithoutCrossCompilation(severity=" + (Object)((Object)this.severity) + ')';
        }

        public int hashCode() {
            return this.severity.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UklibPublicationWithoutCrossCompilation)) {
                return false;
            }
            UklibPublicationWithoutCrossCompilation uklibPublicationWithoutCrossCompilation = (UklibPublicationWithoutCrossCompilation)other;
            return this.severity == uklibPublicationWithoutCrossCompilation.severity;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UklibSourceSetStructureUnderRefinementViolation;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "missingRefinements", "", "kotlin-gradle-plugin_common"})
    public static final class UklibSourceSetStructureUnderRefinementViolation
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UklibSourceSetStructureUnderRefinementViolation INSTANCE = new UklibSourceSetStructureUnderRefinementViolation();

        private UklibSourceSetStructureUnderRefinementViolation() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull KotlinSourceSet sourceSet, @NotNull List<? extends KotlinSourceSet> missingRefinements) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            Intrinsics.checkNotNullParameter(missingRefinements, (String)"missingRefinements");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(sourceSet, missingRefinements){
                final /* synthetic */ KotlinSourceSet $sourceSet;
                final /* synthetic */ List<KotlinSourceSet> $missingRefinements;
                {
                    this.$sourceSet = $sourceSet;
                    this.$missingRefinements = $missingRefinements;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Uklib Incompatible Source Set Structure").description(StringsKt.trimIndent((String)("\n                    Source set '" + this.$sourceSet.getName() + "' must refine (declare dependsOn) all more general source sets. Edges to the following source sets are missing: " + CollectionsKt.joinToString$default((Iterable)this.$missingRefinements, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.1.INSTANCE, (int)30, null) + ".\n                    \n                    For example:\n                    \n                    kotlin {\n                        jvm()\n                        linuxArm64()\n                        linuxX64()\n        \n                        // customLinuxMain is used in compilation of \"linuxArm64\" and \"linuxX64\"\n                        val customLinuxMain by sourceSets.creating\n                        sourceSets.linuxArm64Main.get().dependsOn(customLinuxMain)\n                        sourceSets.linuxX64Main.get().dependsOn(customLinuxMain)\n        \n                        // commonMain is used in compilation of all targets. This means the following dependsOn must exist for a Uklib to be publishable \n                        customLinuxMain.dependsOn(sourceSets.commonMain.get())\n                    }\n                    "))).solution("Make sure '" + this.$sourceSet.getName() + "' forms a compliant structure using https://kotl.in/hierarchy-template or by declaring dependsOn edges. Let us know in https://kotl.in/uklib-source-set-structure if this is not possible in your project");
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UnknownAppleFrameworkBuildType;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "envConfiguration", "", "kotlin-gradle-plugin_common"})
    public static final class UnknownAppleFrameworkBuildType
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UnknownAppleFrameworkBuildType INSTANCE = new UnknownAppleFrameworkBuildType();

        private UnknownAppleFrameworkBuildType() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String envConfiguration) {
            Intrinsics.checkNotNullParameter((Object)envConfiguration, (String)"envConfiguration");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(envConfiguration){
                final /* synthetic */ String $envConfiguration;
                {
                    this.$envConfiguration = $envConfiguration;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Unable to Detect Apple Framework Build Type").description((Function0<String>)((Function0)new Function0<String>(this.$envConfiguration){
                        final /* synthetic */ String $envConfiguration;
                        {
                            this.$envConfiguration = $envConfiguration;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Unable to detect Kotlin framework build type for CONFIGURATION=" + this.$envConfiguration + " automatically.\n                    Specify 'KOTLIN_FRAMEWORK_BUILD_TYPE' to 'debug' or 'release'\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UnrecognizedKotlinNativeDistributionType;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "actualValue", "", "kotlin-gradle-plugin_common"})
    public static final class UnrecognizedKotlinNativeDistributionType
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UnrecognizedKotlinNativeDistributionType INSTANCE = new UnrecognizedKotlinNativeDistributionType();

        private UnrecognizedKotlinNativeDistributionType() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String actualValue) {
            Intrinsics.checkNotNullParameter((Object)actualValue, (String)"actualValue");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(actualValue){
                final /* synthetic */ String $actualValue;
                {
                    this.$actualValue = $actualValue;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Unrecognized Kotlin/Native Distribution Type").description((Function0<String>)((Function0)new Function0<String>(this.$actualValue){
                        final /* synthetic */ String $actualValue;
                        {
                            this.$actualValue = $actualValue;
                            super(0);
                        }

                        public final String invoke() {
                            return "Gradle Property `kotlin.native.distribution.type` sets unknown Kotlin/Native distribution type: " + this.$actualValue;
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UnusedSourceSetsWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "sourceSetNames", "", "", "kotlin-gradle-plugin_common"})
    public static final class UnusedSourceSetsWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UnusedSourceSetsWarning INSTANCE = new UnusedSourceSetsWarning();

        private UnusedSourceSetsWarning() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull Collection<String> sourceSetNames) {
            Intrinsics.checkNotNullParameter(sourceSetNames, (String)"sourceSetNames");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(sourceSetNames){
                final /* synthetic */ Collection<String> $sourceSetNames;
                {
                    this.$sourceSetNames = $sourceSetNames;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Unused Kotlin Source Sets").description((Function0<String>)((Function0)new Function0<String>(this.$sourceSetNames){
                        final /* synthetic */ Collection<String> $sourceSetNames;
                        {
                            this.$sourceSetNames = $sourceSetNames;
                            super(0);
                        }

                        public final String invoke() {
                            String string;
                            if (this.$sourceSetNames.size() == 1) {
                                string = "The Kotlin source set " + (String)CollectionsKt.single((Iterable)this.$sourceSetNames) + " was configured but not added to any Kotlin compilation.\n";
                            } else {
                                String sourceSetNamesString2 = CollectionsKt.joinToString$default((Iterable)this.$sourceSetNames, (CharSequence)"\n", null, null, (int)0, null, (Function1)invoke.sourceSetNamesString.1.INSTANCE, (int)30, null);
                                string = "The following Kotlin source sets were configured but not added to any Kotlin compilation:\n" + sourceSetNamesString2;
                            }
                            return string;
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/connecting-source-sets"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$UsingOutOfProcessDisablesBuildToolsApi;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "kotlin-gradle-plugin_common"})
    public static final class UsingOutOfProcessDisablesBuildToolsApi
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final UsingOutOfProcessDisablesBuildToolsApi INSTANCE = new UsingOutOfProcessDisablesBuildToolsApi();

        private UsingOutOfProcessDisablesBuildToolsApi() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Deprecation.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke() {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, invoke.1.INSTANCE, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$WarnFailToConfigureJavaTestFixturesPlugin;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "testFixturesSourceSetName", "", "kotlin-gradle-plugin_common"})
    public static final class WarnFailToConfigureJavaTestFixturesPlugin
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final WarnFailToConfigureJavaTestFixturesPlugin INSTANCE = new WarnFailToConfigureJavaTestFixturesPlugin();

        private WarnFailToConfigureJavaTestFixturesPlugin() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String testFixturesSourceSetName) {
            Intrinsics.checkNotNullParameter((Object)testFixturesSourceSetName, (String)"testFixturesSourceSetName");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(testFixturesSourceSetName){
                final /* synthetic */ String $testFixturesSourceSetName;
                {
                    this.$testFixturesSourceSetName = $testFixturesSourceSetName;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Failed to configure 'java-test-fixtures' plugin").description("Failed to add to 'java-test-fixtures' plugin source set " + this.$testFixturesSourceSetName + " Kotlin outputs.").solution("Please create a new Kotlin issue for this problem: https://kotl.in/issue");
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$WasmJsEnvironmentNotChosenExplicitly;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$JsLikeEnvironmentNotChosenExplicitly;", "()V", "kotlin-gradle-plugin_common"})
    public static final class WasmJsEnvironmentNotChosenExplicitly
    extends JsLikeEnvironmentNotChosenExplicitly {
        @NotNull
        public static final WasmJsEnvironmentNotChosenExplicitly INSTANCE = new WasmJsEnvironmentNotChosenExplicitly();

        private WasmJsEnvironmentNotChosenExplicitly() {
            super("WebAssembly-JavaScript", "wasmJs");
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$WasmSourceSetsNotFoundError;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "nameOfRequestedSourceSet", "", "kotlin-gradle-plugin_common"})
    public static final class WasmSourceSetsNotFoundError
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final WasmSourceSetsNotFoundError INSTANCE = new WasmSourceSetsNotFoundError();

        private WasmSourceSetsNotFoundError() {
            super(ToolingDiagnostic.Severity.ERROR, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String nameOfRequestedSourceSet) {
            Intrinsics.checkNotNullParameter((Object)nameOfRequestedSourceSet, (String)"nameOfRequestedSourceSet");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(nameOfRequestedSourceSet){
                final /* synthetic */ String $nameOfRequestedSourceSet;
                {
                    this.$nameOfRequestedSourceSet = $nameOfRequestedSourceSet;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Wasm Source Sets Missing Due to Renaming in Kotlin 1.9.20").description((Function0<String>)((Function0)new Function0<String>(this.$nameOfRequestedSourceSet){
                        final /* synthetic */ String $nameOfRequestedSourceSet;
                        {
                            this.$nameOfRequestedSourceSet = $nameOfRequestedSourceSet;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    KotlinSourceSet with name '" + this.$nameOfRequestedSourceSet + "' not found:\n                    The SourceSet requested ('" + this.$nameOfRequestedSourceSet + "') was renamed in Kotlin 1.9.20\n                    \n                    In order to migrate you might want to replace: \n                    val wasmMain by getting -> val wasmJsMain by getting\n                    val wasmTest by getting -> val wasmJsTest by getting\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$WasmWasiEnvironmentNotChosenExplicitly;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$JsLikeEnvironmentNotChosenExplicitly;", "()V", "kotlin-gradle-plugin_common"})
    public static final class WasmWasiEnvironmentNotChosenExplicitly
    extends JsLikeEnvironmentNotChosenExplicitly {
        @NotNull
        public static final WasmWasiEnvironmentNotChosenExplicitly INSTANCE = new WasmWasiEnvironmentNotChosenExplicitly();

        private WasmWasiEnvironmentNotChosenExplicitly() {
            super("WebAssembly WASI", "wasmWasi");
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$XCFrameworkDifferentInnerFrameworksName;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "xcFramework", "", "innerFrameworks", "kotlin-gradle-plugin_common"})
    public static final class XCFrameworkDifferentInnerFrameworksName
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final XCFrameworkDifferentInnerFrameworksName INSTANCE = new XCFrameworkDifferentInnerFrameworksName();

        private XCFrameworkDifferentInnerFrameworksName() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String xcFramework, @NotNull String innerFrameworks) {
            Intrinsics.checkNotNullParameter((Object)xcFramework, (String)"xcFramework");
            Intrinsics.checkNotNullParameter((Object)innerFrameworks, (String)"innerFrameworks");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(xcFramework, innerFrameworks){
                final /* synthetic */ String $xcFramework;
                final /* synthetic */ String $innerFrameworks;
                {
                    this.$xcFramework = $xcFramework;
                    this.$innerFrameworks = $innerFrameworks;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("XCFramework Name Mismatch with Inner Frameworks").description((Function0<String>)((Function0)new Function0<String>(this.$xcFramework, this.$innerFrameworks){
                        final /* synthetic */ String $xcFramework;
                        final /* synthetic */ String $innerFrameworks;
                        {
                            this.$xcFramework = $xcFramework;
                            this.$innerFrameworks = $innerFrameworks;
                            super(0);
                        }

                        public final String invoke() {
                            return "Name of XCFramework '" + this.$xcFramework + "' differs from inner frameworks name '" + this.$innerFrameworks + "'! Framework renaming is not supported yet";
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$XcodeUserScriptSandboxingDiagnostic;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "userScriptSandboxingEnabled", "", "kotlin-gradle-plugin_common"})
    public static final class XcodeUserScriptSandboxingDiagnostic
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final XcodeUserScriptSandboxingDiagnostic INSTANCE = new XcodeUserScriptSandboxingDiagnostic();

        private XcodeUserScriptSandboxingDiagnostic() {
            super(ToolingDiagnostic.Severity.FATAL, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(boolean userScriptSandboxingEnabled) {
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(userScriptSandboxingEnabled){
                final /* synthetic */ boolean $userScriptSandboxingEnabled;
                {
                    this.$userScriptSandboxingEnabled = $userScriptSandboxingEnabled;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("User Script Sandboxing Enabled in Xcode Project").description((Function0<String>)((Function0)new Function0<String>(this.$userScriptSandboxingEnabled){
                        final /* synthetic */ boolean $userScriptSandboxingEnabled;
                        {
                            this.$userScriptSandboxingEnabled = $userScriptSandboxingEnabled;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    " + (this.$userScriptSandboxingEnabled ? "You" : "BUILT_PRODUCTS_DIR is not accessible, probably you") + " have sandboxing for user scripts enabled.\n                    \n                    In your Xcode project, navigate to \"Build Setting\",\n                    and under \"Build Options\" set \"User script sandboxing\" (ENABLE_USER_SCRIPT_SANDBOXING) to \"NO\".\n                    Then, run \"./gradlew --stop\" to stop the Gradle daemon\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE)).documentationLink(new URI("https://kotl.in/iq4uke"), (Function1<? super String, String>)((Function1)invoke.3.INSTANCE));
                }
            }, 15, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/KotlinToolingDiagnostics$XcodeVersionTooHighWarning;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnosticFactory;", "()V", "invoke", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/ToolingDiagnostic;", "xcodeVersionString", "", "maxTested", "kotlin-gradle-plugin_common"})
    public static final class XcodeVersionTooHighWarning
    extends ToolingDiagnosticFactory {
        @NotNull
        public static final XcodeVersionTooHighWarning INSTANCE = new XcodeVersionTooHighWarning();

        private XcodeVersionTooHighWarning() {
            super(ToolingDiagnostic.Severity.WARNING, DiagnosticGroup.Kgp.Misconfiguration.INSTANCE);
        }

        @NotNull
        public final ToolingDiagnostic invoke(@NotNull String xcodeVersionString, @NotNull String maxTested) {
            Intrinsics.checkNotNullParameter((Object)xcodeVersionString, (String)"xcodeVersionString");
            Intrinsics.checkNotNullParameter((Object)maxTested, (String)"maxTested");
            return ToolingDiagnosticFactory.build$default(this, null, null, null, null, (Function1)new Function1<ToolingDiagnostics.TitleStep, ToolingDiagnostics.OptionalStep>(xcodeVersionString, maxTested){
                final /* synthetic */ String $xcodeVersionString;
                final /* synthetic */ String $maxTested;
                {
                    this.$xcodeVersionString = $xcodeVersionString;
                    this.$maxTested = $maxTested;
                    super(1);
                }

                public final ToolingDiagnostics.OptionalStep invoke(ToolingDiagnostics.TitleStep $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.title("Xcode Version Too High for Kotlin Gradle Plugin").description((Function0<String>)((Function0)new Function0<String>(this.$xcodeVersionString, this.$maxTested){
                        final /* synthetic */ String $xcodeVersionString;
                        final /* synthetic */ String $maxTested;
                        {
                            this.$xcodeVersionString = $xcodeVersionString;
                            this.$maxTested = $maxTested;
                            super(0);
                        }

                        public final String invoke() {
                            return StringsKt.trimIndent((String)("\n                    Kotlin <-> Xcode compatibility issue:\n                    The selected Xcode version (" + this.$xcodeVersionString + ") is higher than the maximum known to the Kotlin Gradle Plugin.\n                    Stability in such configuration hasn't been tested, please report encountered issues to https://kotl.in/issue\n                    \n                    Maximum tested Xcode version: " + this.$maxTested + "\n                    "));
                        }
                    })).solution((Function0<String>)((Function0)invoke.2.INSTANCE));
                }
            }, 15, null);
        }
    }
}

