/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.publishing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.signatory.Signatory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.publishing.CheckPomTask;
import org.jetbrains.kotlin.gradle.tasks.publishing.CheckSigningTask;
import org.jetbrains.kotlin.gradle.tasks.publishing.GeneratePgpKeys;
import org.jetbrains.kotlin.gradle.tasks.publishing.HelpersKt;
import org.jetbrains.kotlin.gradle.tasks.publishing.UploadPgpKeyTask;
import org.jetbrains.kotlin.gradle.utils.ConfigurationsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\f\u0010\b\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"keyIdToHex", "", "keyId", "", "addPgpSignatureHelpers", "", "Lorg/gradle/api/Project;", "addPomValidationHelpers", "addSigningValidationHelpers", "maybeCreateBcConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nhelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 helpers.kt\norg/jetbrains/kotlin/gradle/tasks/publishing/HelpersKt\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,139:1\n263#2:140\n*S KotlinDebug\n*F\n+ 1 helpers.kt\norg/jetbrains/kotlin/gradle/tasks/publishing/HelpersKt\n*L\n56#1:140\n*E\n"})
public final class HelpersKt {
    public static final void addPgpSignatureHelpers(@NotNull Project $this$addPgpSignatureHelpers) {
        Intrinsics.checkNotNullParameter((Object)$this$addPgpSignatureHelpers, (String)"<this>");
        Configuration bcConfiguration = HelpersKt.maybeCreateBcConfiguration($this$addPgpSignatureHelpers);
        Provider pgpDirectory = $this$addPgpSignatureHelpers.getProject().getLayout().getBuildDirectory().dir("pgp");
        $this$addPgpSignatureHelpers.getProject().getTasks().register("generatePgpKeys", GeneratePgpKeys.class, new Action((Provider<Directory>)pgpDirectory, $this$addPgpSignatureHelpers, bcConfiguration){
            final /* synthetic */ Provider<Directory> $pgpDirectory;
            final /* synthetic */ Project $this_addPgpSignatureHelpers;
            final /* synthetic */ Configuration $bcConfiguration;
            {
                this.$pgpDirectory = $pgpDirectory;
                this.$this_addPgpSignatureHelpers = $receiver;
                this.$bcConfiguration = $bcConfiguration;
            }

            public final void execute(GeneratePgpKeys it) {
                it.notCompatibleWithConfigurationCache("Do not cache password.");
                it.getOutputDirectory().set(this.$pgpDirectory);
                it.getPassword().set(this.$this_addPgpSignatureHelpers.getProject().getProviders().gradleProperty("signing.password"));
                Object[] objectArray = new Object[]{this.$bcConfiguration};
                it.getBouncyCastleClasspath().from(objectArray);
                it.getGradleHomePath().set((Object)this.$this_addPgpSignatureHelpers.getProject().getGradle().getGradleUserHomeDir().getAbsolutePath());
                it.setGroup("signing");
                it.setDescription(StringsKt.trimIndent((String)"\n            Generates a new PGP keypair.\n            \n            Usage: \n            gradlew generatePgpKeys --name \"Jane Doe <janedoe@example.com>\" --password YOUR_PASSWORD\n        "));
            }
        });
        if (!$this$addPgpSignatureHelpers.getGradle().getStartParameter().isOffline()) {
            $this$addPgpSignatureHelpers.getProject().getTasks().register("uploadPublicPgpKey", UploadPgpKeyTask.class, (Action)addPgpSignatureHelpers.2.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void addSigningValidationHelpers(@NotNull Project $this$addSigningValidationHelpers) {
        void name$iv;
        void $this$register$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addSigningValidationHelpers, (String)"<this>");
        Configuration bcConfiguration = HelpersKt.maybeCreateBcConfiguration($this$addSigningValidationHelpers);
        TaskContainer taskContainer = $this$addSigningValidationHelpers.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "checkSigningConfiguration";
        Function1 configuration$iv = (Function1)new Function1<CheckSigningTask, Unit>(bcConfiguration, $this$addSigningValidationHelpers){
            final /* synthetic */ Configuration $bcConfiguration;
            final /* synthetic */ Project $this_addSigningValidationHelpers;
            {
                this.$bcConfiguration = $bcConfiguration;
                this.$this_addSigningValidationHelpers = $receiver;
                super(1);
            }

            public final void invoke(CheckSigningTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("validation");
                $this$register.setDescription("Checks that a signing configuration is set up correctly.");
                Object[] objectArray = new Object[]{this.$bcConfiguration};
                $this$register.getBouncyCastleClasspath().from(objectArray);
                $this$register.getOfflineMode().set((Object)this.$this_addSigningValidationHelpers.getGradle().getStartParameter().isOffline());
                objectArray = new String[]{"https://keys.openpgp.org", "https://keyserver.ubuntu.com"};
                $this$register.getKeyservers().convention((Iterable)CollectionsKt.listOf((Object[])objectArray));
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider2 = $this$register$iv.register((String)name$iv, CheckSigningTask.class, new Action(configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"register(name, T::class.java, configuration)");
        TaskProvider signingTask2 = taskProvider2;
        $this$addSigningValidationHelpers.getProject().getPluginManager().withPlugin("signing", new Action($this$addSigningValidationHelpers, (TaskProvider<CheckSigningTask>)signingTask2){
            final /* synthetic */ Project $this_addSigningValidationHelpers;
            final /* synthetic */ TaskProvider<CheckSigningTask> $signingTask;
            {
                this.$this_addSigningValidationHelpers = $receiver;
                this.$signingTask = $signingTask;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(AppliedPlugin it) {
                void $this$getExtension$iv;
                Project project = this.$this_addSigningValidationHelpers.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                Project project2 = project;
                String name$iv = "signing";
                boolean $i$f$getExtension = false;
                SigningExtension signingExtension = (SigningExtension)((ExtensionAware)$this$getExtension$iv).getExtensions().getByName(name$iv);
                if (signingExtension != null) {
                    project2 = signingExtension;
                    TaskProvider<CheckSigningTask> taskProvider2 = this.$signingTask;
                    Project project3 = this.$this_addSigningValidationHelpers;
                    Project signing = project2;
                    boolean bl = false;
                    taskProvider2.configure(new Action(project3, (SigningExtension)signing){
                        final /* synthetic */ Project $this_addSigningValidationHelpers;
                        final /* synthetic */ SigningExtension $signing;
                        {
                            this.$this_addSigningValidationHelpers = $receiver;
                            this.$signing = $signing;
                        }

                        public final void execute(CheckSigningTask task2) {
                            block9: {
                                Object object;
                                Object it;
                                Object object2;
                                Unit unit;
                                Object object3;
                                Object object4;
                                Object it2;
                                Signatory signatory;
                                task2.getGradleHomePath().set((Object)this.$this_addSigningValidationHelpers.getProject().getGradle().getGradleUserHomeDir().getAbsolutePath());
                                try {
                                    signatory = this.$signing.getSignatory();
                                }
                                catch (Exception e) {
                                    this.$this_addSigningValidationHelpers.getLogger().warn("Failed to create signatory: " + e.getMessage());
                                    signatory = null;
                                }
                                Signatory signatory2 = signatory;
                                task2.getSignatoryExists().set((Object)(signatory2 != null ? 1 : 0));
                                Object object5 = this.$this_addSigningValidationHelpers.findProperty("signing.keyId");
                                if (object5 != null && (object5 = object5.toString()) != null) {
                                    it2 = object5;
                                    boolean bl = false;
                                    task2.getKeyId().set(it2);
                                }
                                if ((object4 = this.$this_addSigningValidationHelpers.findProperty("signing.secretKeyRingFile")) != null && (object4 = object4.toString()) != null) {
                                    Object object6 = object4;
                                    it2 = this.$this_addSigningValidationHelpers;
                                    Object it3 = object6;
                                    boolean bl = false;
                                    task2.getKeyringPath().set(it2.file(it3));
                                }
                                if ((object3 = this.$this_addSigningValidationHelpers.findProperty("signing.password")) != null && (object3 = object3.toString()) != null) {
                                    Object it4 = object3;
                                    boolean bl = false;
                                    task2.getHasKeyPassword().set((Object)true);
                                    unit = Unit.INSTANCE;
                                } else {
                                    unit = null;
                                }
                                if (unit == null) {
                                    task2.getHasKeyPassword().set((Object)false);
                                }
                                if ((object2 = signatory2) != null && (object2 = object2.getKeyId()) != null) {
                                    it = object2;
                                    boolean bl = false;
                                    task2.getSignatoryKeyId().set(it);
                                }
                                if ((object = signatory2) == null) break block9;
                                String string = "example";
                                it = Charsets.UTF_8;
                                byte[] byArray = string.getBytes((Charset)it);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                byte[] byArray2 = object.sign((InputStream)new ByteArrayInputStream(byArray));
                                object = byArray2;
                                if (byArray2 != null) {
                                    it = object;
                                    boolean bl = false;
                                    task2.getExampleSignature().set(it);
                                }
                            }
                        }
                    });
                }
                this.$this_addSigningValidationHelpers.getProject().getPluginManager().withPlugin("maven-publish", new Action(this.$this_addSigningValidationHelpers, this.$signingTask){
                    final /* synthetic */ Project $this_addSigningValidationHelpers;
                    final /* synthetic */ TaskProvider<CheckSigningTask> $signingTask;
                    {
                        this.$this_addSigningValidationHelpers = $receiver;
                        this.$signingTask = $signingTask;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(AppliedPlugin it) {
                        block0: {
                            void $this$getExtension$iv;
                            Project project = this.$this_addSigningValidationHelpers.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                            Project project2 = project;
                            String name$iv = "publishing";
                            boolean $i$f$getExtension = false;
                            PublishingExtension publishingExtension = (PublishingExtension)((ExtensionAware)$this$getExtension$iv).getExtensions().getByName(name$iv);
                            if (publishingExtension == null) break block0;
                            project2 = publishingExtension;
                            Project project3 = this.$this_addSigningValidationHelpers;
                            TaskProvider<CheckSigningTask> taskProvider2 = this.$signingTask;
                            Project publishing = project2;
                            boolean bl = false;
                            project3.afterEvaluate(new Action((PublishingExtension)publishing, taskProvider2, project3){
                                final /* synthetic */ PublishingExtension $publishing;
                                final /* synthetic */ TaskProvider<CheckSigningTask> $signingTask;
                                final /* synthetic */ Project $this_addSigningValidationHelpers;
                                {
                                    this.$publishing = $publishing;
                                    this.$signingTask = $signingTask;
                                    this.$this_addSigningValidationHelpers = $receiver;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void execute(Project it) {
                                    void $this$associateTo$iv$iv;
                                    void $this$associate$iv;
                                    void $this$filterIsInstanceTo$iv$iv;
                                    PublicationContainer publicationContainer = this.$publishing.getPublications();
                                    Intrinsics.checkNotNullExpressionValue((Object)publicationContainer, (String)"publishing.publications");
                                    Iterable $this$filterIsInstance$iv = (Iterable)publicationContainer;
                                    boolean $i$f$filterIsInstance = false;
                                    Iterable iterable = $this$filterIsInstance$iv;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    boolean $i$f$filterIsInstanceTo22 = false;
                                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                        if (!(element$iv$iv instanceof MavenPublication)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                                    Project project = this.$this_addSigningValidationHelpers;
                                    boolean $i$f$associate = false;
                                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                                    void $i$f$filterIsInstanceTo22 = $this$associate$iv;
                                    Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                                    boolean $i$f$associateTo = false;
                                    for (T element$iv$iv : $this$associateTo$iv$iv) {
                                        Map map = destination$iv$iv2;
                                        MavenPublication it2 = (MavenPublication)element$iv$iv;
                                        boolean bl = false;
                                        String string = it2.getName();
                                        TaskContainer taskContainer = project.getTasks();
                                        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
                                        TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                                        boolean $i$f$withType = false;
                                        TaskCollection taskCollection = $this$withType$iv.withType(Sign.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                                        StringBuilder stringBuilder = new StringBuilder().append("sign");
                                        String string2 = it2.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                                        Pair pair = TuplesKt.to((Object)string, (Object)(taskCollection.findByName(stringBuilder.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string2)).append("Publication").toString()) != null ? 1 : 0));
                                        map.put(pair.getFirst(), pair.getSecond());
                                    }
                                    Map publicationSigning = destination$iv$iv2;
                                    this.$signingTask.configure(new Action(publicationSigning){
                                        final /* synthetic */ Map<String, Boolean> $publicationSigning;
                                        {
                                            this.$publicationSigning = $publicationSigning;
                                        }

                                        public final void execute(CheckSigningTask it) {
                                            it.getPublicationNamesWithSigning().set(this.$publicationSigning);
                                        }
                                    });
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public static final void addPomValidationHelpers(@NotNull Project $this$addPomValidationHelpers) {
        Intrinsics.checkNotNullParameter((Object)$this$addPomValidationHelpers, (String)"<this>");
        $this$addPomValidationHelpers.getProject().getPluginManager().withPlugin("maven-publish", new Action($this$addPomValidationHelpers){
            final /* synthetic */ Project $this_addPomValidationHelpers;
            {
                this.$this_addPomValidationHelpers = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(AppliedPlugin it) {
                block0: {
                    void $this$getExtension$iv;
                    Project project = this.$this_addPomValidationHelpers.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    Project project2 = project;
                    String name$iv = "publishing";
                    boolean $i$f$getExtension = false;
                    PublishingExtension publishingExtension = (PublishingExtension)((ExtensionAware)$this$getExtension$iv).getExtensions().getByName(name$iv);
                    if (publishingExtension == null) break block0;
                    project2 = publishingExtension;
                    Project project3 = this.$this_addPomValidationHelpers;
                    Project publishing = project2;
                    boolean bl = false;
                    PublicationContainer publicationContainer = publishing.getPublications();
                    Intrinsics.checkNotNullExpressionValue((Object)publicationContainer, (String)"publishing.publications");
                    NamedDomainObjectCollection $this$withType$iv = (NamedDomainObjectCollection)publicationContainer;
                    boolean $i$f$withType = false;
                    NamedDomainObjectCollection namedDomainObjectCollection = $this$withType$iv.withType(MavenPublication.class);
                    Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectCollection, (String)"withType(S::class.java)");
                    namedDomainObjectCollection.configureEach(new Action(project3){
                        final /* synthetic */ Project $this_addPomValidationHelpers;
                        {
                            this.$this_addPomValidationHelpers = $receiver;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void execute(MavenPublication publication) {
                            void name$iv;
                            void $this$register$iv;
                            StringBuilder stringBuilder = new StringBuilder();
                            String string = publication.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publication.name");
                            String capitalizedPublicationName = stringBuilder.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string)).append("Publication").toString();
                            String generatePomTaskName = "generatePomFileFor" + capitalizedPublicationName;
                            TaskContainer taskContainer = this.$this_addPomValidationHelpers.getTasks();
                            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
                            TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                            boolean $i$f$withType22 = false;
                            TaskCollection taskCollection = $this$withType$iv.withType(GenerateMavenPom.class);
                            Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                            TaskProvider generatePomTask = taskCollection.named(generatePomTaskName);
                            TaskContainer taskContainer2 = this.$this_addPomValidationHelpers.getProject().getTasks();
                            Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"project.tasks");
                            $this$withType$iv = taskContainer2;
                            StringBuilder stringBuilder2 = new StringBuilder().append("checkPomFileFor");
                            String string2 = publication.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"publication.name");
                            String $i$f$withType22 = stringBuilder2.append(CapitalizeDecapitalizeKt.capitalizeAsciiOnly(string2)).append("Publication").toString();
                            Function1 configuration$iv = (Function1)new Function1<CheckPomTask, Unit>((TaskProvider<GenerateMavenPom>)generatePomTask){
                                final /* synthetic */ TaskProvider<GenerateMavenPom> $generatePomTask;
                                {
                                    this.$generatePomTask = $generatePomTask;
                                    super(1);
                                }

                                public final void invoke(CheckPomTask $this$register) {
                                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                                    Object[] objectArray = new Object[]{this.$generatePomTask};
                                    $this$register.dependsOn(objectArray);
                                    $this$register.setGroup("validation");
                                    $this$register.getPom().set(this.$generatePomTask.map((Transformer)addPomValidationHelpers.1.1.INSTANCE));
                                }
                            };
                            boolean $i$f$register = false;
                            Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register((String)name$iv, CheckPomTask.class, new Action(configuration$iv){
                                private final /* synthetic */ Function1 function;
                                {
                                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                                    this.function = function;
                                }

                                public final /* synthetic */ void execute(Object p0) {
                                    this.function.invoke(p0);
                                }
                            }), (String)"register(name, T::class.java, configuration)");
                        }
                    });
                }
            }
        });
    }

    @NotNull
    public static final String keyIdToHex(long keyId) {
        String string = UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)keyId), (int)16).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return StringsKt.padStart((String)string, (int)16, (char)'0');
    }

    private static final Configuration maybeCreateBcConfiguration(Project $this$maybeCreateBcConfiguration) {
        ConfigurationContainer configurationContainer = $this$maybeCreateBcConfiguration.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        return ConfigurationsKt.maybeCreateResolvable(configurationContainer, "kotlinBouncyCastleConfiguration", (Function1<? super Configuration, Unit>)((Function1)new Function1<Configuration, Unit>($this$maybeCreateBcConfiguration){
            final /* synthetic */ Project $this_maybeCreateBcConfiguration;
            {
                this.$this_maybeCreateBcConfiguration = $receiver;
                super(1);
            }

            public final void invoke(Configuration $this$maybeCreateResolvable) {
                ObjectFactory $this$named$iv;
                Intrinsics.checkNotNullParameter((Object)$this$maybeCreateResolvable, (String)"$this$maybeCreateResolvable");
                AttributeContainer attributeContainer = $this$maybeCreateResolvable.getAttributes();
                ObjectFactory objectFactory = this.$this_maybeCreateBcConfiguration.getProject().getObjects();
                Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
                ObjectFactory objectFactory2 = objectFactory;
                String name$iv = "library";
                boolean $i$f$named = false;
                Named named = $this$named$iv.named(Category.class, name$iv);
                Intrinsics.checkNotNullExpressionValue((Object)named, (String)"named(T::class.java, name)");
                attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)named);
                AttributeContainer attributeContainer2 = $this$maybeCreateResolvable.getAttributes();
                ObjectFactory objectFactory3 = this.$this_maybeCreateBcConfiguration.getProject().getObjects();
                Intrinsics.checkNotNullExpressionValue((Object)objectFactory3, (String)"project.objects");
                $this$named$iv = objectFactory3;
                name$iv = "java-runtime";
                $i$f$named = false;
                Named named2 = $this$named$iv.named(Usage.class, name$iv);
                Intrinsics.checkNotNullExpressionValue((Object)named2, (String)"named(T::class.java, name)");
                attributeContainer2.attribute(Usage.USAGE_ATTRIBUTE, (Object)named2);
                AttributeContainer attributeContainer3 = $this$maybeCreateResolvable.getAttributes();
                ObjectFactory objectFactory4 = this.$this_maybeCreateBcConfiguration.getProject().getObjects();
                Intrinsics.checkNotNullExpressionValue((Object)objectFactory4, (String)"project.objects");
                $this$named$iv = objectFactory4;
                name$iv = "jar";
                $i$f$named = false;
                Named named3 = $this$named$iv.named(LibraryElements.class, name$iv);
                Intrinsics.checkNotNullExpressionValue((Object)named3, (String)"named(T::class.java, name)");
                attributeContainer3.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)named3);
                $this$maybeCreateResolvable.setDescription("Bouncy Castle dependencies used internally for library publishing validation tasks. Not used during compilation.");
                $this$maybeCreateResolvable.defaultDependencies(new Action(this.$this_maybeCreateBcConfiguration){
                    final /* synthetic */ Project $this_maybeCreateBcConfiguration;
                    {
                        this.$this_maybeCreateBcConfiguration = $receiver;
                    }

                    public final void execute(DependencySet it) {
                        it.add((Object)this.$this_maybeCreateBcConfiguration.getProject().getDependencies().create((Object)"org.bouncycastle:bcpkix-jdk18on:1.80"));
                        it.add((Object)this.$this_maybeCreateBcConfiguration.getProject().getDependencies().create((Object)"org.bouncycastle:bcpg-jdk18on:1.80"));
                    }
                });
            }
        }));
    }
}

