/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.resolve.constants;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.gradle.internal.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.ByteValue;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.IntValue;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.LongValue;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.ShortValue;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.UByteValue;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.UIntValue;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.ULongValue;
import org.jetbrains.kotlin.gradle.internal.resolve.constants.UShortValue;
import org.jetbrains.kotlin.gradle.internal.types.KotlinType;
import org.jetbrains.kotlin.gradle.internal.types.KotlinTypeFactory;
import org.jetbrains.kotlin.gradle.internal.types.SimpleType;
import org.jetbrains.kotlin.gradle.internal.types.TypeAttributes;
import org.jetbrains.kotlin.gradle.internal.types.TypeConstructor;
import org.jetbrains.kotlin.gradle.internal.types.TypeUtils;
import org.jetbrains.kotlin.gradle.internal.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.gradle.internal.types.error.ErrorUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001'B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018J\n\u0010\u001e\u001a\u00020\u001fH\u0096\u0080\u0004J\u0014\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0082\u0004J\n\u0010#\u001a\u00020$H\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010%\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/IntegerValueTypeConstant;", "Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/CompileTimeConstant;", "", "value", "moduleDescriptor", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/ModuleDescriptor;", "parameters", "Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/CompileTimeConstant$Parameters;", "newInferenceEnabled", "", "convertedFromSigned", "<init>", "(Ljava/lang/Number;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;ZZ)V", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "getConvertedFromSigned", "()Z", "typeConstructor", "Lorg/jetbrains/kotlin/gradle/internal/types/TypeConstructor;", "toConstantValue", "Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/ConstantValue;", "expectedType", "Lorg/jetbrains/kotlin/gradle/internal/types/KotlinType;", "unknownIntegerType", "Lorg/jetbrains/kotlin/gradle/internal/types/SimpleType;", "getUnknownIntegerType", "()Lorg/jetbrains/kotlin/types/SimpleType;", "getType", "toString", "", "equals", "other", "", "hashCode", "", "hasIntegerLiteralType", "getHasIntegerLiteralType", "Companion", "descriptors"})
public final class IntegerValueTypeConstant
implements CompileTimeConstant<Number> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Number value;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;
    private final boolean newInferenceEnabled;
    private final boolean convertedFromSigned;
    @NotNull
    private final TypeConstructor typeConstructor;
    @NotNull
    private final SimpleType unknownIntegerType;

    public IntegerValueTypeConstant(@NotNull Number value2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull CompileTimeConstant.Parameters parameters, boolean newInferenceEnabled, boolean convertedFromSigned) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.value = value2;
        this.moduleDescriptor = moduleDescriptor;
        this.parameters = parameters;
        this.newInferenceEnabled = newInferenceEnabled;
        this.convertedFromSigned = convertedFromSigned;
        this.typeConstructor = this.newInferenceEnabled ? (TypeConstructor)new IntegerLiteralTypeConstructor(this.value.longValue(), this.getModuleDescriptor(), this.getParameters()) : (TypeConstructor)new IntegerValueTypeConstructor(this.value.longValue(), this.getModuleDescriptor(), this.getParameters());
        String[] stringArray = new String[]{this.typeConstructor.toString()};
        this.unknownIntegerType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), this.typeConstructor, CollectionsKt.emptyList(), false, ErrorUtils.createErrorScope(ErrorScopeKind.INTEGER_LITERAL_TYPE_SCOPE, true, stringArray));
    }

    public /* synthetic */ IntegerValueTypeConstant(Number number, ModuleDescriptor moduleDescriptor, CompileTimeConstant.Parameters parameters, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(number, moduleDescriptor, parameters, bl, bl2);
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public final boolean getConvertedFromSigned() {
        return this.convertedFromSigned;
    }

    @Override
    @NotNull
    public ConstantValue<Number> toConstantValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        KotlinType type = this.getType(expectedType);
        return KotlinBuiltIns.isInt(type) ? (ConstantValue)new IntValue(this.value.intValue()) : (KotlinBuiltIns.isByte(type) ? (ConstantValue)new ByteValue(this.value.byteValue()) : (KotlinBuiltIns.isShort(type) ? (ConstantValue)new ShortValue(this.value.shortValue()) : (KotlinBuiltIns.isLong(type) ? (ConstantValue)new LongValue(this.value.longValue()) : (KotlinBuiltIns.isUInt(type) ? (ConstantValue)new UIntValue(this.value.intValue()) : (KotlinBuiltIns.isUByte(type) ? (ConstantValue)new UByteValue(this.value.byteValue()) : (KotlinBuiltIns.isUShort(type) ? (ConstantValue)new UShortValue(this.value.shortValue()) : (KotlinBuiltIns.isULong(type) ? (ConstantValue)new ULongValue(this.value.longValue()) : (ConstantValue)new LongValue(this.value.longValue()))))))));
    }

    @NotNull
    public final SimpleType getUnknownIntegerType() {
        return this.unknownIntegerType;
    }

    @NotNull
    public final KotlinType getType(@NotNull KotlinType expectedType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        if (this.newInferenceEnabled) {
            TypeConstructor typeConstructor2 = this.typeConstructor;
            Intrinsics.checkNotNull((Object)typeConstructor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor");
            KotlinType kotlinType2 = TypeUtils.getPrimitiveNumberType((IntegerLiteralTypeConstructor)typeConstructor2, expectedType);
            Intrinsics.checkNotNull((Object)kotlinType2);
            kotlinType = kotlinType2;
        } else {
            TypeConstructor typeConstructor3 = this.typeConstructor;
            Intrinsics.checkNotNull((Object)typeConstructor3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor");
            KotlinType kotlinType3 = TypeUtils.getPrimitiveNumberType((IntegerValueTypeConstructor)typeConstructor3, expectedType);
            Intrinsics.checkNotNull((Object)kotlinType3);
            kotlinType = kotlinType3;
        }
        return kotlinType;
    }

    @NotNull
    public String toString() {
        return this.typeConstructor.toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IntegerValueTypeConstant && Intrinsics.areEqual((Object)this.value, (Object)((IntegerValueTypeConstant)other).value) && Intrinsics.areEqual((Object)this.getParameters(), (Object)((IntegerValueTypeConstant)other).getParameters());
    }

    @Override
    public int hashCode() {
        return 31 * this.value.hashCode() + this.getParameters().hashCode();
    }

    @Override
    public boolean getHasIntegerLiteralType() {
        return true;
    }

    @JvmStatic
    @NotNull
    public static final IntegerValueTypeConstant convertToUnsignedConstant(@NotNull IntegerValueTypeConstant $this$convertToUnsignedConstant, @NotNull ModuleDescriptor module2) {
        return Companion.convertToUnsignedConstant($this$convertToUnsignedConstant, module2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/IntegerValueTypeConstant$Companion;", "", "<init>", "()V", "convertToUnsignedConstant", "Lorg/jetbrains/kotlin/gradle/internal/resolve/constants/IntegerValueTypeConstant;", "module", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/ModuleDescriptor;", "convertToSignedConstant", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntegerValueTypeConstant convertToUnsignedConstant(@NotNull IntegerValueTypeConstant $this$convertToUnsignedConstant, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkNotNullParameter((Object)$this$convertToUnsignedConstant, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            CompileTimeConstant.Parameters newParameters = new CompileTimeConstant.Parameters($this$convertToUnsignedConstant.getParameters().getCanBeUsedInAnnotation(), $this$convertToUnsignedConstant.getParameters().isPure(), true, $this$convertToUnsignedConstant.getParameters().isUnsignedLongNumberLiteral(), $this$convertToUnsignedConstant.getParameters().getUsesVariableAsConstant(), $this$convertToUnsignedConstant.getParameters().getUsesNonConstValAsConstant(), $this$convertToUnsignedConstant.getParameters().isConvertableConstVal());
            return new IntegerValueTypeConstant($this$convertToUnsignedConstant.value, module2, newParameters, $this$convertToUnsignedConstant.newInferenceEnabled, true);
        }

        @NotNull
        public final IntegerValueTypeConstant convertToSignedConstant(@NotNull IntegerValueTypeConstant $this$convertToSignedConstant, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkNotNullParameter((Object)$this$convertToSignedConstant, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            CompileTimeConstant.Parameters newParameters = new CompileTimeConstant.Parameters($this$convertToSignedConstant.getParameters().getCanBeUsedInAnnotation(), $this$convertToSignedConstant.getParameters().isPure(), false, $this$convertToSignedConstant.getParameters().isUnsignedLongNumberLiteral(), $this$convertToSignedConstant.getParameters().getUsesVariableAsConstant(), $this$convertToSignedConstant.getParameters().getUsesNonConstValAsConstant(), $this$convertToSignedConstant.getParameters().isConvertableConstVal());
            return new IntegerValueTypeConstant($this$convertToSignedConstant.value, module2, newParameters, $this$convertToSignedConstant.newInferenceEnabled, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

