/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.backend.common;

import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.gradle.internal.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.gradle.internal.config.CompilerConfiguration;
import org.jetbrains.kotlin.gradle.internal.config.DuplicatedUniqueNameStrategy;
import org.jetbrains.kotlin.gradle.internal.config.KlibConfigurationKeysKt;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.loader.KlibLoaderResult;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000f\u00a8\u0006\u0012"}, d2={"eliminateLibrariesWithDuplicatedUniqueNames", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult;", "configuration", "Lorg/jetbrains/kotlin/gradle/internal/config/CompilerConfiguration;", "reportLoadingProblemsIfAny", "", "allAsErrors", "", "computeSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblemCase;", "computeMessageText", "", "Lorg/jetbrains/kotlin/library/loader/KlibLoaderResult$ProblematicLibrary;", "loadFriendLibraries", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "friendLibraryPaths", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nKlibLoaderExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibLoaderExtensions.kt\norg/jetbrains/kotlin/backend/common/KlibLoaderExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1538#2,3:174\n1541#2,3:184\n1915#2,2:198\n1651#2:201\n1915#2:202\n1916#2:204\n1652#2:205\n1220#2,2:206\n1249#2,4:208\n1642#2,10:212\n1915#2:222\n1916#2:224\n1652#2:225\n383#3,7:177\n507#3,7:187\n129#4:194\n158#4,3:195\n1#5:200\n1#5:203\n1#5:223\n*S KotlinDebug\n*F\n+ 1 KlibLoaderExtensions.kt\norg/jetbrains/kotlin/backend/common/KlibLoaderExtensionsKt\n*L\n38#1:174,3\n38#1:184,3\n86#1:198,2\n157#1:201\n157#1:202\n157#1:204\n157#1:205\n169#1:206,2\n169#1:208,4\n171#1:212,10\n171#1:222\n171#1:224\n171#1:225\n38#1:177,7\n40#1:187,7\n68#1:194\n68#1:195,3\n157#1:203\n171#1:223\n*E\n"})
public final class KlibLoaderExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KlibLoaderResult eliminateLibrariesWithDuplicatedUniqueNames(@NotNull KlibLoaderResult $this$eliminateLibrariesWithDuplicatedUniqueNames, @NotNull CompilerConfiguration configuration2) {
        KlibLoaderResult klibLoaderResult;
        Map librariesByUniqueName;
        Object object;
        void $this$groupByTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$eliminateLibrariesWithDuplicatedUniqueNames, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        if ($this$eliminateLibrariesWithDuplicatedUniqueNames.getLibrariesStdlibFirst().isEmpty()) {
            return $this$eliminateLibrariesWithDuplicatedUniqueNames;
        }
        Iterable iterable = $this$eliminateLibrariesWithDuplicatedUniqueNames.getLibrariesStdlibFirst();
        Map destination$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv) {
            Object object2;
            void $this$getOrPut$iv$iv;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)t;
            boolean bl = false;
            String key$iv = KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)((BaseKotlinLibrary)kotlinLibrary));
            object = destination$iv;
            String key$iv$iv = key$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                object2 = answer$iv$iv;
            } else {
                object2 = value$iv$iv;
            }
            List list$iv = (List)object2;
            list$iv.add(t);
        }
        Map $this$filterValues$iv = librariesByUniqueName = destination$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry2 : $this$filterValues$iv.entrySet()) {
            List it = (List)entry2.getValue();
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            result$iv.put(entry2.getKey(), entry2.getValue());
        }
        Map librariesWithDuplicatedUniqueNames = result$iv;
        if (librariesWithDuplicatedUniqueNames.isEmpty()) {
            return $this$eliminateLibrariesWithDuplicatedUniqueNames;
        }
        MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector(configuration2);
        DuplicatedUniqueNameStrategy duplicatedUniqueNameStrategy = KlibConfigurationKeysKt.getDuplicatedUniqueNameStrategy(configuration2);
        if (duplicatedUniqueNameStrategy == null) {
            duplicatedUniqueNameStrategy = DuplicatedUniqueNameStrategy.DENY;
        }
        DuplicatedUniqueNameStrategy duplicatedUniqueNameStrategy2 = duplicatedUniqueNameStrategy;
        for (Map.Entry entry3 : librariesWithDuplicatedUniqueNames.entrySet()) {
            String string = (String)entry3.getKey();
            List libraries2 = (List)entry3.getValue();
            String message2 = "KLIB loader: The same 'unique_name=" + string + "' found in more than one library: " + CollectionsKt.joinToString$default((Iterable)libraries2, null, null, null, (int)0, null, KlibLoaderExtensionsKt::eliminateLibrariesWithDuplicatedUniqueNames$lambda$2, (int)31, null);
            if (duplicatedUniqueNameStrategy2 == DuplicatedUniqueNameStrategy.DENY) {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, message2 + "\nPlease file an issue to https://kotl.in/issue and meanwhile use CLI parameter -Xklib-duplicated-unique-name-strategy with one of the following values:\n" + (Object)((Object)DuplicatedUniqueNameStrategy.ALLOW_ALL_WITH_WARNING) + ": Use all KLIB dependencies, even when they have same 'unique_name' property.\n" + (Object)((Object)DuplicatedUniqueNameStrategy.ALLOW_FIRST_WITH_WARNING) + ": Use the first KLIB dependency with clashing 'unique_name' property. No order guarantees are given though.\n" + (Object)((Object)DuplicatedUniqueNameStrategy.DENY) + ": Fail a compilation with the error.", null, 4, null);
                continue;
            }
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.STRONG_WARNING, message2, null, 4, null);
        }
        if (duplicatedUniqueNameStrategy2 == DuplicatedUniqueNameStrategy.ALLOW_FIRST_WITH_WARNING) {
            Map $this$map$iv = librariesByUniqueName;
            boolean bl = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry $i$f$getOrPut = item$iv$iv = (Map.Entry)object.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add((KotlinLibrary)CollectionsKt.first((List)((List)it.getValue())));
            }
            List list = $this$eliminateLibrariesWithDuplicatedUniqueNames.getProblematicLibraries();
            List list2 = (List)destination$iv$iv;
            klibLoaderResult = new KlibLoaderResult(list2, list);
        } else {
            klibLoaderResult = $this$eliminateLibrariesWithDuplicatedUniqueNames;
        }
        return klibLoaderResult;
    }

    public static final void reportLoadingProblemsIfAny(@NotNull KlibLoaderResult $this$reportLoadingProblemsIfAny, @NotNull CompilerConfiguration configuration2, boolean allAsErrors) {
        Intrinsics.checkNotNullParameter((Object)$this$reportLoadingProblemsIfAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        if (!$this$reportLoadingProblemsIfAny.getHasProblems()) {
            return;
        }
        MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector(configuration2);
        Iterable $this$forEach$iv = $this$reportLoadingProblemsIfAny.getProblematicLibraries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KlibLoaderResult.ProblematicLibrary problematicLibrary = (KlibLoaderResult.ProblematicLibrary)element$iv;
            boolean bl = false;
            MessageCollector.report$default(messageCollector, allAsErrors ? CompilerMessageSeverity.ERROR : KlibLoaderExtensionsKt.computeSeverity(problematicLibrary.getProblemCase()), KlibLoaderExtensionsKt.computeMessageText(problematicLibrary), null, 4, null);
        }
    }

    public static /* synthetic */ void reportLoadingProblemsIfAny$default(KlibLoaderResult klibLoaderResult, CompilerConfiguration compilerConfiguration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        KlibLoaderExtensionsKt.reportLoadingProblemsIfAny(klibLoaderResult, compilerConfiguration, bl);
    }

    private static final CompilerMessageSeverity computeSeverity(KlibLoaderResult.ProblemCase $this$computeSeverity) {
        CompilerMessageSeverity compilerMessageSeverity;
        KlibLoaderResult.ProblemCase problemCase = $this$computeSeverity;
        if (Intrinsics.areEqual((Object)problemCase, (Object)KlibLoaderResult.ProblemCase.LibraryNotFound.INSTANCE) || Intrinsics.areEqual((Object)problemCase, (Object)KlibLoaderResult.ProblemCase.InvalidLibraryFormat.INSTANCE)) {
            compilerMessageSeverity = CompilerMessageSeverity.INFO;
        } else if (problemCase instanceof KlibLoaderResult.ProblemCase.PlatformCheckMismatch || problemCase instanceof KlibLoaderResult.ProblemCase.IncompatibleAbiVersion) {
            compilerMessageSeverity = CompilerMessageSeverity.STRONG_WARNING;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compilerMessageSeverity;
    }

    private static final String computeMessageText(KlibLoaderResult.ProblematicLibrary $this$computeMessageText) {
        String string;
        KlibLoaderResult.ProblemCase problemCase = $this$computeMessageText.getProblemCase();
        if (Intrinsics.areEqual((Object)problemCase, (Object)KlibLoaderResult.ProblemCase.LibraryNotFound.INSTANCE)) {
            string = "Library not found: " + $this$computeMessageText.getLibraryPath();
        } else if (Intrinsics.areEqual((Object)problemCase, (Object)KlibLoaderResult.ProblemCase.InvalidLibraryFormat.INSTANCE)) {
            string = "Not a Kotlin library, or a library with invalid format: " + $this$computeMessageText.getLibraryPath();
        } else if (problemCase instanceof KlibLoaderResult.ProblemCase.PlatformCheckMismatch) {
            KlibLoaderResult.ProblemCase.PlatformCheckMismatch $this$computeMessageText_u24lambda_u240 = (KlibLoaderResult.ProblemCase.PlatformCheckMismatch)problemCase;
            boolean bl = false;
            string = "Library failed platform-specific check: " + $this$computeMessageText.getLibraryPath() + "\nExpected " + $this$computeMessageText_u24lambda_u240.getProperty() + " is " + $this$computeMessageText_u24lambda_u240.getExpected() + " while found " + $this$computeMessageText_u24lambda_u240.getActual() + '.';
        } else if (problemCase instanceof KlibLoaderResult.ProblemCase.IncompatibleAbiVersion) {
            List list;
            Object[] objectArray;
            String string2;
            KlibLoaderResult.ProblemCase.IncompatibleAbiVersion $this$computeMessageText_u24lambda_u241 = (KlibLoaderResult.ProblemCase.IncompatibleAbiVersion)problemCase;
            boolean bl = false;
            String string3 = $this$computeMessageText_u24lambda_u241.getLibraryVersions().getCompilerVersion();
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                string2 = "The library was produced by " + it + " compiler.";
            } else {
                string2 = null;
            }
            String libraryCompilerLine = string2;
            String abiVersionCheckExplanation = $this$computeMessageText_u24lambda_u241.getMinPermittedAbiVersion() != null && $this$computeMessageText_u24lambda_u241.getMaxPermittedAbiVersion() != null ? "ABI version in the range [" + $this$computeMessageText_u24lambda_u241.getMinPermittedAbiVersion() + ", " + $this$computeMessageText_u24lambda_u241.getMaxPermittedAbiVersion() + ']' : ($this$computeMessageText_u24lambda_u241.getMaxPermittedAbiVersion() != null ? "ABI version <= " + $this$computeMessageText_u24lambda_u241.getMaxPermittedAbiVersion() : "ABI version >= " + $this$computeMessageText_u24lambda_u241.getMinPermittedAbiVersion());
            KotlinAbiVersion libraryAbiVersion = $this$computeMessageText_u24lambda_u241.getLibraryVersions().getAbiVersion();
            if (libraryAbiVersion != null) {
                objectArray = new String[]{"Incompatible ABI version " + libraryAbiVersion + " in library: " + $this$computeMessageText.getLibraryPath(), libraryCompilerLine, "The current Kotlin compiler can consume libraries having " + abiVersionCheckExplanation, "Please upgrade your Kotlin compiler version to consume this library."};
                list = CollectionsKt.listOfNotNull((Object[])objectArray);
            } else {
                objectArray = new String[]{"Library with unknown ABI version: " + $this$computeMessageText.getLibraryPath(), libraryCompilerLine, "The current Kotlin compiler can consume libraries having " + abiVersionCheckExplanation + ", but it's not possible to determine the exact ABI version."};
                list = CollectionsKt.listOfNotNull((Object[])objectArray);
            }
            List lines = list;
            string = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String messageText = string;
        return "KLIB loader: " + messageText;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinLibrary> loadFriendLibraries(@NotNull KlibLoaderResult $this$loadFriendLibraries, @NotNull List<String> friendLibraryPaths) {
        void $this$mapNotNullTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void destination$iv;
        String rawPath;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadFriendLibraries, (String)"<this>");
        Intrinsics.checkNotNullParameter(friendLibraryPaths, (String)"friendLibraryPaths");
        if (friendLibraryPaths.isEmpty() || $this$loadFriendLibraries.getLibrariesStdlibFirst().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = friendLibraryPaths;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach22 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            String string;
            block9: {
                Object element$iv = element$iv$iv;
                boolean bl = false;
                rawPath = (String)element$iv;
                boolean bl2 = false;
                if (((CharSequence)rawPath).length() == 0) {
                    string = null;
                } else {
                    String string2;
                    try {
                        string2 = ((Object)Paths.get(rawPath, new String[0]).toRealPath(new LinkOption[0])).toString();
                    }
                    catch (InvalidPathException invalidPathException) {
                        string = null;
                        break block9;
                    }
                    string = string2;
                }
            }
            if (string == null) continue;
            String it$iv = string;
            boolean bl = false;
            destination$iv.add(it$iv);
        }
        Set canonicalFriendLibraryPaths = (Set)destination$iv;
        if (canonicalFriendLibraryPaths.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$associateBy$iv = $this$loadFriendLibraries.getLibrariesStdlibFirst();
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$forEach22 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            rawPath = (KotlinLibrary)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getLibraryFile().getPath(), element$iv$iv);
        }
        Map canonicalLibraryPathsToLibraries = destination$iv$iv;
        Iterable $this$mapNotNull$iv = canonicalFriendLibraryPaths;
        boolean $i$f$mapNotNull = false;
        Iterable capacity$iv22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinLibrary it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if ((KotlinLibrary)canonicalLibraryPathsToLibraries.get(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private static final CharSequence eliminateLibrariesWithDuplicatedUniqueNames$lambda$2(KotlinLibrary it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLibraryFile().getPath();
    }
}

