/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.utils.CodeLine;
import org.jetbrains.kotlin.gradle.utils.ConnectedLinesBuilder;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/ConnectedLinesBuilderImpl;", "Lorg/jetbrains/kotlin/gradle/utils/ConnectedLinesBuilder;", "lineSuffix", "", "level", "", "(Ljava/lang/String;I)V", "lines", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/gradle/utils/CodeLine;", "getLines", "()Lkotlin/collections/ArrayDeque;", "line", "", "content", "kotlin-gradle-plugin_common"})
final class ConnectedLinesBuilderImpl
implements ConnectedLinesBuilder {
    @NotNull
    private final String lineSuffix;
    private final int level;
    @NotNull
    private final ArrayDeque<CodeLine> lines;

    public ConnectedLinesBuilderImpl(@NotNull String lineSuffix, int level) {
        Intrinsics.checkNotNullParameter((Object)lineSuffix, (String)"lineSuffix");
        this.lineSuffix = lineSuffix;
        this.level = level;
        this.lines = new ArrayDeque();
    }

    @NotNull
    public final ArrayDeque<CodeLine> getLines() {
        return this.lines;
    }

    @Override
    public void line(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.lines.isEmpty()) {
            this.lines.addLast((Object)new CodeLine(content, this.level));
        } else {
            CodeLine lastLine = (CodeLine)this.lines.last();
            this.lines.removeLast();
            this.lines.addLast((Object)new CodeLine(lastLine.getContent() + this.lineSuffix, lastLine.getLevel()));
            this.lines.addLast((Object)new CodeLine(content, this.level + 1));
        }
    }
}

