/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.storage.AppendableInMemoryStorage;
import org.jetbrains.kotlin.incremental.storage.AppendableLazyStorage;
import org.jetbrains.kotlin.incremental.storage.AppendablePersistentStorage;
import org.jetbrains.kotlin.incremental.storage.InMemoryStorage;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.PersistentStorage;

@Metadata(k=2, mv={2, 2, 0}, d1={"\u0000,\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aQ\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n\"\u0004\b\u0000\u0010\u0000\"\u0004\b\u0001\u0010\u00012\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f\u001aQ\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f\"\u0004\b\u0000\u0010\u0000\"\u0004\b\u0001\u0010\r2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"KEY", "VALUE", "Ljava/io/File;", "storageFile", "Lorg/jetbrains/kotlin/com/intellij/util/io/KeyDescriptor;", "keyDescriptor", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "valueExternalizer", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "icContext", "Lorg/jetbrains/kotlin/incremental/storage/PersistentStorage;", "createPersistentStorage", "(Ljava/io/File;Lorg/jetbrains/kotlin/com/intellij/util/io/KeyDescriptor;Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)Lorg/jetbrains/kotlin/incremental/storage/PersistentStorage;", "E", "elementExternalizer", "Lorg/jetbrains/kotlin/incremental/storage/AppendablePersistentStorage;", "createAppendablePersistentStorage", "(Ljava/io/File;Lorg/jetbrains/kotlin/com/intellij/util/io/KeyDescriptor;Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)Lorg/jetbrains/kotlin/incremental/storage/AppendablePersistentStorage;", "kotlin-build-common"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
public final class LazyStorageKt {
    @NotNull
    public static final <KEY, VALUE> PersistentStorage<KEY, VALUE> createPersistentStorage(@NotNull File storageFile, @NotNull KeyDescriptor<KEY> keyDescriptor, @NotNull DataExternalizer<VALUE> valueExternalizer, @NotNull IncrementalCompilationContext icContext) {
        PersistentStorage persistentStorage;
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        LazyStorage<KEY, VALUE> storage = new LazyStorage<KEY, VALUE>(storageFile, keyDescriptor, valueExternalizer);
        boolean bl = false;
        if (icContext.getIcFeatures().getKeepIncrementalCompilationCachesInMemory()) {
            InMemoryStorage inMemoryStorage;
            InMemoryStorage it = inMemoryStorage = new InMemoryStorage(storage);
            boolean bl2 = false;
            icContext.getTransaction().registerInMemoryStorageWrapper(it);
            persistentStorage = inMemoryStorage;
        } else {
            persistentStorage = storage;
        }
        return persistentStorage;
    }

    @NotNull
    public static final <KEY, E> AppendablePersistentStorage<KEY, E> createAppendablePersistentStorage(@NotNull File storageFile, @NotNull KeyDescriptor<KEY> keyDescriptor, @NotNull DataExternalizer<E> elementExternalizer, @NotNull IncrementalCompilationContext icContext) {
        AppendablePersistentStorage appendablePersistentStorage;
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter(elementExternalizer, (String)"elementExternalizer");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        AppendableLazyStorage<KEY, E> storage = new AppendableLazyStorage<KEY, E>(storageFile, keyDescriptor, elementExternalizer);
        boolean bl = false;
        if (icContext.getIcFeatures().getKeepIncrementalCompilationCachesInMemory()) {
            AppendableInMemoryStorage appendableInMemoryStorage;
            AppendableInMemoryStorage it = appendableInMemoryStorage = new AppendableInMemoryStorage(storage);
            boolean bl2 = false;
            icContext.getTransaction().registerInMemoryStorageWrapper(it);
            appendablePersistentStorage = appendableInMemoryStorage;
        } else {
            appendablePersistentStorage = storage;
        }
        return appendablePersistentStorage;
    }
}

