/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinNativeCompilerOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinVersion;
import org.jetbrains.kotlin.gradle.plugin.statistics.FusMetrics;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/NativeCompilerOptionMetrics;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/FusMetrics;", "()V", "collectMetrics", "", "compilerOptions", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinNativeCompilerOptions;", "separateKmpCompilationEnabled", "", "metricsConsumer", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "kotlin-gradle-plugin_common"})
public final class NativeCompilerOptionMetrics
implements FusMetrics {
    @NotNull
    public static final NativeCompilerOptionMetrics INSTANCE = new NativeCompilerOptionMetrics();

    private NativeCompilerOptionMetrics() {
    }

    public final void collectMetrics(@NotNull KotlinNativeCompilerOptions compilerOptions2, boolean separateKmpCompilationEnabled, @NotNull StatisticsValuesConsumer metricsConsumer) {
        KotlinVersion v;
        KotlinVersion kotlinVersion;
        Intrinsics.checkNotNullParameter((Object)compilerOptions2, (String)"compilerOptions");
        Intrinsics.checkNotNullParameter((Object)metricsConsumer, (String)"metricsConsumer");
        Object object = compilerOptions2.getProgressiveMode().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compilerOptions.progressiveMode.get()");
        StatisticsValuesConsumer.DefaultImpls.report$default(metricsConsumer, BooleanMetrics.KOTLIN_PROGRESSIVE_MODE, (Boolean)object, null, null, 12, null);
        KotlinVersion kotlinVersion2 = (KotlinVersion)compilerOptions2.getApiVersion().getOrNull();
        if (kotlinVersion2 != null) {
            v = kotlinVersion = kotlinVersion2;
            boolean bl = false;
            StatisticsValuesConsumer.DefaultImpls.report$default(metricsConsumer, StringMetrics.KOTLIN_API_VERSION, v.getVersion(), null, null, 12, null);
        }
        KotlinVersion kotlinVersion3 = (KotlinVersion)compilerOptions2.getLanguageVersion().getOrNull();
        if (kotlinVersion3 != null) {
            v = kotlinVersion = kotlinVersion3;
            boolean bl = false;
            StatisticsValuesConsumer.DefaultImpls.report$default(metricsConsumer, StringMetrics.KOTLIN_LANGUAGE_VERSION, v.getVersion(), null, null, 12, null);
        }
        if (separateKmpCompilationEnabled) {
            StatisticsValuesConsumer.DefaultImpls.report$default(metricsConsumer, BooleanMetrics.KOTLIN_SEPARATE_KMP_COMPILATION_ENABLED, true, null, null, 12, null);
        }
    }
}

