/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.StorageOwner;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;
import org.jetbrains.kotlin.jps.incremental.LookupStorageLock;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ%\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager;", "", "buildDataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Lorg/jetbrains/jps/incremental/storage/BuildDataManager;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "storageProvider", "Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager$JpsLookupStorageProvider;", "cleanLookupStorage", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "withLookupStorage", "T", "fn", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "JpsLookupStorage", "JpsLookupStorageProvider", "jps-plugin"})
public final class JpsLookupStorageManager {
    @NotNull
    private final BuildDataManager buildDataManager;
    @NotNull
    private final JpsLookupStorageProvider storageProvider;

    public JpsLookupStorageManager(@NotNull BuildDataManager buildDataManager, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)buildDataManager, (String)"buildDataManager");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        this.buildDataManager = buildDataManager;
        this.storageProvider = new JpsLookupStorageProvider(pathConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanLookupStorage(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        LookupStorageLock lookupStorageLock = LookupStorageLock.INSTANCE;
        synchronized (lookupStorageLock) {
            block5: {
                boolean bl = false;
                try {
                    this.buildDataManager.cleanTargetStorages((BuildTarget)KotlinDataContainerTarget.INSTANCE);
                }
                catch (IOException e) {
                    File file = this.buildDataManager.getDataPaths().getTargetDataRoot((BuildTarget)KotlinDataContainerTarget.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildDataManager.dataPat\u2026otlinDataContainerTarget)");
                    if (FilesKt.deleteRecursively((File)file)) break block5;
                    log.debug("Could not clear lookup storage caches", (Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T withLookupStorage(@NotNull Function1<? super LookupStorage, ? extends T> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        LookupStorageLock lookupStorageLock = LookupStorageLock.INSTANCE;
        synchronized (lookupStorageLock) {
            boolean bl = false;
            try {
                StorageOwner storageOwner = this.buildDataManager.getStorage((BuildTarget)KotlinDataContainerTarget.INSTANCE, (StorageProvider)this.storageProvider);
                Intrinsics.checkNotNullExpressionValue((Object)storageOwner, (String)"buildDataManager.getStor\u2026rTarget, storageProvider)");
                JpsLookupStorage lookupStorage = (JpsLookupStorage)storageOwner;
                Object object = fn.invoke((Object)lookupStorage);
                return (T)object;
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager$JpsLookupStorageProvider;", "Lorg/jetbrains/jps/builders/storage/StorageProvider;", "Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager$JpsLookupStorage;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "createStorage", "targetDataDir", "Ljava/io/File;", "jps-plugin"})
    private static final class JpsLookupStorageProvider
    extends StorageProvider<JpsLookupStorage> {
        @NotNull
        private final FileToPathConverter pathConverter;

        public JpsLookupStorageProvider(@NotNull FileToPathConverter pathConverter) {
            Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
            this.pathConverter = pathConverter;
        }

        @NotNull
        public JpsLookupStorage createStorage(@NotNull File targetDataDir) {
            Intrinsics.checkNotNullParameter((Object)targetDataDir, (String)"targetDataDir");
            return new JpsLookupStorage(targetDataDir, this.pathConverter);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager$JpsLookupStorage;", "Lorg/jetbrains/jps/incremental/storage/StorageOwner;", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "targetDataDir", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "jps-plugin"})
    private static final class JpsLookupStorage
    extends LookupStorage
    implements StorageOwner {
        public JpsLookupStorage(@NotNull File targetDataDir, @NotNull FileToPathConverter pathConverter) {
            Intrinsics.checkNotNullParameter((Object)targetDataDir, (String)"targetDataDir");
            Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
            super(targetDataDir, pathConverter);
        }
    }
}

