/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.kotlin.compilerRunner.ProgressReporter;
import org.jetbrains.kotlin.jps.KotlinJpsBundle;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u00020\b2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/ProgressReporterImpl;", "Lorg/jetbrains/kotlin/compilerRunner/ProgressReporter;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "(Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/ModuleChunk;)V", "clearProgress", "", "compilationStarted", "progress", "message", "", "jps-plugin"})
public final class ProgressReporterImpl
implements ProgressReporter {
    @NotNull
    private final CompileContext context;
    @NotNull
    private final ModuleChunk chunk;

    public ProgressReporterImpl(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.context = context;
        this.chunk = chunk;
    }

    @Override
    public void progress(@Nls @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.context.processMessage((BuildMessage)new ProgressMessage(Intrinsics.stringPlus((String)"Kotlin: ", (Object)message)));
    }

    @Override
    public void compilationStarted() {
        Object[] objectArray = new Object[1];
        String string = this.chunk.getPresentableShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chunk.presentableShortName");
        objectArray[0] = string;
        this.progress(KotlinJpsBundle.message("progress.text.compiling.0", objectArray));
    }

    @Override
    public void clearProgress() {
        this.context.processMessage((BuildMessage)new ProgressMessage(""));
    }
}

