/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.KotlinMetadataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPartProvider;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\u001f2\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPackageFragment;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializedPackageFragment;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "metadataPartProvider", "Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPartProvider;", "finder", "Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPartProvider;Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;)V", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "getClassDataFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "components", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "memberScope", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "computeMemberScope", "getMemberScope", "hasTopLevelClass", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "initialize", "", "readProto", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "stream", "Ljava/io/InputStream;", "Companion", "deserialization"})
public final class MetadataPackageFragment
extends DeserializedPackageFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataPartProvider metadataPartProvider;
    @NotNull
    private final KotlinMetadataFinder finder;
    @NotNull
    private final ClassDataFinder classDataFinder;
    private DeserializationComponents components;
    @NotNull
    private final NotNullLazyValue<MemberScope> memberScope;
    @NotNull
    public static final String METADATA_FILE_EXTENSION = "kotlin_metadata";
    @NotNull
    public static final String DOT_METADATA_FILE_EXTENSION = ".kotlin_metadata";

    public MetadataPackageFragment(@NotNull FqName fqName2, @NotNull StorageManager storageManager, @NotNull ModuleDescriptor module, @NotNull MetadataPartProvider metadataPartProvider, @NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)metadataPartProvider, (String)"metadataPartProvider");
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        super(fqName2, storageManager, module);
        this.metadataPartProvider = metadataPartProvider;
        this.finder = finder;
        this.classDataFinder = new ClassDataFinder(this){
            final /* synthetic */ MetadataPackageFragment this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final ClassData findClassData(@NotNull ClassId classId) {
                ClassData classData;
                Object v2;
                BuiltInsBinaryVersion version;
                NameResolverImpl nameResolver;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                    ClassId topLevelClassId2 = (ClassId)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)classId, (Function1)classDataFinder.topLevelClassId.1.INSTANCE));
                    InputStream inputStream = MetadataPackageFragment.access$getFinder$p(this.this$0).findMetadata(topLevelClassId2);
                    if (inputStream == null) {
                        return null;
                    }
                    InputStream stream = inputStream;
                    Triple triple = MetadataPackageFragment.access$readProto(this.this$0, stream);
                    ProtoBuf.PackageFragment message = (ProtoBuf.PackageFragment)triple.component1();
                    nameResolver = (NameResolverImpl)triple.component2();
                    version = (BuiltInsBinaryVersion)triple.component3();
                    List<ProtoBuf.Class> list = message.getClass_List();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"message.class_List");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)NameResolverUtilKt.getClassId(nameResolver, classProto.getFqName()), (Object)classId)) continue;
                        v2 = element$iv;
                        break block4;
                    }
                    v2 = null;
                }
                ProtoBuf.Class clazz = v2;
                if (clazz != null) {
                    ProtoBuf.Class classProto = clazz;
                    boolean bl = false;
                    NameResolver nameResolver2 = nameResolver;
                    BinaryVersion binaryVersion = version;
                    SourceElement sourceElement = SourceElement.NO_SOURCE;
                    Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
                    classData = new ClassData(nameResolver2, classProto, binaryVersion, sourceElement);
                } else {
                    classData = null;
                }
                return classData;
            }
        };
        this.memberScope = storageManager.createLazyValue((Function0)new Function0<MemberScope>(this){
            final /* synthetic */ MetadataPackageFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MemberScope invoke() {
                return MetadataPackageFragment.access$computeMemberScope(this.this$0);
            }
        });
    }

    @Override
    @NotNull
    public ClassDataFinder getClassDataFinder() {
        return this.classDataFinder;
    }

    @Override
    public void initialize(@NotNull DeserializationComponents components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.components = components2;
    }

    private final MemberScope computeMemberScope() {
        Object object;
        String string = this.getFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqName.asString()");
        List<String> packageParts = this.metadataPartProvider.findMetadataPackageParts(string);
        ArrayList<DeserializedPackageMemberScope> scopes = new ArrayList<DeserializedPackageMemberScope>();
        for (String partName : packageParts) {
            InputStream stream;
            if (this.finder.findMetadata(new ClassId(this.getFqName(), Name.identifier(partName))) == null) continue;
            object = this.readProto(stream);
            ProtoBuf.PackageFragment proto = (ProtoBuf.PackageFragment)object.component1();
            NameResolverImpl nameResolver = (NameResolverImpl)object.component2();
            BuiltInsBinaryVersion version = (BuiltInsBinaryVersion)object.component3();
            PackageFragmentDescriptor packageFragmentDescriptor = this;
            ProtoBuf.Package package_ = proto.getPackage();
            Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"proto.`package`");
            NameResolver nameResolver2 = nameResolver;
            BinaryVersion binaryVersion = version;
            DeserializationComponents deserializationComponents = this.components;
            if (deserializationComponents == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"components");
                deserializationComponents = null;
            }
            scopes.add(new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, nameResolver2, binaryVersion, null, deserializationComponents, "scope with top-level callables and type aliases (no classes) for package part " + partName + " of " + this, (Function0<? extends Collection<Name>>)((Function0)computeMemberScope.1.INSTANCE)));
        }
        ProtoBuf.Package package_ = ProtoBuf.Package.getDefaultInstance();
        ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"getDefaultInstance()");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"getDefaultInstance()");
        NameResolverImpl nameResolverImpl = new NameResolverImpl(stringTable, qualifiedNameTable);
        BuiltInsBinaryVersion builtInsBinaryVersion = BuiltInsBinaryVersion.INSTANCE;
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            deserializationComponents = null;
        }
        object = deserializationComponents;
        String string2 = "scope for all classes of " + this;
        computeMemberScope.3 var8_8 = computeMemberScope.3.INSTANCE;
        scopes.add(new DeserializedPackageMemberScope(this, package_, nameResolverImpl, builtInsBinaryVersion, (DeserializationComponents)object, string2, var8_8){
            final /* synthetic */ MetadataPackageFragment this$0;
            {
                this.this$0 = $receiver;
                PackageFragmentDescriptor packageFragmentDescriptor = $receiver;
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"getDefaultInstance()");
                super(packageFragmentDescriptor, $super_call_param$1, $super_call_param$2, $super_call_param$3, null, $super_call_param$4, $super_call_param$5, (Function0<? extends Collection<Name>>)((Function0)$super_call_param$6));
            }

            protected boolean hasClass(@NotNull Name name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return this.this$0.hasTopLevelClass(name);
            }

            public boolean definitelyDoesNotContainName(@NotNull Name name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return false;
            }

            @Nullable
            public Set<Name> getClassifierNames() {
                return null;
            }

            @Nullable
            protected Set<Name> getNonDeclaredClassifierNames() {
                return null;
            }
        });
        return ChainedMemberScope.Companion.create(".kotlin_metadata parts scope of " + this, (Iterable<? extends MemberScope>)scopes);
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        return (MemberScope)this.memberScope.invoke();
    }

    @Override
    public boolean hasTopLevelClass(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return true;
    }

    private final Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> readProto(InputStream stream) {
        BuiltInsBinaryVersion version = BuiltInsBinaryVersion.Companion.readFrom(stream);
        if (!version.isCompatible()) {
            throw new UnsupportedOperationException("Kotlin metadata definition format version is not supported: expected " + BuiltInsBinaryVersion.INSTANCE + ", actual " + version + ". Please update Kotlin");
        }
        ProtoBuf.PackageFragment message = ProtoBuf.PackageFragment.parseFrom(stream, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
        ProtoBuf.StringTable stringTable = message.getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)stringTable, (String)"message.strings");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = message.getQualifiedNames();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedNameTable, (String)"message.qualifiedNames");
        NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
        return new Triple((Object)message, (Object)nameResolver, (Object)version);
    }

    public static final /* synthetic */ KotlinMetadataFinder access$getFinder$p(MetadataPackageFragment $this) {
        return $this.finder;
    }

    public static final /* synthetic */ Triple access$readProto(MetadataPackageFragment $this, InputStream stream) {
        return $this.readProto(stream);
    }

    public static final /* synthetic */ MemberScope access$computeMemberScope(MetadataPackageFragment $this) {
        return $this.computeMemberScope();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPackageFragment$Companion;", "", "()V", "DOT_METADATA_FILE_EXTENSION", "", "METADATA_FILE_EXTENSION", "deserialization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

