/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheVersion;
import org.jetbrains.kotlin.jps.incremental.CacheVersionManagerKt;
import org.jetbrains.kotlin.load.kotlin.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesManager;", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersion;", "versionFile", "Ljava/nio/file/Path;", "expectedOwnVersion", "", "(Ljava/nio/file/Path;Ljava/lang/Integer;)V", "expected", "getExpected", "()Lorg/jetbrains/kotlin/jps/incremental/CacheVersion;", "versionFileForTesting", "Ljava/io/File;", "getVersionFileForTesting", "()Ljava/io/File;", "loadActual", "writeVersion", "", "values", "jps-plugin"})
public final class CacheVersionManager
implements CacheAttributesManager<CacheVersion> {
    @NotNull
    private final Path versionFile;
    @Nullable
    private final CacheVersion expected;

    public CacheVersionManager(@NotNull Path versionFile, @Nullable Integer expectedOwnVersion) {
        Intrinsics.checkNotNullParameter((Object)versionFile, (String)"versionFile");
        this.versionFile = versionFile;
        this.expected = expectedOwnVersion == null ? null : CacheVersionManagerKt.CacheVersion(expectedOwnVersion, JvmBytecodeBinaryVersion.INSTANCE, JvmMetadataVersion.INSTANCE);
    }

    @Override
    @Nullable
    public CacheVersion getExpected() {
        return this.expected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CacheVersion loadActual() {
        CacheVersion cacheVersion;
        if (Files.notExists(this.versionFile, new LinkOption[0])) {
            cacheVersion = null;
        } else {
            Object object;
            try {
                InputStream inputStream = Files.newInputStream(this.versionFile, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(versionFile)");
                object = inputStream;
                Object object2 = Charsets.UTF_8;
                Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
                int n = 8192;
                object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                object2 = null;
                try {
                    BufferedReader it = (BufferedReader)object;
                    boolean bl = false;
                    object3 = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                int n2 = Integer.parseInt((String)object3);
                object = new CacheVersion(n2);
            }
            catch (NumberFormatException e) {
                object = null;
            }
            catch (IOException e) {
                object = null;
            }
            cacheVersion = object;
        }
        return cacheVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeVersion(@Nullable CacheVersion values) {
        if (values == null) {
            Files.deleteIfExists(this.versionFile);
        } else {
            Files.createDirectories(this.versionFile.getParent(), new FileAttribute[0]);
            OutputStream outputStream = Files.newOutputStream(this.versionFile, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(versionFile)");
            Closeable closeable = outputStream;
            Object object = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter it = (BufferedWriter)closeable;
                boolean bl = false;
                writer = it.append(String.valueOf(values.getIntValue()));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
    }

    @TestOnly
    @NotNull
    public final File getVersionFileForTesting() {
        File file = this.versionFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"versionFile.toFile()");
        return file;
    }

    @Override
    public boolean isCompatible(@NotNull CacheVersion actual, @NotNull CacheVersion expected) {
        return CacheAttributesManager.DefaultImpls.isCompatible(this, actual, expected);
    }
}

