/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.JsBuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalJsCache;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProviderFromCache;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalJsCache;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.utils.JsLibraryUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\r012\u0006\u00102\u001a\u00020\u001fH\u0002J \u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020-H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u00020-H\u0016J@\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020B2\u0016\u0010C\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0001\u0012\u0004\u0012\u00020E0D2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0016J\u001e\u0010L\u001a\u00020-2\u0006\u0010M\u001a\u00020N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u0011H\u0016J6\u0010Q\u001a\u00020-2\u0006\u00106\u001a\u0002072\u0006\u0010R\u001a\u00020E2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020P0\u00112\u0006\u0010T\u001a\u00020U2\u0006\u00108\u001a\u000209H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u0014\u0010!\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u0011\u0010$\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0014\u0010&\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u0011\u0010(\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0013\u00a8\u0006V"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinJsModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "Lorg/jetbrains/kotlin/build/JsBuildMetaInfo;", "kotlinContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "jpsModuleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "buildMetaInfoFactory", "Lorg/jetbrains/kotlin/build/JsBuildMetaInfo$Companion;", "getBuildMetaInfoFactory", "()Lorg/jetbrains/kotlin/build/JsBuildMetaInfo$Companion;", "buildMetaInfoFileName", "", "getBuildMetaInfoFileName", "()Ljava/lang/String;", "dependenciesMetaFiles", "", "getDependenciesMetaFiles", "()Ljava/util/List;", "explicitOutputPath", "getExplicitOutputPath", "friendBuildTargetsMetaFiles", "getFriendBuildTargetsMetaFiles", "globalLookupCacheId", "getGlobalLookupCacheId", "implicitOutputFile", "Ljava/io/File;", "getImplicitOutputFile", "()Ljava/io/File;", "isFirstBuild", "", "()Z", "isIncrementalCompilationEnabled", "libraryFiles", "getLibraryFiles", "outputFile", "getOutputFile", "outputFileBaseName", "getOutputFileBaseName", "outputMetaFile", "getOutputMetaFile", "sourceMapRoots", "getSourceMapRoots", "addDependencyMetaFile", "", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "result", "", "isTests", "compileModuleChunk", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "dirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "copyJsLibraryFilesIfNeeded", "createCacheStorage", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalJsCache;", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "doAfterBuild", "makeServices", "builder", "Lorg/jetbrains/kotlin/config/Services$Builder;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "registerOutputItems", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "outputItems", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "updateCaches", "jpsIncrementalCache", "files", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "jps-plugin"})
public final class KotlinJsModuleBuildTarget
extends KotlinModuleBuildTarget<JsBuildMetaInfo> {
    public KotlinJsModuleBuildTarget(@NotNull KotlinCompileContext kotlinContext, @NotNull ModuleBuildTarget jpsModuleBuildTarget) {
        Intrinsics.checkNotNullParameter((Object)kotlinContext, (String)"kotlinContext");
        Intrinsics.checkNotNullParameter((Object)jpsModuleBuildTarget, (String)"jpsModuleBuildTarget");
        super(kotlinContext, jpsModuleBuildTarget);
    }

    @Override
    @NotNull
    public String getGlobalLookupCacheId() {
        return "js";
    }

    @Override
    public boolean isIncrementalCompilationEnabled() {
        return IncrementalCompilation.isEnabledForJs();
    }

    @NotNull
    public JsBuildMetaInfo.Companion getBuildMetaInfoFactory() {
        return JsBuildMetaInfo.Companion;
    }

    @Override
    @NotNull
    public String getBuildMetaInfoFileName() {
        return "js-build-meta-info.txt";
    }

    public final boolean isFirstBuild() {
        File targetDataRoot = this.getJpsGlobalContext().getProjectDescriptor().dataManager.getDataPaths().getTargetDataRoot((BuildTarget)this.getJpsModuleBuildTarget());
        Intrinsics.checkNotNullExpressionValue((Object)targetDataRoot, (String)"targetDataRoot");
        return !IncrementalJsCache.Companion.hasHeaderFile(targetDataRoot);
    }

    @Override
    public void makeServices(@NotNull Services.Builder builder, @NotNull Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, @NotNull LookupTracker lookupTracker, @NotNull ExpectActualTracker exceptActualTracer, @NotNull InlineConstTracker inlineConstTracker) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(incrementalCaches, (String)"incrementalCaches");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkNotNullParameter((Object)exceptActualTracer, (String)"exceptActualTracer");
        Intrinsics.checkNotNullParameter((Object)inlineConstTracker, (String)"inlineConstTracker");
        super.makeServices(builder, incrementalCaches, lookupTracker, exceptActualTracer, inlineConstTracker);
        Services.Builder $this$makeServices_u24lambda_u2d0 = builder;
        boolean bl = false;
        $this$makeServices_u24lambda_u2d0.register(IncrementalResultsConsumer.class, new IncrementalResultsConsumerImpl());
        if (this.isIncrementalCompilationEnabled() && !this.isFirstBuild()) {
            JpsIncrementalCache jpsIncrementalCache = incrementalCaches.get(this);
            Intrinsics.checkNotNull((Object)jpsIncrementalCache, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.IncrementalJsCache");
            IncrementalJsCache cache2 = (IncrementalJsCache)jpsIncrementalCache;
            $this$makeServices_u24lambda_u2d0.register(IncrementalDataProvider.class, new IncrementalDataProviderFromCache(cache2));
        }
    }

    @Override
    public boolean compileModuleChunk(@NotNull CommonCompilerArguments commonArguments, @NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (!Intrinsics.areEqual(this.getChunk().getRepresentativeTarget(), (Object)this)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.reportAndSkipCircular(environment)) {
            return false;
        }
        KotlinModuleBuildTarget.SourcesToCompile sources = this.collectSourcesToCompile(dirtyFilesHolder2);
        if (!sources.logFiles()) {
            return false;
        }
        List libraries = CollectionsKt.plus((Collection)this.getLibraryFiles(), (Iterable)this.getDependenciesMetaFiles());
        new JpsKotlinCompilerRunner().runK2JsCompiler(commonArguments, ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()), environment, (Collection<? extends File>)sources.getAllFiles(), (Collection<? extends File>)sources.getCrossCompiledFiles(), (Collection<? extends File>)this.getSourceMapRoots(), libraries, this.getFriendBuildTargetsMetaFiles(), this.getOutputFile());
        return true;
    }

    @Override
    public void doAfterBuild() {
        this.copyJsLibraryFilesIfNeeded();
    }

    private final void copyJsLibraryFilesIfNeeded() {
        if (ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()).getCopyJsLibraryFiles()) {
            String outputLibraryRuntimeDirectory = new File(this.getOutputDir(), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()).getOutputDirectoryForJsLibraryFiles()).getAbsolutePath();
            List<String> list = this.getLibraryFiles();
            Intrinsics.checkNotNullExpressionValue((Object)outputLibraryRuntimeDirectory, (String)"outputLibraryRuntimeDirectory");
            JsLibraryUtils.copyJsFilesFromLibraries(list, outputLibraryRuntimeDirectory, ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()).getSourceMap());
        }
    }

    private final List<File> getSourceMapRoots() {
        List list;
        CharSequence charSequence = ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()).getSourceMapPrefix();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            list = CollectionsKt.emptyList();
        } else {
            Iterable $this$filterTo$iv$iv;
            URI it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            List list2 = this.getModule().getContentRootsList().getUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"module.contentRootsList.urls");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(URI.create((String)((Object)it)));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (URI)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getScheme(), (Object)"file")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (URI)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File(it.getPath()));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFriendBuildTargetsMetaFiles() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getFriendBuildTargets();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv$iv;
            boolean bl2 = false;
            Object object = it instanceof KotlinJsModuleBuildTarget ? (KotlinJsModuleBuildTarget)it : null;
            if ((object != null && (object = ((KotlinJsModuleBuildTarget)object).getOutputMetaFile()) != null && (object = ((File)object).getAbsoluteFile()) != null ? ((File)object).toString() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final File getOutputFile() {
        File file;
        String string = this.getExplicitOutputPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = this.getImplicitOutputFile();
        }
        return file;
    }

    private final String getExplicitOutputPath() {
        return this.isTests() ? ModuleSettingsKt.getTestOutputFilePath(this.getModule()) : ModuleSettingsKt.getProductionOutputFilePath(this.getModule());
    }

    private final File getImplicitOutputFile() {
        String suffix = this.isTests() ? "_test" : "";
        return new File(this.getOutputDir(), this.getModule().getName() + suffix + ".js");
    }

    private final String getOutputFileBaseName() {
        String string = this.getOutputFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputFile.path");
        return StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null);
    }

    @NotNull
    public final File getOutputMetaFile() {
        return new File(this.getOutputFileBaseName() + ".meta.js");
    }

    private final List<String> getLibraryFiles() {
        List list;
        List result = list = (List)new ArrayList();
        boolean bl = false;
        for (JpsLibrary library : this.getAllDependencies().getLibraries()) {
            for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                String string = JpsPathUtil.urlToPath((String)root.getUrl());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(root.url)");
                result.add(string);
            }
        }
        return list;
    }

    private final List<String> getDependenciesMetaFiles() {
        List list;
        List result = list = (List)new ArrayList();
        boolean bl = false;
        this.getAllDependencies().processModules(arg_0 -> KotlinJsModuleBuildTarget._get_dependenciesMetaFiles_$lambda-8$lambda-7(this, result, arg_0));
        return list;
    }

    private final void addDependencyMetaFile(JpsModule module, List<String> result, boolean isTests) {
        Path metaFile;
        KotlinModuleBuildTarget<?> dependencyBuildTarget = this.getKotlinContext().getTargetsBinding().get(JpsUtilKt.ModuleBuildTarget(module, isTests));
        if (!Intrinsics.areEqual(dependencyBuildTarget, (Object)this) && dependencyBuildTarget instanceof KotlinJsModuleBuildTarget && !dependencyBuildTarget.getSources().isEmpty() && Files.exists(metaFile = ((KotlinJsModuleBuildTarget)dependencyBuildTarget).getOutputMetaFile().toPath(), new LinkOption[0])) {
            result.add(((Object)metaFile.toAbsolutePath()).toString());
        }
    }

    @Override
    @NotNull
    public JpsIncrementalJsCache createCacheStorage(@NotNull BuildDataPaths paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        return new JpsIncrementalJsCache(this.getJpsModuleBuildTarget(), paths, this.getKotlinContext().getFileToPathConverter());
    }

    @Override
    public void updateCaches(@NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull JpsIncrementalCache jpsIncrementalCache, @NotNull List<? extends GeneratedFile> files, @NotNull ChangesCollector changesCollector, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)jpsIncrementalCache, (String)"jpsIncrementalCache");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super.updateCaches(dirtyFilesHolder2, jpsIncrementalCache, files, changesCollector, environment);
        IncrementalResultsConsumer incrementalResultsConsumer = environment.getServices().get(IncrementalResultsConsumer.class);
        Intrinsics.checkNotNull((Object)incrementalResultsConsumer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl");
        IncrementalResultsConsumerImpl incrementalResults = (IncrementalResultsConsumerImpl)incrementalResultsConsumer;
        IncrementalJsCache jsCache = (IncrementalJsCache)jpsIncrementalCache;
        jsCache.setHeader(incrementalResults.getHeaderMetadata());
        jsCache.updateSourceToOutputMap((Iterable)files);
        jsCache.compareAndUpdate(incrementalResults, changesCollector);
        jsCache.clearCacheForRemovedClasses(changesCollector);
    }

    @Override
    public void registerOutputItems(@NotNull ModuleLevelBuilder.OutputConsumer outputConsumer, @NotNull List<? extends GeneratedFile> outputItems) {
        Intrinsics.checkNotNullParameter((Object)outputConsumer, (String)"outputConsumer");
        Intrinsics.checkNotNullParameter(outputItems, (String)"outputItems");
        if (this.isIncrementalCompilationEnabled()) {
            for (GeneratedFile generatedFile : outputItems) {
                for (File source : generatedFile.getSourceFiles()) {
                    outputConsumer.registerOutputFile((BuildTarget)this.getJpsModuleBuildTarget(), new File(String.valueOf(source.getPath().hashCode())), (Collection)CollectionsKt.listOf((Object)source.getPath()));
                }
            }
        } else {
            super.registerOutputItems(outputConsumer, outputItems);
        }
    }

    private static final void _get_dependenciesMetaFiles_$lambda-8$lambda-7(KotlinJsModuleBuildTarget this$0, List $result, JpsModule module) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        if (this$0.isTests()) {
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
            this$0.addDependencyMetaFile(module, $result, true);
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
        this$0.addDependencyMetaFile(module, $result, false);
    }
}

