/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0011\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\n\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/utils/IntArrayList;", "", "initialCapacity", "", "(I)V", "data", "", "isEmpty", "", "()Z", "size", "add", "", "o", "ensureCapacity", "minCapacity", "get", "index", "toString", "", "trimToSize", "util"})
public final class IntArrayList {
    @NotNull
    private int[] data;
    private int size;

    public IntArrayList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public final void trimToSize() {
        if (this.size < this.data.length) {
            int[] nArray = Arrays.copyOf(this.data, this.size);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            this.data = nArray;
        }
    }

    private final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            int[] nArray = Arrays.copyOf(this.data, Math.max(this.data.length * 3 / 2 + 1, minCapacity));
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            this.data = nArray;
        }
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int get(int index) {
        return this.data[index];
    }

    public final void add(int o) {
        this.ensureCapacity(this.size + 1);
        int n = this.size;
        this.size = n + 1;
        this.data[n] = o;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)this.size)), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>(this){
            final /* synthetic */ IntArrayList this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(int it) {
                return String.valueOf(this.this$0.get(it));
            }
        }), (int)24, null);
    }
}

