/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.AdditionalRootsProviderService;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.builders.java.ResourcesTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.kotlin.config.KotlinResourceRootType;
import org.jetbrains.kotlin.config.ResourceKotlinRootType;
import org.jetbrains.kotlin.config.TestResourceKotlinRootType;
import org.jetbrains.kotlin.jps.build.KotlinResourcesRootProviderKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinResourcesRootProvider;", "Lorg/jetbrains/jps/builders/AdditionalRootsProviderService;", "Lorg/jetbrains/jps/builders/java/ResourceRootDescriptor;", "()V", "getAdditionalRoots", "", "target", "Lorg/jetbrains/jps/builders/BuildTarget;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "jps-plugin"})
public final class KotlinResourcesRootProvider
extends AdditionalRootsProviderService<ResourceRootDescriptor> {
    public KotlinResourcesRootProvider() {
        super((Collection)ResourcesTargetType.ALL_TYPES);
    }

    @NotNull
    public List<ResourceRootDescriptor> getAdditionalRoots(@NotNull BuildTarget<ResourceRootDescriptor> target, @Nullable BuildDataPaths dataPaths) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        ResourcesTarget resourcesTarget = target instanceof ResourcesTarget ? (ResourcesTarget)target : null;
        if (resourcesTarget == null) {
            return CollectionsKt.emptyList();
        }
        ResourcesTarget moduleBuildTarget = resourcesTarget;
        JpsModule jpsModule = moduleBuildTarget.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"moduleBuildTarget.module");
        JpsModule module = jpsModule;
        List result = new ArrayList();
        KotlinResourceRootType kotlinResourceRootType = ((ResourcesTarget)target).isTests() ? (KotlinResourceRootType)TestResourceKotlinRootType.INSTANCE : (KotlinResourceRootType)ResourceKotlinRootType.INSTANCE;
        Iterable iterable = module.getSourceRoots((JpsModuleSourceRootType)kotlinResourceRootType);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"module.getSourceRoots(kotlinResourceRootType)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsTypedModuleSourceRoot it = (JpsTypedModuleSourceRoot)element$iv;
            boolean bl = false;
            File file = it.getFile();
            ResourcesTarget resourcesTarget2 = (ResourcesTarget)target;
            JpsElement jpsElement = it.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)jpsElement, (String)"it.properties");
            result.add(new ResourceRootDescriptor(file, resourcesTarget2, KotlinResourcesRootProviderKt.access$getPackagePrefix((JavaResourceRootProperties)jpsElement), SetsKt.emptySet()));
        }
        return result;
    }
}

