/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LanguageVersionSettingsProvider;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.InterfaceDefaultMethodCallChecker;
import org.jetbrains.kotlin.resolve.jvm.checkers.JvmDefaultCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InterfaceDefaultMethodCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/config/JvmTarget;Lcom/intellij/openapi/project/Project;)V", "ideService", "Lorg/jetbrains/kotlin/resolve/LanguageVersionSettingsProvider;", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findInterfaceMember", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptorToSearch", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "startExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getSuperCallLabelTarget", "expression", "frontend.java"})
public final class InterfaceDefaultMethodCallChecker
implements CallChecker {
    @NotNull
    private final JvmTarget jvmTarget;
    @NotNull
    private final Project project;
    @Nullable
    private final LanguageVersionSettingsProvider ideService;

    public InterfaceDefaultMethodCallChecker(@NotNull JvmTarget jvmTarget, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.jvmTarget = jvmTarget;
        this.project = project;
        this.ideService = LanguageVersionSettingsProvider.Companion.getInstance(this.project);
    }

    @NotNull
    public final JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean supportDefaults = this.jvmTarget.compareTo((Enum)JvmTarget.JVM_1_8) >= 0;
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        CallableMemberDescriptor callableMemberDescriptor = callableDescriptor instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)callableDescriptor : null;
        if (callableMemberDescriptor == null) {
            return;
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        if (descriptor2 instanceof JavaPropertyDescriptor) {
            return;
        }
        if (!supportDefaults && DescriptorUtils.isStaticDeclaration(descriptor2) && DescriptorUtils.isInterface(descriptor2.getContainingDeclaration()) && descriptor2 instanceof JavaCallableMemberDescriptor) {
            context.getTrace().report((Diagnostic)ErrorsJvm.INTERFACE_STATIC_METHOD_CALL_FROM_JAVA6_TARGET.on(context.getLanguageVersionSettings(), reportOn));
        }
        Call call = resolvedCall.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"resolvedCall.call");
        KtSuperExpression ktSuperExpression = CallResolverUtilKt.getSuperCallExpression((Call)call);
        if (ktSuperExpression == null) {
            return;
        }
        KtSuperExpression superCallExpression = ktSuperExpression;
        if (!DescriptorUtils.isInterface(descriptor2.getOriginal().getContainingDeclaration())) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor2 = DescriptorUtils.unwrapFakeOverride(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor2, (String)"unwrapFakeOverride(descriptor)");
        CallableMemberDescriptor realDescriptor = callableMemberDescriptor2;
        DeclarationDescriptor declarationDescriptor = realDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor realDescriptorOwner = classDescriptor;
        JvmDefaultMode jvmDefaultMode2 = context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getJvmDefaultMode());
        if (DescriptorUtils.isInterface(realDescriptorOwner) && (realDescriptor instanceof JavaCallableMemberDescriptor || JvmDefaultCheckerKt.isCompiledToJvmDefaultWithProperMode(realDescriptor, this.ideService, jvmDefaultMode2))) {
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
            BindingContext bindingContext2 = bindingContext;
            ClassDescriptor thisForSuperCall = this.getSuperCallLabelTarget(bindingContext2, superCallExpression);
            if (thisForSuperCall != null && DescriptorUtils.isInterface(thisForSuperCall)) {
                CallableMemberDescriptor declarationWithCall;
                CallableMemberDescriptor callableMemberDescriptor3 = declarationWithCall = this.findInterfaceMember(thisForSuperCall, superCallExpression, bindingContext2);
                boolean bl = callableMemberDescriptor3 != null ? !JvmDefaultCheckerKt.isCompiledToJvmDefaultWithProperMode(callableMemberDescriptor3, this.ideService, jvmDefaultMode2) : false;
                if (bl) {
                    context.getTrace().report((Diagnostic)ErrorsJvm.INTERFACE_CANT_CALL_DEFAULT_METHOD_VIA_SUPER.on(reportOn));
                    return;
                }
            }
            if (!supportDefaults) {
                context.getTrace().report((Diagnostic)ErrorsJvm.DEFAULT_METHOD_CALL_FROM_JAVA6_TARGET.on(context.getLanguageVersionSettings(), reportOn));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CallableMemberDescriptor findInterfaceMember(ClassDescriptor descriptorToSearch, KtSuperExpression startExpression, BindingContext bindingContext) {
        Sequence parents2;
        Sequence $this$fold$iv = parents2 = SequencesKt.generateSequence((Function0)((Function0)new Function0<PsiElement>(startExpression){
            final /* synthetic */ KtSuperExpression $startExpression;
            {
                this.$startExpression = $startExpression;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                return this.$startExpression.getParent();
            }
        }), (Function1)findInterfaceMember.parents.2.INSTANCE);
        boolean $i$f$fold = false;
        KtSuperExpression accumulator$iv = startExpression;
        for (Object element$iv : $this$fold$iv) {
            void parent;
            PsiElement psiElement = (PsiElement)element$iv;
            PsiElement child = (PsiElement)accumulator$iv;
            boolean bl = false;
            if (parent instanceof KtClassBody && Intrinsics.areEqual((Object)descriptorToSearch, (Object)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)((KtClassBody)parent).getParent()))) {
                Object object;
                PsiElement psiElement2 = child;
                return psiElement2 instanceof KtNamedFunction ? (CallableMemberDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)child) : (psiElement2 instanceof KtProperty ? (CallableMemberDescriptor)((object = bindingContext.get((ReadOnlySlice)BindingContext.VARIABLE, (Object)child)) instanceof PropertyDescriptor ? (PropertyDescriptor)object : null) : null);
            }
            accumulator$iv = parent;
        }
        return null;
    }

    private final ClassDescriptor getSuperCallLabelTarget(BindingContext bindingContext, KtSuperExpression expression2) {
        KotlinType kotlinType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, (Object)expression2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType thisTypeForSuperCall = kotlinType;
        ClassifierDescriptor descriptor2 = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
        return descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
    }
}

