/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.statistic;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GcMetric;
import org.jetbrains.kotlin.build.report.statistics.BuildDataType;
import org.jetbrains.kotlin.build.report.statistics.CompileStatisticsData;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0001J\u0019\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0019\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0007H\u0096\u0001J\u0011\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0001J\u0011\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0096\u0001J\u0019\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0011\u0010\"\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0001J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\t\u0010'\u001a\u00020\u0018H\u0096\u0001J\u0019\u0010(\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0011\u0010)\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporterImpl;", "Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "reporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;)V", "startTime", "", "uuid", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "addAttribute", "", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addGcMetric", "metric", "", "value", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetric;", "addMetric", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addTimeMetric", "addTimeMetricMs", "time", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "durationMs", "addTimeMetricNs", "durationNs", "endGcMetric", "name", "endMeasure", "flush", "Lorg/jetbrains/kotlin/build/report/statistics/CompileStatisticsData;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "getMetrics", "startGcMetric", "startMeasure", "Companion", "jps-plugin"})
public final class JpsBuilderMetricReporterImpl
implements JpsBuilderMetricReporter,
BuildMetricsReporter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final BuildMetricsReporterImpl reporter;
    private final UUID uuid;
    private final long startTime;
    @Nullable
    private static final String hostName;

    public JpsBuilderMetricReporterImpl(@NotNull BuildMetricsReporterImpl reporter) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.reporter = reporter;
        this.uuid = UUID.randomUUID();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.reporter.addAttribute(attribute);
    }

    @Override
    public void addGcMetric(@NotNull String metric, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.reporter.addGcMetric(metric, value2);
    }

    @Override
    public void addMetric(@NotNull BuildPerformanceMetric metric, long value2) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.reporter.addMetric(metric, value2);
    }

    @Override
    public void addMetrics(@NotNull BuildMetrics metrics) {
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.reporter.addMetrics(metrics);
    }

    @Override
    public void addTimeMetric(@NotNull BuildPerformanceMetric metric) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.reporter.addTimeMetric(metric);
    }

    @Override
    public void addTimeMetricMs(@NotNull BuildTime time, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.addTimeMetricMs(time, durationMs);
    }

    @Override
    public void addTimeMetricNs(@NotNull BuildTime time, long durationNs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.addTimeMetricNs(time, durationNs);
    }

    @Override
    public void endGcMetric(@NotNull String name, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.reporter.endGcMetric(name, value2);
    }

    @Override
    public void endMeasure(@NotNull BuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.endMeasure(time);
    }

    @Override
    @NotNull
    public BuildMetrics getMetrics() {
        return this.reporter.getMetrics();
    }

    @Override
    public void startGcMetric(@NotNull String name, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.reporter.startGcMetric(name, value2);
    }

    @Override
    public void startMeasure(@NotNull BuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.startMeasure(time);
    }

    @Override
    @NotNull
    public CompileStatisticsData flush(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BuildMetrics buildMetrics = this.reporter.getMetrics();
        String string = context.getProjectDescriptor().getProject().getName();
        long l = this.startTime;
        long l2 = System.currentTimeMillis() - this.startTime;
        Set set = SetsKt.emptySet();
        String string2 = this.uuid.toString();
        List list = CollectionsKt.emptyList();
        String string3 = hostName;
        long l3 = System.currentTimeMillis();
        Map<BuildTime, Long> map = buildMetrics.getBuildTimes().asMapMs();
        Map<BuildPerformanceMetric, Long> map2 = buildMetrics.getBuildPerformanceMetrics().asMap();
        List list2 = CollectionsKt.emptyList();
        Set set2 = SetsKt.emptySet();
        String string4 = BuildDataType.JPS_DATA.name();
        List list3 = CollectionsKt.emptyList();
        List list4 = CollectionsKt.emptyList();
        Map<String, Long> map3 = buildMetrics.getGcMetrics().asGcTimeMap();
        Map<String, Long> map4 = buildMetrics.getGcMetrics().asGcCountMap();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        return new CompileStatisticsData(0, string, "JPS build", "JPS build", "Unknown", l, l2, set, list, string2, "kotlin_version", null, string3, l3, null, list2, set2, map, map2, map3, map4, string4, true, list3, null, list4, 16385, null);
    }

    static {
        String string;
        Companion = new Companion(null);
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception _) {
            string = null;
        }
        hostName = string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporterImpl$Companion;", "", "()V", "hostName", "", "jps-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

