/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.RawSubstitution;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeImpl;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.RawType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeRefinement;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\n\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/load/java/lazy/types/RawTypeImpl;", "Lorg/jetbrains/kotlin/types/FlexibleType;", "Lorg/jetbrains/kotlin/types/RawType;", "lowerBound", "Lorg/jetbrains/kotlin/types/SimpleType;", "upperBound", "(Lorg/jetbrains/kotlin/types/SimpleType;Lorg/jetbrains/kotlin/types/SimpleType;)V", "disableAssertion", "", "(Lorg/jetbrains/kotlin/types/SimpleType;Lorg/jetbrains/kotlin/types/SimpleType;Z)V", "delegate", "getDelegate", "()Lorg/jetbrains/kotlin/types/SimpleType;", "memberScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getMemberScope", "()Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "makeNullableAsSpecified", "newNullability", "refine", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "render", "", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "options", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "replaceAttributes", "newAttributes", "Lorg/jetbrains/kotlin/types/TypeAttributes;", "descriptors.jvm"})
@SourceDebugExtension(value={"SMAP\nRawType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawType.kt\norg/jetbrains/kotlin/load/java/lazy/types/RawTypeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1726#2,3:99\n1549#2:102\n1620#2,3:103\n*S KotlinDebug\n*F\n+ 1 RawType.kt\norg/jetbrains/kotlin/load/java/lazy/types/RawTypeImpl\n*L\n80#1:99,3\n61#1:102\n61#1:103,3\n*E\n"})
public final class RawTypeImpl
extends FlexibleType
implements RawType {
    private RawTypeImpl(SimpleType lowerBound, SimpleType upperBound, boolean disableAssertion) {
        super(lowerBound, upperBound);
        if (!disableAssertion) {
            boolean bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(lowerBound, upperBound);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Lower bound " + lowerBound + " of a flexible type must be a subtype of the upper bound " + upperBound;
                throw new AssertionError((Object)string);
            }
        }
    }

    public RawTypeImpl(@NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        Intrinsics.checkNotNullParameter((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
        this(lowerBound, upperBound, false);
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        return this.getLowerBound();
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        ClassifierDescriptor classifierDescriptor = this.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            throw new IllegalStateException(("Incorrect classifier: " + this.getConstructor().getDeclarationDescriptor()).toString());
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        MemberScope memberScope2 = classDescriptor2.getMemberScope(new RawSubstitution(null, 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"getMemberScope(...)");
        return memberScope2;
    }

    @Override
    @NotNull
    public RawTypeImpl replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter((Object)newAttributes, (String)"newAttributes");
        return new RawTypeImpl(this.getLowerBound().replaceAttributes(newAttributes), this.getUpperBound().replaceAttributes(newAttributes));
    }

    @Override
    @NotNull
    public RawTypeImpl makeNullableAsSpecified(boolean newNullability) {
        return new RawTypeImpl(this.getLowerBound().makeNullableAsSpecified(newNullability), this.getUpperBound().makeNullableAsSpecified(newNullability));
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options) {
        boolean bl;
        String newArgs2;
        String upperRendered;
        String lowerRendered;
        block6: {
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            lowerRendered = renderer.renderType(this.getLowerBound());
            upperRendered = renderer.renderType(this.getUpperBound());
            if (options.getDebugMode()) {
                return "raw (" + lowerRendered + ".." + upperRendered + ')';
            }
            if (this.getUpperBound().getArguments().isEmpty()) {
                return renderer.renderFlexibleType(lowerRendered, upperRendered, TypeUtilsKt.getBuiltIns(this));
            }
            List<String> lowerArgs = RawTypeImpl.render$renderArguments(renderer, this.getLowerBound());
            List<String> upperArgs = RawTypeImpl.render$renderArguments(renderer, this.getUpperBound());
            newArgs2 = CollectionsKt.joinToString$default((Iterable)lowerArgs, (CharSequence)", ", null, null, (int)0, null, (Function1)render.newArgs.1.INSTANCE, (int)30, null);
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)lowerArgs, (Iterable)upperArgs);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (RawTypeImpl.render$onlyOutDiffers((String)it.getFirst(), (String)it.getSecond())) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        String newUpper = bl ? RawTypeImpl.render$replaceArgs(upperRendered, newArgs2) : upperRendered;
        String newLower = RawTypeImpl.render$replaceArgs(lowerRendered, newArgs2);
        if (Intrinsics.areEqual((Object)newLower, (Object)newUpper)) {
            return newLower;
        }
        return renderer.renderFlexibleType(newLower, newUpper, TypeUtilsKt.getBuiltIns(this));
    }

    @Override
    @TypeRefinement
    @NotNull
    public FlexibleType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getLowerBound());
        Intrinsics.checkNotNull((Object)kotlinType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        SimpleType simpleType2 = (SimpleType)kotlinType;
        KotlinType kotlinType2 = kotlinTypeRefiner.refineType(this.getUpperBound());
        Intrinsics.checkNotNull((Object)kotlinType2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        return new RawTypeImpl(simpleType2, (SimpleType)kotlinType2, true);
    }

    private static final boolean render$onlyOutDiffers(String first, String second) {
        return Intrinsics.areEqual((Object)first, (Object)StringsKt.removePrefix((String)second, (CharSequence)"out ")) || Intrinsics.areEqual((Object)second, (Object)"*");
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> render$renderArguments(DescriptorRenderer $renderer, KotlinType type2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = type2.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($renderer.renderTypeProjection((TypeProjection)it));
        }
        return (List)destination$iv$iv;
    }

    private static final String render$replaceArgs(String $this$render_u24replaceArgs, String newArgs2) {
        if (!StringsKt.contains$default((CharSequence)$this$render_u24replaceArgs, (char)'<', (boolean)false, (int)2, null)) {
            return $this$render_u24replaceArgs;
        }
        return StringsKt.substringBefore$default((String)$this$render_u24replaceArgs, (char)'<', null, (int)2, null) + '<' + newArgs2 + '>' + StringsKt.substringAfterLast$default((String)$this$render_u24replaceArgs, (char)'>', null, (int)2, null);
    }
}

