/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.statistic;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.kotlin.build.report.FileReportSettings;
import org.jetbrains.kotlin.build.report.HttpReportSettings;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.JpsBuildTime;
import org.jetbrains.kotlin.build.report.statistics.BuildStartParameters;
import org.jetbrains.kotlin.build.report.statistics.HttpReportService;
import org.jetbrains.kotlin.build.report.statistics.file.FileReportService;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinLogger;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporter;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporterImpl;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ/\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001f0#\u00a2\u0006\u0002\u0010$R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00060\nj\b\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService;", "", "()V", "buildMetrics", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporter;", "fileReportSettings", "Lorg/jetbrains/kotlin/build/report/FileReportSettings;", "finishedModuleBuildMetrics", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "httpReportSettings", "Lorg/jetbrains/kotlin/build/report/HttpReportSettings;", "httpService", "Lorg/jetbrains/kotlin/build/report/statistics/HttpReportService;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "loggerAdapter", "Lorg/jetbrains/kotlin/compilerRunner/JpsKotlinLogger;", "buildFinish", "", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "buildStarted", "moduleBuildFinished", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "moduleBuildStarted", "reportMetrics", "T", "metric", "Lorg/jetbrains/kotlin/build/report/metrics/JpsBuildTime;", "action", "Lkotlin/Function0;", "(Lorg/jetbrains/jps/ModuleChunk;Lorg/jetbrains/kotlin/build/report/metrics/JpsBuildTime;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nJpsStatisticsReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsStatisticsReportService.kt\norg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,174:1\n1#2:175\n1549#3:176\n1620#3,3:177\n31#4,5:180\n*S KotlinDebug\n*F\n+ 1 JpsStatisticsReportService.kt\norg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService\n*L\n144#1:176\n144#1:177,3\n163#1:180,5\n*E\n"})
public final class JpsStatisticsReportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FileReportSettings fileReportSettings = org.jetbrains.kotlin.jps.statistic.JpsStatisticsReportService$Companion.access$initFileReportSettings(Companion);
    @Nullable
    private final HttpReportSettings httpReportSettings = org.jetbrains.kotlin.jps.statistic.JpsStatisticsReportService$Companion.access$initHttpReportSettings(Companion);
    @NotNull
    private final HashMap<String, JpsBuilderMetricReporter> buildMetrics = new HashMap();
    @NotNull
    private final ArrayList<JpsBuilderMetricReporter> finishedModuleBuildMetrics = new ArrayList();
    @NotNull
    private final Logger log;
    @NotNull
    private final JpsKotlinLogger loggerAdapter;
    @Nullable
    private final HttpReportService httpService;

    public JpsStatisticsReportService() {
        HttpReportService httpReportService;
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.statistic.KotlinBuilderReportService");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#org.jetbra\u2026linBuilderReportService\")");
        this.log = logger;
        this.loggerAdapter = new JpsKotlinLogger(this.log);
        JpsStatisticsReportService jpsStatisticsReportService = this;
        HttpReportSettings httpReportSettings = this.httpReportSettings;
        if (httpReportSettings != null) {
            HttpReportSettings it = httpReportSettings;
            JpsStatisticsReportService jpsStatisticsReportService2 = jpsStatisticsReportService;
            boolean bl = false;
            httpReportService = new HttpReportService(it.getUrl(), it.getUser(), it.getPassword());
            jpsStatisticsReportService = jpsStatisticsReportService2;
        } else {
            httpReportService = null;
        }
        jpsStatisticsReportService.httpService = httpReportService;
    }

    public final void moduleBuildStarted(@NotNull ModuleChunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        String moduleName = chunk.getName();
        if (this.buildMetrics.get(moduleName) != null) {
            this.log.warn("Service already initialized for context");
            return;
        }
        this.log.info("JpsStatisticsReportService: Service started");
        Map map = this.buildMetrics;
        Intrinsics.checkNotNullExpressionValue((Object)moduleName, (String)"moduleName");
        map.put(moduleName, new JpsBuilderMetricReporterImpl(chunk, new BuildMetricsReporterImpl(), null, null, 12, null));
    }

    public final void moduleBuildFinished(@NotNull ModuleChunk chunk, @NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String moduleName = chunk.getName();
        JpsBuilderMetricReporter metrics = this.buildMetrics.remove(moduleName);
        if (metrics == null) {
            this.log.warn("Service hasn't initialized for context");
            return;
        }
        this.log.info("JpsStatisticsReportService: Service finished");
        metrics.buildFinish(chunk, context);
        this.finishedModuleBuildMetrics.add(metrics);
    }

    /*
     * WARNING - void declaration
     */
    public final void buildFinish(@NotNull CompileContext context) {
        block2: {
            FileReportSettings fileReportSettings;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$map$iv = this.finishedModuleBuildMetrics;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JpsBuilderMetricReporter jpsBuilderMetricReporter = (JpsBuilderMetricReporter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.flush(context));
            }
            List compileStatisticsData = (List)destination$iv$iv;
            HttpReportService httpReportService = this.httpService;
            if (httpReportService != null) {
                httpReportService.sendData(compileStatisticsData, this.loggerAdapter);
            }
            FileReportSettings fileReportSettings2 = this.fileReportSettings;
            if (fileReportSettings2 == null) break block2;
            FileReportSettings it = fileReportSettings = fileReportSettings2;
            boolean bl = false;
            File file = it.getBuildReportDir();
            String string = context.getProjectDescriptor().getProject().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.projectDescriptor.project.name");
            FileReportService.Companion.reportBuildStatInFile(file, string, true, compileStatisticsData, new BuildStartParameters(CollectionsKt.listOf((Object)"JPS build"), null, null, null, null, 30, null), CollectionsKt.emptyList(), this.loggerAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T reportMetrics(@NotNull ModuleChunk chunk, @NotNull JpsBuildTime metric, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String moduleName = chunk.getName();
        JpsBuilderMetricReporter metrics = this.buildMetrics.get(moduleName);
        if (metrics == null) {
            this.log.warn("Service hasn't initialized for context");
            return (T)action.invoke();
        }
        this.log.info("JpsStatisticsReportService: report metrics");
        BuildMetricsReporter $this$measure$iv = metrics;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure((BuildTime)metric);
        try {
            object = action.invoke();
        }
        finally {
            $this$measure$iv.endMeasure((BuildTime)metric);
        }
        return (T)object;
    }

    public final void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.loggerAdapter.info("Build started for " + context);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService$Companion;", "", "()V", "initFileReportSettings", "Lorg/jetbrains/kotlin/build/report/FileReportSettings;", "initHttpReportSettings", "Lorg/jetbrains/kotlin/build/report/HttpReportSettings;", "jps-plugin"})
    @SourceDebugExtension(value={"SMAP\nJpsStatisticsReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsStatisticsReportService.kt\norg/jetbrains/kotlin/jps/statistic/JpsStatisticsReportService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final FileReportSettings initFileReportSettings() {
            FileReportSettings fileReportSettings;
            String string = System.getProperty("kotlin.build.report.file.output_dir");
            if (string != null) {
                String it = string;
                boolean bl = false;
                fileReportSettings = new FileReportSettings(new File(it), false, 2, null);
            } else {
                fileReportSettings = null;
            }
            return fileReportSettings;
        }

        private final HttpReportSettings initHttpReportSettings() {
            String string = System.getProperty("kotlin.build.report.http.url");
            if (string == null) {
                return null;
            }
            String httpReportUrl = string;
            String httpReportUser = System.getProperty("kotlin.build.report.http.user");
            String httpReportPassword = System.getProperty("kotlin.build.report.http.password");
            boolean includeGitBranch = Boolean.parseBoolean(System.getProperty("kotlin.build.report.http.git_branch", "false"));
            boolean verboseEnvironment = Boolean.parseBoolean(System.getProperty("kotlin.build.report.http.environment.verbose", "false"));
            return new HttpReportSettings(httpReportUrl, httpReportUser, httpReportPassword, verboseEnvironment, includeGitBranch);
        }

        public static final /* synthetic */ FileReportSettings access$initFileReportSettings(Companion $this) {
            return $this.initFileReportSettings();
        }

        public static final /* synthetic */ HttpReportSettings access$initHttpReportSettings(Companion $this) {
            return $this.initHttpReportSettings();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

