/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.KeywordStringsGenerated;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u001a0\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u00a8\u0006\u0013"}, d2={"render", "", "Lorg/jetbrains/kotlin/name/Name;", "shouldBeEscaped", "", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Lorg/jetbrains/kotlin/name/FqName;", "renderFqName", "pathSegments", "", "replacePrefixesInTypeRepresentations", "lowerRendered", "lowerPrefix", "upperRendered", "upperPrefix", "foldedPrefix", "typeStringsDifferOnlyInNullability", "lower", "upper", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nRenderingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderingUtils.kt\norg/jetbrains/kotlin/renderer/RenderingUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,78:1\n1083#2,2:79\n*S KotlinDebug\n*F\n+ 1 RenderingUtils.kt\norg/jetbrains/kotlin/renderer/RenderingUtilsKt\n*L\n30#1:79,2\n*E\n"})
public final class RenderingUtilsKt {
    @NotNull
    public static final String render(@NotNull Name $this$render) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        if (RenderingUtilsKt.shouldBeEscaped($this$render)) {
            StringBuilder stringBuilder = new StringBuilder();
            char c = '`';
            String string2 = $this$render.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String string3 = string2;
            string = stringBuilder.append(c + string3).append('`').toString();
        } else {
            String string4 = $this$render.asString();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeEscaped(Name $this$shouldBeEscaped) {
        String string = $this$shouldBeEscaped.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String string2 = string;
        if (KeywordStringsGenerated.KEYWORDS.contains(string2)) return true;
        CharSequence $this$any$iv = string2;
        boolean $i$f$any = false;
        for (int i = 0; i < $this$any$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$any$iv.charAt(i);
            boolean bl = false;
            if (!Character.isLetterOrDigit(it) && it != '_') {
                return true;
            }
            boolean bl2 = false;
            if (!bl2) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (((CharSequence)string2).length() == 0) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        if (Character.isJavaIdentifierStart(string2.codePointAt(0))) return false;
        return true;
    }

    @NotNull
    public static final String render(@NotNull FqNameUnsafe $this$render) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        List<Name> list = $this$render.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"pathSegments(...)");
        return RenderingUtilsKt.renderFqName(list);
    }

    @NotNull
    public static final String render(@NotNull FqName $this$render) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        List<Name> list = $this$render.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"pathSegments(...)");
        return RenderingUtilsKt.renderFqName(list);
    }

    @NotNull
    public static final String renderFqName(@NotNull List<Name> pathSegments) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        StringBuilder $this$renderFqName_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Name element : pathSegments) {
            if ($this$renderFqName_u24lambda_u241.length() > 0) {
                $this$renderFqName_u24lambda_u241.append(".");
            }
            $this$renderFqName_u24lambda_u241.append(RenderingUtilsKt.render(element));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public static final String replacePrefixesInTypeRepresentations(@NotNull String lowerRendered, @NotNull String lowerPrefix, @NotNull String upperRendered, @NotNull String upperPrefix, @NotNull String foldedPrefix) {
        Intrinsics.checkNotNullParameter((Object)lowerRendered, (String)"lowerRendered");
        Intrinsics.checkNotNullParameter((Object)lowerPrefix, (String)"lowerPrefix");
        Intrinsics.checkNotNullParameter((Object)upperRendered, (String)"upperRendered");
        Intrinsics.checkNotNullParameter((Object)upperPrefix, (String)"upperPrefix");
        Intrinsics.checkNotNullParameter((Object)foldedPrefix, (String)"foldedPrefix");
        if (StringsKt.startsWith$default((String)lowerRendered, (String)lowerPrefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)upperRendered, (String)upperPrefix, (boolean)false, (int)2, null)) {
            String string = lowerRendered.substring(lowerPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String lowerWithoutPrefix = string;
            String string2 = upperRendered.substring(upperPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String upperWithoutPrefix = string2;
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual((Object)lowerWithoutPrefix, (Object)upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + '!';
            }
        }
        return null;
    }

    public static final boolean typeStringsDifferOnlyInNullability(@NotNull String lower, @NotNull String upper) {
        Intrinsics.checkNotNullParameter((Object)lower, (String)"lower");
        Intrinsics.checkNotNullParameter((Object)upper, (String)"upper");
        return Intrinsics.areEqual((Object)lower, (Object)StringsKt.replace$default((String)upper, (String)"?", (String)"", (boolean)false, (int)4, null)) || StringsKt.endsWith$default((String)upper, (String)"?", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(lower + '?'), (Object)upper) || Intrinsics.areEqual((Object)('(' + lower + ")?"), (Object)upper);
    }
}

