/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.name.FqName;

public enum JvmPrimitiveType {
    BOOLEAN(PrimitiveType.BOOLEAN, "boolean", "Z", "java.lang.Boolean"),
    CHAR(PrimitiveType.CHAR, "char", "C", "java.lang.Character"),
    BYTE(PrimitiveType.BYTE, "byte", "B", "java.lang.Byte"),
    SHORT(PrimitiveType.SHORT, "short", "S", "java.lang.Short"),
    INT(PrimitiveType.INT, "int", "I", "java.lang.Integer"),
    FLOAT(PrimitiveType.FLOAT, "float", "F", "java.lang.Float"),
    LONG(PrimitiveType.LONG, "long", "J", "java.lang.Long"),
    DOUBLE(PrimitiveType.DOUBLE, "double", "D", "java.lang.Double");

    private static final Map<String, JvmPrimitiveType> TYPE_BY_NAME;
    private static final Map<PrimitiveType, JvmPrimitiveType> TYPE_BY_PRIMITIVE_TYPE;
    private static final Map<String, JvmPrimitiveType> TYPE_BY_DESC;
    private static final Set<String> WRAPPER_CLASS_INTERNAL_NAMES;
    private static final Map<String, String> OWNER_TO_BOXING_METHOD_DESCRIPTOR;
    private final PrimitiveType primitiveType;
    private final String name;
    private final String desc;
    private final FqName wrapperFqName;

    public static boolean isWrapperClassInternalName(@NotNull String internalName) {
        if (internalName == null) {
            JvmPrimitiveType.$$$reportNull$$$0(0);
        }
        return WRAPPER_CLASS_INTERNAL_NAMES.contains(internalName);
    }

    public static boolean isBoxingMethodDescriptor(@NotNull String owner, @NotNull String methodDescriptor) {
        if (owner == null) {
            JvmPrimitiveType.$$$reportNull$$$0(1);
        }
        if (methodDescriptor == null) {
            JvmPrimitiveType.$$$reportNull$$$0(2);
        }
        return methodDescriptor.equals(OWNER_TO_BOXING_METHOD_DESCRIPTOR.get(owner));
    }

    @NotNull
    public static JvmPrimitiveType get(@NotNull String name) {
        JvmPrimitiveType result;
        if (name == null) {
            JvmPrimitiveType.$$$reportNull$$$0(3);
        }
        if ((result = TYPE_BY_NAME.get(name)) == null) {
            throw new AssertionError((Object)("Non-primitive type name passed: " + name));
        }
        JvmPrimitiveType jvmPrimitiveType = result;
        if (jvmPrimitiveType == null) {
            JvmPrimitiveType.$$$reportNull$$$0(4);
        }
        return jvmPrimitiveType;
    }

    @NotNull
    public static JvmPrimitiveType get(@NotNull PrimitiveType type2) {
        if (type2 == null) {
            JvmPrimitiveType.$$$reportNull$$$0(5);
        }
        JvmPrimitiveType jvmPrimitiveType = TYPE_BY_PRIMITIVE_TYPE.get((Object)type2);
        if (jvmPrimitiveType == null) {
            JvmPrimitiveType.$$$reportNull$$$0(6);
        }
        return jvmPrimitiveType;
    }

    @Nullable
    public static JvmPrimitiveType getByDesc(@NotNull String desc) {
        if (desc == null) {
            JvmPrimitiveType.$$$reportNull$$$0(7);
        }
        return TYPE_BY_DESC.get(desc);
    }

    private JvmPrimitiveType(@NotNull PrimitiveType primitiveType, @NotNull String name, String desc, String wrapperClassName) {
        if (primitiveType == null) {
            JvmPrimitiveType.$$$reportNull$$$0(8);
        }
        if (name == null) {
            JvmPrimitiveType.$$$reportNull$$$0(9);
        }
        if (desc == null) {
            JvmPrimitiveType.$$$reportNull$$$0(10);
        }
        if (wrapperClassName == null) {
            JvmPrimitiveType.$$$reportNull$$$0(11);
        }
        this.primitiveType = primitiveType;
        this.name = name;
        this.desc = desc;
        this.wrapperFqName = new FqName(wrapperClassName);
    }

    @NotNull
    public PrimitiveType getPrimitiveType() {
        PrimitiveType primitiveType = this.primitiveType;
        if (primitiveType == null) {
            JvmPrimitiveType.$$$reportNull$$$0(12);
        }
        return primitiveType;
    }

    @NotNull
    public String getJavaKeywordName() {
        String string = this.name;
        if (string == null) {
            JvmPrimitiveType.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getDesc() {
        String string = this.desc;
        if (string == null) {
            JvmPrimitiveType.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public FqName getWrapperFqName() {
        FqName fqName2 = this.wrapperFqName;
        if (fqName2 == null) {
            JvmPrimitiveType.$$$reportNull$$$0(15);
        }
        return fqName2;
    }

    static {
        TYPE_BY_NAME = new HashMap<String, JvmPrimitiveType>();
        TYPE_BY_PRIMITIVE_TYPE = new EnumMap<PrimitiveType, JvmPrimitiveType>(PrimitiveType.class);
        TYPE_BY_DESC = new HashMap<String, JvmPrimitiveType>();
        WRAPPER_CLASS_INTERNAL_NAMES = new HashSet<String>();
        OWNER_TO_BOXING_METHOD_DESCRIPTOR = new HashMap<String, String>();
        for (JvmPrimitiveType type2 : JvmPrimitiveType.values()) {
            TYPE_BY_NAME.put(type2.getJavaKeywordName(), type2);
            TYPE_BY_PRIMITIVE_TYPE.put(type2.getPrimitiveType(), type2);
            TYPE_BY_DESC.put(type2.getDesc(), type2);
            String internalName = type2.wrapperFqName.asString().replace('.', '/');
            WRAPPER_CLASS_INTERNAL_NAMES.add(internalName);
            OWNER_TO_BOXING_METHOD_DESCRIPTOR.put(internalName, "(" + type2.desc + ")L" + internalName + ";");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDescriptor";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/JvmPrimitiveType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/JvmPrimitiveType";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaKeywordName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesc";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperFqName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isWrapperClassInternalName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBoxingMethodDescriptor";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getByDesc";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

