/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.storage.DefaultSimpleLock;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bB%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\u0002\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/storage/CancellableSimpleLock;", "Lorg/jetbrains/kotlin/storage/DefaultSimpleLock;", "lock", "Ljava/util/concurrent/locks/Lock;", "checkCancelled", "Ljava/lang/Runnable;", "interruptedExceptionHandler", "Lkotlin/Function1;", "Ljava/lang/InterruptedException;", "", "<init>", "(Ljava/util/concurrent/locks/Lock;Ljava/lang/Runnable;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/Runnable;Lkotlin/jvm/functions/Function1;)V", "util.runtime"})
public final class CancellableSimpleLock
extends DefaultSimpleLock {
    @NotNull
    private final Runnable checkCancelled;
    @NotNull
    private final Function1<InterruptedException, Unit> interruptedExceptionHandler;

    public CancellableSimpleLock(@NotNull Lock lock, @NotNull Runnable checkCancelled, @NotNull Function1<? super InterruptedException, Unit> interruptedExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)checkCancelled, (String)"checkCancelled");
        Intrinsics.checkNotNullParameter(interruptedExceptionHandler, (String)"interruptedExceptionHandler");
        super(lock);
        this.checkCancelled = checkCancelled;
        this.interruptedExceptionHandler = interruptedExceptionHandler;
    }

    public CancellableSimpleLock(@NotNull Runnable checkCancelled, @NotNull Function1<? super InterruptedException, Unit> interruptedExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)checkCancelled, (String)"checkCancelled");
        Intrinsics.checkNotNullParameter(interruptedExceptionHandler, (String)"interruptedExceptionHandler");
        ReentrantLock reentrantLock = new ReentrantLock();
        this((Lock)reentrantLock, checkCancelled, interruptedExceptionHandler);
    }

    @Override
    public void lock() {
        try {
            while (!this.getLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                this.checkCancelled.run();
            }
        }
        catch (InterruptedException e) {
            this.interruptedExceptionHandler.invoke((Object)e);
        }
    }
}

