/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageOrApiVersion;
import org.jetbrains.kotlin.utils.DescriptionAware;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u0000 $2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001$B\u0019\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010#\u001a\u00020 H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"j\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersion;", "Lorg/jetbrains/kotlin/utils/DescriptionAware;", "Lorg/jetbrains/kotlin/config/LanguageOrApiVersion;", "", "major", "", "minor", "<init>", "(Ljava/lang/String;III)V", "getMajor", "()I", "getMinor", "KOTLIN_1_0", "KOTLIN_1_1", "KOTLIN_1_2", "KOTLIN_1_3", "KOTLIN_1_4", "KOTLIN_1_5", "KOTLIN_1_6", "KOTLIN_1_7", "KOTLIN_1_8", "KOTLIN_1_9", "KOTLIN_2_0", "KOTLIN_2_1", "isStable", "", "()Z", "usesK2", "getUsesK2", "isDeprecated", "isUnsupported", "versionString", "", "getVersionString", "()Ljava/lang/String;", "toString", "Companion", "util"})
public final class LanguageVersion
extends Enum<LanguageVersion>
implements DescriptionAware,
LanguageOrApiVersion {
    @NotNull
    public static final Companion Companion;
    private final int major;
    private final int minor;
    @NotNull
    private final String versionString;
    @JvmField
    @NotNull
    public static final LanguageVersion FIRST_API_SUPPORTED;
    @JvmField
    @NotNull
    public static final LanguageVersion FIRST_SUPPORTED;
    @JvmField
    @NotNull
    public static final LanguageVersion FIRST_NON_DEPRECATED;
    @JvmField
    @NotNull
    public static final LanguageVersion LATEST_STABLE;
    public static final /* enum */ LanguageVersion KOTLIN_1_0;
    public static final /* enum */ LanguageVersion KOTLIN_1_1;
    public static final /* enum */ LanguageVersion KOTLIN_1_2;
    public static final /* enum */ LanguageVersion KOTLIN_1_3;
    public static final /* enum */ LanguageVersion KOTLIN_1_4;
    public static final /* enum */ LanguageVersion KOTLIN_1_5;
    public static final /* enum */ LanguageVersion KOTLIN_1_6;
    public static final /* enum */ LanguageVersion KOTLIN_1_7;
    public static final /* enum */ LanguageVersion KOTLIN_1_8;
    public static final /* enum */ LanguageVersion KOTLIN_1_9;
    public static final /* enum */ LanguageVersion KOTLIN_2_0;
    public static final /* enum */ LanguageVersion KOTLIN_2_1;
    private static final /* synthetic */ LanguageVersion[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private LanguageVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.versionString = "" + this.major + '.' + this.minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    @Override
    public boolean isStable() {
        return this.compareTo((Enum)LATEST_STABLE) <= 0;
    }

    public final boolean getUsesK2() {
        return this.compareTo((Enum)KOTLIN_2_0) >= 0;
    }

    @Override
    public boolean isDeprecated() {
        return FIRST_SUPPORTED.compareTo((Enum)this) <= 0 && this.compareTo((Enum)FIRST_NON_DEPRECATED) < 0;
    }

    @Override
    public boolean isUnsupported() {
        return this.compareTo((Enum)FIRST_SUPPORTED) < 0;
    }

    @Override
    @NotNull
    public String getVersionString() {
        return this.versionString;
    }

    @NotNull
    public String toString() {
        return this.getVersionString();
    }

    public static LanguageVersion[] values() {
        return (LanguageVersion[])$VALUES.clone();
    }

    public static LanguageVersion valueOf(String value2) {
        return Enum.valueOf(LanguageVersion.class, value2);
    }

    @NotNull
    public static EnumEntries<LanguageVersion> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @Nullable
    public static final LanguageVersion fromVersionString(@Nullable String str) {
        return Companion.fromVersionString(str);
    }

    @JvmStatic
    @Nullable
    public static final LanguageVersion fromFullVersionString(@NotNull String str) {
        return Companion.fromFullVersionString(str);
    }

    static {
        KOTLIN_1_0 = new LanguageVersion(1, 0);
        KOTLIN_1_1 = new LanguageVersion(1, 1);
        KOTLIN_1_2 = new LanguageVersion(1, 2);
        KOTLIN_1_3 = new LanguageVersion(1, 3);
        KOTLIN_1_4 = new LanguageVersion(1, 4);
        KOTLIN_1_5 = new LanguageVersion(1, 5);
        KOTLIN_1_6 = new LanguageVersion(1, 6);
        KOTLIN_1_7 = new LanguageVersion(1, 7);
        KOTLIN_1_8 = new LanguageVersion(1, 8);
        KOTLIN_1_9 = new LanguageVersion(1, 9);
        KOTLIN_2_0 = new LanguageVersion(2, 0);
        KOTLIN_2_1 = new LanguageVersion(2, 1);
        $VALUES = languageVersionArray = new LanguageVersion[]{LanguageVersion.KOTLIN_1_0, LanguageVersion.KOTLIN_1_1, LanguageVersion.KOTLIN_1_2, LanguageVersion.KOTLIN_1_3, LanguageVersion.KOTLIN_1_4, LanguageVersion.KOTLIN_1_5, LanguageVersion.KOTLIN_1_6, LanguageVersion.KOTLIN_1_7, LanguageVersion.KOTLIN_1_8, LanguageVersion.KOTLIN_1_9, LanguageVersion.KOTLIN_2_0, LanguageVersion.KOTLIN_2_1};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        FIRST_API_SUPPORTED = KOTLIN_1_4;
        FIRST_SUPPORTED = KOTLIN_1_4;
        FIRST_NON_DEPRECATED = KOTLIN_1_7;
        LATEST_STABLE = KOTLIN_2_0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersion$Companion;", "", "<init>", "()V", "fromVersionString", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "str", "", "fromFullVersionString", "FIRST_API_SUPPORTED", "FIRST_SUPPORTED", "FIRST_NON_DEPRECATED", "LATEST_STABLE", "util"})
    @SourceDebugExtension(value={"SMAP\nLanguageVersionSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageVersionSettings.kt\norg/jetbrains/kotlin/config/LanguageVersion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,643:1\n1#2:644\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final LanguageVersion fromVersionString(@Nullable String str) {
            Object v0;
            block1: {
                Iterable iterable = LanguageVersion.getEntries();
                for (Object t : iterable) {
                    LanguageVersion it = (LanguageVersion)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getVersionString(), (Object)str)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @JvmStatic
        @Nullable
        public final LanguageVersion fromFullVersionString(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String[] stringArray = new String[]{".", "-"};
            List it = StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            return it.size() >= 2 ? Companion.fromVersionString((String)it.get(0) + '.' + (String)it.get(1)) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

