/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.build.CommonBuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporter;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#2\u0006\u0010$\u001a\u00020\u0018H\u0002J*\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00020'04H\u0016R\u0014\u0010\b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001aR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinCommonModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "Lorg/jetbrains/kotlin/build/CommonBuildMetaInfo;", "kotlinContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "jpsModuleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "buildMetaInfo", "getBuildMetaInfo", "()Lorg/jetbrains/kotlin/build/CommonBuildMetaInfo;", "compilerArgumentsFileName", "", "getCompilerArgumentsFileName", "()Ljava/lang/String;", "dependenciesOutputDirs", "", "getDependenciesOutputDirs", "()Ljava/util/List;", "destination", "getDestination", "globalLookupCacheId", "getGlobalLookupCacheId", "hasCaches", "", "getHasCaches", "()Z", "isIncrementalCompilationEnabled", "libraryFiles", "getLibraryFiles", "addDependencyMetaFile", "", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "result", "", "isTests", "compileModuleChunk", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "dirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "buildMetricReporter", "Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporter;", "createCacheStorage", "", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "isEnabled", "chunkCompilerArguments", "Lkotlin/Lazy;", "jps-plugin"})
public final class KotlinCommonModuleBuildTarget
extends KotlinModuleBuildTarget<CommonBuildMetaInfo> {
    public KotlinCommonModuleBuildTarget(@NotNull KotlinCompileContext kotlinContext, @NotNull ModuleBuildTarget jpsModuleBuildTarget) {
        Intrinsics.checkNotNullParameter((Object)kotlinContext, (String)"kotlinContext");
        Intrinsics.checkNotNullParameter((Object)jpsModuleBuildTarget, (String)"jpsModuleBuildTarget");
        super(kotlinContext, jpsModuleBuildTarget);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEnabled(@NotNull Lazy<? extends CommonCompilerArguments> chunkCompilerArguments) {
        Intrinsics.checkNotNullParameter(chunkCompilerArguments, (String)"chunkCompilerArguments");
        K2MetadataCompilerArguments k2MetadataArguments = ModuleSettingsKt.getK2MetadataCompilerArguments(this.getModule());
        if (k2MetadataArguments.getEnabledInJps()) return true;
        Object object = chunkCompilerArguments.getValue();
        if (!(object instanceof K2MetadataCompilerArguments)) return false;
        K2MetadataCompilerArguments k2MetadataCompilerArguments = (K2MetadataCompilerArguments)object;
        if (k2MetadataCompilerArguments == null) return false;
        if (!k2MetadataCompilerArguments.getEnabledInJps()) return false;
        return true;
    }

    @Override
    public boolean isIncrementalCompilationEnabled() {
        return false;
    }

    @Override
    @NotNull
    public String getCompilerArgumentsFileName() {
        return "common-build-meta-info.txt";
    }

    @Override
    @NotNull
    public CommonBuildMetaInfo getBuildMetaInfo() {
        return new CommonBuildMetaInfo();
    }

    @Override
    @NotNull
    public String getGlobalLookupCacheId() {
        return "metadata-compiler";
    }

    @Override
    public boolean compileModuleChunk(@NotNull CommonCompilerArguments commonArguments, @NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull JpsCompilerEnvironment environment, @Nullable JpsBuilderMetricReporter buildMetricReporter) {
        Intrinsics.checkNotNullParameter((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (!Intrinsics.areEqual(this.getChunk().getRepresentativeTarget(), (Object)this)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.reportAndSkipCircular(environment);
        new JpsKotlinCompilerRunner().runK2MetadataCompiler(commonArguments, ModuleSettingsKt.getK2MetadataCompilerArguments(this.getModule()), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()), environment, this.getDestination(), CollectionsKt.plus((Collection)this.getDependenciesOutputDirs(), (Iterable)this.getLibraryFiles()), this.getSourceFiles(), buildMetricReporter);
        return true;
    }

    private final List<String> getLibraryFiles() {
        List list;
        List result = list = (List)new ArrayList();
        boolean bl = false;
        for (JpsLibrary library : this.getAllDependencies().getLibraries()) {
            for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                String string = JpsPathUtil.urlToPath((String)root.getUrl());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(root.url)");
                result.add(string);
            }
        }
        return list;
    }

    private final List<String> getDependenciesOutputDirs() {
        List list;
        List result = list = (List)new ArrayList();
        boolean bl = false;
        this.getAllDependencies().processModules(arg_0 -> KotlinCommonModuleBuildTarget._get_dependenciesOutputDirs_$lambda$2$lambda$1((Function1)new Function1<JpsModule, Unit>(this, (List<String>)result){
            final /* synthetic */ KotlinCommonModuleBuildTarget this$0;
            final /* synthetic */ List<String> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(1);
            }

            public final void invoke(JpsModule module) {
                if (this.this$0.isTests()) {
                    Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
                    KotlinCommonModuleBuildTarget.access$addDependencyMetaFile(this.this$0, module, this.$result, true);
                }
                Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
                KotlinCommonModuleBuildTarget.access$addDependencyMetaFile(this.this$0, module, this.$result, false);
            }
        }, arg_0));
        return list;
    }

    @NotNull
    public final String getDestination() {
        String string = ModuleSettingsKt.getK2MetadataCompilerArguments(this.getModule()).getDestination();
        if (string == null) {
            String string2 = this.getOutputDir().getAbsolutePath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputDir.absolutePath");
        }
        return string;
    }

    private final void addDependencyMetaFile(JpsModule module, List<String> result, boolean isTests) {
        KotlinModuleBuildTarget<?> dependencyBuildTarget = this.getKotlinContext().getTargetsBinding().get(JpsUtilKt.ModuleBuildTarget(module, isTests));
        if (!Intrinsics.areEqual(dependencyBuildTarget, (Object)this) && dependencyBuildTarget instanceof KotlinCommonModuleBuildTarget && !dependencyBuildTarget.getSources().isEmpty()) {
            result.add(((KotlinCommonModuleBuildTarget)dependencyBuildTarget).getDestination());
        }
    }

    @Override
    public boolean getHasCaches() {
        return false;
    }

    @NotNull
    public Void createCacheStorage(@NotNull BuildDataPaths paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        throw new IllegalStateException("incremental K2MetadataCompiler not supported yet, createCacheStorage() should not be called".toString());
    }

    private static final void _get_dependenciesOutputDirs_$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$addDependencyMetaFile(KotlinCommonModuleBuildTarget $this, JpsModule module, List result, boolean isTests) {
        $this.addDependencyMetaFile(module, result, isTests);
    }
}

