/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "<init>", "()V", "alwaysApplicable", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nFileClassAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileClassAnnotationsChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1755#2,3:93\n1755#2,3:96\n*S KotlinDebug\n*F\n+ 1 FileClassAnnotationsChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker\n*L\n60#1:93,3\n83#1:96,3\n*E\n"})
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final FileClassAnnotationsChecker INSTANCE = new FileClassAnnotationsChecker();
    @NotNull
    private static final HashSet<FqName> alwaysApplicable;

    private FileClassAnnotationsChecker() {
    }

    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        ClassDescriptor classDescriptor;
        KtAnnotationEntry entry;
        boolean isMultifileClass;
        ArrayList<Pair> fileAnnotationsToCheck;
        block13: {
            boolean bl;
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            fileAnnotationsToCheck = new ArrayList<Pair>();
            for (KtAnnotationEntry iterator2 : entries) {
                Object classDescriptor2;
                Set applicableTargets;
                AnnotationDescriptor descriptor;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = iterator2.getUseSiteTarget();
                if ((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) != AnnotationUseSiteTarget.FILE || (AnnotationDescriptor)trace.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)iterator2) == null || DescriptorUtilsKt.getAnnotationClass(descriptor) == null || (applicableTargets = AnnotationChecker.Companion.applicableTargetSetFromTargetAnnotationOrNull((ClassDescriptor)classDescriptor2)) == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair((Object)iterator2, classDescriptor2));
            }
            Iterable iterable = fileAnnotationsToCheck;
            boolean $i$f$any = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)it.getSecond()), (Object)JvmStandardClassIds.INSTANCE.getJVM_MULTIFILE_CLASS())) continue;
                    bl = true;
                    break block13;
                }
                bl = isMultifileClass = false;
            }
        }
        if (isMultifileClass) {
            Iterator iterator2 = fileAnnotationsToCheck.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Pair pair = (Pair)e;
                entry = (KtAnnotationEntry)pair.component1();
                classDescriptor = (ClassDescriptor)pair.component2();
                FqName classFqName = DescriptorUtilsKt.getFqNameSafe(classDescriptor);
                if (alwaysApplicable.contains(classFqName) || DescriptorUtilsKt.getAnnotationRetention(classDescriptor) == KotlinRetention.SOURCE) continue;
                trace.report((Diagnostic)ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((PsiElement)entry, (Object)classFqName));
            }
        } else {
            Iterator iterator4 = fileAnnotationsToCheck.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
            Iterator iterator5 = iterator4;
            while (iterator5.hasNext()) {
                boolean bl;
                block14: {
                    String value2;
                    Object[] stringTemplateEntries;
                    Object e = iterator5.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Pair pair = (Pair)e;
                    entry = (KtAnnotationEntry)pair.component1();
                    classDescriptor = (ClassDescriptor)pair.component2();
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor), (Object)JvmStandardClassIds.INSTANCE.getJVM_PACKAGE_NAME())) continue;
                    List list = entry.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
                    ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)list);
                    if (valueArgument == null || (valueArgument = valueArgument.getArgumentExpression()) == null) continue;
                    ValueArgument argumentExpression = valueArgument;
                    Object[] objectArray = argumentExpression instanceof KtStringTemplateExpression ? (Object[])argumentExpression : null;
                    if (objectArray == null) continue;
                    if ((objectArray = objectArray.getEntries()) == null || (stringTemplateEntries = objectArray).length > 1) continue;
                    Object object = ArraysKt.singleOrNull((Object[])stringTemplateEntries);
                    KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = object instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object : null;
                    String string = value2 = ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
                    if (value2 == null) {
                        trace.report((Diagnostic)ErrorsJvm.JVM_PACKAGE_NAME_CANNOT_BE_EMPTY.on((PsiElement)entry));
                        continue;
                    }
                    if (!FqNamesUtilKt.isValidJavaFqName(value2)) {
                        trace.report((Diagnostic)ErrorsJvm.JVM_PACKAGE_NAME_MUST_BE_VALID_NAME.on((PsiElement)entry));
                        continue;
                    }
                    Iterable $this$any$iv = entry.getContainingKtFile().getDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv;
                            boolean bl3 = false;
                            if (!(!(it instanceof KtFunction) && !(it instanceof KtProperty) && !(it instanceof KtTypeAlias))) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                trace.report((Diagnostic)ErrorsJvm.JVM_PACKAGE_NAME_NOT_SUPPORTED_IN_FILES_WITH_CLASSES.on((PsiElement)entry));
            }
        }
    }

    static {
        Object[] objectArray = new FqName[]{JvmStandardClassIds.JVM_NAME, JvmStandardClassIds.INSTANCE.getJVM_MULTIFILE_CLASS()};
        alwaysApplicable = SetsKt.hashSetOf((Object[])objectArray);
    }
}

