/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\tH\u0007J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\tH\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils;", "", "<init>", "()V", "getPathHashCode", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "PART_CLASS_NAME_SUFFIX", "", "decapitalizeAsJavaClassName", "str", "getDefaultPartFqName", "Lorg/jetbrains/kotlin/name/FqName;", "facadeClassFqName", "getPackagePartFqName", "packageFqName", "fileName", "getFilesWithCallables", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "getFilePartShortName", "getFileNameByFacadeName", "facadeClassName", "frontend.common.jvm"})
@SourceDebugExtension(value={"SMAP\nPackagePartClassUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackagePartClassUtils.kt\norg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n774#2:60\n865#2,2:61\n*S KotlinDebug\n*F\n+ 1 PackagePartClassUtils.kt\norg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils\n*L\n46#1:60\n46#1:61,2\n*E\n"})
public final class PackagePartClassUtils {
    @NotNull
    public static final PackagePartClassUtils INSTANCE = new PackagePartClassUtils();
    @NotNull
    private static final String PART_CLASS_NAME_SUFFIX = "Kt";

    private PackagePartClassUtils() {
    }

    @JvmStatic
    public static final int getPathHashCode(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2.hashCode();
    }

    @JvmStatic
    private static final String decapitalizeAsJavaClassName(String str) {
        String string;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = str.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            String string4 = str.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else if (str.charAt(0) == '_') {
            String string5 = str.substring(1);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        } else {
            string = str;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultPartFqName(@NotNull FqName facadeClassFqName, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)facadeClassFqName, (String)"facadeClassFqName");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FqName fqName = facadeClassFqName.parent();
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return PackagePartClassUtils.getPackagePartFqName(fqName, string);
    }

    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull FqName packageFqName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String partClassName = PackagePartClassUtils.getFilePartShortName(fileName);
        Name name = Name.identifier(partClassName);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return packageFqName.child(name);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<KtFile> getFilesWithCallables(@NotNull Collection<? extends KtFile> files) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!it.hasTopLevelCallables()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final String getFilePartShortName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        StringBuilder stringBuilder = new StringBuilder();
        String string = FileUtil.getNameWithoutExtension((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        return stringBuilder.append(NameUtils.getPackagePartClassNamePrefix(string)).append(PART_CLASS_NAME_SUFFIX).toString();
    }

    @JvmStatic
    @Nullable
    public static final String getFileNameByFacadeName(@NotNull String facadeClassName) {
        Intrinsics.checkNotNullParameter((Object)facadeClassName, (String)"facadeClassName");
        if (!StringsKt.endsWith$default((String)facadeClassName, (String)PART_CLASS_NAME_SUFFIX, (boolean)false, (int)2, null)) {
            return null;
        }
        String string = facadeClassName.substring(0, facadeClassName.length() - 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String baseName = string;
        if (Intrinsics.areEqual((Object)baseName, (Object)"_")) {
            return null;
        }
        return PackagePartClassUtils.decapitalizeAsJavaClassName(baseName) + ".kt";
    }
}

