/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/util/Time;", "", "nanos", "", "userNanos", "cpuNanos", "<init>", "(JJJ)V", "getNanos", "()J", "getUserNanos", "getCpuNanos", "millis", "getMillis", "plus", "other", "minus", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "", "toString", "", "Companion", "compiler.common"})
public final class Time {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long nanos;
    private final long userNanos;
    private final long cpuNanos;
    @NotNull
    private static final Time ZERO = new Time(0L, 0L, 0L);

    public Time(long nanos, long userNanos, long cpuNanos) {
        this.nanos = nanos;
        this.userNanos = userNanos;
        this.cpuNanos = cpuNanos;
    }

    public final long getNanos() {
        return this.nanos;
    }

    public final long getUserNanos() {
        return this.userNanos;
    }

    public final long getCpuNanos() {
        return this.cpuNanos;
    }

    public final long getMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanos);
    }

    @NotNull
    public final Time plus(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Time(this.nanos + other.nanos, this.userNanos + other.userNanos, this.cpuNanos + other.cpuNanos);
    }

    @NotNull
    public final Time minus(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Time(this.nanos - other.nanos, this.userNanos - other.userNanos, this.cpuNanos - other.cpuNanos);
    }

    public final long component1() {
        return this.nanos;
    }

    public final long component2() {
        return this.userNanos;
    }

    public final long component3() {
        return this.cpuNanos;
    }

    @NotNull
    public final Time copy(long nanos, long userNanos, long cpuNanos) {
        return new Time(nanos, userNanos, cpuNanos);
    }

    public static /* synthetic */ Time copy$default(Time time, long l, long l2, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            l = time.nanos;
        }
        if ((n & 2) != 0) {
            l2 = time.userNanos;
        }
        if ((n & 4) != 0) {
            l3 = time.cpuNanos;
        }
        return time.copy(l, l2, l3);
    }

    @NotNull
    public String toString() {
        return "Time(nanos=" + this.nanos + ", userNanos=" + this.userNanos + ", cpuNanos=" + this.cpuNanos + ')';
    }

    public int hashCode() {
        int result = Long.hashCode(this.nanos);
        result = result * 31 + Long.hashCode(this.userNanos);
        result = result * 31 + Long.hashCode(this.cpuNanos);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Time)) {
            return false;
        }
        Time time = (Time)other;
        if (this.nanos != time.nanos) {
            return false;
        }
        if (this.userNanos != time.userNanos) {
            return false;
        }
        return this.cpuNanos == time.cpuNanos;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/util/Time$Companion;", "", "<init>", "()V", "ZERO", "Lorg/jetbrains/kotlin/util/Time;", "getZERO", "()Lorg/jetbrains/kotlin/util/Time;", "compiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Time getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

