/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.io.File;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerOutputFileLayout;", "", "()V", "maxFileNameLength", "", "fileName", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "getFileName", "(Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;)Ljava/lang/String;", "base64Hash", "value", "ensureMaxFileNameLength", "resolveCommonizedDirectory", "Ljava/io/File;", "root", "target", "kotlin-klib-commonizer-api"})
public final class CommonizerOutputFileLayout {
    @NotNull
    public static final CommonizerOutputFileLayout INSTANCE = new CommonizerOutputFileLayout();
    public static final int maxFileNameLength = 150;

    private CommonizerOutputFileLayout() {
    }

    @NotNull
    public final File resolveCommonizedDirectory(@NotNull File root, @NotNull CommonizerTarget target) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return FilesKt.resolve((File)root, (String)this.getFileName(target));
    }

    @NotNull
    public final String getFileName(@NotNull CommonizerTarget $this$fileName) {
        Intrinsics.checkNotNullParameter((Object)$this$fileName, (String)"<this>");
        return this.ensureMaxFileNameLength(CommonizerTargetKt.getIdentityString($this$fileName));
    }

    @NotNull
    public final String ensureMaxFileNameLength(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (fileName.length() > 150) {
            String hashSuffix = "[--" + this.base64Hash(fileName) + ']';
            return StringsKt.take((String)fileName, (int)(150 - hashSuffix.length())) + hashSuffix;
        }
        return fileName;
    }

    @NotNull
    public final String base64Hash(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        Base64.Encoder base64 = Base64.getUrlEncoder();
        byte[] byArray = base64.encode(sha.digest(StringsKt.encodeToByteArray((String)value)));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"base64.encode(sha.digest\u2026lue.encodeToByteArray()))");
        return StringsKt.decodeToString((byte[])byArray);
    }
}

