/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.mergedtree;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.ApproximationKeysKt;
import org.jetbrains.kotlin.descriptors.commonizer.utils.InternersKt;
import org.jetbrains.kotlin.descriptors.commonizer.utils.TypeKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\r\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0010\u001a\u00020\u0006H\u00c2\u0003J\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\bH\u00c2\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0013\u001a\u00020\fH\u00c2\u0003J\u0011\u0010\u0014\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nH\u00c2\u0003JH\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0012\b\u0002\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0010\b\u0002\u0010\r\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\fH\u0016J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/FunctionApproximationKey;", "", "function", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "valueParametersTypes", "", "", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirTypeSignature;", "additionalValueParametersNamesHash", "", "extensionReceiverParameterType", "(Lorg/jetbrains/kotlin/name/Name;[Ljava/lang/String;ILjava/lang/String;)V", "[Ljava/lang/String;", "component1", "component2", "()[Ljava/lang/String;", "component3", "component4", "copy", "(Lorg/jetbrains/kotlin/name/Name;[Ljava/lang/String;ILjava/lang/String;)Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/FunctionApproximationKey;", "equals", "", "other", "hashCode", "toString", "kotlin-klib-commonizer"})
public final class FunctionApproximationKey {
    private final Name name;
    private final String[] valueParametersTypes;
    private final int additionalValueParametersNamesHash;
    private final String extensionReceiverParameterType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof FunctionApproximationKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)((FunctionApproximationKey)other).name)) return false;
        if (this.additionalValueParametersNamesHash != ((FunctionApproximationKey)other).additionalValueParametersNamesHash) return false;
        Object[] objectArray = this.valueParametersTypes;
        Object[] objectArray2 = ((FunctionApproximationKey)other).valueParametersTypes;
        boolean bl = false;
        if (!Arrays.equals(objectArray, objectArray2)) return false;
        if (!Intrinsics.areEqual((Object)this.extensionReceiverParameterType, (Object)((FunctionApproximationKey)other).extensionReceiverParameterType)) return false;
        return true;
    }

    public int hashCode() {
        int $this$appendHashCode$iv;
        int n;
        boolean bl;
        Object object;
        Name value$iv22 = this.name;
        boolean $i$f$hashCode = false;
        Name name = value$iv22;
        boolean bl2 = false;
        Name name2 = name;
        int value$iv22 = name2 != null ? name2.hashCode() : 0;
        Object[] array$iv = this.valueParametersTypes;
        boolean $i$f$appendHashCode = false;
        boolean $i$f$hashCode2 = false;
        if (array$iv != null) {
            object = array$iv;
            bl = false;
            n = Arrays.hashCode((Object[])object);
        } else {
            n = 0;
        }
        $this$appendHashCode$iv = 31 * $this$appendHashCode$iv + n;
        Object value$iv = this.extensionReceiverParameterType;
        $i$f$appendHashCode = false;
        $i$f$hashCode2 = false;
        object = value$iv;
        bl = false;
        Object object2 = object;
        $this$appendHashCode$iv = 31 * $this$appendHashCode$iv + (object2 != null ? object2.hashCode() : 0);
        value$iv = this.additionalValueParametersNamesHash;
        $i$f$appendHashCode = false;
        $i$f$hashCode2 = false;
        object = value$iv;
        bl = false;
        return 31 * $this$appendHashCode$iv + object.hashCode();
    }

    public FunctionApproximationKey(@NotNull Name name, @NotNull String[] valueParametersTypes, int additionalValueParametersNamesHash, @Nullable String extensionReceiverParameterType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)valueParametersTypes, (String)"valueParametersTypes");
        this.name = name;
        this.valueParametersTypes = valueParametersTypes;
        this.additionalValueParametersNamesHash = additionalValueParametersNamesHash;
        this.extensionReceiverParameterType = extensionReceiverParameterType;
    }

    /*
     * WARNING - void declaration
     */
    public FunctionApproximationKey(@NotNull SimpleFunctionDescriptor function) {
        ReceiverParameterDescriptor receiverParameterDescriptor;
        void $this$toTypeSignatures$iv;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Name name = function.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"function.name");
        Name name2 = InternersKt.intern(name);
        List list = function.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"function.valueParameters");
        List list2 = list;
        Name name3 = name2;
        FunctionApproximationKey functionApproximationKey = this;
        boolean $i$f$toTypeSignatures = false;
        int n = $this$toTypeSignatures$iv.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string;
            void index$iv;
            int n3 = n2;
            int n4 = n2++;
            String[] stringArray2 = stringArray;
            boolean bl = false;
            KotlinType kotlinType = ((ValueParameterDescriptor)$this$toTypeSignatures$iv.get((int)index$iv)).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"this[index].type");
            stringArray2[n4] = string = TypeKt.getSignature(kotlinType);
        }
        String[] stringArray3 = stringArray;
        functionApproximationKey(name3, stringArray3, ApproximationKeysKt.access$additionalValueParameterNamesHash((FunctionDescriptor)function), (receiverParameterDescriptor = function.getExtensionReceiverParameter()) != null && (receiverParameterDescriptor = receiverParameterDescriptor.getType()) != null ? TypeKt.getSignature((KotlinType)receiverParameterDescriptor) : null);
    }

    private final Name component1() {
        return this.name;
    }

    private final String[] component2() {
        return this.valueParametersTypes;
    }

    private final int component3() {
        return this.additionalValueParametersNamesHash;
    }

    private final String component4() {
        return this.extensionReceiverParameterType;
    }

    @NotNull
    public final FunctionApproximationKey copy(@NotNull Name name, @NotNull String[] valueParametersTypes, int additionalValueParametersNamesHash, @Nullable String extensionReceiverParameterType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)valueParametersTypes, (String)"valueParametersTypes");
        return new FunctionApproximationKey(name, valueParametersTypes, additionalValueParametersNamesHash, extensionReceiverParameterType);
    }

    public static /* synthetic */ FunctionApproximationKey copy$default(FunctionApproximationKey functionApproximationKey, Name name, String[] stringArray, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            name = functionApproximationKey.name;
        }
        if ((n2 & 2) != 0) {
            stringArray = functionApproximationKey.valueParametersTypes;
        }
        if ((n2 & 4) != 0) {
            n = functionApproximationKey.additionalValueParametersNamesHash;
        }
        if ((n2 & 8) != 0) {
            string = functionApproximationKey.extensionReceiverParameterType;
        }
        return functionApproximationKey.copy(name, stringArray, n, string);
    }

    @NotNull
    public String toString() {
        return "FunctionApproximationKey(name=" + this.name + ", valueParametersTypes=" + Arrays.toString(this.valueParametersTypes) + ", additionalValueParametersNamesHash=" + this.additionalValueParametersNamesHash + ", extensionReceiverParameterType=" + this.extensionReceiverParameterType + ")";
    }
}

