/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.stats.DeclarationType;
import org.jetbrains.kotlin.descriptors.commonizer.stats.RawStatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.StatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.StatsOutput;
import org.jetbrains.kotlin.descriptors.commonizer.utils.TypeKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector;", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsCollector;", "targets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "output", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsOutput;", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsOutput;)V", "headerWritten", "", "close", "", "logStats", "result", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "writeHeader", "CommonDeclarationStatus", "PlatformDeclarationStatus", "RawStatsHeader", "RawStatsRow", "kotlin-klib-commonizer"})
public final class RawStatsCollector
implements StatsCollector {
    private boolean headerWritten;
    private final List<KonanTarget> targets;
    private final StatsOutput output;

    /*
     * WARNING - void declaration
     */
    @Override
    public void logStats(@NotNull List<? extends DeclarationDescriptor> result) {
        Object element$iv$iv2;
        int $i$f$firstIsInstance;
        Iterable $this$firstIsInstance$iv$iv;
        block10: {
            Intrinsics.checkNotNullParameter(result, (String)"result");
            if (!this.headerWritten) {
                this.writeHeader();
                this.headerWritten = true;
            }
            Iterable $this$firstNonNull$iv = result;
            boolean $i$f$firstNonNull = false;
            $this$firstIsInstance$iv$iv = $this$firstNonNull$iv;
            $i$f$firstIsInstance = 0;
            for (Object element$iv$iv2 : $this$firstIsInstance$iv$iv) {
                if (!(element$iv$iv2 instanceof DeclarationDescriptor)) continue;
                break block10;
            }
            throw (Throwable)new NoSuchElementException("No element of given type found");
        }
        DeclarationDescriptor firstNotNull = (DeclarationDescriptor)element$iv$iv2;
        boolean lastIsNull = CollectionsKt.last(result) == null;
        int n = this.targets.size();
        String string = firstNotNull instanceof ModuleDescriptor ? ((ModuleDescriptor)firstNotNull).getName().asString() : DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)firstNotNull).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (firstNotNull is Modu\u2026ull.fqNameSafe.asString()");
        RawStatsRow statsRow = new RawStatsRow(n, string, DeclarationType.Companion.getDeclarationType(firstNotNull));
        if (firstNotNull instanceof PropertyDescriptor || firstNotNull instanceof SimpleFunctionDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)firstNotNull).getExtensionReceiverParameter();
            $this$firstIsInstance$iv$iv = receiverParameterDescriptor != null && (receiverParameterDescriptor = receiverParameterDescriptor.getType()) != null ? TypeKt.getSignature((KotlinType)receiverParameterDescriptor) : null;
            $i$f$firstIsInstance = 0;
            Object object = $this$firstIsInstance$iv$iv;
            if (object == null) {
                object = "";
            }
            statsRow.setExtensionReceiver((String)object);
        }
        if (firstNotNull instanceof ConstructorDescriptor || firstNotNull instanceof SimpleFunctionDescriptor) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)firstNotNull;
            List list = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"functionDescriptor.valueParameters");
            statsRow.setParameterNames(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)logStats.1.INSTANCE, (int)31, null));
            List list2 = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"functionDescriptor.valueParameters");
            statsRow.setParameterTypes(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)logStats.2.INSTANCE, (int)31, null));
        }
        boolean isLiftedUp = !lastIsNull;
        $i$f$firstIsInstance = 0;
        int n2 = result.size() - 1;
        while ($i$f$firstIsInstance < n2) {
            PlatformDeclarationStatus platformDeclarationStatus;
            void index;
            Collection collection = statsRow.getPlatform();
            if (result.get((int)index) == null) {
                platformDeclarationStatus = PlatformDeclarationStatus.ABSENT;
            } else if (lastIsNull) {
                platformDeclarationStatus = PlatformDeclarationStatus.ORIGINAL;
            } else {
                isLiftedUp = false;
                platformDeclarationStatus = PlatformDeclarationStatus.ACTUAL;
            }
            PlatformDeclarationStatus platformDeclarationStatus2 = platformDeclarationStatus;
            boolean bl = false;
            collection.add(platformDeclarationStatus2);
            ++index;
        }
        statsRow.setCommon(isLiftedUp ? CommonDeclarationStatus.LIFTED_UP : (lastIsNull ? CommonDeclarationStatus.ABSENT : CommonDeclarationStatus.EXPECT));
        this.output.writeRow(statsRow);
    }

    @Override
    public void close() {
        this.output.close();
    }

    /*
     * WARNING - void declaration
     */
    private final void writeHeader() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.targets;
        StatsOutput statsOutput = this.output;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KonanTarget konanTarget = (KonanTarget)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        statsOutput.writeHeader(new RawStatsHeader(list));
    }

    public RawStatsCollector(@NotNull List<? extends KonanTarget> targets, @NotNull StatsOutput output) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.targets = targets;
        this.output = output;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector$RawStatsHeader;", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsOutput$StatsHeader;", "targetNames", "", "", "(Ljava/util/List;)V", "toList", "kotlin-klib-commonizer"})
    public static final class RawStatsHeader
    implements StatsOutput.StatsHeader {
        private final List<String> targetNames;

        @Override
        @NotNull
        public List<String> toList() {
            boolean bl = false;
            List list = new ArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List $this$apply = list;
            boolean bl4 = false;
            Collection collection = $this$apply;
            Object object = "FQ Name";
            boolean bl5 = false;
            collection.add(object);
            collection = $this$apply;
            object = "Extension Receiver";
            bl5 = false;
            collection.add(object);
            collection = $this$apply;
            object = "Parameter Names";
            bl5 = false;
            collection.add(object);
            collection = $this$apply;
            object = "Parameter Types";
            bl5 = false;
            collection.add(object);
            collection = $this$apply;
            object = "Declaration Type";
            bl5 = false;
            collection.add(object);
            collection = $this$apply;
            object = "common";
            bl5 = false;
            collection.add(object);
            collection = $this$apply;
            object = this.targetNames;
            bl5 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
            return list;
        }

        public RawStatsHeader(@NotNull List<String> targetNames2) {
            Intrinsics.checkNotNullParameter(targetNames2, (String)"targetNames");
            this.targetNames = targetNames2;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050#H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u0015R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector$RawStatsRow;", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/StatsOutput$StatsRow;", "dimension", "", "fqName", "", "declarationType", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/DeclarationType;", "(ILjava/lang/String;Lorg/jetbrains/kotlin/descriptors/commonizer/stats/DeclarationType;)V", "common", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector$CommonDeclarationStatus;", "getCommon", "()Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector$CommonDeclarationStatus;", "setCommon", "(Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector$CommonDeclarationStatus;)V", "getDeclarationType", "()Lorg/jetbrains/kotlin/descriptors/commonizer/stats/DeclarationType;", "extensionReceiver", "getExtensionReceiver", "()Ljava/lang/String;", "setExtensionReceiver", "(Ljava/lang/String;)V", "getFqName", "parameterNames", "getParameterNames", "setParameterNames", "parameterTypes", "getParameterTypes", "setParameterTypes", "platform", "", "Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector$PlatformDeclarationStatus;", "getPlatform", "()Ljava/util/List;", "toList", "", "kotlin-klib-commonizer"})
    public static final class RawStatsRow
    implements StatsOutput.StatsRow {
        @NotNull
        private String extensionReceiver;
        @NotNull
        private String parameterNames;
        @NotNull
        private String parameterTypes;
        public CommonDeclarationStatus common;
        @NotNull
        private final List<PlatformDeclarationStatus> platform;
        @NotNull
        private final String fqName;
        @NotNull
        private final DeclarationType declarationType;

        @NotNull
        public final String getExtensionReceiver() {
            return this.extensionReceiver;
        }

        public final void setExtensionReceiver(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.extensionReceiver = string;
        }

        @NotNull
        public final String getParameterNames() {
            return this.parameterNames;
        }

        public final void setParameterNames(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.parameterNames = string;
        }

        @NotNull
        public final String getParameterTypes() {
            return this.parameterTypes;
        }

        public final void setParameterTypes(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.parameterTypes = string;
        }

        @NotNull
        public final CommonDeclarationStatus getCommon() {
            CommonDeclarationStatus commonDeclarationStatus = this.common;
            if (commonDeclarationStatus == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"common");
            }
            return commonDeclarationStatus;
        }

        public final void setCommon(@NotNull CommonDeclarationStatus commonDeclarationStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)commonDeclarationStatus), (String)"<set-?>");
            this.common = commonDeclarationStatus;
        }

        @NotNull
        public final List<PlatformDeclarationStatus> getPlatform() {
            return this.platform;
        }

        @Override
        @NotNull
        public List<String> toList() {
            boolean bl = false;
            List list = new ArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            List $this$apply = list;
            boolean bl4 = false;
            Collection collection = $this$apply;
            String string = this.fqName;
            boolean bl5 = false;
            collection.add(string);
            collection = $this$apply;
            string = this.extensionReceiver;
            bl5 = false;
            collection.add(string);
            collection = $this$apply;
            string = this.parameterNames;
            bl5 = false;
            collection.add(string);
            collection = $this$apply;
            string = this.parameterTypes;
            bl5 = false;
            collection.add(string);
            collection = $this$apply;
            string = this.declarationType.getAlias();
            bl5 = false;
            collection.add(string);
            collection = $this$apply;
            CommonDeclarationStatus commonDeclarationStatus = this.common;
            if (commonDeclarationStatus == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"common");
            }
            string = String.valueOf(commonDeclarationStatus.getAlias());
            bl5 = false;
            collection.add(string);
            Iterable $this$forEach$iv = this.platform;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PlatformDeclarationStatus it = (PlatformDeclarationStatus)((Object)element$iv);
                boolean bl6 = false;
                Collection collection2 = $this$apply;
                String string2 = String.valueOf(it.getAlias());
                boolean bl7 = false;
                collection2.add(string2);
            }
            return list;
        }

        @NotNull
        public final String getFqName() {
            return this.fqName;
        }

        @NotNull
        public final DeclarationType getDeclarationType() {
            return this.declarationType;
        }

        public RawStatsRow(int dimension, @NotNull String fqName, @NotNull DeclarationType declarationType) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)((Object)declarationType), (String)"declarationType");
            this.fqName = fqName;
            this.declarationType = declarationType;
            this.extensionReceiver = "";
            this.parameterNames = "";
            this.parameterTypes = "";
            this.platform = new ArrayList(dimension);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector$CommonDeclarationStatus;", "", "alias", "", "(Ljava/lang/String;IC)V", "getAlias", "()C", "LIFTED_UP", "EXPECT", "ABSENT", "kotlin-klib-commonizer"})
    public static final class CommonDeclarationStatus
    extends Enum<CommonDeclarationStatus> {
        public static final /* enum */ CommonDeclarationStatus LIFTED_UP;
        public static final /* enum */ CommonDeclarationStatus EXPECT;
        public static final /* enum */ CommonDeclarationStatus ABSENT;
        private static final /* synthetic */ CommonDeclarationStatus[] $VALUES;
        private final char alias;

        static {
            CommonDeclarationStatus[] commonDeclarationStatusArray = new CommonDeclarationStatus[3];
            CommonDeclarationStatus[] commonDeclarationStatusArray2 = commonDeclarationStatusArray;
            commonDeclarationStatusArray[0] = LIFTED_UP = new CommonDeclarationStatus('L');
            commonDeclarationStatusArray[1] = EXPECT = new CommonDeclarationStatus('E');
            commonDeclarationStatusArray[2] = ABSENT = new CommonDeclarationStatus('-');
            $VALUES = commonDeclarationStatusArray;
        }

        public final char getAlias() {
            return this.alias;
        }

        private CommonDeclarationStatus(char alias) {
            this.alias = alias;
        }

        public static CommonDeclarationStatus[] values() {
            return (CommonDeclarationStatus[])$VALUES.clone();
        }

        public static CommonDeclarationStatus valueOf(String string) {
            return Enum.valueOf(CommonDeclarationStatus.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/stats/RawStatsCollector$PlatformDeclarationStatus;", "", "alias", "", "(Ljava/lang/String;IC)V", "getAlias", "()C", "ACTUAL", "ORIGINAL", "ABSENT", "kotlin-klib-commonizer"})
    public static final class PlatformDeclarationStatus
    extends Enum<PlatformDeclarationStatus> {
        public static final /* enum */ PlatformDeclarationStatus ACTUAL;
        public static final /* enum */ PlatformDeclarationStatus ORIGINAL;
        public static final /* enum */ PlatformDeclarationStatus ABSENT;
        private static final /* synthetic */ PlatformDeclarationStatus[] $VALUES;
        private final char alias;

        static {
            PlatformDeclarationStatus[] platformDeclarationStatusArray = new PlatformDeclarationStatus[3];
            PlatformDeclarationStatus[] platformDeclarationStatusArray2 = platformDeclarationStatusArray;
            platformDeclarationStatusArray[0] = ACTUAL = new PlatformDeclarationStatus('A');
            platformDeclarationStatusArray[1] = ORIGINAL = new PlatformDeclarationStatus('O');
            platformDeclarationStatusArray[2] = ABSENT = new PlatformDeclarationStatus('-');
            $VALUES = platformDeclarationStatusArray;
        }

        public final char getAlias() {
            return this.alias;
        }

        private PlatformDeclarationStatus(char alias) {
            this.alias = alias;
        }

        public static PlatformDeclarationStatus[] values() {
            return (PlatformDeclarationStatus[])$VALUES.clone();
        }

        public static PlatformDeclarationStatus valueOf(String string) {
            return Enum.valueOf(PlatformDeclarationStatus.class, string);
        }
    }
}

