/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirClass;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirClassifier;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirType;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirTypeAlias;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirClassConstructorNode;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirClassNode;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirClassifiersCache;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirFunctionNode;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirModuleNode;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirNodeVisitor;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirPackageNode;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirPropertyNode;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirRootNode;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirTypeAliasNode;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.NodeBuildersKt;
import org.jetbrains.kotlin.descriptors.commonizer.utils.CommonizedGroup;
import org.jetbrains.kotlin.descriptors.commonizer.utils.FqNameKt;
import org.jetbrains.kotlin.descriptors.commonizer.utils.InternersKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010 J\u001e\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0$0\"*\u00020\u000eH\u0002J \u0010!\u001a\u0016\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0$\u0018\u00010\"*\u00020\u001fH\u0002J(\u0010%\u001a\u00020\u0002*\u00020&2\u001a\u0010'\u001a\u0016\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0$\u0018\u00010\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/CommonizationVisitor;", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirNodeVisitor;", "", "cache", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirClassifiersCache;", "root", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirRootNode;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirClassifiersCache;Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirRootNode;)V", "visitClassConstructorNode", "node", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirClassConstructorNode;", "data", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirClassConstructorNode;Lkotlin/Unit;)V", "visitClassNode", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirClassNode;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirClassNode;Lkotlin/Unit;)V", "visitFunctionNode", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirFunctionNode;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirFunctionNode;Lkotlin/Unit;)V", "visitModuleNode", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirModuleNode;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirModuleNode;Lkotlin/Unit;)V", "visitPackageNode", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirPackageNode;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirPackageNode;Lkotlin/Unit;)V", "visitPropertyNode", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirPropertyNode;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirPropertyNode;Lkotlin/Unit;)V", "visitRootNode", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirRootNode;Lkotlin/Unit;)V", "visitTypeAliasNode", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirTypeAliasNode;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirTypeAliasNode;Lkotlin/Unit;)V", "collectCommonSupertypes", "", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirType;", "Lorg/jetbrains/kotlin/descriptors/commonizer/utils/CommonizedGroup;", "commonizeSupertypes", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirClass;", "supertypesMap", "kotlin-klib-commonizer"})
public final class CommonizationVisitor
implements CirNodeVisitor<Unit, Unit> {
    @NotNull
    private final CirClassifiersCache cache;
    @NotNull
    private final CirRootNode root;

    public CommonizationVisitor(@NotNull CirClassifiersCache cache, @NotNull CirRootNode root) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.cache = cache;
        this.root = root;
    }

    @Override
    public void visitRootNode(@NotNull CirRootNode node, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean bl = node == this.root;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = node.getCommonDeclaration().invoke() != null;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Iterable $this$forEach$iv = node.getModules().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirModuleNode module = (CirModuleNode)element$iv;
            boolean bl7 = false;
            module.accept(this, Unit.INSTANCE);
        }
    }

    @Override
    public void visitModuleNode(@NotNull CirModuleNode node, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        node.getCommonDeclaration().invoke();
        Iterable $this$forEach$iv = node.getPackages().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirPackageNode pkg = (CirPackageNode)element$iv;
            boolean bl = false;
            pkg.accept(this, Unit.INSTANCE);
        }
    }

    @Override
    public void visitPackageNode(@NotNull CirPackageNode node, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        node.getCommonDeclaration().invoke();
        Iterable $this$forEach$iv = node.getProperties().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirPropertyNode property = (CirPropertyNode)element$iv;
            boolean bl = false;
            property.accept(this, Unit.INSTANCE);
        }
        $this$forEach$iv = node.getFunctions().values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirFunctionNode function = (CirFunctionNode)element$iv;
            boolean bl = false;
            function.accept(this, Unit.INSTANCE);
        }
        $this$forEach$iv = node.getClasses().values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirClassNode clazz = (CirClassNode)element$iv;
            boolean bl = false;
            clazz.accept(this, Unit.INSTANCE);
        }
        $this$forEach$iv = node.getTypeAliases().values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirTypeAliasNode typeAlias = (CirTypeAliasNode)element$iv;
            boolean bl = false;
            typeAlias.accept(this, Unit.INSTANCE);
        }
    }

    @Override
    public void visitPropertyNode(@NotNull CirPropertyNode node, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        node.getCommonDeclaration().invoke();
    }

    @Override
    public void visitFunctionNode(@NotNull CirFunctionNode node, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        node.getCommonDeclaration().invoke();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClassNode(@NotNull CirClassNode node, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CirClass commonClass = (CirClass)node.getCommonDeclaration().invoke();
        Iterable $this$forEach$iv = node.getConstructors().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirClassConstructorNode constructor = (CirClassConstructorNode)element$iv;
            boolean bl = false;
            constructor.accept(this, Unit.INSTANCE);
        }
        $this$forEach$iv = node.getProperties().values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirPropertyNode property = (CirPropertyNode)element$iv;
            boolean bl = false;
            property.accept(this, Unit.INSTANCE);
        }
        $this$forEach$iv = node.getFunctions().values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirFunctionNode function = (CirFunctionNode)element$iv;
            boolean bl = false;
            function.accept(this, Unit.INSTANCE);
        }
        $this$forEach$iv = node.getClasses().values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CirClassNode clazz = (CirClassNode)element$iv;
            boolean bl = false;
            clazz.accept(this, Unit.INSTANCE);
        }
        if (commonClass != null) {
            void $this$mapTo$iv;
            Iterable $i$f$forEach2 = (Iterable)((Object)node.getTargetDeclarations());
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                CirClass cirClass = (CirClass)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Name name = it.getCompanion();
                collection.add(name);
            }
            Name companionObjectName = (Name)CollectionsKt.singleOrNull((Iterable)destination$iv);
            if (companionObjectName != null) {
                ClassId companionObjectClassId = InternersKt.internedClassId(node.getClassId(), companionObjectName);
                CirClassNode cirClassNode = this.cache.classNode(companionObjectClassId);
                if (cirClassNode == null) {
                    String string = Intrinsics.stringPlus((String)"Can't find companion object with class ID ", (Object)companionObjectClassId);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                CirClassNode companionObjectNode = cirClassNode;
                if (companionObjectNode.getCommonDeclaration().invoke() != null) {
                    commonClass.setCompanion(companionObjectName);
                }
            }
            this.commonizeSupertypes(commonClass, this.collectCommonSupertypes(node));
        }
    }

    @Override
    public void visitClassConstructorNode(@NotNull CirClassConstructorNode node, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        node.getCommonDeclaration().invoke();
    }

    @Override
    public void visitTypeAliasNode(@NotNull CirTypeAliasNode node, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        CirClassifier commonClassifier = (CirClassifier)node.getCommonDeclaration().invoke();
        if (commonClassifier instanceof CirClass) {
            this.commonizeSupertypes((CirClass)commonClassifier, this.collectCommonSupertypes(node));
        }
    }

    private final Map<CirType, CommonizedGroup<CirType>> collectCommonSupertypes(CirClassNode $this$collectCommonSupertypes) {
        boolean bl = false;
        Map supertypesMap = new LinkedHashMap();
        Iterator iterator = $this$collectCommonSupertypes.getTargetDeclarations().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            CirClass clazz = (CirClass)iterator.next();
            Intrinsics.checkNotNull((Object)clazz);
            for (CirType supertype : clazz.getSupertypes()) {
                Object object;
                Map $this$getOrPut$iv = supertypesMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(supertype);
                if (value$iv == null) {
                    boolean bl2 = false;
                    CommonizedGroup answer$iv = new CommonizedGroup($this$collectCommonSupertypes.getTargetDeclarations().size());
                    $this$getOrPut$iv.put(supertype, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((CommonizedGroup)((Object)object)).set(index, supertype);
            }
        }
        return supertypesMap;
    }

    private final Map<CirType, CommonizedGroup<CirType>> collectCommonSupertypes(CirTypeAliasNode $this$collectCommonSupertypes) {
        boolean bl = false;
        Map supertypesMap = new LinkedHashMap();
        Iterator iterator = $this$collectCommonSupertypes.getTargetDeclarations().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            CirTypeAlias typeAlias = (CirTypeAlias)iterator.next();
            Intrinsics.checkNotNull((Object)typeAlias);
            ClassId expandedClassId = typeAlias.getExpandedType().getClassifierId();
            FqName fqName = expandedClassId.getPackageFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"expandedClassId.packageFqName");
            if (FqNameKt.isUnderStandardKotlinPackages(fqName)) {
                return null;
            }
            CirClassNode cirClassNode = this.cache.classNode(expandedClassId);
            if (cirClassNode == null) {
                return null;
            }
            CirClassNode expandedClassNode = cirClassNode;
            CirClass cirClass = expandedClassNode.getTargetDeclarations().get(index);
            if (cirClass == null) {
                String string = "Can't find expanded class with class ID " + expandedClassId + " and index " + index + " for type alias " + $this$collectCommonSupertypes.getClassId();
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            CirClass expandedClass = cirClass;
            for (CirType supertype : expandedClass.getSupertypes()) {
                Object object;
                Map $this$getOrPut$iv = supertypesMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(supertype);
                if (value$iv == null) {
                    boolean bl3 = false;
                    CommonizedGroup answer$iv = new CommonizedGroup($this$collectCommonSupertypes.getTargetDeclarations().size());
                    $this$getOrPut$iv.put(supertype, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((CommonizedGroup)((Object)object)).set(index, supertype);
            }
        }
        return supertypesMap;
    }

    /*
     * WARNING - void declaration
     */
    private final void commonizeSupertypes(CirClass $this$commonizeSupertypes, Map<CirType, CommonizedGroup<CirType>> supertypesMap) {
        List list;
        CirClass cirClass = $this$commonizeSupertypes;
        Object object = supertypesMap;
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || object.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            List list2;
            void $this$compactMapNotNull$iv;
            object = supertypesMap.values();
            CirClass cirClass2 = cirClass;
            boolean $i$f$compactMapNotNull = false;
            if ($this$compactMapNotNull$iv.isEmpty()) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$compact$iv$iv;
                List $this$mapNotNullTo$iv$iv;
                Iterable iterable = (Iterable)$this$compactMapNotNull$iv;
                Collection destination$iv$iv = new ArrayList($this$compactMapNotNull$iv.size());
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    CirType cirType;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    CommonizedGroup supertypesGroup = (CommonizedGroup)((Object)element$iv$iv);
                    boolean bl4 = false;
                    if ((CirType)NodeBuildersKt.commonize(supertypesGroup, new TypeCommonizer(this.cache)) == null) continue;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    CirType it$iv$iv = cirType;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNullTo$iv$iv = (List)destination$iv$iv;
                boolean $i$f$compact = false;
                int n = $this$compact$iv$iv.size();
                switch (n) {
                    case 0: {
                        list2 = CollectionsKt.emptyList();
                        break;
                    }
                    case 1: {
                        List list3 = Collections.singletonList($this$compact$iv$iv.get(0));
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"singletonList(this[0])");
                        list2 = list3;
                        break;
                    }
                    default: {
                        void var9_13 = $this$compact$iv$iv;
                        ((ArrayList)$this$compact$iv$iv).trimToSize();
                        List list3 = $this$compact$iv$iv;
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"when (this) {\n            is java.util.ArrayList -> {\n                trimToSize()\n                this\n            }\n            else -> {\n                @Suppress(\"ReplaceJavaStaticMethodWithKotlinAnalog\")\n                Arrays.asList(*toTypedArray())\n            }\n        }");
                        list2 = list3;
                    }
                }
            }
            List list4 = list2;
            cirClass = cirClass2;
            list = list4;
        }
        cirClass.setSupertypes(list);
    }
}

