/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.konan;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataMetadataVersionKt;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataMonolithicSerializer;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.builtins.konan.KonanBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.FacadeKt;
import org.jetbrains.kotlin.descriptors.commonizer.InputTarget;
import org.jetbrains.kotlin.descriptors.commonizer.ModuleResult;
import org.jetbrains.kotlin.descriptors.commonizer.OutputTarget;
import org.jetbrains.kotlin.descriptors.commonizer.Parameters;
import org.jetbrains.kotlin.descriptors.commonizer.Result;
import org.jetbrains.kotlin.descriptors.commonizer.Target;
import org.jetbrains.kotlin.descriptors.commonizer.TargetProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.CommonNativeManifestDataProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeDistributionLibraries;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeDistributionModulesProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeManifestDataProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeSensitiveManifestData;
import org.jetbrains.kotlin.descriptors.commonizer.stats.AggregatedStatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.FileStatsOutput;
import org.jetbrains.kotlin.descriptors.commonizer.stats.RawStatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.StatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.utils.ResettableClockMark;
import org.jetbrains.kotlin.descriptors.konan.UtilsKt;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.library.NativeLibraryConstantsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.impl.BaseWriterImpl;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.impl.KotlinLibraryWriterImpl;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.konan.impl.KlibResolvedModuleDescriptorsFactoryImpl;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 B2\u00020\u0001:\u0002BCBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0\u001fH\u0002J\b\u0010!\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u001bH\u0002J\u0006\u0010.\u001a\u00020\u001bJ$\u0010/\u001a\u00020\u001b2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0\u001f2\u0006\u00101\u001a\u00020\u001dH\u0002JD\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020,2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J \u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010\u0007\u001a\u00020\u0003H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u0003*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00020\u0003*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer;", "", "repository", "Ljava/io/File;", "targets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "destination", "copyStdlib", "", "copyEndorsedLibs", "statsType", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$StatsType;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/io/File;Ljava/util/List;Ljava/io/File;ZZLorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$StatsType;Lorg/jetbrains/kotlin/util/Logger;)V", "clockMark", "Lorg/jetbrains/kotlin/descriptors/commonizer/utils/ResettableClockMark;", "librariesDestination", "Lorg/jetbrains/kotlin/descriptors/commonizer/Target;", "getLibrariesDestination", "(Lorg/jetbrains/kotlin/descriptors/commonizer/Target;)Ljava/io/File;", "platformLibrariesSource", "Lorg/jetbrains/kotlin/descriptors/commonizer/InputTarget;", "getPlatformLibrariesSource", "(Lorg/jetbrains/kotlin/descriptors/commonizer/InputTarget;)Ljava/io/File;", "checkPreconditions", "", "commonize", "Lorg/jetbrains/kotlin/descriptors/commonizer/Result;", "librariesByTargets", "", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionLibraries;", "copyCommonStandardLibraries", "copyTargetAsIs", "leafTarget", "librariesCount", "", "loadLibraries", "loadLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "location", "logProgress", "message", "", "logTotal", "run", "saveModules", "originalLibrariesByTargets", "result", "serializeTarget", "target", "targetName", "newModules", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "absentModuleLocations", "manifestProvider", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeManifestDataProvider;", "serializer", "Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataMonolithicSerializer;", "writeLibrary", "metadata", "Lorg/jetbrains/kotlin/library/SerializedMetadata;", "manifestData", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeSensitiveManifestData;", "Companion", "StatsType", "kotlin-klib-commonizer"})
public final class NativeDistributionCommonizer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final java.io.File repository;
    @NotNull
    private final List<KonanTarget> targets;
    @NotNull
    private final java.io.File destination;
    private final boolean copyStdlib;
    private final boolean copyEndorsedLibs;
    @NotNull
    private final StatsType statsType;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ResettableClockMark clockMark;

    public NativeDistributionCommonizer(@NotNull java.io.File repository, @NotNull List<? extends KonanTarget> targets, @NotNull java.io.File destination, boolean copyStdlib, boolean copyEndorsedLibs, @NotNull StatsType statsType, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)((Object)statsType), (String)"statsType");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.repository = repository;
        this.targets = targets;
        this.destination = destination;
        this.copyStdlib = copyStdlib;
        this.copyEndorsedLibs = copyEndorsedLibs;
        this.statsType = statsType;
        this.logger = logger;
        this.clockMark = new ResettableClockMark();
    }

    public final void run() {
        this.checkPreconditions();
        this.clockMark.reset();
        Map<InputTarget, NativeDistributionLibraries> librariesByTargets = this.loadLibraries();
        Result result = this.commonize(librariesByTargets);
        this.saveModules(librariesByTargets, result);
        this.logTotal();
    }

    private final void checkPreconditions() {
        if (!this.repository.isDirectory()) {
            this.logger.fatal(Intrinsics.stringPlus((String)"Repository does not exist: ", (Object)this.repository));
            throw null;
        }
        int n = this.targets.size();
        switch (n) {
            case 0: {
                this.logger.fatal("No targets specified");
                throw null;
            }
            case 1: {
                this.logger.fatal(Intrinsics.stringPlus((String)"Too few targets specified: ", this.targets));
                throw null;
            }
        }
        if (!this.destination.exists()) {
            this.destination.mkdirs();
        } else {
            boolean bl;
            block10: {
                if (!this.destination.isDirectory()) {
                    this.logger.fatal(Intrinsics.stringPlus((String)"Output already exists: ", (Object)this.destination));
                    throw null;
                }
                Sequence $this$any$iv = (Sequence)FilesKt.walkTopDown((java.io.File)this.destination);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    java.io.File it = (java.io.File)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)this.destination))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                this.logger.fatal(Intrinsics.stringPlus((String)"Output is not empty: ", (Object)this.destination));
                throw null;
            }
        }
    }

    private final void logProgress(String message) {
        this.logger.log("* " + message + " in " + this.clockMark.elapsedSinceLast());
    }

    private final void logTotal() {
        this.logger.log(Intrinsics.stringPlus((String)"TOTAL: ", (Object)this.clockMark.elapsedSinceStart()));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<InputTarget, NativeDistributionLibraries> loadLibraries() {
        void $this$associateTo$iv$iv;
        java.io.File stdlibPath = FilesKt.resolve((java.io.File)this.repository, (java.io.File)NativeLibraryConstantsKt.konanCommonLibraryPath((String)"stdlib"));
        KotlinLibrary stdlib = this.loadLibrary(stdlibPath);
        Iterable $this$associate$iv = this.targets;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            java.io.File[] platformLibs;
            List list;
            java.io.File[] fileArray;
            Map map = destination$iv$iv;
            KonanTarget target = (KonanTarget)element$iv$iv;
            boolean bl = false;
            InputTarget leafTarget = new InputTarget(target.getName(), target);
            java.io.File[] fileArray2 = this.getPlatformLibrariesSource(leafTarget);
            boolean bl2 = false;
            boolean bl3 = false;
            java.io.File[] it = fileArray2;
            boolean bl4 = false;
            java.io.File[] fileArray3 = it.isDirectory() ? fileArray2 : null;
            java.io.File[] fileArray4 = fileArray = fileArray3 == null ? null : fileArray3.listFiles();
            if (fileArray == null) {
                list = null;
            } else {
                fileArray2 = fileArray;
                bl2 = false;
                bl3 = false;
                it = fileArray2;
                boolean bl5 = false;
                java.io.File[] fileArray5 = it;
                int n = 0;
                java.io.File[] fileArray6 = fileArray5;
                boolean bl6 = false;
                Object object = fileArray3 = !(fileArray6.length == 0) ? fileArray2 : null;
                if (fileArray3 == null) {
                    list = null;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    fileArray2 = fileArray3;
                    boolean $i$f$map = false;
                    void var18_18 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    fileArray5 = $this$mapTo$iv$iv;
                    n = fileArray5.length;
                    for (int i = 0; i < n; ++i) {
                        void it2;
                        java.io.File item$iv$iv;
                        java.io.File file = item$iv$iv = fileArray5[i];
                        Collection collection = destination$iv$iv2;
                        boolean bl7 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                        KotlinLibrary kotlinLibrary = this.loadLibrary((java.io.File)it2);
                        collection.add(kotlinLibrary);
                    }
                    list = (List)destination$iv$iv2;
                }
            }
            fileArray = list;
            boolean bl8 = false;
            Object object = fileArray;
            if (fileArray == null) {
                object = platformLibs = CollectionsKt.emptyList();
            }
            if (platformLibs.isEmpty()) {
                this.logger.warning("No platform libraries found for target " + target + ". This target will be excluded from commonization.");
            }
            Pair pair = TuplesKt.to((Object)leafTarget, (Object)new NativeDistributionLibraries(stdlib, (List<? extends KotlinLibrary>)platformLibs));
            boolean bl9 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map result = destination$iv$iv;
        this.logProgress("Read lazy (uninitialized) libraries");
        return result;
    }

    private final KotlinLibrary loadLibrary(java.io.File location) {
        if (!location.isDirectory()) {
            this.logger.fatal(Intrinsics.stringPlus((String)"Library not found: ", (Object)location));
            throw null;
        }
        String string = location.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"location.path");
        KotlinLibrary library = SingleFileResolveKt.resolveSingleFileKlib((File)new File(string), (Logger)this.logger, (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE));
        if (library.getVersions().getMetadataVersion() == null) {
            this.logger.fatal(Intrinsics.stringPlus((String)"Library does not have metadata version specified in manifest: ", (Object)location));
            throw null;
        }
        KlibMetadataVersion metadataVersion = KlibMetadataMetadataVersionKt.getMetadataVersion((KotlinLibrary)library);
        KlibMetadataVersion klibMetadataVersion = metadataVersion;
        if (!Intrinsics.areEqual((Object)(klibMetadataVersion == null ? null : Boolean.valueOf(klibMetadataVersion.isCompatible())), (Object)true)) {
            this.logger.fatal(StringsKt.trimIndent((String)("\n                Library has incompatible metadata version " + ((klibMetadataVersion = metadataVersion) == null ? "\"unknown\"" : klibMetadataVersion) + ": " + location + "\n                Please make sure that all libraries passed to commonizer compatible metadata version " + KlibMetadataVersion.INSTANCE + "\n                ")));
            throw null;
        }
        return library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Result commonize(Map<InputTarget, NativeDistributionLibraries> librariesByTargets) {
        StatsCollector statsCollector;
        Object object = this.statsType;
        int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 1: {
                statsCollector = new RawStatsCollector(this.targets, new FileStatsOutput(this.destination, "raw"));
                break;
            }
            case 2: {
                statsCollector = new AggregatedStatsCollector(this.targets, new FileStatsOutput(this.destination, "aggregated"));
                break;
            }
            case 3: {
                statsCollector = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        StatsCollector statsCollector2 = statsCollector;
        object = statsCollector2;
        n = 0;
        boolean bl = false;
        Throwable throwable = null;
        try {
            StatsCollector it = (StatsCollector)object;
            boolean bl2 = false;
            Parameters parameters2 = new Parameters(statsCollector2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){

                public final void invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    NativeDistributionCommonizer.access$logProgress((NativeDistributionCommonizer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "logProgress(Ljava/lang/String;)V";
                }

                @NotNull
                public final String getName() {
                    return "logProgress";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(NativeDistributionCommonizer.class);
                }
            }));
            boolean bl3 = false;
            boolean bl4 = false;
            Parameters $this$commonize_u24lambda_u2d7_u24lambda_u2d6 = parameters2;
            boolean bl5 = false;
            Map<InputTarget, NativeDistributionLibraries> $this$forEach$iv = librariesByTargets;
            boolean $i$f$forEach = false;
            Map<InputTarget, NativeDistributionLibraries> map = $this$forEach$iv;
            boolean bl6 = false;
            Iterator<Map.Entry<InputTarget, NativeDistributionLibraries>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<InputTarget, NativeDistributionLibraries> element$iv;
                Map.Entry<InputTarget, NativeDistributionLibraries> $dstr$target$libraries = element$iv = iterator.next();
                boolean bl7 = false;
                Map.Entry<InputTarget, NativeDistributionLibraries> entry = $dstr$target$libraries;
                boolean bl8 = false;
                InputTarget target = entry.getKey();
                Map.Entry<InputTarget, NativeDistributionLibraries> entry2 = $dstr$target$libraries;
                boolean bl9 = false;
                NativeDistributionLibraries libraries = entry2.getValue();
                if (libraries.getPlatformLibs().isEmpty()) continue;
                NativeDistributionModulesProvider provider = new NativeDistributionModulesProvider((StorageManager)new LockBasedStorageManager(Intrinsics.stringPlus((String)"Target ", (Object)target)), libraries);
                $this$commonize_u24lambda_u2d7_u24lambda_u2d6.addTarget(new TargetProvider(target, KonanBuiltIns.class, provider, provider));
            }
            Parameters parameters3 = parameters2;
            Result result = FacadeKt.runCommonization(parameters3);
            return result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveModules(Map<InputTarget, NativeDistributionLibraries> originalLibrariesByTargets, Result result) {
        block12: {
            void $this$mapTo$iv$iv;
            Iterable element$iv3;
            Result result2;
            block11: {
                this.copyCommonStandardLibraries();
                result2 = result;
                if (!(result2 instanceof Result.NothingToCommonize)) break block11;
                Map<InputTarget, NativeDistributionLibraries> $this$forEach$iv = originalLibrariesByTargets;
                boolean $i$f$forEach = false;
                Map<InputTarget, NativeDistributionLibraries> map = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<InputTarget, NativeDistributionLibraries>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<InputTarget, NativeDistributionLibraries> element$iv2;
                    Map.Entry<InputTarget, NativeDistributionLibraries> $dstr$target$libraries = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    Map.Entry<InputTarget, NativeDistributionLibraries> entry = $dstr$target$libraries;
                    boolean bl3 = false;
                    InputTarget target = entry.getKey();
                    Map.Entry<InputTarget, NativeDistributionLibraries> entry2 = $dstr$target$libraries;
                    boolean bl4 = false;
                    NativeDistributionLibraries libraries = entry2.getValue();
                    this.copyTargetAsIs(target, libraries.getPlatformLibs().size());
                }
                break block12;
            }
            if (!(result2 instanceof Result.Commonized)) break block12;
            LanguageVersionSettingsImpl $i$f$forEach = LanguageVersionSettingsImpl.DEFAULT;
            Object object = KlibMetadataVersion.INSTANCE;
            KlibMetadataMonolithicSerializer serializer = new KlibMetadataMonolithicSerializer((LanguageVersionSettings)$i$f$forEach, (BinaryVersion)object, null, false, false, false, 48, null);
            Set targetsToCopy = SetsKt.minus(originalLibrariesByTargets.keySet(), (Iterable)((Result.Commonized)result).getLeafTargets());
            object = targetsToCopy;
            boolean bl = false;
            if (!object.isEmpty()) {
                Iterable $this$forEach$iv = targetsToCopy;
                boolean $i$f$forEach2 = false;
                for (Iterable element$iv3 : $this$forEach$iv) {
                    InputTarget target = (InputTarget)((Object)element$iv3);
                    boolean bl5 = false;
                    NativeDistributionLibraries libraries = (NativeDistributionLibraries)MapsKt.getValue(originalLibrariesByTargets, (Object)target);
                    this.copyTargetAsIs(target, libraries.getPlatformLibs().size());
                }
            }
            Iterable $this$map$iv = ((Result.Commonized)result).getLeafTargets();
            boolean $i$f$map = false;
            element$iv3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InputTarget target = (InputTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                String string = it.getName();
                collection.add(string);
            }
            List leafTargetNames = (List)destination$iv$iv;
            Set targetsToSerialize = SetsKt.plus(((Result.Commonized)result).getLeafTargets(), (Object)((Result.Commonized)result).getSharedTarget());
            Iterable $this$forEach$iv = targetsToSerialize;
            boolean $i$f$forEach3 = false;
            for (Object element$iv4 : $this$forEach$iv) {
                Target $this$mapNotNullTo$iv$iv;
                boolean bl7;
                Object object2;
                void $this$mapNotNullTo$iv$iv2;
                Target target = (Target)element$iv4;
                boolean bl8 = false;
                Collection moduleResults = (Collection)MapsKt.getValue(((Result.Commonized)result).getModulesByTargets(), (Object)target);
                Iterable $this$mapNotNull$iv = moduleResults;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Iterable<ModuleDescriptor> destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach4 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl9 = false;
                    ModuleResult it = (ModuleResult)element$iv$iv;
                    boolean bl10 = false;
                    ModuleResult.Commonized commonized = it instanceof ModuleResult.Commonized ? (ModuleResult.Commonized)it : null;
                    if ((commonized == null ? null : commonized.getModule()) == null) continue;
                    object2 = object2;
                    boolean bl11 = false;
                    bl7 = false;
                    ModuleDescriptor it$iv$iv = object2;
                    boolean bl12 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Collection newModules = (List)destination$iv$iv2;
                Iterable $this$mapNotNull$iv2 = moduleResults;
                boolean $i$f$mapNotNull2 = false;
                destination$iv$iv2 = $this$mapNotNull$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach5 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    java.io.File file;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl13 = false;
                    ModuleResult it = (ModuleResult)element$iv$iv;
                    boolean bl14 = false;
                    object2 = it instanceof ModuleResult.Absent ? (ModuleResult.Absent)it : null;
                    if ((object2 == null ? null : ((ModuleResult.Absent)object2).getOriginalLocation()) == null) continue;
                    file = file;
                    bl7 = false;
                    boolean bl15 = false;
                    java.io.File it$iv$iv = file;
                    boolean bl16 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                List absentModuleLocations = (List)destination$iv$iv3;
                NativeManifestDataProvider manifestProvider = null;
                String starredTarget = null;
                $this$mapNotNullTo$iv$iv = target;
                if ($this$mapNotNullTo$iv$iv instanceof InputTarget) {
                    manifestProvider = (NativeManifestDataProvider)MapsKt.getValue(originalLibrariesByTargets, (Object)target);
                    starredTarget = ((InputTarget)target).getName();
                } else if ($this$mapNotNullTo$iv$iv instanceof OutputTarget) {
                    manifestProvider = new CommonNativeManifestDataProvider(originalLibrariesByTargets.values());
                    starredTarget = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String targetName2 = CollectionsKt.joinToString$default((Iterable)leafTargetNames, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(starredTarget){
                    final /* synthetic */ String $starredTarget;
                    {
                        this.$starredTarget = $starredTarget;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it, (Object)this.$starredTarget) ? (CharSequence)Intrinsics.stringPlus((String)it, (Object)"(*)") : (CharSequence)it;
                    }
                }), (int)31, null);
                this.serializeTarget(target, targetName2, newModules, absentModuleLocations, manifestProvider, serializer);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void copyCommonStandardLibraries() {
        if (this.copyStdlib || this.copyEndorsedLibs) {
            String element$iv2;
            Object it;
            boolean $i$f$filter;
            java.io.File[] $this$filter$iv;
            List list;
            Object[] objectArray = FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)this.repository, (String)"klib"), (String)"common").listFiles();
            if (objectArray == null) {
                list = null;
            } else {
                void $this$filterTo$iv$iv;
                $this$filter$iv = objectArray;
                $i$f$filter = false;
                java.io.File[] fileArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var8_10 = $this$filterTo$iv$iv;
                int n = ((void)var8_10).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it2 = element$iv$iv = var8_10[i];
                    boolean bl = false;
                    if (!it2.isDirectory()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            List list2 = list;
            if (list2 != null) {
                java.io.File dir;
                Collection destination$iv$iv;
                boolean $i$f$filter2;
                Iterable $this$filter$iv2;
                Object object;
                $this$filter$iv = list2;
                $i$f$filter = false;
                boolean bl = false;
                it = $this$filter$iv;
                boolean bl2 = false;
                if (this.copyStdlib) {
                    if (this.copyEndorsedLibs) {
                        object = it;
                    } else {
                        void $this$filterTo$iv$iv;
                        $this$filter$iv2 = (Iterable)it;
                        $i$f$filter2 = false;
                        Iterable iterable = $this$filter$iv2;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            dir = (java.io.File)element$iv$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
                            if (!FilesKt.endsWith((java.io.File)dir, (String)"stdlib")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        object = (List)destination$iv$iv;
                    }
                } else {
                    $this$filter$iv2 = (Iterable)it;
                    $i$f$filter2 = false;
                    Iterable $this$filterTo$iv$iv = $this$filter$iv2;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        dir = (java.io.File)element$iv$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
                        if (!(!FilesKt.endsWith((java.io.File)dir, (String)"stdlib"))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    object = (List)destination$iv$iv;
                }
                objectArray = object;
                Iterable $this$forEach$iv = (Iterable)objectArray;
                boolean $i$f$forEach = false;
                for (String element$iv2 : $this$forEach$iv) {
                    java.io.File libraryOrigin = (java.io.File)((Object)element$iv2);
                    boolean bl5 = false;
                    java.io.File file = FilesKt.resolve((java.io.File)this.destination, (String)"common");
                    String string = libraryOrigin.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"libraryOrigin.name");
                    java.io.File libraryDestination = FilesKt.resolve((java.io.File)file, (String)string);
                    Intrinsics.checkNotNullExpressionValue((Object)libraryOrigin, (String)"libraryOrigin");
                    FilesKt.copyRecursively$default((java.io.File)libraryOrigin, (java.io.File)libraryDestination, (boolean)false, null, (int)6, null);
                }
            }
            objectArray = new String[2];
            String string = "standard library";
            boolean bl = false;
            boolean bl6 = false;
            element$iv2 = string;
            int n = 0;
            Object[] objectArray2 = objectArray;
            boolean bl7 = false;
            boolean bl8 = this.copyStdlib;
            objectArray2[n] = bl8 ? string : null;
            string = "endorsed libraries";
            bl = false;
            bl6 = false;
            it = string;
            n = 1;
            objectArray2 = objectArray;
            boolean bl9 = false;
            bl8 = this.copyEndorsedLibs;
            objectArray2[n] = bl8 ? string : null;
            String what = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" and ", null, null, (int)0, null, null, (int)62, null);
            this.logProgress(Intrinsics.stringPlus((String)"Copied ", (Object)what));
        }
    }

    private final void copyTargetAsIs(InputTarget leafTarget, int librariesCount) {
        java.io.File librariesDestination = this.getLibrariesDestination(leafTarget);
        librariesDestination.mkdirs();
        java.io.File librariesSource = this.getPlatformLibrariesSource(leafTarget);
        if (librariesSource.isDirectory()) {
            FilesKt.copyRecursively$default((java.io.File)librariesSource, (java.io.File)librariesDestination, (boolean)false, null, (int)6, null);
        }
        this.logProgress("Copied " + librariesCount + " libraries for [" + leafTarget.getName() + ']');
    }

    private final void serializeTarget(Target target, String targetName2, Collection<? extends ModuleDescriptor> newModules, List<? extends java.io.File> absentModuleLocations, NativeManifestDataProvider manifestProvider, KlibMetadataMonolithicSerializer serializer) {
        Object libraryName;
        java.io.File librariesDestination = this.getLibrariesDestination(target);
        librariesDestination.mkdirs();
        for (ModuleDescriptor moduleDescriptor : newModules) {
            Name name = moduleDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"newModule.name");
            libraryName = name;
            if (!Companion.shouldBeSerialized((Name)libraryName)) continue;
            SerializedMetadata metadata = serializer.serializeModule(moduleDescriptor);
            String string = libraryName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"libraryName.asString()");
            String plainName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"<"), (CharSequence)">");
            NativeSensitiveManifestData manifestData = manifestProvider.getManifest(plainName);
            java.io.File libraryDestination = FilesKt.resolve((java.io.File)librariesDestination, (String)plainName);
            this.writeLibrary(metadata, manifestData, libraryDestination);
        }
        for (java.io.File file : absentModuleLocations) {
            libraryName = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)libraryName, (String)"libraryName");
            FilesKt.copyRecursively$default((java.io.File)file, (java.io.File)FilesKt.resolve((java.io.File)librariesDestination, (String)libraryName), (boolean)false, null, (int)6, null);
        }
        this.logProgress("Written libraries for [" + targetName2 + ']');
    }

    private final void writeLibrary(SerializedMetadata metadata, NativeSensitiveManifestData manifestData, java.io.File destination) {
        String string = destination.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destination.path");
        KotlinLibraryWriterImpl library = new KotlinLibraryWriterImpl(new File(string), manifestData.getUniqueName(), manifestData.getVersions(), BuiltInsPlatform.NATIVE, CollectionsKt.emptyList(), true, manifestData.getShortName(), null, null, null, null, 1920, null);
        library.addMetadata(metadata);
        manifestData.applyTo((BaseWriterImpl)library.getBase());
        library.commit();
    }

    private final java.io.File getPlatformLibrariesSource(InputTarget $this$platformLibrariesSource) {
        return FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)this.repository, (String)"klib"), (String)"platform"), (String)$this$platformLibrariesSource.getName());
    }

    private final java.io.File getLibrariesDestination(Target $this$librariesDestination) {
        java.io.File file;
        Target target = $this$librariesDestination;
        if (target instanceof InputTarget) {
            file = FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)this.destination, (String)"platform"), (String)((InputTarget)$this$librariesDestination).getName());
        } else if (target instanceof OutputTarget) {
            file = FilesKt.resolve((java.io.File)this.destination, (String)"common");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return file;
    }

    public static final /* synthetic */ void access$logProgress(NativeDistributionCommonizer $this, String message) {
        $this.logProgress(message);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$StatsType;", "", "(Ljava/lang/String;I)V", "RAW", "AGGREGATED", "NONE", "kotlin-klib-commonizer"})
    public static final class StatsType
    extends Enum<StatsType> {
        public static final /* enum */ StatsType RAW = new StatsType();
        public static final /* enum */ StatsType AGGREGATED = new StatsType();
        public static final /* enum */ StatsType NONE = new StatsType();
        private static final /* synthetic */ StatsType[] $VALUES;

        public static StatsType[] values() {
            StatsType[] statsTypeArray = $VALUES;
            StatsType[] statsTypeArray2 = new StatsType[statsTypeArray.length];
            System.arraycopy(statsTypeArray, 0, statsTypeArray2, 0, statsTypeArray.length);
            return statsTypeArray2;
        }

        public static StatsType valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(StatsType.class, value);
        }

        static {
            StatsType[] statsTypeArray = new StatsType[]{RAW, AGGREGATED, NONE};
            $VALUES = statsTypeArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$Companion;", "", "()V", "shouldBeSerialized", "", "libraryName", "Lorg/jetbrains/kotlin/name/Name;", "kotlin-klib-commonizer"})
    private static final class Companion {
        private Companion() {
        }

        public final boolean shouldBeSerialized(@NotNull Name libraryName) {
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            return !Intrinsics.areEqual((Object)libraryName, (Object)UtilsKt.getNATIVE_STDLIB_MODULE_NAME()) && !Intrinsics.areEqual((Object)libraryName, (Object)KlibResolvedModuleDescriptorsFactoryImpl.Companion.getFORWARD_DECLARATIONS_MODULE_NAME());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatsType.values().length];
            nArray[StatsType.RAW.ordinal()] = 1;
            nArray[StatsType.AGGREGATED.ordinal()] = 2;
            nArray[StatsType.NONE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

